/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains <code>ProfileObjectType</code> mapping information from the model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectedProfileObjectType implements SdkPojo, Serializable,
        ToCopyableBuilder<DetectedProfileObjectType.Builder, DetectedProfileObjectType> {
    private static final SdkField<String> SOURCE_LAST_UPDATED_TIMESTAMP_FORMAT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceLastUpdatedTimestampFormat")
            .getter(getter(DetectedProfileObjectType::sourceLastUpdatedTimestampFormat))
            .setter(setter(Builder::sourceLastUpdatedTimestampFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLastUpdatedTimestampFormat")
                    .build()).build();

    private static final SdkField<Map<String, ObjectTypeField>> FIELDS_FIELD = SdkField
            .<Map<String, ObjectTypeField>> builder(MarshallingType.MAP)
            .memberName("Fields")
            .getter(getter(DetectedProfileObjectType::fields))
            .setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fields").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ObjectTypeField> builder(MarshallingType.SDK_POJO)
                                            .constructor(ObjectTypeField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, List<ObjectTypeKey>>> KEYS_FIELD = SdkField
            .<Map<String, List<ObjectTypeKey>>> builder(MarshallingType.MAP)
            .memberName("Keys")
            .getter(getter(DetectedProfileObjectType::keys))
            .setter(setter(Builder::keys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keys").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<ObjectTypeKey>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<ObjectTypeKey> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(ObjectTypeKey::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SOURCE_LAST_UPDATED_TIMESTAMP_FORMAT_FIELD, FIELDS_FIELD, KEYS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceLastUpdatedTimestampFormat;

    private final Map<String, ObjectTypeField> fields;

    private final Map<String, List<ObjectTypeKey>> keys;

    private DetectedProfileObjectType(BuilderImpl builder) {
        this.sourceLastUpdatedTimestampFormat = builder.sourceLastUpdatedTimestampFormat;
        this.fields = builder.fields;
        this.keys = builder.keys;
    }

    /**
     * <p>
     * The format of <code>sourceLastUpdatedTimestamp</code> that was detected in fields.
     * </p>
     * 
     * @return The format of <code>sourceLastUpdatedTimestamp</code> that was detected in fields.
     */
    public final String sourceLastUpdatedTimestampFormat() {
        return sourceLastUpdatedTimestampFormat;
    }

    /**
     * For responses, this returns true if the service returned a value for the Fields property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFields() {
        return fields != null && !(fields instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of the name and the <code>ObjectType</code> field.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFields} method.
     * </p>
     * 
     * @return A map of the name and the <code>ObjectType</code> field.
     */
    public final Map<String, ObjectTypeField> fields() {
        return fields;
    }

    /**
     * For responses, this returns true if the service returned a value for the Keys property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasKeys() {
        return keys != null && !(keys instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of unique keys that can be used to map data to a profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeys} method.
     * </p>
     * 
     * @return A list of unique keys that can be used to map data to a profile.
     */
    public final Map<String, List<ObjectTypeKey>> keys() {
        return keys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceLastUpdatedTimestampFormat());
        hashCode = 31 * hashCode + Objects.hashCode(hasFields() ? fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasKeys() ? keys() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectedProfileObjectType)) {
            return false;
        }
        DetectedProfileObjectType other = (DetectedProfileObjectType) obj;
        return Objects.equals(sourceLastUpdatedTimestampFormat(), other.sourceLastUpdatedTimestampFormat())
                && hasFields() == other.hasFields() && Objects.equals(fields(), other.fields()) && hasKeys() == other.hasKeys()
                && Objects.equals(keys(), other.keys());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectedProfileObjectType")
                .add("SourceLastUpdatedTimestampFormat", sourceLastUpdatedTimestampFormat())
                .add("Fields", fields() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Keys", keys() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceLastUpdatedTimestampFormat":
            return Optional.ofNullable(clazz.cast(sourceLastUpdatedTimestampFormat()));
        case "Fields":
            return Optional.ofNullable(clazz.cast(fields()));
        case "Keys":
            return Optional.ofNullable(clazz.cast(keys()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceLastUpdatedTimestampFormat", SOURCE_LAST_UPDATED_TIMESTAMP_FORMAT_FIELD);
        map.put("Fields", FIELDS_FIELD);
        map.put("Keys", KEYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DetectedProfileObjectType, T> g) {
        return obj -> g.apply((DetectedProfileObjectType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DetectedProfileObjectType> {
        /**
         * <p>
         * The format of <code>sourceLastUpdatedTimestamp</code> that was detected in fields.
         * </p>
         * 
         * @param sourceLastUpdatedTimestampFormat
         *        The format of <code>sourceLastUpdatedTimestamp</code> that was detected in fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLastUpdatedTimestampFormat(String sourceLastUpdatedTimestampFormat);

        /**
         * <p>
         * A map of the name and the <code>ObjectType</code> field.
         * </p>
         * 
         * @param fields
         *        A map of the name and the <code>ObjectType</code> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Map<String, ObjectTypeField> fields);

        /**
         * <p>
         * A list of unique keys that can be used to map data to a profile.
         * </p>
         * 
         * @param keys
         *        A list of unique keys that can be used to map data to a profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keys(Map<String, ? extends Collection<ObjectTypeKey>> keys);
    }

    static final class BuilderImpl implements Builder {
        private String sourceLastUpdatedTimestampFormat;

        private Map<String, ObjectTypeField> fields = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, List<ObjectTypeKey>> keys = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectedProfileObjectType model) {
            sourceLastUpdatedTimestampFormat(model.sourceLastUpdatedTimestampFormat);
            fields(model.fields);
            keys(model.keys);
        }

        public final String getSourceLastUpdatedTimestampFormat() {
            return sourceLastUpdatedTimestampFormat;
        }

        public final void setSourceLastUpdatedTimestampFormat(String sourceLastUpdatedTimestampFormat) {
            this.sourceLastUpdatedTimestampFormat = sourceLastUpdatedTimestampFormat;
        }

        @Override
        public final Builder sourceLastUpdatedTimestampFormat(String sourceLastUpdatedTimestampFormat) {
            this.sourceLastUpdatedTimestampFormat = sourceLastUpdatedTimestampFormat;
            return this;
        }

        public final Map<String, ObjectTypeField.Builder> getFields() {
            Map<String, ObjectTypeField.Builder> result = FieldMapCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFields(Map<String, ObjectTypeField.BuilderImpl> fields) {
            this.fields = FieldMapCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Map<String, ObjectTypeField> fields) {
            this.fields = FieldMapCopier.copy(fields);
            return this;
        }

        public final Map<String, List<ObjectTypeKey.Builder>> getKeys() {
            Map<String, List<ObjectTypeKey.Builder>> result = KeyMapCopier.copyToBuilder(this.keys);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setKeys(Map<String, ? extends Collection<ObjectTypeKey.BuilderImpl>> keys) {
            this.keys = KeyMapCopier.copyFromBuilder(keys);
        }

        @Override
        public final Builder keys(Map<String, ? extends Collection<ObjectTypeKey>> keys) {
            this.keys = KeyMapCopier.copy(keys);
            return this;
        }

        @Override
        public DetectedProfileObjectType build() {
            return new DetectedProfileObjectType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
