/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object that holds what profile and calculated attributes to segment on.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Dimension implements SdkPojo, Serializable, ToCopyableBuilder<Dimension.Builder, Dimension> {
    private static final SdkField<ProfileAttributes> PROFILE_ATTRIBUTES_FIELD = SdkField
            .<ProfileAttributes> builder(MarshallingType.SDK_POJO).memberName("ProfileAttributes")
            .getter(getter(Dimension::profileAttributes)).setter(setter(Builder::profileAttributes))
            .constructor(ProfileAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileAttributes").build()).build();

    private static final SdkField<Map<String, CalculatedAttributeDimension>> CALCULATED_ATTRIBUTES_FIELD = SdkField
            .<Map<String, CalculatedAttributeDimension>> builder(MarshallingType.MAP)
            .memberName("CalculatedAttributes")
            .getter(getter(Dimension::calculatedAttributes))
            .setter(setter(Builder::calculatedAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatedAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<CalculatedAttributeDimension> builder(MarshallingType.SDK_POJO)
                                            .constructor(CalculatedAttributeDimension::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ATTRIBUTES_FIELD,
            CALCULATED_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ProfileAttributes profileAttributes;

    private final Map<String, CalculatedAttributeDimension> calculatedAttributes;

    private final Type type;

    private Dimension(BuilderImpl builder) {
        this.profileAttributes = builder.profileAttributes;
        this.calculatedAttributes = builder.calculatedAttributes;
        this.type = builder.type;
    }

    /**
     * <p>
     * Object that holds the profile attributes to segment on.
     * </p>
     * 
     * @return Object that holds the profile attributes to segment on.
     */
    public final ProfileAttributes profileAttributes() {
        return profileAttributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the CalculatedAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCalculatedAttributes() {
        return calculatedAttributes != null && !(calculatedAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Object that holds the calculated attributes to segment on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCalculatedAttributes} method.
     * </p>
     * 
     * @return Object that holds the calculated attributes to segment on.
     */
    public final Map<String, CalculatedAttributeDimension> calculatedAttributes() {
        return calculatedAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(profileAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(hasCalculatedAttributes() ? calculatedAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Dimension)) {
            return false;
        }
        Dimension other = (Dimension) obj;
        return Objects.equals(profileAttributes(), other.profileAttributes())
                && hasCalculatedAttributes() == other.hasCalculatedAttributes()
                && Objects.equals(calculatedAttributes(), other.calculatedAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Dimension")
                .add("ProfileAttributes", profileAttributes() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CalculatedAttributes", hasCalculatedAttributes() ? calculatedAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProfileAttributes":
            return Optional.ofNullable(clazz.cast(profileAttributes()));
        case "CalculatedAttributes":
            return Optional.ofNullable(clazz.cast(calculatedAttributes()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #profileAttributes()} initialized to the given value.
     *
     * <p>
     * Object that holds the profile attributes to segment on.
     * </p>
     * 
     * @param profileAttributes
     *        Object that holds the profile attributes to segment on.
     */
    public static Dimension fromProfileAttributes(ProfileAttributes profileAttributes) {
        return builder().profileAttributes(profileAttributes).build();
    }

    /**
     * Create an instance of this class with {@link #profileAttributes()} initialized to the given value.
     *
     * <p>
     * Object that holds the profile attributes to segment on.
     * </p>
     * 
     * @param profileAttributes
     *        Object that holds the profile attributes to segment on.
     */
    public static Dimension fromProfileAttributes(Consumer<ProfileAttributes.Builder> profileAttributes) {
        ProfileAttributes.Builder builder = ProfileAttributes.builder();
        profileAttributes.accept(builder);
        return fromProfileAttributes(builder.build());
    }

    /**
     * Create an instance of this class with {@link #calculatedAttributes()} initialized to the given value.
     *
     * <p>
     * Object that holds the calculated attributes to segment on.
     * </p>
     * 
     * @param calculatedAttributes
     *        Object that holds the calculated attributes to segment on.
     */
    public static Dimension fromCalculatedAttributes(Map<String, CalculatedAttributeDimension> calculatedAttributes) {
        return builder().calculatedAttributes(calculatedAttributes).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProfileAttributes", PROFILE_ATTRIBUTES_FIELD);
        map.put("CalculatedAttributes", CALCULATED_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Dimension, T> g) {
        return obj -> g.apply((Dimension) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Dimension> {
        /**
         * <p>
         * Object that holds the profile attributes to segment on.
         * </p>
         * 
         * @param profileAttributes
         *        Object that holds the profile attributes to segment on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileAttributes(ProfileAttributes profileAttributes);

        /**
         * <p>
         * Object that holds the profile attributes to segment on.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProfileAttributes.Builder} avoiding the
         * need to create one manually via {@link ProfileAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProfileAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #profileAttributes(ProfileAttributes)}.
         * 
         * @param profileAttributes
         *        a consumer that will call methods on {@link ProfileAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #profileAttributes(ProfileAttributes)
         */
        default Builder profileAttributes(Consumer<ProfileAttributes.Builder> profileAttributes) {
            return profileAttributes(ProfileAttributes.builder().applyMutation(profileAttributes).build());
        }

        /**
         * <p>
         * Object that holds the calculated attributes to segment on.
         * </p>
         * 
         * @param calculatedAttributes
         *        Object that holds the calculated attributes to segment on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calculatedAttributes(Map<String, CalculatedAttributeDimension> calculatedAttributes);
    }

    static final class BuilderImpl implements Builder {
        private ProfileAttributes profileAttributes;

        private Map<String, CalculatedAttributeDimension> calculatedAttributes = DefaultSdkAutoConstructMap.getInstance();

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Dimension model) {
            profileAttributes(model.profileAttributes);
            calculatedAttributes(model.calculatedAttributes);
        }

        public final ProfileAttributes.Builder getProfileAttributes() {
            return profileAttributes != null ? profileAttributes.toBuilder() : null;
        }

        public final void setProfileAttributes(ProfileAttributes.BuilderImpl profileAttributes) {
            Object oldValue = this.profileAttributes;
            this.profileAttributes = profileAttributes != null ? profileAttributes.build() : null;
            handleUnionValueChange(Type.PROFILE_ATTRIBUTES, oldValue, this.profileAttributes);
        }

        @Override
        public final Builder profileAttributes(ProfileAttributes profileAttributes) {
            Object oldValue = this.profileAttributes;
            this.profileAttributes = profileAttributes;
            handleUnionValueChange(Type.PROFILE_ATTRIBUTES, oldValue, this.profileAttributes);
            return this;
        }

        public final Map<String, CalculatedAttributeDimension.Builder> getCalculatedAttributes() {
            Map<String, CalculatedAttributeDimension.Builder> result = CalculatedCustomAttributesCopier
                    .copyToBuilder(this.calculatedAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCalculatedAttributes(Map<String, CalculatedAttributeDimension.BuilderImpl> calculatedAttributes) {
            Object oldValue = this.calculatedAttributes;
            this.calculatedAttributes = CalculatedCustomAttributesCopier.copyFromBuilder(calculatedAttributes);
            handleUnionValueChange(Type.CALCULATED_ATTRIBUTES, oldValue, this.calculatedAttributes);
        }

        @Override
        public final Builder calculatedAttributes(Map<String, CalculatedAttributeDimension> calculatedAttributes) {
            Object oldValue = this.calculatedAttributes;
            this.calculatedAttributes = CalculatedCustomAttributesCopier.copy(calculatedAttributes);
            handleUnionValueChange(Type.CALCULATED_ATTRIBUTES, oldValue, this.calculatedAttributes);
            return this;
        }

        @Override
        public Dimension build() {
            return new Dimension(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Dimension#type()
     */
    public enum Type {
        PROFILE_ATTRIBUTES,

        CALCULATED_ATTRIBUTES,

        UNKNOWN_TO_SDK_VERSION
    }
}
