/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object that defines users preferred methods of engagement.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EngagementPreferences implements SdkPojo, Serializable,
        ToCopyableBuilder<EngagementPreferences.Builder, EngagementPreferences> {
    private static final SdkField<List<ContactPreference>> PHONE_FIELD = SdkField
            .<List<ContactPreference>> builder(MarshallingType.LIST)
            .memberName("Phone")
            .getter(getter(EngagementPreferences::phone))
            .setter(setter(Builder::phone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phone").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContactPreference> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContactPreference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ContactPreference>> EMAIL_FIELD = SdkField
            .<List<ContactPreference>> builder(MarshallingType.LIST)
            .memberName("Email")
            .getter(getter(EngagementPreferences::email))
            .setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContactPreference> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContactPreference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_FIELD, EMAIL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ContactPreference> phone;

    private final List<ContactPreference> email;

    private EngagementPreferences(BuilderImpl builder) {
        this.phone = builder.phone;
        this.email = builder.email;
    }

    /**
     * For responses, this returns true if the service returned a value for the Phone property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasPhone() {
        return phone != null && !(phone instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of phone-related contact preferences
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPhone} method.
     * </p>
     * 
     * @return A list of phone-related contact preferences
     */
    public final List<ContactPreference> phone() {
        return phone;
    }

    /**
     * For responses, this returns true if the service returned a value for the Email property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasEmail() {
        return email != null && !(email instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of email-related contact preferences
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEmail} method.
     * </p>
     * 
     * @return A list of email-related contact preferences
     */
    public final List<ContactPreference> email() {
        return email;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPhone() ? phone() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEmail() ? email() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EngagementPreferences)) {
            return false;
        }
        EngagementPreferences other = (EngagementPreferences) obj;
        return hasPhone() == other.hasPhone() && Objects.equals(phone(), other.phone()) && hasEmail() == other.hasEmail()
                && Objects.equals(email(), other.email());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EngagementPreferences").add("Phone", hasPhone() ? phone() : null)
                .add("Email", hasEmail() ? email() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Phone":
            return Optional.ofNullable(clazz.cast(phone()));
        case "Email":
            return Optional.ofNullable(clazz.cast(email()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Phone", PHONE_FIELD);
        map.put("Email", EMAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EngagementPreferences, T> g) {
        return obj -> g.apply((EngagementPreferences) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EngagementPreferences> {
        /**
         * <p>
         * A list of phone-related contact preferences
         * </p>
         * 
         * @param phone
         *        A list of phone-related contact preferences
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phone(Collection<ContactPreference> phone);

        /**
         * <p>
         * A list of phone-related contact preferences
         * </p>
         * 
         * @param phone
         *        A list of phone-related contact preferences
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phone(ContactPreference... phone);

        /**
         * <p>
         * A list of phone-related contact preferences
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.customerprofiles.model.ContactPreference.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.customerprofiles.model.ContactPreference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.customerprofiles.model.ContactPreference.Builder#build()} is called
         * immediately and its result is passed to {@link #phone(List<ContactPreference>)}.
         * 
         * @param phone
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.customerprofiles.model.ContactPreference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phone(java.util.Collection<ContactPreference>)
         */
        Builder phone(Consumer<ContactPreference.Builder>... phone);

        /**
         * <p>
         * A list of email-related contact preferences
         * </p>
         * 
         * @param email
         *        A list of email-related contact preferences
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(Collection<ContactPreference> email);

        /**
         * <p>
         * A list of email-related contact preferences
         * </p>
         * 
         * @param email
         *        A list of email-related contact preferences
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(ContactPreference... email);

        /**
         * <p>
         * A list of email-related contact preferences
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.customerprofiles.model.ContactPreference.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.customerprofiles.model.ContactPreference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.customerprofiles.model.ContactPreference.Builder#build()} is called
         * immediately and its result is passed to {@link #email(List<ContactPreference>)}.
         * 
         * @param email
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.customerprofiles.model.ContactPreference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #email(java.util.Collection<ContactPreference>)
         */
        Builder email(Consumer<ContactPreference.Builder>... email);
    }

    static final class BuilderImpl implements Builder {
        private List<ContactPreference> phone = DefaultSdkAutoConstructList.getInstance();

        private List<ContactPreference> email = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EngagementPreferences model) {
            phone(model.phone);
            email(model.email);
        }

        public final List<ContactPreference.Builder> getPhone() {
            List<ContactPreference.Builder> result = PhonePreferenceListCopier.copyToBuilder(this.phone);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhone(Collection<ContactPreference.BuilderImpl> phone) {
            this.phone = PhonePreferenceListCopier.copyFromBuilder(phone);
        }

        @Override
        public final Builder phone(Collection<ContactPreference> phone) {
            this.phone = PhonePreferenceListCopier.copy(phone);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phone(ContactPreference... phone) {
            phone(Arrays.asList(phone));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phone(Consumer<ContactPreference.Builder>... phone) {
            phone(Stream.of(phone).map(c -> ContactPreference.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ContactPreference.Builder> getEmail() {
            List<ContactPreference.Builder> result = EmailPreferenceListCopier.copyToBuilder(this.email);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEmail(Collection<ContactPreference.BuilderImpl> email) {
            this.email = EmailPreferenceListCopier.copyFromBuilder(email);
        }

        @Override
        public final Builder email(Collection<ContactPreference> email) {
            this.email = EmailPreferenceListCopier.copy(email);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder email(ContactPreference... email) {
            email(Arrays.asList(email));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder email(Consumer<ContactPreference.Builder>... email) {
            email(Stream.of(email).map(c -> ContactPreference.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public EngagementPreferences build() {
            return new EngagementPreferences(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
