/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An instance of EventStream in a list of EventStreams.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventStreamSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<EventStreamSummary.Builder, EventStreamSummary> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(EventStreamSummary::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> EVENT_STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventStreamName").getter(getter(EventStreamSummary::eventStreamName))
            .setter(setter(Builder::eventStreamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventStreamName").build()).build();

    private static final SdkField<String> EVENT_STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventStreamArn").getter(getter(EventStreamSummary::eventStreamArn))
            .setter(setter(Builder::eventStreamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventStreamArn").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(EventStreamSummary::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Instant> STOPPED_SINCE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StoppedSince").getter(getter(EventStreamSummary::stoppedSince)).setter(setter(Builder::stoppedSince))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppedSince").build()).build();

    private static final SdkField<DestinationSummary> DESTINATION_SUMMARY_FIELD = SdkField
            .<DestinationSummary> builder(MarshallingType.SDK_POJO).memberName("DestinationSummary")
            .getter(getter(EventStreamSummary::destinationSummary)).setter(setter(Builder::destinationSummary))
            .constructor(DestinationSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationSummary").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(EventStreamSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            EVENT_STREAM_NAME_FIELD, EVENT_STREAM_ARN_FIELD, STATE_FIELD, STOPPED_SINCE_FIELD, DESTINATION_SUMMARY_FIELD,
            TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String domainName;

    private final String eventStreamName;

    private final String eventStreamArn;

    private final String state;

    private final Instant stoppedSince;

    private final DestinationSummary destinationSummary;

    private final Map<String, String> tags;

    private EventStreamSummary(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.eventStreamName = builder.eventStreamName;
        this.eventStreamArn = builder.eventStreamArn;
        this.state = builder.state;
        this.stoppedSince = builder.stoppedSince;
        this.destinationSummary = builder.destinationSummary;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique name of the domain.
     * </p>
     * 
     * @return The unique name of the domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The name of the event stream.
     * </p>
     * 
     * @return The name of the event stream.
     */
    public final String eventStreamName() {
        return eventStreamName;
    }

    /**
     * <p>
     * A unique identifier for the event stream.
     * </p>
     * 
     * @return A unique identifier for the event stream.
     */
    public final String eventStreamArn() {
        return eventStreamArn;
    }

    /**
     * <p>
     * The operational state of destination stream for export.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link EventStreamState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The operational state of destination stream for export.
     * @see EventStreamState
     */
    public final EventStreamState state() {
        return EventStreamState.fromValue(state);
    }

    /**
     * <p>
     * The operational state of destination stream for export.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link EventStreamState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The operational state of destination stream for export.
     * @see EventStreamState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The timestamp when the <code>State</code> changed to <code>STOPPED</code>.
     * </p>
     * 
     * @return The timestamp when the <code>State</code> changed to <code>STOPPED</code>.
     */
    public final Instant stoppedSince() {
        return stoppedSince;
    }

    /**
     * <p>
     * Summary information about the Kinesis data stream.
     * </p>
     * 
     * @return Summary information about the Kinesis data stream.
     */
    public final DestinationSummary destinationSummary() {
        return destinationSummary;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(eventStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(eventStreamArn());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stoppedSince());
        hashCode = 31 * hashCode + Objects.hashCode(destinationSummary());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventStreamSummary)) {
            return false;
        }
        EventStreamSummary other = (EventStreamSummary) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(eventStreamName(), other.eventStreamName())
                && Objects.equals(eventStreamArn(), other.eventStreamArn())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(stoppedSince(), other.stoppedSince())
                && Objects.equals(destinationSummary(), other.destinationSummary()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventStreamSummary").add("DomainName", domainName()).add("EventStreamName", eventStreamName())
                .add("EventStreamArn", eventStreamArn()).add("State", stateAsString()).add("StoppedSince", stoppedSince())
                .add("DestinationSummary", destinationSummary()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "EventStreamName":
            return Optional.ofNullable(clazz.cast(eventStreamName()));
        case "EventStreamArn":
            return Optional.ofNullable(clazz.cast(eventStreamArn()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StoppedSince":
            return Optional.ofNullable(clazz.cast(stoppedSince()));
        case "DestinationSummary":
            return Optional.ofNullable(clazz.cast(destinationSummary()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("EventStreamName", EVENT_STREAM_NAME_FIELD);
        map.put("EventStreamArn", EVENT_STREAM_ARN_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StoppedSince", STOPPED_SINCE_FIELD);
        map.put("DestinationSummary", DESTINATION_SUMMARY_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventStreamSummary, T> g) {
        return obj -> g.apply((EventStreamSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventStreamSummary> {
        /**
         * <p>
         * The unique name of the domain.
         * </p>
         * 
         * @param domainName
         *        The unique name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The name of the event stream.
         * </p>
         * 
         * @param eventStreamName
         *        The name of the event stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventStreamName(String eventStreamName);

        /**
         * <p>
         * A unique identifier for the event stream.
         * </p>
         * 
         * @param eventStreamArn
         *        A unique identifier for the event stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventStreamArn(String eventStreamArn);

        /**
         * <p>
         * The operational state of destination stream for export.
         * </p>
         * 
         * @param state
         *        The operational state of destination stream for export.
         * @see EventStreamState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventStreamState
         */
        Builder state(String state);

        /**
         * <p>
         * The operational state of destination stream for export.
         * </p>
         * 
         * @param state
         *        The operational state of destination stream for export.
         * @see EventStreamState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EventStreamState
         */
        Builder state(EventStreamState state);

        /**
         * <p>
         * The timestamp when the <code>State</code> changed to <code>STOPPED</code>.
         * </p>
         * 
         * @param stoppedSince
         *        The timestamp when the <code>State</code> changed to <code>STOPPED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppedSince(Instant stoppedSince);

        /**
         * <p>
         * Summary information about the Kinesis data stream.
         * </p>
         * 
         * @param destinationSummary
         *        Summary information about the Kinesis data stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationSummary(DestinationSummary destinationSummary);

        /**
         * <p>
         * Summary information about the Kinesis data stream.
         * </p>
         * This is a convenience method that creates an instance of the {@link DestinationSummary.Builder} avoiding the
         * need to create one manually via {@link DestinationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DestinationSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationSummary(DestinationSummary)}.
         * 
         * @param destinationSummary
         *        a consumer that will call methods on {@link DestinationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationSummary(DestinationSummary)
         */
        default Builder destinationSummary(Consumer<DestinationSummary.Builder> destinationSummary) {
            return destinationSummary(DestinationSummary.builder().applyMutation(destinationSummary).build());
        }

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String domainName;

        private String eventStreamName;

        private String eventStreamArn;

        private String state;

        private Instant stoppedSince;

        private DestinationSummary destinationSummary;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventStreamSummary model) {
            domainName(model.domainName);
            eventStreamName(model.eventStreamName);
            eventStreamArn(model.eventStreamArn);
            state(model.state);
            stoppedSince(model.stoppedSince);
            destinationSummary(model.destinationSummary);
            tags(model.tags);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getEventStreamName() {
            return eventStreamName;
        }

        public final void setEventStreamName(String eventStreamName) {
            this.eventStreamName = eventStreamName;
        }

        @Override
        public final Builder eventStreamName(String eventStreamName) {
            this.eventStreamName = eventStreamName;
            return this;
        }

        public final String getEventStreamArn() {
            return eventStreamArn;
        }

        public final void setEventStreamArn(String eventStreamArn) {
            this.eventStreamArn = eventStreamArn;
        }

        @Override
        public final Builder eventStreamArn(String eventStreamArn) {
            this.eventStreamArn = eventStreamArn;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(EventStreamState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getStoppedSince() {
            return stoppedSince;
        }

        public final void setStoppedSince(Instant stoppedSince) {
            this.stoppedSince = stoppedSince;
        }

        @Override
        public final Builder stoppedSince(Instant stoppedSince) {
            this.stoppedSince = stoppedSince;
            return this;
        }

        public final DestinationSummary.Builder getDestinationSummary() {
            return destinationSummary != null ? destinationSummary.toBuilder() : null;
        }

        public final void setDestinationSummary(DestinationSummary.BuilderImpl destinationSummary) {
            this.destinationSummary = destinationSummary != null ? destinationSummary.build() : null;
        }

        @Override
        public final Builder destinationSummary(DestinationSummary destinationSummary) {
            this.destinationSummary = destinationSummary;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public EventStreamSummary build() {
            return new EventStreamSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
