/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A specific event dimension to be assessed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventTriggerDimension implements SdkPojo, Serializable,
        ToCopyableBuilder<EventTriggerDimension.Builder, EventTriggerDimension> {
    private static final SdkField<List<ObjectAttribute>> OBJECT_ATTRIBUTES_FIELD = SdkField
            .<List<ObjectAttribute>> builder(MarshallingType.LIST)
            .memberName("ObjectAttributes")
            .getter(getter(EventTriggerDimension::objectAttributes))
            .setter(setter(Builder::objectAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ObjectAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(ObjectAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ObjectAttribute> objectAttributes;

    private EventTriggerDimension(BuilderImpl builder) {
        this.objectAttributes = builder.objectAttributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the ObjectAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasObjectAttributes() {
        return objectAttributes != null && !(objectAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of object attributes to be evaluated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasObjectAttributes} method.
     * </p>
     * 
     * @return A list of object attributes to be evaluated.
     */
    public final List<ObjectAttribute> objectAttributes() {
        return objectAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasObjectAttributes() ? objectAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventTriggerDimension)) {
            return false;
        }
        EventTriggerDimension other = (EventTriggerDimension) obj;
        return hasObjectAttributes() == other.hasObjectAttributes()
                && Objects.equals(objectAttributes(), other.objectAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventTriggerDimension")
                .add("ObjectAttributes", hasObjectAttributes() ? objectAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ObjectAttributes":
            return Optional.ofNullable(clazz.cast(objectAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ObjectAttributes", OBJECT_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventTriggerDimension, T> g) {
        return obj -> g.apply((EventTriggerDimension) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventTriggerDimension> {
        /**
         * <p>
         * A list of object attributes to be evaluated.
         * </p>
         * 
         * @param objectAttributes
         *        A list of object attributes to be evaluated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectAttributes(Collection<ObjectAttribute> objectAttributes);

        /**
         * <p>
         * A list of object attributes to be evaluated.
         * </p>
         * 
         * @param objectAttributes
         *        A list of object attributes to be evaluated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectAttributes(ObjectAttribute... objectAttributes);

        /**
         * <p>
         * A list of object attributes to be evaluated.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.customerprofiles.model.ObjectAttribute.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.customerprofiles.model.ObjectAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.customerprofiles.model.ObjectAttribute.Builder#build()} is called
         * immediately and its result is passed to {@link #objectAttributes(List<ObjectAttribute>)}.
         * 
         * @param objectAttributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.customerprofiles.model.ObjectAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #objectAttributes(java.util.Collection<ObjectAttribute>)
         */
        Builder objectAttributes(Consumer<ObjectAttribute.Builder>... objectAttributes);
    }

    static final class BuilderImpl implements Builder {
        private List<ObjectAttribute> objectAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventTriggerDimension model) {
            objectAttributes(model.objectAttributes);
        }

        public final List<ObjectAttribute.Builder> getObjectAttributes() {
            List<ObjectAttribute.Builder> result = ObjectAttributesCopier.copyToBuilder(this.objectAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setObjectAttributes(Collection<ObjectAttribute.BuilderImpl> objectAttributes) {
            this.objectAttributes = ObjectAttributesCopier.copyFromBuilder(objectAttributes);
        }

        @Override
        public final Builder objectAttributes(Collection<ObjectAttribute> objectAttributes) {
            this.objectAttributes = ObjectAttributesCopier.copy(objectAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectAttributes(ObjectAttribute... objectAttributes) {
            objectAttributes(Arrays.asList(objectAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectAttributes(Consumer<ObjectAttribute.Builder>... objectAttributes) {
            objectAttributes(Stream.of(objectAttributes).map(c -> ObjectAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public EventTriggerDimension build() {
            return new EventTriggerDimension(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
