/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of the event trigger.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventTriggerSummaryItem implements SdkPojo, Serializable,
        ToCopyableBuilder<EventTriggerSummaryItem.Builder, EventTriggerSummaryItem> {
    private static final SdkField<String> OBJECT_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectTypeName").getter(getter(EventTriggerSummaryItem::objectTypeName))
            .setter(setter(Builder::objectTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectTypeName").build()).build();

    private static final SdkField<String> EVENT_TRIGGER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventTriggerName").getter(getter(EventTriggerSummaryItem::eventTriggerName))
            .setter(setter(Builder::eventTriggerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTriggerName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(EventTriggerSummaryItem::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(EventTriggerSummaryItem::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAt").getter(getter(EventTriggerSummaryItem::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(EventTriggerSummaryItem::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_TYPE_NAME_FIELD,
            EVENT_TRIGGER_NAME_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String objectTypeName;

    private final String eventTriggerName;

    private final String description;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final Map<String, String> tags;

    private EventTriggerSummaryItem(BuilderImpl builder) {
        this.objectTypeName = builder.objectTypeName;
        this.eventTriggerName = builder.eventTriggerName;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique name of the object type.
     * </p>
     * 
     * @return The unique name of the object type.
     */
    public final String objectTypeName() {
        return objectTypeName;
    }

    /**
     * <p>
     * The unique name of the event trigger.
     * </p>
     * 
     * @return The unique name of the event trigger.
     */
    public final String eventTriggerName() {
        return eventTriggerName;
    }

    /**
     * <p>
     * The description of the event trigger.
     * </p>
     * 
     * @return The description of the event trigger.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The timestamp of when the event trigger was created.
     * </p>
     * 
     * @return The timestamp of when the event trigger was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp of when the event trigger was most recently updated.
     * </p>
     * 
     * @return The timestamp of when the event trigger was most recently updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An array of key-value pairs to apply to this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An array of key-value pairs to apply to this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(objectTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(eventTriggerName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventTriggerSummaryItem)) {
            return false;
        }
        EventTriggerSummaryItem other = (EventTriggerSummaryItem) obj;
        return Objects.equals(objectTypeName(), other.objectTypeName())
                && Objects.equals(eventTriggerName(), other.eventTriggerName())
                && Objects.equals(description(), other.description()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventTriggerSummaryItem").add("ObjectTypeName", objectTypeName())
                .add("EventTriggerName", eventTriggerName()).add("Description", description()).add("CreatedAt", createdAt())
                .add("LastUpdatedAt", lastUpdatedAt()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ObjectTypeName":
            return Optional.ofNullable(clazz.cast(objectTypeName()));
        case "EventTriggerName":
            return Optional.ofNullable(clazz.cast(eventTriggerName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ObjectTypeName", OBJECT_TYPE_NAME_FIELD);
        map.put("EventTriggerName", EVENT_TRIGGER_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventTriggerSummaryItem, T> g) {
        return obj -> g.apply((EventTriggerSummaryItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventTriggerSummaryItem> {
        /**
         * <p>
         * The unique name of the object type.
         * </p>
         * 
         * @param objectTypeName
         *        The unique name of the object type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectTypeName(String objectTypeName);

        /**
         * <p>
         * The unique name of the event trigger.
         * </p>
         * 
         * @param eventTriggerName
         *        The unique name of the event trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTriggerName(String eventTriggerName);

        /**
         * <p>
         * The description of the event trigger.
         * </p>
         * 
         * @param description
         *        The description of the event trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The timestamp of when the event trigger was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the event trigger was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp of when the event trigger was most recently updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The timestamp of when the event trigger was most recently updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * An array of key-value pairs to apply to this resource.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs to apply to this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String objectTypeName;

        private String eventTriggerName;

        private String description;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventTriggerSummaryItem model) {
            objectTypeName(model.objectTypeName);
            eventTriggerName(model.eventTriggerName);
            description(model.description);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            tags(model.tags);
        }

        public final String getObjectTypeName() {
            return objectTypeName;
        }

        public final void setObjectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
        }

        @Override
        public final Builder objectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
            return this;
        }

        public final String getEventTriggerName() {
            return eventTriggerName;
        }

        public final void setEventTriggerName(String eventTriggerName) {
            this.eventTriggerName = eventTriggerName;
        }

        @Override
        public final Builder eventTriggerName(String eventTriggerName) {
            this.eventTriggerName = eventTriggerName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public EventTriggerSummaryItem build() {
            return new EventTriggerSummaryItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
