/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information about the S3 bucket where Identity Resolution Jobs writes result files.
 * </p>
 * <note>
 * <p>
 * You need to give Customer Profiles service principal write permission to your S3 bucket. Otherwise, you'll get an
 * exception in the API response. For an example policy, see <a href=
 * "https://docs.aws.amazon.com/connect/latest/adminguide/cross-service-confused-deputy-prevention.html#customer-profiles-cross-service"
 * >Amazon Connect Customer Profiles cross-service confused deputy prevention</a>.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportingConfig implements SdkPojo, Serializable, ToCopyableBuilder<ExportingConfig.Builder, ExportingConfig> {
    private static final SdkField<S3ExportingConfig> S3_EXPORTING_FIELD = SdkField
            .<S3ExportingConfig> builder(MarshallingType.SDK_POJO).memberName("S3Exporting")
            .getter(getter(ExportingConfig::s3Exporting)).setter(setter(Builder::s3Exporting))
            .constructor(S3ExportingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Exporting").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_EXPORTING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final S3ExportingConfig s3Exporting;

    private ExportingConfig(BuilderImpl builder) {
        this.s3Exporting = builder.s3Exporting;
    }

    /**
     * <p>
     * The S3 location where Identity Resolution Jobs write result files.
     * </p>
     * 
     * @return The S3 location where Identity Resolution Jobs write result files.
     */
    public final S3ExportingConfig s3Exporting() {
        return s3Exporting;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Exporting());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportingConfig)) {
            return false;
        }
        ExportingConfig other = (ExportingConfig) obj;
        return Objects.equals(s3Exporting(), other.s3Exporting());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportingConfig").add("S3Exporting", s3Exporting()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Exporting":
            return Optional.ofNullable(clazz.cast(s3Exporting()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S3Exporting", S3_EXPORTING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportingConfig, T> g) {
        return obj -> g.apply((ExportingConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportingConfig> {
        /**
         * <p>
         * The S3 location where Identity Resolution Jobs write result files.
         * </p>
         * 
         * @param s3Exporting
         *        The S3 location where Identity Resolution Jobs write result files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Exporting(S3ExportingConfig s3Exporting);

        /**
         * <p>
         * The S3 location where Identity Resolution Jobs write result files.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3ExportingConfig.Builder} avoiding the
         * need to create one manually via {@link S3ExportingConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3ExportingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #s3Exporting(S3ExportingConfig)}.
         * 
         * @param s3Exporting
         *        a consumer that will call methods on {@link S3ExportingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Exporting(S3ExportingConfig)
         */
        default Builder s3Exporting(Consumer<S3ExportingConfig.Builder> s3Exporting) {
            return s3Exporting(S3ExportingConfig.builder().applyMutation(s3Exporting).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3ExportingConfig s3Exporting;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportingConfig model) {
            s3Exporting(model.s3Exporting);
        }

        public final S3ExportingConfig.Builder getS3Exporting() {
            return s3Exporting != null ? s3Exporting.toBuilder() : null;
        }

        public final void setS3Exporting(S3ExportingConfig.BuilderImpl s3Exporting) {
            this.s3Exporting = s3Exporting != null ? s3Exporting.build() : null;
        }

        @Override
        public final Builder s3Exporting(S3ExportingConfig s3Exporting) {
            this.s3Exporting = s3Exporting;
            return this;
        }

        @Override
        public ExportingConfig build() {
            return new ExportingConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
