/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A duplicate customer profile that is to be merged into a main profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FieldSourceProfileIds implements SdkPojo, Serializable,
        ToCopyableBuilder<FieldSourceProfileIds.Builder, FieldSourceProfileIds> {
    private static final SdkField<String> ACCOUNT_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountNumber").getter(getter(FieldSourceProfileIds::accountNumber))
            .setter(setter(Builder::accountNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountNumber").build()).build();

    private static final SdkField<String> ADDITIONAL_INFORMATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdditionalInformation").getter(getter(FieldSourceProfileIds::additionalInformation))
            .setter(setter(Builder::additionalInformation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalInformation").build())
            .build();

    private static final SdkField<String> PARTY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PartyType").getter(getter(FieldSourceProfileIds::partyType)).setter(setter(Builder::partyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartyType").build()).build();

    private static final SdkField<String> BUSINESS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BusinessName").getter(getter(FieldSourceProfileIds::businessName)).setter(setter(Builder::businessName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessName").build()).build();

    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirstName").getter(getter(FieldSourceProfileIds::firstName)).setter(setter(Builder::firstName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstName").build()).build();

    private static final SdkField<String> MIDDLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MiddleName").getter(getter(FieldSourceProfileIds::middleName)).setter(setter(Builder::middleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MiddleName").build()).build();

    private static final SdkField<String> LAST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastName").getter(getter(FieldSourceProfileIds::lastName)).setter(setter(Builder::lastName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastName").build()).build();

    private static final SdkField<String> BIRTH_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BirthDate").getter(getter(FieldSourceProfileIds::birthDate)).setter(setter(Builder::birthDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BirthDate").build()).build();

    private static final SdkField<String> GENDER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Gender")
            .getter(getter(FieldSourceProfileIds::gender)).setter(setter(Builder::gender))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Gender").build()).build();

    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumber").getter(getter(FieldSourceProfileIds::phoneNumber)).setter(setter(Builder::phoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()).build();

    private static final SdkField<String> MOBILE_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MobilePhoneNumber").getter(getter(FieldSourceProfileIds::mobilePhoneNumber))
            .setter(setter(Builder::mobilePhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MobilePhoneNumber").build()).build();

    private static final SdkField<String> HOME_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HomePhoneNumber").getter(getter(FieldSourceProfileIds::homePhoneNumber))
            .setter(setter(Builder::homePhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomePhoneNumber").build()).build();

    private static final SdkField<String> BUSINESS_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BusinessPhoneNumber").getter(getter(FieldSourceProfileIds::businessPhoneNumber))
            .setter(setter(Builder::businessPhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessPhoneNumber").build())
            .build();

    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailAddress").getter(getter(FieldSourceProfileIds::emailAddress)).setter(setter(Builder::emailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()).build();

    private static final SdkField<String> PERSONAL_EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PersonalEmailAddress").getter(getter(FieldSourceProfileIds::personalEmailAddress))
            .setter(setter(Builder::personalEmailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersonalEmailAddress").build())
            .build();

    private static final SdkField<String> BUSINESS_EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BusinessEmailAddress").getter(getter(FieldSourceProfileIds::businessEmailAddress))
            .setter(setter(Builder::businessEmailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessEmailAddress").build())
            .build();

    private static final SdkField<String> ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Address")
            .getter(getter(FieldSourceProfileIds::address)).setter(setter(Builder::address))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()).build();

    private static final SdkField<String> SHIPPING_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShippingAddress").getter(getter(FieldSourceProfileIds::shippingAddress))
            .setter(setter(Builder::shippingAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShippingAddress").build()).build();

    private static final SdkField<String> MAILING_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MailingAddress").getter(getter(FieldSourceProfileIds::mailingAddress))
            .setter(setter(Builder::mailingAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MailingAddress").build()).build();

    private static final SdkField<String> BILLING_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BillingAddress").getter(getter(FieldSourceProfileIds::billingAddress))
            .setter(setter(Builder::billingAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingAddress").build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Attributes")
            .getter(getter(FieldSourceProfileIds::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> PROFILE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileType").getter(getter(FieldSourceProfileIds::profileType)).setter(setter(Builder::profileType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileType").build()).build();

    private static final SdkField<String> ENGAGEMENT_PREFERENCES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngagementPreferences").getter(getter(FieldSourceProfileIds::engagementPreferences))
            .setter(setter(Builder::engagementPreferences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementPreferences").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_NUMBER_FIELD,
            ADDITIONAL_INFORMATION_FIELD, PARTY_TYPE_FIELD, BUSINESS_NAME_FIELD, FIRST_NAME_FIELD, MIDDLE_NAME_FIELD,
            LAST_NAME_FIELD, BIRTH_DATE_FIELD, GENDER_FIELD, PHONE_NUMBER_FIELD, MOBILE_PHONE_NUMBER_FIELD,
            HOME_PHONE_NUMBER_FIELD, BUSINESS_PHONE_NUMBER_FIELD, EMAIL_ADDRESS_FIELD, PERSONAL_EMAIL_ADDRESS_FIELD,
            BUSINESS_EMAIL_ADDRESS_FIELD, ADDRESS_FIELD, SHIPPING_ADDRESS_FIELD, MAILING_ADDRESS_FIELD, BILLING_ADDRESS_FIELD,
            ATTRIBUTES_FIELD, PROFILE_TYPE_FIELD, ENGAGEMENT_PREFERENCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountNumber;

    private final String additionalInformation;

    private final String partyType;

    private final String businessName;

    private final String firstName;

    private final String middleName;

    private final String lastName;

    private final String birthDate;

    private final String gender;

    private final String phoneNumber;

    private final String mobilePhoneNumber;

    private final String homePhoneNumber;

    private final String businessPhoneNumber;

    private final String emailAddress;

    private final String personalEmailAddress;

    private final String businessEmailAddress;

    private final String address;

    private final String shippingAddress;

    private final String mailingAddress;

    private final String billingAddress;

    private final Map<String, String> attributes;

    private final String profileType;

    private final String engagementPreferences;

    private FieldSourceProfileIds(BuilderImpl builder) {
        this.accountNumber = builder.accountNumber;
        this.additionalInformation = builder.additionalInformation;
        this.partyType = builder.partyType;
        this.businessName = builder.businessName;
        this.firstName = builder.firstName;
        this.middleName = builder.middleName;
        this.lastName = builder.lastName;
        this.birthDate = builder.birthDate;
        this.gender = builder.gender;
        this.phoneNumber = builder.phoneNumber;
        this.mobilePhoneNumber = builder.mobilePhoneNumber;
        this.homePhoneNumber = builder.homePhoneNumber;
        this.businessPhoneNumber = builder.businessPhoneNumber;
        this.emailAddress = builder.emailAddress;
        this.personalEmailAddress = builder.personalEmailAddress;
        this.businessEmailAddress = builder.businessEmailAddress;
        this.address = builder.address;
        this.shippingAddress = builder.shippingAddress;
        this.mailingAddress = builder.mailingAddress;
        this.billingAddress = builder.billingAddress;
        this.attributes = builder.attributes;
        this.profileType = builder.profileType;
        this.engagementPreferences = builder.engagementPreferences;
    }

    /**
     * <p>
     * A unique identifier for the account number field to be merged.
     * </p>
     * 
     * @return A unique identifier for the account number field to be merged.
     */
    public final String accountNumber() {
        return accountNumber;
    }

    /**
     * <p>
     * A unique identifier for the additional information field to be merged.
     * </p>
     * 
     * @return A unique identifier for the additional information field to be merged.
     */
    public final String additionalInformation() {
        return additionalInformation;
    }

    /**
     * <p>
     * A unique identifier for the party type field to be merged.
     * </p>
     * 
     * @return A unique identifier for the party type field to be merged.
     */
    public final String partyType() {
        return partyType;
    }

    /**
     * <p>
     * A unique identifier for the business name field to be merged.
     * </p>
     * 
     * @return A unique identifier for the business name field to be merged.
     */
    public final String businessName() {
        return businessName;
    }

    /**
     * <p>
     * A unique identifier for the first name field to be merged.
     * </p>
     * 
     * @return A unique identifier for the first name field to be merged.
     */
    public final String firstName() {
        return firstName;
    }

    /**
     * <p>
     * A unique identifier for the middle name field to be merged.
     * </p>
     * 
     * @return A unique identifier for the middle name field to be merged.
     */
    public final String middleName() {
        return middleName;
    }

    /**
     * <p>
     * A unique identifier for the last name field to be merged.
     * </p>
     * 
     * @return A unique identifier for the last name field to be merged.
     */
    public final String lastName() {
        return lastName;
    }

    /**
     * <p>
     * A unique identifier for the birthdate field to be merged.
     * </p>
     * 
     * @return A unique identifier for the birthdate field to be merged.
     */
    public final String birthDate() {
        return birthDate;
    }

    /**
     * <p>
     * A unique identifier for the gender field to be merged.
     * </p>
     * 
     * @return A unique identifier for the gender field to be merged.
     */
    public final String gender() {
        return gender;
    }

    /**
     * <p>
     * A unique identifier for the phone number field to be merged.
     * </p>
     * 
     * @return A unique identifier for the phone number field to be merged.
     */
    public final String phoneNumber() {
        return phoneNumber;
    }

    /**
     * <p>
     * A unique identifier for the mobile phone number field to be merged.
     * </p>
     * 
     * @return A unique identifier for the mobile phone number field to be merged.
     */
    public final String mobilePhoneNumber() {
        return mobilePhoneNumber;
    }

    /**
     * <p>
     * A unique identifier for the home phone number field to be merged.
     * </p>
     * 
     * @return A unique identifier for the home phone number field to be merged.
     */
    public final String homePhoneNumber() {
        return homePhoneNumber;
    }

    /**
     * <p>
     * A unique identifier for the business phone number field to be merged.
     * </p>
     * 
     * @return A unique identifier for the business phone number field to be merged.
     */
    public final String businessPhoneNumber() {
        return businessPhoneNumber;
    }

    /**
     * <p>
     * A unique identifier for the email address field to be merged.
     * </p>
     * 
     * @return A unique identifier for the email address field to be merged.
     */
    public final String emailAddress() {
        return emailAddress;
    }

    /**
     * <p>
     * A unique identifier for the personal email address field to be merged.
     * </p>
     * 
     * @return A unique identifier for the personal email address field to be merged.
     */
    public final String personalEmailAddress() {
        return personalEmailAddress;
    }

    /**
     * <p>
     * A unique identifier for the party type field to be merged.
     * </p>
     * 
     * @return A unique identifier for the party type field to be merged.
     */
    public final String businessEmailAddress() {
        return businessEmailAddress;
    }

    /**
     * <p>
     * A unique identifier for the party type field to be merged.
     * </p>
     * 
     * @return A unique identifier for the party type field to be merged.
     */
    public final String address() {
        return address;
    }

    /**
     * <p>
     * A unique identifier for the shipping address field to be merged.
     * </p>
     * 
     * @return A unique identifier for the shipping address field to be merged.
     */
    public final String shippingAddress() {
        return shippingAddress;
    }

    /**
     * <p>
     * A unique identifier for the mailing address field to be merged.
     * </p>
     * 
     * @return A unique identifier for the mailing address field to be merged.
     */
    public final String mailingAddress() {
        return mailingAddress;
    }

    /**
     * <p>
     * A unique identifier for the billing type field to be merged.
     * </p>
     * 
     * @return A unique identifier for the billing type field to be merged.
     */
    public final String billingAddress() {
        return billingAddress;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A unique identifier for the attributes field to be merged.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return A unique identifier for the attributes field to be merged.
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    /**
     * <p>
     * A unique identifier for the profile type field to be merged.
     * </p>
     * 
     * @return A unique identifier for the profile type field to be merged.
     */
    public final String profileType() {
        return profileType;
    }

    /**
     * <p>
     * A unique identifier for the engagement preferences field to be merged.
     * </p>
     * 
     * @return A unique identifier for the engagement preferences field to be merged.
     */
    public final String engagementPreferences() {
        return engagementPreferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountNumber());
        hashCode = 31 * hashCode + Objects.hashCode(additionalInformation());
        hashCode = 31 * hashCode + Objects.hashCode(partyType());
        hashCode = 31 * hashCode + Objects.hashCode(businessName());
        hashCode = 31 * hashCode + Objects.hashCode(firstName());
        hashCode = 31 * hashCode + Objects.hashCode(middleName());
        hashCode = 31 * hashCode + Objects.hashCode(lastName());
        hashCode = 31 * hashCode + Objects.hashCode(birthDate());
        hashCode = 31 * hashCode + Objects.hashCode(gender());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(mobilePhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(homePhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(businessPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(personalEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(businessEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(address());
        hashCode = 31 * hashCode + Objects.hashCode(shippingAddress());
        hashCode = 31 * hashCode + Objects.hashCode(mailingAddress());
        hashCode = 31 * hashCode + Objects.hashCode(billingAddress());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(profileType());
        hashCode = 31 * hashCode + Objects.hashCode(engagementPreferences());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldSourceProfileIds)) {
            return false;
        }
        FieldSourceProfileIds other = (FieldSourceProfileIds) obj;
        return Objects.equals(accountNumber(), other.accountNumber())
                && Objects.equals(additionalInformation(), other.additionalInformation())
                && Objects.equals(partyType(), other.partyType()) && Objects.equals(businessName(), other.businessName())
                && Objects.equals(firstName(), other.firstName()) && Objects.equals(middleName(), other.middleName())
                && Objects.equals(lastName(), other.lastName()) && Objects.equals(birthDate(), other.birthDate())
                && Objects.equals(gender(), other.gender()) && Objects.equals(phoneNumber(), other.phoneNumber())
                && Objects.equals(mobilePhoneNumber(), other.mobilePhoneNumber())
                && Objects.equals(homePhoneNumber(), other.homePhoneNumber())
                && Objects.equals(businessPhoneNumber(), other.businessPhoneNumber())
                && Objects.equals(emailAddress(), other.emailAddress())
                && Objects.equals(personalEmailAddress(), other.personalEmailAddress())
                && Objects.equals(businessEmailAddress(), other.businessEmailAddress())
                && Objects.equals(address(), other.address()) && Objects.equals(shippingAddress(), other.shippingAddress())
                && Objects.equals(mailingAddress(), other.mailingAddress())
                && Objects.equals(billingAddress(), other.billingAddress()) && hasAttributes() == other.hasAttributes()
                && Objects.equals(attributes(), other.attributes()) && Objects.equals(profileType(), other.profileType())
                && Objects.equals(engagementPreferences(), other.engagementPreferences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FieldSourceProfileIds").add("AccountNumber", accountNumber())
                .add("AdditionalInformation", additionalInformation()).add("PartyType", partyType())
                .add("BusinessName", businessName()).add("FirstName", firstName()).add("MiddleName", middleName())
                .add("LastName", lastName()).add("BirthDate", birthDate()).add("Gender", gender())
                .add("PhoneNumber", phoneNumber()).add("MobilePhoneNumber", mobilePhoneNumber())
                .add("HomePhoneNumber", homePhoneNumber()).add("BusinessPhoneNumber", businessPhoneNumber())
                .add("EmailAddress", emailAddress()).add("PersonalEmailAddress", personalEmailAddress())
                .add("BusinessEmailAddress", businessEmailAddress()).add("Address", address())
                .add("ShippingAddress", shippingAddress()).add("MailingAddress", mailingAddress())
                .add("BillingAddress", billingAddress()).add("Attributes", hasAttributes() ? attributes() : null)
                .add("ProfileType", profileType()).add("EngagementPreferences", engagementPreferences()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountNumber":
            return Optional.ofNullable(clazz.cast(accountNumber()));
        case "AdditionalInformation":
            return Optional.ofNullable(clazz.cast(additionalInformation()));
        case "PartyType":
            return Optional.ofNullable(clazz.cast(partyType()));
        case "BusinessName":
            return Optional.ofNullable(clazz.cast(businessName()));
        case "FirstName":
            return Optional.ofNullable(clazz.cast(firstName()));
        case "MiddleName":
            return Optional.ofNullable(clazz.cast(middleName()));
        case "LastName":
            return Optional.ofNullable(clazz.cast(lastName()));
        case "BirthDate":
            return Optional.ofNullable(clazz.cast(birthDate()));
        case "Gender":
            return Optional.ofNullable(clazz.cast(gender()));
        case "PhoneNumber":
            return Optional.ofNullable(clazz.cast(phoneNumber()));
        case "MobilePhoneNumber":
            return Optional.ofNullable(clazz.cast(mobilePhoneNumber()));
        case "HomePhoneNumber":
            return Optional.ofNullable(clazz.cast(homePhoneNumber()));
        case "BusinessPhoneNumber":
            return Optional.ofNullable(clazz.cast(businessPhoneNumber()));
        case "EmailAddress":
            return Optional.ofNullable(clazz.cast(emailAddress()));
        case "PersonalEmailAddress":
            return Optional.ofNullable(clazz.cast(personalEmailAddress()));
        case "BusinessEmailAddress":
            return Optional.ofNullable(clazz.cast(businessEmailAddress()));
        case "Address":
            return Optional.ofNullable(clazz.cast(address()));
        case "ShippingAddress":
            return Optional.ofNullable(clazz.cast(shippingAddress()));
        case "MailingAddress":
            return Optional.ofNullable(clazz.cast(mailingAddress()));
        case "BillingAddress":
            return Optional.ofNullable(clazz.cast(billingAddress()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "ProfileType":
            return Optional.ofNullable(clazz.cast(profileType()));
        case "EngagementPreferences":
            return Optional.ofNullable(clazz.cast(engagementPreferences()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccountNumber", ACCOUNT_NUMBER_FIELD);
        map.put("AdditionalInformation", ADDITIONAL_INFORMATION_FIELD);
        map.put("PartyType", PARTY_TYPE_FIELD);
        map.put("BusinessName", BUSINESS_NAME_FIELD);
        map.put("FirstName", FIRST_NAME_FIELD);
        map.put("MiddleName", MIDDLE_NAME_FIELD);
        map.put("LastName", LAST_NAME_FIELD);
        map.put("BirthDate", BIRTH_DATE_FIELD);
        map.put("Gender", GENDER_FIELD);
        map.put("PhoneNumber", PHONE_NUMBER_FIELD);
        map.put("MobilePhoneNumber", MOBILE_PHONE_NUMBER_FIELD);
        map.put("HomePhoneNumber", HOME_PHONE_NUMBER_FIELD);
        map.put("BusinessPhoneNumber", BUSINESS_PHONE_NUMBER_FIELD);
        map.put("EmailAddress", EMAIL_ADDRESS_FIELD);
        map.put("PersonalEmailAddress", PERSONAL_EMAIL_ADDRESS_FIELD);
        map.put("BusinessEmailAddress", BUSINESS_EMAIL_ADDRESS_FIELD);
        map.put("Address", ADDRESS_FIELD);
        map.put("ShippingAddress", SHIPPING_ADDRESS_FIELD);
        map.put("MailingAddress", MAILING_ADDRESS_FIELD);
        map.put("BillingAddress", BILLING_ADDRESS_FIELD);
        map.put("Attributes", ATTRIBUTES_FIELD);
        map.put("ProfileType", PROFILE_TYPE_FIELD);
        map.put("EngagementPreferences", ENGAGEMENT_PREFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FieldSourceProfileIds, T> g) {
        return obj -> g.apply((FieldSourceProfileIds) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FieldSourceProfileIds> {
        /**
         * <p>
         * A unique identifier for the account number field to be merged.
         * </p>
         * 
         * @param accountNumber
         *        A unique identifier for the account number field to be merged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountNumber(String accountNumber);

        /**
         * <p>
         * A unique identifier for the additional information field to be merged.
         * </p>
         * 
         * @param additionalInformation
         *        A unique identifier for the additional information field to be merged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalInformation(String additionalInformation);

        /**
         * <p>
         * A unique identifier for the party type field to be merged.
         * </p>
         * 
         * @param partyType
         *        A unique identifier for the party type field to be merged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partyType(String partyType);

        /**
         * <p>
         * A unique identifier for the business name field to be merged.
         * </p>
         * 
         * @param businessName
         *        A unique identifier for the business name field to be merged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessName(String businessName);

        /**
         * <p>
         * A unique identifier for the first name field to be merged.
         * </p>
         * 
         * @param firstName
         *        A unique identifier for the first name field to be merged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstName(String firstName);

        /**
         * <p>
         * A unique identifier for the middle name field to be merged.
         * </p>
         * 
         * @param middleName
         *        A unique identifier for the middle name field to be merged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder middleName(String middleName);

        /**
         * <p>
         * A unique identifier for the last name field to be merged.
         * </p>
         * 
         * @param lastName
         *        A unique identifier for the last name field to be merged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastName(String lastName);

        /**
         * <p>
         * A unique identifier for the birthdate field to be merged.
         * </p>
         * 
         * @param birthDate
         *        A unique identifier for the birthdate field to be merged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder birthDate(String birthDate);

        /**
         * <p>
         * A unique identifier for the gender field to be merged.
         * </p>
         * 
         * @param gender
         *        A unique identifier for the gender field to be merged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gender(String gender);

        /**
         * <p>
         * A unique identifier for the phone number field to be merged.
         * </p>
         * 
         * @param phoneNumber
         *        A unique identifier for the phone number field to be merged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String phoneNumber);

        /**
         * <p>
         * A unique identifier for the mobile phone number field to be merged.
         * </p>
         * 
         * @param mobilePhoneNumber
         *        A unique identifier for the mobile phone number field to be merged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mobilePhoneNumber(String mobilePhoneNumber);

        /**
         * <p>
         * A unique identifier for the home phone number field to be merged.
         * </p>
         * 
         * @param homePhoneNumber
         *        A unique identifier for the home phone number field to be merged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homePhoneNumber(String homePhoneNumber);

        /**
         * <p>
         * A unique identifier for the business phone number field to be merged.
         * </p>
         * 
         * @param businessPhoneNumber
         *        A unique identifier for the business phone number field to be merged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessPhoneNumber(String businessPhoneNumber);

        /**
         * <p>
         * A unique identifier for the email address field to be merged.
         * </p>
         * 
         * @param emailAddress
         *        A unique identifier for the email address field to be merged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);

        /**
         * <p>
         * A unique identifier for the personal email address field to be merged.
         * </p>
         * 
         * @param personalEmailAddress
         *        A unique identifier for the personal email address field to be merged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder personalEmailAddress(String personalEmailAddress);

        /**
         * <p>
         * A unique identifier for the party type field to be merged.
         * </p>
         * 
         * @param businessEmailAddress
         *        A unique identifier for the party type field to be merged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessEmailAddress(String businessEmailAddress);

        /**
         * <p>
         * A unique identifier for the party type field to be merged.
         * </p>
         * 
         * @param address
         *        A unique identifier for the party type field to be merged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(String address);

        /**
         * <p>
         * A unique identifier for the shipping address field to be merged.
         * </p>
         * 
         * @param shippingAddress
         *        A unique identifier for the shipping address field to be merged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shippingAddress(String shippingAddress);

        /**
         * <p>
         * A unique identifier for the mailing address field to be merged.
         * </p>
         * 
         * @param mailingAddress
         *        A unique identifier for the mailing address field to be merged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mailingAddress(String mailingAddress);

        /**
         * <p>
         * A unique identifier for the billing type field to be merged.
         * </p>
         * 
         * @param billingAddress
         *        A unique identifier for the billing type field to be merged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingAddress(String billingAddress);

        /**
         * <p>
         * A unique identifier for the attributes field to be merged.
         * </p>
         * 
         * @param attributes
         *        A unique identifier for the attributes field to be merged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * A unique identifier for the profile type field to be merged.
         * </p>
         * 
         * @param profileType
         *        A unique identifier for the profile type field to be merged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileType(String profileType);

        /**
         * <p>
         * A unique identifier for the engagement preferences field to be merged.
         * </p>
         * 
         * @param engagementPreferences
         *        A unique identifier for the engagement preferences field to be merged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagementPreferences(String engagementPreferences);
    }

    static final class BuilderImpl implements Builder {
        private String accountNumber;

        private String additionalInformation;

        private String partyType;

        private String businessName;

        private String firstName;

        private String middleName;

        private String lastName;

        private String birthDate;

        private String gender;

        private String phoneNumber;

        private String mobilePhoneNumber;

        private String homePhoneNumber;

        private String businessPhoneNumber;

        private String emailAddress;

        private String personalEmailAddress;

        private String businessEmailAddress;

        private String address;

        private String shippingAddress;

        private String mailingAddress;

        private String billingAddress;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private String profileType;

        private String engagementPreferences;

        private BuilderImpl() {
        }

        private BuilderImpl(FieldSourceProfileIds model) {
            accountNumber(model.accountNumber);
            additionalInformation(model.additionalInformation);
            partyType(model.partyType);
            businessName(model.businessName);
            firstName(model.firstName);
            middleName(model.middleName);
            lastName(model.lastName);
            birthDate(model.birthDate);
            gender(model.gender);
            phoneNumber(model.phoneNumber);
            mobilePhoneNumber(model.mobilePhoneNumber);
            homePhoneNumber(model.homePhoneNumber);
            businessPhoneNumber(model.businessPhoneNumber);
            emailAddress(model.emailAddress);
            personalEmailAddress(model.personalEmailAddress);
            businessEmailAddress(model.businessEmailAddress);
            address(model.address);
            shippingAddress(model.shippingAddress);
            mailingAddress(model.mailingAddress);
            billingAddress(model.billingAddress);
            attributes(model.attributes);
            profileType(model.profileType);
            engagementPreferences(model.engagementPreferences);
        }

        public final String getAccountNumber() {
            return accountNumber;
        }

        public final void setAccountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
        }

        @Override
        public final Builder accountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        public final String getAdditionalInformation() {
            return additionalInformation;
        }

        public final void setAdditionalInformation(String additionalInformation) {
            this.additionalInformation = additionalInformation;
        }

        @Override
        public final Builder additionalInformation(String additionalInformation) {
            this.additionalInformation = additionalInformation;
            return this;
        }

        public final String getPartyType() {
            return partyType;
        }

        public final void setPartyType(String partyType) {
            this.partyType = partyType;
        }

        @Override
        public final Builder partyType(String partyType) {
            this.partyType = partyType;
            return this;
        }

        public final String getBusinessName() {
            return businessName;
        }

        public final void setBusinessName(String businessName) {
            this.businessName = businessName;
        }

        @Override
        public final Builder businessName(String businessName) {
            this.businessName = businessName;
            return this;
        }

        public final String getFirstName() {
            return firstName;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final String getMiddleName() {
            return middleName;
        }

        public final void setMiddleName(String middleName) {
            this.middleName = middleName;
        }

        @Override
        public final Builder middleName(String middleName) {
            this.middleName = middleName;
            return this;
        }

        public final String getLastName() {
            return lastName;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final String getBirthDate() {
            return birthDate;
        }

        public final void setBirthDate(String birthDate) {
            this.birthDate = birthDate;
        }

        @Override
        public final Builder birthDate(String birthDate) {
            this.birthDate = birthDate;
            return this;
        }

        public final String getGender() {
            return gender;
        }

        public final void setGender(String gender) {
            this.gender = gender;
        }

        @Override
        public final Builder gender(String gender) {
            this.gender = gender;
            return this;
        }

        public final String getPhoneNumber() {
            return phoneNumber;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final String getMobilePhoneNumber() {
            return mobilePhoneNumber;
        }

        public final void setMobilePhoneNumber(String mobilePhoneNumber) {
            this.mobilePhoneNumber = mobilePhoneNumber;
        }

        @Override
        public final Builder mobilePhoneNumber(String mobilePhoneNumber) {
            this.mobilePhoneNumber = mobilePhoneNumber;
            return this;
        }

        public final String getHomePhoneNumber() {
            return homePhoneNumber;
        }

        public final void setHomePhoneNumber(String homePhoneNumber) {
            this.homePhoneNumber = homePhoneNumber;
        }

        @Override
        public final Builder homePhoneNumber(String homePhoneNumber) {
            this.homePhoneNumber = homePhoneNumber;
            return this;
        }

        public final String getBusinessPhoneNumber() {
            return businessPhoneNumber;
        }

        public final void setBusinessPhoneNumber(String businessPhoneNumber) {
            this.businessPhoneNumber = businessPhoneNumber;
        }

        @Override
        public final Builder businessPhoneNumber(String businessPhoneNumber) {
            this.businessPhoneNumber = businessPhoneNumber;
            return this;
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final String getPersonalEmailAddress() {
            return personalEmailAddress;
        }

        public final void setPersonalEmailAddress(String personalEmailAddress) {
            this.personalEmailAddress = personalEmailAddress;
        }

        @Override
        public final Builder personalEmailAddress(String personalEmailAddress) {
            this.personalEmailAddress = personalEmailAddress;
            return this;
        }

        public final String getBusinessEmailAddress() {
            return businessEmailAddress;
        }

        public final void setBusinessEmailAddress(String businessEmailAddress) {
            this.businessEmailAddress = businessEmailAddress;
        }

        @Override
        public final Builder businessEmailAddress(String businessEmailAddress) {
            this.businessEmailAddress = businessEmailAddress;
            return this;
        }

        public final String getAddress() {
            return address;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final String getShippingAddress() {
            return shippingAddress;
        }

        public final void setShippingAddress(String shippingAddress) {
            this.shippingAddress = shippingAddress;
        }

        @Override
        public final Builder shippingAddress(String shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        public final String getMailingAddress() {
            return mailingAddress;
        }

        public final void setMailingAddress(String mailingAddress) {
            this.mailingAddress = mailingAddress;
        }

        @Override
        public final Builder mailingAddress(String mailingAddress) {
            this.mailingAddress = mailingAddress;
            return this;
        }

        public final String getBillingAddress() {
            return billingAddress;
        }

        public final void setBillingAddress(String billingAddress) {
            this.billingAddress = billingAddress;
        }

        @Override
        public final Builder billingAddress(String billingAddress) {
            this.billingAddress = billingAddress;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributeSourceIdMapCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributeSourceIdMapCopier.copy(attributes);
            return this;
        }

        public final String getProfileType() {
            return profileType;
        }

        public final void setProfileType(String profileType) {
            this.profileType = profileType;
        }

        @Override
        public final Builder profileType(String profileType) {
            this.profileType = profileType;
            return this;
        }

        public final String getEngagementPreferences() {
            return engagementPreferences;
        }

        public final void setEngagementPreferences(String engagementPreferences) {
            this.engagementPreferences = engagementPreferences;
        }

        @Override
        public final Builder engagementPreferences(String engagementPreferences) {
            this.engagementPreferences = engagementPreferences;
            return this;
        }

        @Override
        public FieldSourceProfileIds build() {
            return new FieldSourceProfileIds(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
