/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAutoMergingPreviewRequest extends CustomerProfilesRequest implements
        ToCopyableBuilder<GetAutoMergingPreviewRequest.Builder, GetAutoMergingPreviewRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(GetAutoMergingPreviewRequest::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()).build();

    private static final SdkField<Consolidation> CONSOLIDATION_FIELD = SdkField.<Consolidation> builder(MarshallingType.SDK_POJO)
            .memberName("Consolidation").getter(getter(GetAutoMergingPreviewRequest::consolidation))
            .setter(setter(Builder::consolidation)).constructor(Consolidation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Consolidation").build()).build();

    private static final SdkField<ConflictResolution> CONFLICT_RESOLUTION_FIELD = SdkField
            .<ConflictResolution> builder(MarshallingType.SDK_POJO).memberName("ConflictResolution")
            .getter(getter(GetAutoMergingPreviewRequest::conflictResolution)).setter(setter(Builder::conflictResolution))
            .constructor(ConflictResolution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConflictResolution").build())
            .build();

    private static final SdkField<Double> MIN_ALLOWED_CONFIDENCE_SCORE_FOR_MERGING_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("MinAllowedConfidenceScoreForMerging")
            .getter(getter(GetAutoMergingPreviewRequest::minAllowedConfidenceScoreForMerging))
            .setter(setter(Builder::minAllowedConfidenceScoreForMerging))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("MinAllowedConfidenceScoreForMerging").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            CONSOLIDATION_FIELD, CONFLICT_RESOLUTION_FIELD, MIN_ALLOWED_CONFIDENCE_SCORE_FOR_MERGING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainName;

    private final Consolidation consolidation;

    private final ConflictResolution conflictResolution;

    private final Double minAllowedConfidenceScoreForMerging;

    private GetAutoMergingPreviewRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.consolidation = builder.consolidation;
        this.conflictResolution = builder.conflictResolution;
        this.minAllowedConfidenceScoreForMerging = builder.minAllowedConfidenceScoreForMerging;
    }

    /**
     * <p>
     * The unique name of the domain.
     * </p>
     * 
     * @return The unique name of the domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * A list of matching attributes that represent matching criteria.
     * </p>
     * 
     * @return A list of matching attributes that represent matching criteria.
     */
    public final Consolidation consolidation() {
        return consolidation;
    }

    /**
     * <p>
     * How the auto-merging process should resolve conflicts between different profiles.
     * </p>
     * 
     * @return How the auto-merging process should resolve conflicts between different profiles.
     */
    public final ConflictResolution conflictResolution() {
        return conflictResolution;
    }

    /**
     * <p>
     * Minimum confidence score required for profiles within a matching group to be merged during the auto-merge
     * process.
     * </p>
     * 
     * @return Minimum confidence score required for profiles within a matching group to be merged during the auto-merge
     *         process.
     */
    public final Double minAllowedConfidenceScoreForMerging() {
        return minAllowedConfidenceScoreForMerging;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(consolidation());
        hashCode = 31 * hashCode + Objects.hashCode(conflictResolution());
        hashCode = 31 * hashCode + Objects.hashCode(minAllowedConfidenceScoreForMerging());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAutoMergingPreviewRequest)) {
            return false;
        }
        GetAutoMergingPreviewRequest other = (GetAutoMergingPreviewRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(consolidation(), other.consolidation())
                && Objects.equals(conflictResolution(), other.conflictResolution())
                && Objects.equals(minAllowedConfidenceScoreForMerging(), other.minAllowedConfidenceScoreForMerging());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAutoMergingPreviewRequest").add("DomainName", domainName())
                .add("Consolidation", consolidation()).add("ConflictResolution", conflictResolution())
                .add("MinAllowedConfidenceScoreForMerging", minAllowedConfidenceScoreForMerging()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "Consolidation":
            return Optional.ofNullable(clazz.cast(consolidation()));
        case "ConflictResolution":
            return Optional.ofNullable(clazz.cast(conflictResolution()));
        case "MinAllowedConfidenceScoreForMerging":
            return Optional.ofNullable(clazz.cast(minAllowedConfidenceScoreForMerging()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("Consolidation", CONSOLIDATION_FIELD);
        map.put("ConflictResolution", CONFLICT_RESOLUTION_FIELD);
        map.put("MinAllowedConfidenceScoreForMerging", MIN_ALLOWED_CONFIDENCE_SCORE_FOR_MERGING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAutoMergingPreviewRequest, T> g) {
        return obj -> g.apply((GetAutoMergingPreviewRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CustomerProfilesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAutoMergingPreviewRequest> {
        /**
         * <p>
         * The unique name of the domain.
         * </p>
         * 
         * @param domainName
         *        The unique name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * A list of matching attributes that represent matching criteria.
         * </p>
         * 
         * @param consolidation
         *        A list of matching attributes that represent matching criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consolidation(Consolidation consolidation);

        /**
         * <p>
         * A list of matching attributes that represent matching criteria.
         * </p>
         * This is a convenience method that creates an instance of the {@link Consolidation.Builder} avoiding the need
         * to create one manually via {@link Consolidation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Consolidation.Builder#build()} is called immediately and its
         * result is passed to {@link #consolidation(Consolidation)}.
         * 
         * @param consolidation
         *        a consumer that will call methods on {@link Consolidation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consolidation(Consolidation)
         */
        default Builder consolidation(Consumer<Consolidation.Builder> consolidation) {
            return consolidation(Consolidation.builder().applyMutation(consolidation).build());
        }

        /**
         * <p>
         * How the auto-merging process should resolve conflicts between different profiles.
         * </p>
         * 
         * @param conflictResolution
         *        How the auto-merging process should resolve conflicts between different profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conflictResolution(ConflictResolution conflictResolution);

        /**
         * <p>
         * How the auto-merging process should resolve conflicts between different profiles.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConflictResolution.Builder} avoiding the
         * need to create one manually via {@link ConflictResolution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConflictResolution.Builder#build()} is called immediately and its
         * result is passed to {@link #conflictResolution(ConflictResolution)}.
         * 
         * @param conflictResolution
         *        a consumer that will call methods on {@link ConflictResolution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conflictResolution(ConflictResolution)
         */
        default Builder conflictResolution(Consumer<ConflictResolution.Builder> conflictResolution) {
            return conflictResolution(ConflictResolution.builder().applyMutation(conflictResolution).build());
        }

        /**
         * <p>
         * Minimum confidence score required for profiles within a matching group to be merged during the auto-merge
         * process.
         * </p>
         * 
         * @param minAllowedConfidenceScoreForMerging
         *        Minimum confidence score required for profiles within a matching group to be merged during the
         *        auto-merge process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minAllowedConfidenceScoreForMerging(Double minAllowedConfidenceScoreForMerging);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CustomerProfilesRequest.BuilderImpl implements Builder {
        private String domainName;

        private Consolidation consolidation;

        private ConflictResolution conflictResolution;

        private Double minAllowedConfidenceScoreForMerging;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAutoMergingPreviewRequest model) {
            super(model);
            domainName(model.domainName);
            consolidation(model.consolidation);
            conflictResolution(model.conflictResolution);
            minAllowedConfidenceScoreForMerging(model.minAllowedConfidenceScoreForMerging);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final Consolidation.Builder getConsolidation() {
            return consolidation != null ? consolidation.toBuilder() : null;
        }

        public final void setConsolidation(Consolidation.BuilderImpl consolidation) {
            this.consolidation = consolidation != null ? consolidation.build() : null;
        }

        @Override
        public final Builder consolidation(Consolidation consolidation) {
            this.consolidation = consolidation;
            return this;
        }

        public final ConflictResolution.Builder getConflictResolution() {
            return conflictResolution != null ? conflictResolution.toBuilder() : null;
        }

        public final void setConflictResolution(ConflictResolution.BuilderImpl conflictResolution) {
            this.conflictResolution = conflictResolution != null ? conflictResolution.build() : null;
        }

        @Override
        public final Builder conflictResolution(ConflictResolution conflictResolution) {
            this.conflictResolution = conflictResolution;
            return this;
        }

        public final Double getMinAllowedConfidenceScoreForMerging() {
            return minAllowedConfidenceScoreForMerging;
        }

        public final void setMinAllowedConfidenceScoreForMerging(Double minAllowedConfidenceScoreForMerging) {
            this.minAllowedConfidenceScoreForMerging = minAllowedConfidenceScoreForMerging;
        }

        @Override
        public final Builder minAllowedConfidenceScoreForMerging(Double minAllowedConfidenceScoreForMerging) {
            this.minAllowedConfidenceScoreForMerging = minAllowedConfidenceScoreForMerging;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAutoMergingPreviewRequest build() {
            return new GetAutoMergingPreviewRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
