/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetProfileHistoryRecordResponse extends CustomerProfilesResponse implements
        ToCopyableBuilder<GetProfileHistoryRecordResponse.Builder, GetProfileHistoryRecordResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(GetProfileHistoryRecordResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> OBJECT_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectTypeName").getter(getter(GetProfileHistoryRecordResponse::objectTypeName))
            .setter(setter(Builder::objectTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectTypeName").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(GetProfileHistoryRecordResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAt").getter(getter(GetProfileHistoryRecordResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()).build();

    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionType").getter(getter(GetProfileHistoryRecordResponse::actionTypeAsString))
            .setter(setter(Builder::actionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionType").build()).build();

    private static final SdkField<String> PROFILE_OBJECT_UNIQUE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileObjectUniqueKey").getter(getter(GetProfileHistoryRecordResponse::profileObjectUniqueKey))
            .setter(setter(Builder::profileObjectUniqueKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileObjectUniqueKey").build())
            .build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(GetProfileHistoryRecordResponse::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<String> PERFORMED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PerformedBy").getter(getter(GetProfileHistoryRecordResponse::performedBy))
            .setter(setter(Builder::performedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            OBJECT_TYPE_NAME_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, ACTION_TYPE_FIELD, PROFILE_OBJECT_UNIQUE_KEY_FIELD,
            CONTENT_FIELD, PERFORMED_BY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String objectTypeName;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final String actionType;

    private final String profileObjectUniqueKey;

    private final String content;

    private final String performedBy;

    private GetProfileHistoryRecordResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.objectTypeName = builder.objectTypeName;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.actionType = builder.actionType;
        this.profileObjectUniqueKey = builder.profileObjectUniqueKey;
        this.content = builder.content;
        this.performedBy = builder.performedBy;
    }

    /**
     * <p>
     * The unique identifier of the profile history record.
     * </p>
     * 
     * @return The unique identifier of the profile history record.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the profile object type.
     * </p>
     * 
     * @return The name of the profile object type.
     */
    public final String objectTypeName() {
        return objectTypeName;
    }

    /**
     * <p>
     * The timestamp of when the profile history record was created.
     * </p>
     * 
     * @return The timestamp of when the profile history record was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp of when the profile history record was last updated.
     * </p>
     * 
     * @return The timestamp of when the profile history record was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The action type of the profile history record.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link ActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The action type of the profile history record.
     * @see ActionType
     */
    public final ActionType actionType() {
        return ActionType.fromValue(actionType);
    }

    /**
     * <p>
     * The action type of the profile history record.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link ActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The action type of the profile history record.
     * @see ActionType
     */
    public final String actionTypeAsString() {
        return actionType;
    }

    /**
     * <p>
     * The unique identifier of the profile object generated by the service.
     * </p>
     * 
     * @return The unique identifier of the profile object generated by the service.
     */
    public final String profileObjectUniqueKey() {
        return profileObjectUniqueKey;
    }

    /**
     * <p>
     * A string containing the customer profile, profile object, or profile key content.
     * </p>
     * 
     * @return A string containing the customer profile, profile object, or profile key content.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the person or service principal who performed the action.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the person or service principal who performed the action.
     */
    public final String performedBy() {
        return performedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(objectTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(profileObjectUniqueKey());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(performedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProfileHistoryRecordResponse)) {
            return false;
        }
        GetProfileHistoryRecordResponse other = (GetProfileHistoryRecordResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(objectTypeName(), other.objectTypeName())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(actionTypeAsString(), other.actionTypeAsString())
                && Objects.equals(profileObjectUniqueKey(), other.profileObjectUniqueKey())
                && Objects.equals(content(), other.content()) && Objects.equals(performedBy(), other.performedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetProfileHistoryRecordResponse").add("Id", id()).add("ObjectTypeName", objectTypeName())
                .add("CreatedAt", createdAt()).add("LastUpdatedAt", lastUpdatedAt()).add("ActionType", actionTypeAsString())
                .add("ProfileObjectUniqueKey", profileObjectUniqueKey())
                .add("Content", content() == null ? null : "*** Sensitive Data Redacted ***").add("PerformedBy", performedBy())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ObjectTypeName":
            return Optional.ofNullable(clazz.cast(objectTypeName()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "ActionType":
            return Optional.ofNullable(clazz.cast(actionTypeAsString()));
        case "ProfileObjectUniqueKey":
            return Optional.ofNullable(clazz.cast(profileObjectUniqueKey()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "PerformedBy":
            return Optional.ofNullable(clazz.cast(performedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("ObjectTypeName", OBJECT_TYPE_NAME_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("ActionType", ACTION_TYPE_FIELD);
        map.put("ProfileObjectUniqueKey", PROFILE_OBJECT_UNIQUE_KEY_FIELD);
        map.put("Content", CONTENT_FIELD);
        map.put("PerformedBy", PERFORMED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetProfileHistoryRecordResponse, T> g) {
        return obj -> g.apply((GetProfileHistoryRecordResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CustomerProfilesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetProfileHistoryRecordResponse> {
        /**
         * <p>
         * The unique identifier of the profile history record.
         * </p>
         * 
         * @param id
         *        The unique identifier of the profile history record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the profile object type.
         * </p>
         * 
         * @param objectTypeName
         *        The name of the profile object type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectTypeName(String objectTypeName);

        /**
         * <p>
         * The timestamp of when the profile history record was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the profile history record was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp of when the profile history record was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The timestamp of when the profile history record was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The action type of the profile history record.
         * </p>
         * 
         * @param actionType
         *        The action type of the profile history record.
         * @see ActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionType
         */
        Builder actionType(String actionType);

        /**
         * <p>
         * The action type of the profile history record.
         * </p>
         * 
         * @param actionType
         *        The action type of the profile history record.
         * @see ActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionType
         */
        Builder actionType(ActionType actionType);

        /**
         * <p>
         * The unique identifier of the profile object generated by the service.
         * </p>
         * 
         * @param profileObjectUniqueKey
         *        The unique identifier of the profile object generated by the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileObjectUniqueKey(String profileObjectUniqueKey);

        /**
         * <p>
         * A string containing the customer profile, profile object, or profile key content.
         * </p>
         * 
         * @param content
         *        A string containing the customer profile, profile object, or profile key content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the person or service principal who performed the action.
         * </p>
         * 
         * @param performedBy
         *        The Amazon Resource Name (ARN) of the person or service principal who performed the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performedBy(String performedBy);
    }

    static final class BuilderImpl extends CustomerProfilesResponse.BuilderImpl implements Builder {
        private String id;

        private String objectTypeName;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private String actionType;

        private String profileObjectUniqueKey;

        private String content;

        private String performedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProfileHistoryRecordResponse model) {
            super(model);
            id(model.id);
            objectTypeName(model.objectTypeName);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            actionType(model.actionType);
            profileObjectUniqueKey(model.profileObjectUniqueKey);
            content(model.content);
            performedBy(model.performedBy);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getObjectTypeName() {
            return objectTypeName;
        }

        public final void setObjectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
        }

        @Override
        public final Builder objectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getActionType() {
            return actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(ActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final String getProfileObjectUniqueKey() {
            return profileObjectUniqueKey;
        }

        public final void setProfileObjectUniqueKey(String profileObjectUniqueKey) {
            this.profileObjectUniqueKey = profileObjectUniqueKey;
        }

        @Override
        public final Builder profileObjectUniqueKey(String profileObjectUniqueKey) {
            this.profileObjectUniqueKey = profileObjectUniqueKey;
            return this;
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getPerformedBy() {
            return performedBy;
        }

        public final void setPerformedBy(String performedBy) {
            this.performedBy = performedBy;
        }

        @Override
        public final Builder performedBy(String performedBy) {
            this.performedBy = performedBy;
            return this;
        }

        @Override
        public GetProfileHistoryRecordResponse build() {
            return new GetProfileHistoryRecordResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
