/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSegmentEstimateResponse extends CustomerProfilesResponse implements
        ToCopyableBuilder<GetSegmentEstimateResponse.Builder, GetSegmentEstimateResponse> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(GetSegmentEstimateResponse::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> ESTIMATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EstimateId").getter(getter(GetSegmentEstimateResponse::estimateId)).setter(setter(Builder::estimateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimateId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetSegmentEstimateResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ESTIMATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Estimate").getter(getter(GetSegmentEstimateResponse::estimate)).setter(setter(Builder::estimate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Estimate").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(GetSegmentEstimateResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<Integer> STATUS_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StatusCode").getter(getter(GetSegmentEstimateResponse::statusCode)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("StatusCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            ESTIMATE_ID_FIELD, STATUS_FIELD, ESTIMATE_FIELD, MESSAGE_FIELD, STATUS_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainName;

    private final String estimateId;

    private final String status;

    private final String estimate;

    private final String message;

    private final Integer statusCode;

    private GetSegmentEstimateResponse(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.estimateId = builder.estimateId;
        this.status = builder.status;
        this.estimate = builder.estimate;
        this.message = builder.message;
        this.statusCode = builder.statusCode;
    }

    /**
     * <p>
     * The unique name of the domain.
     * </p>
     * 
     * @return The unique name of the domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The <code>QueryId</code> which is the same as the value passed in <code>QueryId</code>.
     * </p>
     * 
     * @return The <code>QueryId</code> which is the same as the value passed in <code>QueryId</code>.
     */
    public final String estimateId() {
        return estimateId;
    }

    /**
     * <p>
     * The current status of the query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EstimateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the query.
     * @see EstimateStatus
     */
    public final EstimateStatus status() {
        return EstimateStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EstimateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the query.
     * @see EstimateStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The estimated number of profiles contained in the segment.
     * </p>
     * 
     * @return The estimated number of profiles contained in the segment.
     */
    public final String estimate() {
        return estimate;
    }

    /**
     * <p>
     * The error message if there is any error.
     * </p>
     * 
     * @return The error message if there is any error.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The status code of the segment estimate.
     * </p>
     * 
     * @return The status code of the segment estimate.
     */
    public final Integer statusCode() {
        return statusCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(estimateId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(estimate());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSegmentEstimateResponse)) {
            return false;
        }
        GetSegmentEstimateResponse other = (GetSegmentEstimateResponse) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(estimateId(), other.estimateId())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(estimate(), other.estimate())
                && Objects.equals(message(), other.message()) && Objects.equals(statusCode(), other.statusCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSegmentEstimateResponse").add("DomainName", domainName()).add("EstimateId", estimateId())
                .add("Status", statusAsString()).add("Estimate", estimate()).add("Message", message())
                .add("StatusCode", statusCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "EstimateId":
            return Optional.ofNullable(clazz.cast(estimateId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Estimate":
            return Optional.ofNullable(clazz.cast(estimate()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "StatusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("EstimateId", ESTIMATE_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Estimate", ESTIMATE_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("StatusCode", STATUS_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSegmentEstimateResponse, T> g) {
        return obj -> g.apply((GetSegmentEstimateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CustomerProfilesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSegmentEstimateResponse> {
        /**
         * <p>
         * The unique name of the domain.
         * </p>
         * 
         * @param domainName
         *        The unique name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The <code>QueryId</code> which is the same as the value passed in <code>QueryId</code>.
         * </p>
         * 
         * @param estimateId
         *        The <code>QueryId</code> which is the same as the value passed in <code>QueryId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimateId(String estimateId);

        /**
         * <p>
         * The current status of the query.
         * </p>
         * 
         * @param status
         *        The current status of the query.
         * @see EstimateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EstimateStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the query.
         * </p>
         * 
         * @param status
         *        The current status of the query.
         * @see EstimateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EstimateStatus
         */
        Builder status(EstimateStatus status);

        /**
         * <p>
         * The estimated number of profiles contained in the segment.
         * </p>
         * 
         * @param estimate
         *        The estimated number of profiles contained in the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimate(String estimate);

        /**
         * <p>
         * The error message if there is any error.
         * </p>
         * 
         * @param message
         *        The error message if there is any error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The status code of the segment estimate.
         * </p>
         * 
         * @param statusCode
         *        The status code of the segment estimate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(Integer statusCode);
    }

    static final class BuilderImpl extends CustomerProfilesResponse.BuilderImpl implements Builder {
        private String domainName;

        private String estimateId;

        private String status;

        private String estimate;

        private String message;

        private Integer statusCode;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSegmentEstimateResponse model) {
            super(model);
            domainName(model.domainName);
            estimateId(model.estimateId);
            status(model.status);
            estimate(model.estimate);
            message(model.message);
            statusCode(model.statusCode);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getEstimateId() {
            return estimateId;
        }

        public final void setEstimateId(String estimateId) {
            this.estimateId = estimateId;
        }

        @Override
        public final Builder estimateId(String estimateId) {
            this.estimateId = estimateId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EstimateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getEstimate() {
            return estimate;
        }

        public final void setEstimate(String estimate) {
            this.estimate = estimate;
        }

        @Override
        public final Builder estimate(String estimate) {
            this.estimate = estimate;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Integer getStatusCode() {
            return statusCode;
        }

        public final void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public GetSegmentEstimateResponse build() {
            return new GetSegmentEstimateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
