/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSegmentMembershipResponse extends CustomerProfilesResponse implements
        ToCopyableBuilder<GetSegmentMembershipResponse.Builder, GetSegmentMembershipResponse> {
    private static final SdkField<String> SEGMENT_DEFINITION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentDefinitionName").getter(getter(GetSegmentMembershipResponse::segmentDefinitionName))
            .setter(setter(Builder::segmentDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentDefinitionName").build())
            .build();

    private static final SdkField<List<ProfileQueryResult>> PROFILES_FIELD = SdkField
            .<List<ProfileQueryResult>> builder(MarshallingType.LIST)
            .memberName("Profiles")
            .getter(getter(GetSegmentMembershipResponse::profiles))
            .setter(setter(Builder::profiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Profiles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProfileQueryResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProfileQueryResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ProfileQueryFailures>> FAILURES_FIELD = SdkField
            .<List<ProfileQueryFailures>> builder(MarshallingType.LIST)
            .memberName("Failures")
            .getter(getter(GetSegmentMembershipResponse::failures))
            .setter(setter(Builder::failures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Failures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProfileQueryFailures> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProfileQueryFailures::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEGMENT_DEFINITION_NAME_FIELD,
            PROFILES_FIELD, FAILURES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String segmentDefinitionName;

    private final List<ProfileQueryResult> profiles;

    private final List<ProfileQueryFailures> failures;

    private GetSegmentMembershipResponse(BuilderImpl builder) {
        super(builder);
        this.segmentDefinitionName = builder.segmentDefinitionName;
        this.profiles = builder.profiles;
        this.failures = builder.failures;
    }

    /**
     * <p>
     * The unique name of the segment definition.
     * </p>
     * 
     * @return The unique name of the segment definition.
     */
    public final String segmentDefinitionName() {
        return segmentDefinitionName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Profiles property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProfiles() {
        return profiles != null && !(profiles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of maps where each contains a response per profile requested.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProfiles} method.
     * </p>
     * 
     * @return An array of maps where each contains a response per profile requested.
     */
    public final List<ProfileQueryResult> profiles() {
        return profiles;
    }

    /**
     * For responses, this returns true if the service returned a value for the Failures property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFailures() {
        return failures != null && !(failures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of maps where each contains a response per profile failed for the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailures} method.
     * </p>
     * 
     * @return An array of maps where each contains a response per profile failed for the request.
     */
    public final List<ProfileQueryFailures> failures() {
        return failures;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(segmentDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(hasProfiles() ? profiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailures() ? failures() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSegmentMembershipResponse)) {
            return false;
        }
        GetSegmentMembershipResponse other = (GetSegmentMembershipResponse) obj;
        return Objects.equals(segmentDefinitionName(), other.segmentDefinitionName()) && hasProfiles() == other.hasProfiles()
                && Objects.equals(profiles(), other.profiles()) && hasFailures() == other.hasFailures()
                && Objects.equals(failures(), other.failures());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSegmentMembershipResponse").add("SegmentDefinitionName", segmentDefinitionName())
                .add("Profiles", hasProfiles() ? profiles() : null).add("Failures", hasFailures() ? failures() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SegmentDefinitionName":
            return Optional.ofNullable(clazz.cast(segmentDefinitionName()));
        case "Profiles":
            return Optional.ofNullable(clazz.cast(profiles()));
        case "Failures":
            return Optional.ofNullable(clazz.cast(failures()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SegmentDefinitionName", SEGMENT_DEFINITION_NAME_FIELD);
        map.put("Profiles", PROFILES_FIELD);
        map.put("Failures", FAILURES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSegmentMembershipResponse, T> g) {
        return obj -> g.apply((GetSegmentMembershipResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CustomerProfilesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSegmentMembershipResponse> {
        /**
         * <p>
         * The unique name of the segment definition.
         * </p>
         * 
         * @param segmentDefinitionName
         *        The unique name of the segment definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentDefinitionName(String segmentDefinitionName);

        /**
         * <p>
         * An array of maps where each contains a response per profile requested.
         * </p>
         * 
         * @param profiles
         *        An array of maps where each contains a response per profile requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profiles(Collection<ProfileQueryResult> profiles);

        /**
         * <p>
         * An array of maps where each contains a response per profile requested.
         * </p>
         * 
         * @param profiles
         *        An array of maps where each contains a response per profile requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profiles(ProfileQueryResult... profiles);

        /**
         * <p>
         * An array of maps where each contains a response per profile requested.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.customerprofiles.model.ProfileQueryResult.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.customerprofiles.model.ProfileQueryResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.customerprofiles.model.ProfileQueryResult.Builder#build()} is called
         * immediately and its result is passed to {@link #profiles(List<ProfileQueryResult>)}.
         * 
         * @param profiles
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.customerprofiles.model.ProfileQueryResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #profiles(java.util.Collection<ProfileQueryResult>)
         */
        Builder profiles(Consumer<ProfileQueryResult.Builder>... profiles);

        /**
         * <p>
         * An array of maps where each contains a response per profile failed for the request.
         * </p>
         * 
         * @param failures
         *        An array of maps where each contains a response per profile failed for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(Collection<ProfileQueryFailures> failures);

        /**
         * <p>
         * An array of maps where each contains a response per profile failed for the request.
         * </p>
         * 
         * @param failures
         *        An array of maps where each contains a response per profile failed for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(ProfileQueryFailures... failures);

        /**
         * <p>
         * An array of maps where each contains a response per profile failed for the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.customerprofiles.model.ProfileQueryFailures.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.customerprofiles.model.ProfileQueryFailures#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.customerprofiles.model.ProfileQueryFailures.Builder#build()} is called
         * immediately and its result is passed to {@link #failures(List<ProfileQueryFailures>)}.
         * 
         * @param failures
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.customerprofiles.model.ProfileQueryFailures.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failures(java.util.Collection<ProfileQueryFailures>)
         */
        Builder failures(Consumer<ProfileQueryFailures.Builder>... failures);
    }

    static final class BuilderImpl extends CustomerProfilesResponse.BuilderImpl implements Builder {
        private String segmentDefinitionName;

        private List<ProfileQueryResult> profiles = DefaultSdkAutoConstructList.getInstance();

        private List<ProfileQueryFailures> failures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSegmentMembershipResponse model) {
            super(model);
            segmentDefinitionName(model.segmentDefinitionName);
            profiles(model.profiles);
            failures(model.failures);
        }

        public final String getSegmentDefinitionName() {
            return segmentDefinitionName;
        }

        public final void setSegmentDefinitionName(String segmentDefinitionName) {
            this.segmentDefinitionName = segmentDefinitionName;
        }

        @Override
        public final Builder segmentDefinitionName(String segmentDefinitionName) {
            this.segmentDefinitionName = segmentDefinitionName;
            return this;
        }

        public final List<ProfileQueryResult.Builder> getProfiles() {
            List<ProfileQueryResult.Builder> result = ProfilesCopier.copyToBuilder(this.profiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProfiles(Collection<ProfileQueryResult.BuilderImpl> profiles) {
            this.profiles = ProfilesCopier.copyFromBuilder(profiles);
        }

        @Override
        public final Builder profiles(Collection<ProfileQueryResult> profiles) {
            this.profiles = ProfilesCopier.copy(profiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profiles(ProfileQueryResult... profiles) {
            profiles(Arrays.asList(profiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profiles(Consumer<ProfileQueryResult.Builder>... profiles) {
            profiles(Stream.of(profiles).map(c -> ProfileQueryResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ProfileQueryFailures.Builder> getFailures() {
            List<ProfileQueryFailures.Builder> result = FailuresCopier.copyToBuilder(this.failures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailures(Collection<ProfileQueryFailures.BuilderImpl> failures) {
            this.failures = FailuresCopier.copyFromBuilder(failures);
        }

        @Override
        public final Builder failures(Collection<ProfileQueryFailures> failures) {
            this.failures = FailuresCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(ProfileQueryFailures... failures) {
            failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<ProfileQueryFailures.Builder>... failures) {
            failures(Stream.of(failures).map(c -> ProfileQueryFailures.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetSegmentMembershipResponse build() {
            return new GetSegmentMembershipResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
