/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSegmentSnapshotResponse extends CustomerProfilesResponse implements
        ToCopyableBuilder<GetSegmentSnapshotResponse.Builder, GetSegmentSnapshotResponse> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotId").getter(getter(GetSegmentSnapshotResponse::snapshotId)).setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetSegmentSnapshotResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(GetSegmentSnapshotResponse::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final SdkField<String> DATA_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataFormat").getter(getter(GetSegmentSnapshotResponse::dataFormatAsString))
            .setter(setter(Builder::dataFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFormat").build()).build();

    private static final SdkField<String> ENCRYPTION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionKey").getter(getter(GetSegmentSnapshotResponse::encryptionKey))
            .setter(setter(Builder::encryptionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKey").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(GetSegmentSnapshotResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> DESTINATION_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationUri").getter(getter(GetSegmentSnapshotResponse::destinationUri))
            .setter(setter(Builder::destinationUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationUri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD,
            STATUS_FIELD, STATUS_MESSAGE_FIELD, DATA_FORMAT_FIELD, ENCRYPTION_KEY_FIELD, ROLE_ARN_FIELD, DESTINATION_URI_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String snapshotId;

    private final String status;

    private final String statusMessage;

    private final String dataFormat;

    private final String encryptionKey;

    private final String roleArn;

    private final String destinationUri;

    private GetSegmentSnapshotResponse(BuilderImpl builder) {
        super(builder);
        this.snapshotId = builder.snapshotId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.dataFormat = builder.dataFormat;
        this.encryptionKey = builder.encryptionKey;
        this.roleArn = builder.roleArn;
        this.destinationUri = builder.destinationUri;
    }

    /**
     * <p>
     * The unique identifier of the segment snapshot.
     * </p>
     * 
     * @return The unique identifier of the segment snapshot.
     */
    public final String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The status of the asynchronous job for exporting the segment snapshot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SegmentSnapshotStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the asynchronous job for exporting the segment snapshot.
     * @see SegmentSnapshotStatus
     */
    public final SegmentSnapshotStatus status() {
        return SegmentSnapshotStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the asynchronous job for exporting the segment snapshot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SegmentSnapshotStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the asynchronous job for exporting the segment snapshot.
     * @see SegmentSnapshotStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The status message of the asynchronous job for exporting the segment snapshot.
     * </p>
     * 
     * @return The status message of the asynchronous job for exporting the segment snapshot.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The format in which the segment will be exported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataFormat} will
     * return {@link DataFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataFormatAsString}.
     * </p>
     * 
     * @return The format in which the segment will be exported.
     * @see DataFormat
     */
    public final DataFormat dataFormat() {
        return DataFormat.fromValue(dataFormat);
    }

    /**
     * <p>
     * The format in which the segment will be exported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataFormat} will
     * return {@link DataFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dataFormatAsString}.
     * </p>
     * 
     * @return The format in which the segment will be exported.
     * @see DataFormat
     */
    public final String dataFormatAsString() {
        return dataFormat;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the KMS key used to encrypt the exported segment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the KMS key used to encrypt the exported segment.
     */
    public final String encryptionKey() {
        return encryptionKey;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that allows Customer Profiles service principal to assume the role
     * for conducting KMS and S3 operations.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that allows Customer Profiles service principal to assume
     *         the role for conducting KMS and S3 operations.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The destination to which the segment will be exported. This field must be provided if the request is not
     * submitted from the Amazon Connect Admin Website.
     * </p>
     * 
     * @return The destination to which the segment will be exported. This field must be provided if the request is not
     *         submitted from the Amazon Connect Admin Website.
     */
    public final String destinationUri() {
        return destinationUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(dataFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(destinationUri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSegmentSnapshotResponse)) {
            return false;
        }
        GetSegmentSnapshotResponse other = (GetSegmentSnapshotResponse) obj;
        return Objects.equals(snapshotId(), other.snapshotId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(dataFormatAsString(), other.dataFormatAsString())
                && Objects.equals(encryptionKey(), other.encryptionKey()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(destinationUri(), other.destinationUri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSegmentSnapshotResponse").add("SnapshotId", snapshotId()).add("Status", statusAsString())
                .add("StatusMessage", statusMessage()).add("DataFormat", dataFormatAsString())
                .add("EncryptionKey", encryptionKey()).add("RoleArn", roleArn()).add("DestinationUri", destinationUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "DataFormat":
            return Optional.ofNullable(clazz.cast(dataFormatAsString()));
        case "EncryptionKey":
            return Optional.ofNullable(clazz.cast(encryptionKey()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "DestinationUri":
            return Optional.ofNullable(clazz.cast(destinationUri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SnapshotId", SNAPSHOT_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("DataFormat", DATA_FORMAT_FIELD);
        map.put("EncryptionKey", ENCRYPTION_KEY_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("DestinationUri", DESTINATION_URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSegmentSnapshotResponse, T> g) {
        return obj -> g.apply((GetSegmentSnapshotResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CustomerProfilesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSegmentSnapshotResponse> {
        /**
         * <p>
         * The unique identifier of the segment snapshot.
         * </p>
         * 
         * @param snapshotId
         *        The unique identifier of the segment snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The status of the asynchronous job for exporting the segment snapshot.
         * </p>
         * 
         * @param status
         *        The status of the asynchronous job for exporting the segment snapshot.
         * @see SegmentSnapshotStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SegmentSnapshotStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the asynchronous job for exporting the segment snapshot.
         * </p>
         * 
         * @param status
         *        The status of the asynchronous job for exporting the segment snapshot.
         * @see SegmentSnapshotStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SegmentSnapshotStatus
         */
        Builder status(SegmentSnapshotStatus status);

        /**
         * <p>
         * The status message of the asynchronous job for exporting the segment snapshot.
         * </p>
         * 
         * @param statusMessage
         *        The status message of the asynchronous job for exporting the segment snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The format in which the segment will be exported.
         * </p>
         * 
         * @param dataFormat
         *        The format in which the segment will be exported.
         * @see DataFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataFormat
         */
        Builder dataFormat(String dataFormat);

        /**
         * <p>
         * The format in which the segment will be exported.
         * </p>
         * 
         * @param dataFormat
         *        The format in which the segment will be exported.
         * @see DataFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataFormat
         */
        Builder dataFormat(DataFormat dataFormat);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the KMS key used to encrypt the exported segment.
         * </p>
         * 
         * @param encryptionKey
         *        The Amazon Resource Name (ARN) of the KMS key used to encrypt the exported segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKey(String encryptionKey);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that allows Customer Profiles service principal to assume the
         * role for conducting KMS and S3 operations.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role that allows Customer Profiles service principal to
         *        assume the role for conducting KMS and S3 operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The destination to which the segment will be exported. This field must be provided if the request is not
         * submitted from the Amazon Connect Admin Website.
         * </p>
         * 
         * @param destinationUri
         *        The destination to which the segment will be exported. This field must be provided if the request is
         *        not submitted from the Amazon Connect Admin Website.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationUri(String destinationUri);
    }

    static final class BuilderImpl extends CustomerProfilesResponse.BuilderImpl implements Builder {
        private String snapshotId;

        private String status;

        private String statusMessage;

        private String dataFormat;

        private String encryptionKey;

        private String roleArn;

        private String destinationUri;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSegmentSnapshotResponse model) {
            super(model);
            snapshotId(model.snapshotId);
            status(model.status);
            statusMessage(model.statusMessage);
            dataFormat(model.dataFormat);
            encryptionKey(model.encryptionKey);
            roleArn(model.roleArn);
            destinationUri(model.destinationUri);
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SegmentSnapshotStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getDataFormat() {
            return dataFormat;
        }

        public final void setDataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
        }

        @Override
        public final Builder dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        @Override
        public final Builder dataFormat(DataFormat dataFormat) {
            this.dataFormat(dataFormat == null ? null : dataFormat.toString());
            return this;
        }

        public final String getEncryptionKey() {
            return encryptionKey;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        @Override
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getDestinationUri() {
            return destinationUri;
        }

        public final void setDestinationUri(String destinationUri) {
            this.destinationUri = destinationUri;
        }

        @Override
        public final Builder destinationUri(String destinationUri) {
            this.destinationUri = destinationUri;
            return this;
        }

        @Override
        public GetSegmentSnapshotResponse build() {
            return new GetSegmentSnapshotResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
