/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUploadJobPathResponse extends CustomerProfilesResponse implements
        ToCopyableBuilder<GetUploadJobPathResponse.Builder, GetUploadJobPathResponse> {
    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Url")
            .getter(getter(GetUploadJobPathResponse::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(GetUploadJobPathResponse::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<Instant> VALID_UNTIL_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ValidUntil").getter(getter(GetUploadJobPathResponse::validUntil)).setter(setter(Builder::validUntil))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidUntil").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD, CLIENT_TOKEN_FIELD,
            VALID_UNTIL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String url;

    private final String clientToken;

    private final Instant validUntil;

    private GetUploadJobPathResponse(BuilderImpl builder) {
        super(builder);
        this.url = builder.url;
        this.clientToken = builder.clientToken;
        this.validUntil = builder.validUntil;
    }

    /**
     * <p>
     * The pre-signed S3 URL for uploading the CSV file associated with the upload job.
     * </p>
     * 
     * @return The pre-signed S3 URL for uploading the CSV file associated with the upload job.
     */
    public final String url() {
        return url;
    }

    /**
     * <p>
     * The plaintext data key used to encrypt the upload file.
     * </p>
     * <p>
     * To persist to the pre-signed url, use the client token and MD5 client token as header. The required headers are
     * as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * x-amz-server-side-encryption-customer-key: Client Token
     * </p>
     * </li>
     * <li>
     * <p>
     * x-amz-server-side-encryption-customer-key-MD5: MD5 Client Token
     * </p>
     * </li>
     * <li>
     * <p>
     * x-amz-server-side-encryption-customer-algorithm: AES256
     * </p>
     * </li>
     * </ul>
     * 
     * @return The plaintext data key used to encrypt the upload file. </p>
     *         <p>
     *         To persist to the pre-signed url, use the client token and MD5 client token as header. The required
     *         headers are as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         x-amz-server-side-encryption-customer-key: Client Token
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         x-amz-server-side-encryption-customer-key-MD5: MD5 Client Token
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         x-amz-server-side-encryption-customer-algorithm: AES256
     *         </p>
     *         </li>
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The expiry timestamp for the pre-signed URL, after which the URL will no longer be valid.
     * </p>
     * 
     * @return The expiry timestamp for the pre-signed URL, after which the URL will no longer be valid.
     */
    public final Instant validUntil() {
        return validUntil;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(validUntil());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUploadJobPathResponse)) {
            return false;
        }
        GetUploadJobPathResponse other = (GetUploadJobPathResponse) obj;
        return Objects.equals(url(), other.url()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(validUntil(), other.validUntil());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetUploadJobPathResponse").add("Url", url()).add("ClientToken", clientToken())
                .add("ValidUntil", validUntil()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "ValidUntil":
            return Optional.ofNullable(clazz.cast(validUntil()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Url", URL_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("ValidUntil", VALID_UNTIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetUploadJobPathResponse, T> g) {
        return obj -> g.apply((GetUploadJobPathResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CustomerProfilesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetUploadJobPathResponse> {
        /**
         * <p>
         * The pre-signed S3 URL for uploading the CSV file associated with the upload job.
         * </p>
         * 
         * @param url
         *        The pre-signed S3 URL for uploading the CSV file associated with the upload job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The plaintext data key used to encrypt the upload file.
         * </p>
         * <p>
         * To persist to the pre-signed url, use the client token and MD5 client token as header. The required headers
         * are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * x-amz-server-side-encryption-customer-key: Client Token
         * </p>
         * </li>
         * <li>
         * <p>
         * x-amz-server-side-encryption-customer-key-MD5: MD5 Client Token
         * </p>
         * </li>
         * <li>
         * <p>
         * x-amz-server-side-encryption-customer-algorithm: AES256
         * </p>
         * </li>
         * </ul>
         * 
         * @param clientToken
         *        The plaintext data key used to encrypt the upload file. </p>
         *        <p>
         *        To persist to the pre-signed url, use the client token and MD5 client token as header. The required
         *        headers are as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        x-amz-server-side-encryption-customer-key: Client Token
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        x-amz-server-side-encryption-customer-key-MD5: MD5 Client Token
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        x-amz-server-side-encryption-customer-algorithm: AES256
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The expiry timestamp for the pre-signed URL, after which the URL will no longer be valid.
         * </p>
         * 
         * @param validUntil
         *        The expiry timestamp for the pre-signed URL, after which the URL will no longer be valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validUntil(Instant validUntil);
    }

    static final class BuilderImpl extends CustomerProfilesResponse.BuilderImpl implements Builder {
        private String url;

        private String clientToken;

        private Instant validUntil;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUploadJobPathResponse model) {
            super(model);
            url(model.url);
            clientToken(model.clientToken);
            validUntil(model.validUntil);
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Instant getValidUntil() {
            return validUntil;
        }

        public final void setValidUntil(Instant validUntil) {
            this.validUntil = validUntil;
        }

        @Override
        public final Builder validUntil(Instant validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        @Override
        public GetUploadJobPathResponse build() {
            return new GetUploadJobPathResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
