/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUploadJobResponse extends CustomerProfilesResponse implements
        ToCopyableBuilder<GetUploadJobResponse.Builder, GetUploadJobResponse> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobId")
            .getter(getter(GetUploadJobResponse::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(GetUploadJobResponse::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetUploadJobResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(GetUploadJobResponse::statusReasonAsString))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(GetUploadJobResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> COMPLETED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletedAt").getter(getter(GetUploadJobResponse::completedAt)).setter(setter(Builder::completedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedAt").build()).build();

    private static final SdkField<Map<String, ObjectTypeField>> FIELDS_FIELD = SdkField
            .<Map<String, ObjectTypeField>> builder(MarshallingType.MAP)
            .memberName("Fields")
            .getter(getter(GetUploadJobResponse::fields))
            .setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fields").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ObjectTypeField> builder(MarshallingType.SDK_POJO)
                                            .constructor(ObjectTypeField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> UNIQUE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UniqueKey").getter(getter(GetUploadJobResponse::uniqueKey)).setter(setter(Builder::uniqueKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UniqueKey").build()).build();

    private static final SdkField<ResultsSummary> RESULTS_SUMMARY_FIELD = SdkField
            .<ResultsSummary> builder(MarshallingType.SDK_POJO).memberName("ResultsSummary")
            .getter(getter(GetUploadJobResponse::resultsSummary)).setter(setter(Builder::resultsSummary))
            .constructor(ResultsSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultsSummary").build()).build();

    private static final SdkField<Integer> DATA_EXPIRY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DataExpiry").getter(getter(GetUploadJobResponse::dataExpiry)).setter(setter(Builder::dataExpiry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataExpiry").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD,
            DISPLAY_NAME_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, CREATED_AT_FIELD, COMPLETED_AT_FIELD, FIELDS_FIELD,
            UNIQUE_KEY_FIELD, RESULTS_SUMMARY_FIELD, DATA_EXPIRY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String jobId;

    private final String displayName;

    private final String status;

    private final String statusReason;

    private final Instant createdAt;

    private final Instant completedAt;

    private final Map<String, ObjectTypeField> fields;

    private final String uniqueKey;

    private final ResultsSummary resultsSummary;

    private final Integer dataExpiry;

    private GetUploadJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.displayName = builder.displayName;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.createdAt = builder.createdAt;
        this.completedAt = builder.completedAt;
        this.fields = builder.fields;
        this.uniqueKey = builder.uniqueKey;
        this.resultsSummary = builder.resultsSummary;
        this.dataExpiry = builder.dataExpiry;
    }

    /**
     * <p>
     * The unique identifier of the upload job.
     * </p>
     * 
     * @return The unique identifier of the upload job.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The unique name of the upload job. Could be a file name to identify the upload job.
     * </p>
     * 
     * @return The unique name of the upload job. Could be a file name to identify the upload job.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The status describing the status for the upload job. The following are Valid Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>CREATED</b>: The upload job has been created, but has not started processing yet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>IN_PROGRESS</b>: The upload job is currently in progress, ingesting and processing the profile data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PARTIALLY_SUCCEEDED</b>: The upload job has successfully completed the ingestion and processing of all profile
     * data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>SUCCEEDED</b>: The upload job has successfully completed the ingestion and processing of all profile data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>FAILED</b>: The upload job has failed to complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>STOPPED</b>: The upload job has been manually stopped or terminated before completion.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UploadJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status describing the status for the upload job. The following are Valid Values: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>CREATED</b>: The upload job has been created, but has not started processing yet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>IN_PROGRESS</b>: The upload job is currently in progress, ingesting and processing the profile data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PARTIALLY_SUCCEEDED</b>: The upload job has successfully completed the ingestion and processing of all
     *         profile data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>SUCCEEDED</b>: The upload job has successfully completed the ingestion and processing of all profile
     *         data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>FAILED</b>: The upload job has failed to complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>STOPPED</b>: The upload job has been manually stopped or terminated before completion.
     *         </p>
     *         </li>
     * @see UploadJobStatus
     */
    public final UploadJobStatus status() {
        return UploadJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status describing the status for the upload job. The following are Valid Values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>CREATED</b>: The upload job has been created, but has not started processing yet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>IN_PROGRESS</b>: The upload job is currently in progress, ingesting and processing the profile data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PARTIALLY_SUCCEEDED</b>: The upload job has successfully completed the ingestion and processing of all profile
     * data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>SUCCEEDED</b>: The upload job has successfully completed the ingestion and processing of all profile data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>FAILED</b>: The upload job has failed to complete.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>STOPPED</b>: The upload job has been manually stopped or terminated before completion.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UploadJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status describing the status for the upload job. The following are Valid Values: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>CREATED</b>: The upload job has been created, but has not started processing yet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>IN_PROGRESS</b>: The upload job is currently in progress, ingesting and processing the profile data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PARTIALLY_SUCCEEDED</b>: The upload job has successfully completed the ingestion and processing of all
     *         profile data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>SUCCEEDED</b>: The upload job has successfully completed the ingestion and processing of all profile
     *         data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>FAILED</b>: The upload job has failed to complete.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>STOPPED</b>: The upload job has been manually stopped or terminated before completion.
     *         </p>
     *         </li>
     * @see UploadJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason for the current status of the upload job. Possible reasons:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>VALIDATION_FAILURE</b>: The upload job has encountered an error or issue and was unable to complete the
     * profile data ingestion.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>INTERNAL_FAILURE</b>: Failure caused from service side
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusReason} will
     * return {@link StatusReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusReasonAsString}.
     * </p>
     * 
     * @return The reason for the current status of the upload job. Possible reasons: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>VALIDATION_FAILURE</b>: The upload job has encountered an error or issue and was unable to complete
     *         the profile data ingestion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>INTERNAL_FAILURE</b>: Failure caused from service side
     *         </p>
     *         </li>
     * @see StatusReason
     */
    public final StatusReason statusReason() {
        return StatusReason.fromValue(statusReason);
    }

    /**
     * <p>
     * The reason for the current status of the upload job. Possible reasons:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>VALIDATION_FAILURE</b>: The upload job has encountered an error or issue and was unable to complete the
     * profile data ingestion.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>INTERNAL_FAILURE</b>: Failure caused from service side
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusReason} will
     * return {@link StatusReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusReasonAsString}.
     * </p>
     * 
     * @return The reason for the current status of the upload job. Possible reasons: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>VALIDATION_FAILURE</b>: The upload job has encountered an error or issue and was unable to complete
     *         the profile data ingestion.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>INTERNAL_FAILURE</b>: Failure caused from service side
     *         </p>
     *         </li>
     * @see StatusReason
     */
    public final String statusReasonAsString() {
        return statusReason;
    }

    /**
     * <p>
     * The timestamp when the upload job was created.
     * </p>
     * 
     * @return The timestamp when the upload job was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the upload job was completed.
     * </p>
     * 
     * @return The timestamp when the upload job was completed.
     */
    public final Instant completedAt() {
        return completedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Fields property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFields() {
        return fields != null && !(fields instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The mapping between CSV Columns and Profile Object attributes for the upload job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFields} method.
     * </p>
     * 
     * @return The mapping between CSV Columns and Profile Object attributes for the upload job.
     */
    public final Map<String, ObjectTypeField> fields() {
        return fields;
    }

    /**
     * <p>
     * The unique key columns used for de-duping the keys in the upload job.
     * </p>
     * 
     * @return The unique key columns used for de-duping the keys in the upload job.
     */
    public final String uniqueKey() {
        return uniqueKey;
    }

    /**
     * <p>
     * The summary of results for the upload job, including the number of updated, created, and failed records.
     * </p>
     * 
     * @return The summary of results for the upload job, including the number of updated, created, and failed records.
     */
    public final ResultsSummary resultsSummary() {
        return resultsSummary;
    }

    /**
     * <p>
     * The expiry duration for the profiles ingested with the upload job.
     * </p>
     * 
     * @return The expiry duration for the profiles ingested with the upload job.
     */
    public final Integer dataExpiry() {
        return dataExpiry;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(completedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasFields() ? fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(uniqueKey());
        hashCode = 31 * hashCode + Objects.hashCode(resultsSummary());
        hashCode = 31 * hashCode + Objects.hashCode(dataExpiry());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUploadJobResponse)) {
            return false;
        }
        GetUploadJobResponse other = (GetUploadJobResponse) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReasonAsString(), other.statusReasonAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(completedAt(), other.completedAt())
                && hasFields() == other.hasFields() && Objects.equals(fields(), other.fields())
                && Objects.equals(uniqueKey(), other.uniqueKey()) && Objects.equals(resultsSummary(), other.resultsSummary())
                && Objects.equals(dataExpiry(), other.dataExpiry());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetUploadJobResponse").add("JobId", jobId()).add("DisplayName", displayName())
                .add("Status", statusAsString()).add("StatusReason", statusReasonAsString()).add("CreatedAt", createdAt())
                .add("CompletedAt", completedAt()).add("Fields", fields() == null ? null : "*** Sensitive Data Redacted ***")
                .add("UniqueKey", uniqueKey()).add("ResultsSummary", resultsSummary()).add("DataExpiry", dataExpiry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReasonAsString()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "CompletedAt":
            return Optional.ofNullable(clazz.cast(completedAt()));
        case "Fields":
            return Optional.ofNullable(clazz.cast(fields()));
        case "UniqueKey":
            return Optional.ofNullable(clazz.cast(uniqueKey()));
        case "ResultsSummary":
            return Optional.ofNullable(clazz.cast(resultsSummary()));
        case "DataExpiry":
            return Optional.ofNullable(clazz.cast(dataExpiry()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("JobId", JOB_ID_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("CompletedAt", COMPLETED_AT_FIELD);
        map.put("Fields", FIELDS_FIELD);
        map.put("UniqueKey", UNIQUE_KEY_FIELD);
        map.put("ResultsSummary", RESULTS_SUMMARY_FIELD);
        map.put("DataExpiry", DATA_EXPIRY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetUploadJobResponse, T> g) {
        return obj -> g.apply((GetUploadJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CustomerProfilesResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetUploadJobResponse> {
        /**
         * <p>
         * The unique identifier of the upload job.
         * </p>
         * 
         * @param jobId
         *        The unique identifier of the upload job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The unique name of the upload job. Could be a file name to identify the upload job.
         * </p>
         * 
         * @param displayName
         *        The unique name of the upload job. Could be a file name to identify the upload job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The status describing the status for the upload job. The following are Valid Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>CREATED</b>: The upload job has been created, but has not started processing yet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>IN_PROGRESS</b>: The upload job is currently in progress, ingesting and processing the profile data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PARTIALLY_SUCCEEDED</b>: The upload job has successfully completed the ingestion and processing of all
         * profile data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SUCCEEDED</b>: The upload job has successfully completed the ingestion and processing of all profile data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>FAILED</b>: The upload job has failed to complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>STOPPED</b>: The upload job has been manually stopped or terminated before completion.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status describing the status for the upload job. The following are Valid Values: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>CREATED</b>: The upload job has been created, but has not started processing yet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>IN_PROGRESS</b>: The upload job is currently in progress, ingesting and processing the profile
         *        data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PARTIALLY_SUCCEEDED</b>: The upload job has successfully completed the ingestion and processing of
         *        all profile data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SUCCEEDED</b>: The upload job has successfully completed the ingestion and processing of all
         *        profile data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>FAILED</b>: The upload job has failed to complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>STOPPED</b>: The upload job has been manually stopped or terminated before completion.
         *        </p>
         *        </li>
         * @see UploadJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UploadJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status describing the status for the upload job. The following are Valid Values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>CREATED</b>: The upload job has been created, but has not started processing yet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>IN_PROGRESS</b>: The upload job is currently in progress, ingesting and processing the profile data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PARTIALLY_SUCCEEDED</b>: The upload job has successfully completed the ingestion and processing of all
         * profile data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SUCCEEDED</b>: The upload job has successfully completed the ingestion and processing of all profile data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>FAILED</b>: The upload job has failed to complete.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>STOPPED</b>: The upload job has been manually stopped or terminated before completion.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status describing the status for the upload job. The following are Valid Values: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>CREATED</b>: The upload job has been created, but has not started processing yet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>IN_PROGRESS</b>: The upload job is currently in progress, ingesting and processing the profile
         *        data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PARTIALLY_SUCCEEDED</b>: The upload job has successfully completed the ingestion and processing of
         *        all profile data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SUCCEEDED</b>: The upload job has successfully completed the ingestion and processing of all
         *        profile data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>FAILED</b>: The upload job has failed to complete.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>STOPPED</b>: The upload job has been manually stopped or terminated before completion.
         *        </p>
         *        </li>
         * @see UploadJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UploadJobStatus
         */
        Builder status(UploadJobStatus status);

        /**
         * <p>
         * The reason for the current status of the upload job. Possible reasons:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>VALIDATION_FAILURE</b>: The upload job has encountered an error or issue and was unable to complete the
         * profile data ingestion.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>INTERNAL_FAILURE</b>: Failure caused from service side
         * </p>
         * </li>
         * </ul>
         * 
         * @param statusReason
         *        The reason for the current status of the upload job. Possible reasons: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>VALIDATION_FAILURE</b>: The upload job has encountered an error or issue and was unable to complete
         *        the profile data ingestion.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>INTERNAL_FAILURE</b>: Failure caused from service side
         *        </p>
         *        </li>
         * @see StatusReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusReason
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The reason for the current status of the upload job. Possible reasons:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>VALIDATION_FAILURE</b>: The upload job has encountered an error or issue and was unable to complete the
         * profile data ingestion.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>INTERNAL_FAILURE</b>: Failure caused from service side
         * </p>
         * </li>
         * </ul>
         * 
         * @param statusReason
         *        The reason for the current status of the upload job. Possible reasons: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>VALIDATION_FAILURE</b>: The upload job has encountered an error or issue and was unable to complete
         *        the profile data ingestion.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>INTERNAL_FAILURE</b>: Failure caused from service side
         *        </p>
         *        </li>
         * @see StatusReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusReason
         */
        Builder statusReason(StatusReason statusReason);

        /**
         * <p>
         * The timestamp when the upload job was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the upload job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the upload job was completed.
         * </p>
         * 
         * @param completedAt
         *        The timestamp when the upload job was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedAt(Instant completedAt);

        /**
         * <p>
         * The mapping between CSV Columns and Profile Object attributes for the upload job.
         * </p>
         * 
         * @param fields
         *        The mapping between CSV Columns and Profile Object attributes for the upload job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Map<String, ObjectTypeField> fields);

        /**
         * <p>
         * The unique key columns used for de-duping the keys in the upload job.
         * </p>
         * 
         * @param uniqueKey
         *        The unique key columns used for de-duping the keys in the upload job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uniqueKey(String uniqueKey);

        /**
         * <p>
         * The summary of results for the upload job, including the number of updated, created, and failed records.
         * </p>
         * 
         * @param resultsSummary
         *        The summary of results for the upload job, including the number of updated, created, and failed
         *        records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultsSummary(ResultsSummary resultsSummary);

        /**
         * <p>
         * The summary of results for the upload job, including the number of updated, created, and failed records.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResultsSummary.Builder} avoiding the need
         * to create one manually via {@link ResultsSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResultsSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #resultsSummary(ResultsSummary)}.
         * 
         * @param resultsSummary
         *        a consumer that will call methods on {@link ResultsSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultsSummary(ResultsSummary)
         */
        default Builder resultsSummary(Consumer<ResultsSummary.Builder> resultsSummary) {
            return resultsSummary(ResultsSummary.builder().applyMutation(resultsSummary).build());
        }

        /**
         * <p>
         * The expiry duration for the profiles ingested with the upload job.
         * </p>
         * 
         * @param dataExpiry
         *        The expiry duration for the profiles ingested with the upload job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataExpiry(Integer dataExpiry);
    }

    static final class BuilderImpl extends CustomerProfilesResponse.BuilderImpl implements Builder {
        private String jobId;

        private String displayName;

        private String status;

        private String statusReason;

        private Instant createdAt;

        private Instant completedAt;

        private Map<String, ObjectTypeField> fields = DefaultSdkAutoConstructMap.getInstance();

        private String uniqueKey;

        private ResultsSummary resultsSummary;

        private Integer dataExpiry;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUploadJobResponse model) {
            super(model);
            jobId(model.jobId);
            displayName(model.displayName);
            status(model.status);
            statusReason(model.statusReason);
            createdAt(model.createdAt);
            completedAt(model.completedAt);
            fields(model.fields);
            uniqueKey(model.uniqueKey);
            resultsSummary(model.resultsSummary);
            dataExpiry(model.dataExpiry);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(UploadJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public final Builder statusReason(StatusReason statusReason) {
            this.statusReason(statusReason == null ? null : statusReason.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getCompletedAt() {
            return completedAt;
        }

        public final void setCompletedAt(Instant completedAt) {
            this.completedAt = completedAt;
        }

        @Override
        public final Builder completedAt(Instant completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public final Map<String, ObjectTypeField.Builder> getFields() {
            Map<String, ObjectTypeField.Builder> result = FieldMapCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFields(Map<String, ObjectTypeField.BuilderImpl> fields) {
            this.fields = FieldMapCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Map<String, ObjectTypeField> fields) {
            this.fields = FieldMapCopier.copy(fields);
            return this;
        }

        public final String getUniqueKey() {
            return uniqueKey;
        }

        public final void setUniqueKey(String uniqueKey) {
            this.uniqueKey = uniqueKey;
        }

        @Override
        public final Builder uniqueKey(String uniqueKey) {
            this.uniqueKey = uniqueKey;
            return this;
        }

        public final ResultsSummary.Builder getResultsSummary() {
            return resultsSummary != null ? resultsSummary.toBuilder() : null;
        }

        public final void setResultsSummary(ResultsSummary.BuilderImpl resultsSummary) {
            this.resultsSummary = resultsSummary != null ? resultsSummary.build() : null;
        }

        @Override
        public final Builder resultsSummary(ResultsSummary resultsSummary) {
            this.resultsSummary = resultsSummary;
            return this;
        }

        public final Integer getDataExpiry() {
            return dataExpiry;
        }

        public final void setDataExpiry(Integer dataExpiry) {
            this.dataExpiry = dataExpiry;
        }

        @Override
        public final Builder dataExpiry(Integer dataExpiry) {
            this.dataExpiry = dataExpiry;
            return this;
        }

        @Override
        public GetUploadJobResponse build() {
            return new GetUploadJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
