/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWorkflowResponse extends CustomerProfilesResponse implements
        ToCopyableBuilder<GetWorkflowResponse.Builder, GetWorkflowResponse> {
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowId").getter(getter(GetWorkflowResponse::workflowId)).setter(setter(Builder::workflowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowId").build()).build();

    private static final SdkField<String> WORKFLOW_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowType").getter(getter(GetWorkflowResponse::workflowTypeAsString))
            .setter(setter(Builder::workflowType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetWorkflowResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ERROR_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorDescription").getter(getter(GetWorkflowResponse::errorDescription))
            .setter(setter(Builder::errorDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDescription").build()).build();

    private static final SdkField<Instant> START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartDate").getter(getter(GetWorkflowResponse::startDate)).setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAt").getter(getter(GetWorkflowResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()).build();

    private static final SdkField<WorkflowAttributes> ATTRIBUTES_FIELD = SdkField
            .<WorkflowAttributes> builder(MarshallingType.SDK_POJO).memberName("Attributes")
            .getter(getter(GetWorkflowResponse::attributes)).setter(setter(Builder::attributes))
            .constructor(WorkflowAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build()).build();

    private static final SdkField<WorkflowMetrics> METRICS_FIELD = SdkField.<WorkflowMetrics> builder(MarshallingType.SDK_POJO)
            .memberName("Metrics").getter(getter(GetWorkflowResponse::metrics)).setter(setter(Builder::metrics))
            .constructor(WorkflowMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ID_FIELD,
            WORKFLOW_TYPE_FIELD, STATUS_FIELD, ERROR_DESCRIPTION_FIELD, START_DATE_FIELD, LAST_UPDATED_AT_FIELD,
            ATTRIBUTES_FIELD, METRICS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workflowId;

    private final String workflowType;

    private final String status;

    private final String errorDescription;

    private final Instant startDate;

    private final Instant lastUpdatedAt;

    private final WorkflowAttributes attributes;

    private final WorkflowMetrics metrics;

    private GetWorkflowResponse(BuilderImpl builder) {
        super(builder);
        this.workflowId = builder.workflowId;
        this.workflowType = builder.workflowType;
        this.status = builder.status;
        this.errorDescription = builder.errorDescription;
        this.startDate = builder.startDate;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.attributes = builder.attributes;
        this.metrics = builder.metrics;
    }

    /**
     * <p>
     * Unique identifier for the workflow.
     * </p>
     * 
     * @return Unique identifier for the workflow.
     */
    public final String workflowId() {
        return workflowId;
    }

    /**
     * <p>
     * The type of workflow. The only supported value is APPFLOW_INTEGRATION.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workflowType} will
     * return {@link WorkflowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workflowTypeAsString}.
     * </p>
     * 
     * @return The type of workflow. The only supported value is APPFLOW_INTEGRATION.
     * @see WorkflowType
     */
    public final WorkflowType workflowType() {
        return WorkflowType.fromValue(workflowType);
    }

    /**
     * <p>
     * The type of workflow. The only supported value is APPFLOW_INTEGRATION.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workflowType} will
     * return {@link WorkflowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workflowTypeAsString}.
     * </p>
     * 
     * @return The type of workflow. The only supported value is APPFLOW_INTEGRATION.
     * @see WorkflowType
     */
    public final String workflowTypeAsString() {
        return workflowType;
    }

    /**
     * <p>
     * Status of workflow execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of workflow execution.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * Status of workflow execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of workflow execution.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Workflow error messages during execution (if any).
     * </p>
     * 
     * @return Workflow error messages during execution (if any).
     */
    public final String errorDescription() {
        return errorDescription;
    }

    /**
     * <p>
     * The timestamp that represents when workflow execution started.
     * </p>
     * 
     * @return The timestamp that represents when workflow execution started.
     */
    public final Instant startDate() {
        return startDate;
    }

    /**
     * <p>
     * The timestamp that represents when workflow execution last updated.
     * </p>
     * 
     * @return The timestamp that represents when workflow execution last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * Attributes provided for workflow execution.
     * </p>
     * 
     * @return Attributes provided for workflow execution.
     */
    public final WorkflowAttributes attributes() {
        return attributes;
    }

    /**
     * <p>
     * Workflow specific execution metrics.
     * </p>
     * 
     * @return Workflow specific execution metrics.
     */
    public final WorkflowMetrics metrics() {
        return metrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(workflowTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorDescription());
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        hashCode = 31 * hashCode + Objects.hashCode(metrics());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkflowResponse)) {
            return false;
        }
        GetWorkflowResponse other = (GetWorkflowResponse) obj;
        return Objects.equals(workflowId(), other.workflowId())
                && Objects.equals(workflowTypeAsString(), other.workflowTypeAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(errorDescription(), other.errorDescription()) && Objects.equals(startDate(), other.startDate())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(attributes(), other.attributes())
                && Objects.equals(metrics(), other.metrics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWorkflowResponse").add("WorkflowId", workflowId())
                .add("WorkflowType", workflowTypeAsString()).add("Status", statusAsString())
                .add("ErrorDescription", errorDescription()).add("StartDate", startDate()).add("LastUpdatedAt", lastUpdatedAt())
                .add("Attributes", attributes()).add("Metrics", metrics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkflowId":
            return Optional.ofNullable(clazz.cast(workflowId()));
        case "WorkflowType":
            return Optional.ofNullable(clazz.cast(workflowTypeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ErrorDescription":
            return Optional.ofNullable(clazz.cast(errorDescription()));
        case "StartDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "Metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkflowId", WORKFLOW_ID_FIELD);
        map.put("WorkflowType", WORKFLOW_TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ErrorDescription", ERROR_DESCRIPTION_FIELD);
        map.put("StartDate", START_DATE_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("Attributes", ATTRIBUTES_FIELD);
        map.put("Metrics", METRICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWorkflowResponse, T> g) {
        return obj -> g.apply((GetWorkflowResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CustomerProfilesResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetWorkflowResponse> {
        /**
         * <p>
         * Unique identifier for the workflow.
         * </p>
         * 
         * @param workflowId
         *        Unique identifier for the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowId(String workflowId);

        /**
         * <p>
         * The type of workflow. The only supported value is APPFLOW_INTEGRATION.
         * </p>
         * 
         * @param workflowType
         *        The type of workflow. The only supported value is APPFLOW_INTEGRATION.
         * @see WorkflowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowType
         */
        Builder workflowType(String workflowType);

        /**
         * <p>
         * The type of workflow. The only supported value is APPFLOW_INTEGRATION.
         * </p>
         * 
         * @param workflowType
         *        The type of workflow. The only supported value is APPFLOW_INTEGRATION.
         * @see WorkflowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowType
         */
        Builder workflowType(WorkflowType workflowType);

        /**
         * <p>
         * Status of workflow execution.
         * </p>
         * 
         * @param status
         *        Status of workflow execution.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * Status of workflow execution.
         * </p>
         * 
         * @param status
         *        Status of workflow execution.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * Workflow error messages during execution (if any).
         * </p>
         * 
         * @param errorDescription
         *        Workflow error messages during execution (if any).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDescription(String errorDescription);

        /**
         * <p>
         * The timestamp that represents when workflow execution started.
         * </p>
         * 
         * @param startDate
         *        The timestamp that represents when workflow execution started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(Instant startDate);

        /**
         * <p>
         * The timestamp that represents when workflow execution last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The timestamp that represents when workflow execution last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * Attributes provided for workflow execution.
         * </p>
         * 
         * @param attributes
         *        Attributes provided for workflow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(WorkflowAttributes attributes);

        /**
         * <p>
         * Attributes provided for workflow execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkflowAttributes.Builder} avoiding the
         * need to create one manually via {@link WorkflowAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkflowAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #attributes(WorkflowAttributes)}.
         * 
         * @param attributes
         *        a consumer that will call methods on {@link WorkflowAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(WorkflowAttributes)
         */
        default Builder attributes(Consumer<WorkflowAttributes.Builder> attributes) {
            return attributes(WorkflowAttributes.builder().applyMutation(attributes).build());
        }

        /**
         * <p>
         * Workflow specific execution metrics.
         * </p>
         * 
         * @param metrics
         *        Workflow specific execution metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(WorkflowMetrics metrics);

        /**
         * <p>
         * Workflow specific execution metrics.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkflowMetrics.Builder} avoiding the
         * need to create one manually via {@link WorkflowMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkflowMetrics.Builder#build()} is called immediately and its
         * result is passed to {@link #metrics(WorkflowMetrics)}.
         * 
         * @param metrics
         *        a consumer that will call methods on {@link WorkflowMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metrics(WorkflowMetrics)
         */
        default Builder metrics(Consumer<WorkflowMetrics.Builder> metrics) {
            return metrics(WorkflowMetrics.builder().applyMutation(metrics).build());
        }
    }

    static final class BuilderImpl extends CustomerProfilesResponse.BuilderImpl implements Builder {
        private String workflowId;

        private String workflowType;

        private String status;

        private String errorDescription;

        private Instant startDate;

        private Instant lastUpdatedAt;

        private WorkflowAttributes attributes;

        private WorkflowMetrics metrics;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkflowResponse model) {
            super(model);
            workflowId(model.workflowId);
            workflowType(model.workflowType);
            status(model.status);
            errorDescription(model.errorDescription);
            startDate(model.startDate);
            lastUpdatedAt(model.lastUpdatedAt);
            attributes(model.attributes);
            metrics(model.metrics);
        }

        public final String getWorkflowId() {
            return workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final String getWorkflowType() {
            return workflowType;
        }

        public final void setWorkflowType(String workflowType) {
            this.workflowType = workflowType;
        }

        @Override
        public final Builder workflowType(String workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType(workflowType == null ? null : workflowType.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getErrorDescription() {
            return errorDescription;
        }

        public final void setErrorDescription(String errorDescription) {
            this.errorDescription = errorDescription;
        }

        @Override
        public final Builder errorDescription(String errorDescription) {
            this.errorDescription = errorDescription;
            return this;
        }

        public final Instant getStartDate() {
            return startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final WorkflowAttributes.Builder getAttributes() {
            return attributes != null ? attributes.toBuilder() : null;
        }

        public final void setAttributes(WorkflowAttributes.BuilderImpl attributes) {
            this.attributes = attributes != null ? attributes.build() : null;
        }

        @Override
        public final Builder attributes(WorkflowAttributes attributes) {
            this.attributes = attributes;
            return this;
        }

        public final WorkflowMetrics.Builder getMetrics() {
            return metrics != null ? metrics.toBuilder() : null;
        }

        public final void setMetrics(WorkflowMetrics.BuilderImpl metrics) {
            this.metrics = metrics != null ? metrics.build() : null;
        }

        @Override
        public final Builder metrics(WorkflowMetrics metrics) {
            this.metrics = metrics;
            return this;
        }

        @Override
        public GetWorkflowResponse build() {
            return new GetWorkflowResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
