/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains dimensions that determine what to segment on.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Group implements SdkPojo, Serializable, ToCopyableBuilder<Group.Builder, Group> {
    private static final SdkField<List<Dimension>> DIMENSIONS_FIELD = SdkField
            .<List<Dimension>> builder(MarshallingType.LIST)
            .memberName("Dimensions")
            .getter(getter(Group::dimensions))
            .setter(setter(Builder::dimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Dimension> builder(MarshallingType.SDK_POJO)
                                            .constructor(Dimension::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SourceSegment>> SOURCE_SEGMENTS_FIELD = SdkField
            .<List<SourceSegment>> builder(MarshallingType.LIST)
            .memberName("SourceSegments")
            .getter(getter(Group::sourceSegments))
            .setter(setter(Builder::sourceSegments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSegments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SourceSegment> builder(MarshallingType.SDK_POJO)
                                            .constructor(SourceSegment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceType").getter(getter(Group::sourceTypeAsString)).setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Group::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSIONS_FIELD,
            SOURCE_SEGMENTS_FIELD, SOURCE_TYPE_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Dimension> dimensions;

    private final List<SourceSegment> sourceSegments;

    private final String sourceType;

    private final String type;

    private Group(BuilderImpl builder) {
        this.dimensions = builder.dimensions;
        this.sourceSegments = builder.sourceSegments;
        this.sourceType = builder.sourceType;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Dimensions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDimensions() {
        return dimensions != null && !(dimensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Defines the attributes to segment on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDimensions} method.
     * </p>
     * 
     * @return Defines the attributes to segment on.
     */
    public final List<Dimension> dimensions() {
        return dimensions;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceSegments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourceSegments() {
        return sourceSegments != null && !(sourceSegments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Defines the starting source of data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceSegments} method.
     * </p>
     * 
     * @return Defines the starting source of data.
     */
    public final List<SourceSegment> sourceSegments() {
        return sourceSegments;
    }

    /**
     * <p>
     * Defines how to interact with the source data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link IncludeOptions#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return Defines how to interact with the source data.
     * @see IncludeOptions
     */
    public final IncludeOptions sourceType() {
        return IncludeOptions.fromValue(sourceType);
    }

    /**
     * <p>
     * Defines how to interact with the source data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link IncludeOptions#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return Defines how to interact with the source data.
     * @see IncludeOptions
     */
    public final String sourceTypeAsString() {
        return sourceType;
    }

    /**
     * <p>
     * Defines how to interact with the profiles found in the current filtering.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link IncludeOptions#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Defines how to interact with the profiles found in the current filtering.
     * @see IncludeOptions
     */
    public final IncludeOptions type() {
        return IncludeOptions.fromValue(type);
    }

    /**
     * <p>
     * Defines how to interact with the profiles found in the current filtering.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link IncludeOptions#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Defines how to interact with the profiles found in the current filtering.
     * @see IncludeOptions
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensions() ? dimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceSegments() ? sourceSegments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Group)) {
            return false;
        }
        Group other = (Group) obj;
        return hasDimensions() == other.hasDimensions() && Objects.equals(dimensions(), other.dimensions())
                && hasSourceSegments() == other.hasSourceSegments() && Objects.equals(sourceSegments(), other.sourceSegments())
                && Objects.equals(sourceTypeAsString(), other.sourceTypeAsString())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Group").add("Dimensions", hasDimensions() ? dimensions() : null)
                .add("SourceSegments", hasSourceSegments() ? sourceSegments() : null).add("SourceType", sourceTypeAsString())
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        case "SourceSegments":
            return Optional.ofNullable(clazz.cast(sourceSegments()));
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceTypeAsString()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Dimensions", DIMENSIONS_FIELD);
        map.put("SourceSegments", SOURCE_SEGMENTS_FIELD);
        map.put("SourceType", SOURCE_TYPE_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Group, T> g) {
        return obj -> g.apply((Group) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Group> {
        /**
         * <p>
         * Defines the attributes to segment on.
         * </p>
         * 
         * @param dimensions
         *        Defines the attributes to segment on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Collection<Dimension> dimensions);

        /**
         * <p>
         * Defines the attributes to segment on.
         * </p>
         * 
         * @param dimensions
         *        Defines the attributes to segment on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Dimension... dimensions);

        /**
         * <p>
         * Defines the attributes to segment on.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.customerprofiles.model.Dimension.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.customerprofiles.model.Dimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.customerprofiles.model.Dimension.Builder#build()} is called
         * immediately and its result is passed to {@link #dimensions(List<Dimension>)}.
         * 
         * @param dimensions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.customerprofiles.model.Dimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensions(java.util.Collection<Dimension>)
         */
        Builder dimensions(Consumer<Dimension.Builder>... dimensions);

        /**
         * <p>
         * Defines the starting source of data.
         * </p>
         * 
         * @param sourceSegments
         *        Defines the starting source of data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSegments(Collection<SourceSegment> sourceSegments);

        /**
         * <p>
         * Defines the starting source of data.
         * </p>
         * 
         * @param sourceSegments
         *        Defines the starting source of data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSegments(SourceSegment... sourceSegments);

        /**
         * <p>
         * Defines the starting source of data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.customerprofiles.model.SourceSegment.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.customerprofiles.model.SourceSegment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.customerprofiles.model.SourceSegment.Builder#build()} is called
         * immediately and its result is passed to {@link #sourceSegments(List<SourceSegment>)}.
         * 
         * @param sourceSegments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.customerprofiles.model.SourceSegment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceSegments(java.util.Collection<SourceSegment>)
         */
        Builder sourceSegments(Consumer<SourceSegment.Builder>... sourceSegments);

        /**
         * <p>
         * Defines how to interact with the source data.
         * </p>
         * 
         * @param sourceType
         *        Defines how to interact with the source data.
         * @see IncludeOptions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IncludeOptions
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * Defines how to interact with the source data.
         * </p>
         * 
         * @param sourceType
         *        Defines how to interact with the source data.
         * @see IncludeOptions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IncludeOptions
         */
        Builder sourceType(IncludeOptions sourceType);

        /**
         * <p>
         * Defines how to interact with the profiles found in the current filtering.
         * </p>
         * 
         * @param type
         *        Defines how to interact with the profiles found in the current filtering.
         * @see IncludeOptions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IncludeOptions
         */
        Builder type(String type);

        /**
         * <p>
         * Defines how to interact with the profiles found in the current filtering.
         * </p>
         * 
         * @param type
         *        Defines how to interact with the profiles found in the current filtering.
         * @see IncludeOptions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IncludeOptions
         */
        Builder type(IncludeOptions type);
    }

    static final class BuilderImpl implements Builder {
        private List<Dimension> dimensions = DefaultSdkAutoConstructList.getInstance();

        private List<SourceSegment> sourceSegments = DefaultSdkAutoConstructList.getInstance();

        private String sourceType;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Group model) {
            dimensions(model.dimensions);
            sourceSegments(model.sourceSegments);
            sourceType(model.sourceType);
            type(model.type);
        }

        public final List<Dimension.Builder> getDimensions() {
            List<Dimension.Builder> result = DimensionListCopier.copyToBuilder(this.dimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensions(Collection<Dimension.BuilderImpl> dimensions) {
            this.dimensions = DimensionListCopier.copyFromBuilder(dimensions);
        }

        @Override
        public final Builder dimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionListCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Dimension... dimensions) {
            dimensions(Arrays.asList(dimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Consumer<Dimension.Builder>... dimensions) {
            dimensions(Stream.of(dimensions).map(c -> Dimension.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SourceSegment.Builder> getSourceSegments() {
            List<SourceSegment.Builder> result = SourceSegmentListCopier.copyToBuilder(this.sourceSegments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceSegments(Collection<SourceSegment.BuilderImpl> sourceSegments) {
            this.sourceSegments = SourceSegmentListCopier.copyFromBuilder(sourceSegments);
        }

        @Override
        public final Builder sourceSegments(Collection<SourceSegment> sourceSegments) {
            this.sourceSegments = SourceSegmentListCopier.copy(sourceSegments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceSegments(SourceSegment... sourceSegments) {
            sourceSegments(Arrays.asList(sourceSegments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceSegments(Consumer<SourceSegment.Builder>... sourceSegments) {
            sourceSegments(Stream.of(sourceSegments).map(c -> SourceSegment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getSourceType() {
            return sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(IncludeOptions sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(IncludeOptions type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Group build() {
            return new Group(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
