/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the Identity Resolution Job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdentityResolutionJob implements SdkPojo, Serializable,
        ToCopyableBuilder<IdentityResolutionJob.Builder, IdentityResolutionJob> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(IdentityResolutionJob::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobId")
            .getter(getter(IdentityResolutionJob::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(IdentityResolutionJob::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> JOB_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("JobStartTime").getter(getter(IdentityResolutionJob::jobStartTime)).setter(setter(Builder::jobStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStartTime").build()).build();

    private static final SdkField<Instant> JOB_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("JobEndTime").getter(getter(IdentityResolutionJob::jobEndTime)).setter(setter(Builder::jobEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobEndTime").build()).build();

    private static final SdkField<JobStats> JOB_STATS_FIELD = SdkField.<JobStats> builder(MarshallingType.SDK_POJO)
            .memberName("JobStats").getter(getter(IdentityResolutionJob::jobStats)).setter(setter(Builder::jobStats))
            .constructor(JobStats::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStats").build()).build();

    private static final SdkField<ExportingLocation> EXPORTING_LOCATION_FIELD = SdkField
            .<ExportingLocation> builder(MarshallingType.SDK_POJO).memberName("ExportingLocation")
            .getter(getter(IdentityResolutionJob::exportingLocation)).setter(setter(Builder::exportingLocation))
            .constructor(ExportingLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportingLocation").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(IdentityResolutionJob::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            JOB_ID_FIELD, STATUS_FIELD, JOB_START_TIME_FIELD, JOB_END_TIME_FIELD, JOB_STATS_FIELD, EXPORTING_LOCATION_FIELD,
            MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String domainName;

    private final String jobId;

    private final String status;

    private final Instant jobStartTime;

    private final Instant jobEndTime;

    private final JobStats jobStats;

    private final ExportingLocation exportingLocation;

    private final String message;

    private IdentityResolutionJob(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.jobId = builder.jobId;
        this.status = builder.status;
        this.jobStartTime = builder.jobStartTime;
        this.jobEndTime = builder.jobEndTime;
        this.jobStats = builder.jobStats;
        this.exportingLocation = builder.exportingLocation;
        this.message = builder.message;
    }

    /**
     * <p>
     * The unique name of the domain.
     * </p>
     * 
     * @return The unique name of the domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The unique identifier of the Identity Resolution Job.
     * </p>
     * 
     * @return The unique identifier of the Identity Resolution Job.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The status of the Identity Resolution Job.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code>: The Identity Resolution Job is scheduled but has not started yet. If you turn off the
     * Identity Resolution feature in your domain, jobs in the <code>PENDING</code> state are deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PREPROCESSING</code>: The Identity Resolution Job is loading your data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FIND_MATCHING</code>: The Identity Resolution Job is using the machine learning model to identify profiles
     * that belong to the same matching group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MERGING</code>: The Identity Resolution Job is merging duplicate profiles.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code>: The Identity Resolution Job completed successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PARTIAL_SUCCESS</code>: There's a system error and not all of the data is merged. The Identity Resolution
     * Job writes a message indicating the source of the problem.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>: The Identity Resolution Job did not merge any data. It writes a message indicating the
     * source of the problem.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IdentityResolutionJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Identity Resolution Job.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code>: The Identity Resolution Job is scheduled but has not started yet. If you turn off
     *         the Identity Resolution feature in your domain, jobs in the <code>PENDING</code> state are deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PREPROCESSING</code>: The Identity Resolution Job is loading your data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FIND_MATCHING</code>: The Identity Resolution Job is using the machine learning model to identify
     *         profiles that belong to the same matching group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MERGING</code>: The Identity Resolution Job is merging duplicate profiles.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED</code>: The Identity Resolution Job completed successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PARTIAL_SUCCESS</code>: There's a system error and not all of the data is merged. The Identity
     *         Resolution Job writes a message indicating the source of the problem.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>: The Identity Resolution Job did not merge any data. It writes a message indicating
     *         the source of the problem.
     *         </p>
     *         </li>
     * @see IdentityResolutionJobStatus
     */
    public final IdentityResolutionJobStatus status() {
        return IdentityResolutionJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the Identity Resolution Job.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code>: The Identity Resolution Job is scheduled but has not started yet. If you turn off the
     * Identity Resolution feature in your domain, jobs in the <code>PENDING</code> state are deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PREPROCESSING</code>: The Identity Resolution Job is loading your data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FIND_MATCHING</code>: The Identity Resolution Job is using the machine learning model to identify profiles
     * that belong to the same matching group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MERGING</code>: The Identity Resolution Job is merging duplicate profiles.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code>: The Identity Resolution Job completed successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PARTIAL_SUCCESS</code>: There's a system error and not all of the data is merged. The Identity Resolution
     * Job writes a message indicating the source of the problem.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>: The Identity Resolution Job did not merge any data. It writes a message indicating the
     * source of the problem.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IdentityResolutionJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Identity Resolution Job.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code>: The Identity Resolution Job is scheduled but has not started yet. If you turn off
     *         the Identity Resolution feature in your domain, jobs in the <code>PENDING</code> state are deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PREPROCESSING</code>: The Identity Resolution Job is loading your data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FIND_MATCHING</code>: The Identity Resolution Job is using the machine learning model to identify
     *         profiles that belong to the same matching group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MERGING</code>: The Identity Resolution Job is merging duplicate profiles.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED</code>: The Identity Resolution Job completed successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PARTIAL_SUCCESS</code>: There's a system error and not all of the data is merged. The Identity
     *         Resolution Job writes a message indicating the source of the problem.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>: The Identity Resolution Job did not merge any data. It writes a message indicating
     *         the source of the problem.
     *         </p>
     *         </li>
     * @see IdentityResolutionJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The timestamp of when the job was started or will be started.
     * </p>
     * 
     * @return The timestamp of when the job was started or will be started.
     */
    public final Instant jobStartTime() {
        return jobStartTime;
    }

    /**
     * <p>
     * The timestamp of when the job was completed.
     * </p>
     * 
     * @return The timestamp of when the job was completed.
     */
    public final Instant jobEndTime() {
        return jobEndTime;
    }

    /**
     * <p>
     * Statistics about an Identity Resolution Job.
     * </p>
     * 
     * @return Statistics about an Identity Resolution Job.
     */
    public final JobStats jobStats() {
        return jobStats;
    }

    /**
     * <p>
     * The S3 location where the Identity Resolution Job writes result files.
     * </p>
     * 
     * @return The S3 location where the Identity Resolution Job writes result files.
     */
    public final ExportingLocation exportingLocation() {
        return exportingLocation;
    }

    /**
     * <p>
     * The error messages that are generated when the Identity Resolution Job runs.
     * </p>
     * 
     * @return The error messages that are generated when the Identity Resolution Job runs.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jobStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(jobEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(jobStats());
        hashCode = 31 * hashCode + Objects.hashCode(exportingLocation());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityResolutionJob)) {
            return false;
        }
        IdentityResolutionJob other = (IdentityResolutionJob) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(jobId(), other.jobId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(jobStartTime(), other.jobStartTime()) && Objects.equals(jobEndTime(), other.jobEndTime())
                && Objects.equals(jobStats(), other.jobStats()) && Objects.equals(exportingLocation(), other.exportingLocation())
                && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdentityResolutionJob").add("DomainName", domainName()).add("JobId", jobId())
                .add("Status", statusAsString()).add("JobStartTime", jobStartTime()).add("JobEndTime", jobEndTime())
                .add("JobStats", jobStats()).add("ExportingLocation", exportingLocation()).add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "JobStartTime":
            return Optional.ofNullable(clazz.cast(jobStartTime()));
        case "JobEndTime":
            return Optional.ofNullable(clazz.cast(jobEndTime()));
        case "JobStats":
            return Optional.ofNullable(clazz.cast(jobStats()));
        case "ExportingLocation":
            return Optional.ofNullable(clazz.cast(exportingLocation()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("JobId", JOB_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("JobStartTime", JOB_START_TIME_FIELD);
        map.put("JobEndTime", JOB_END_TIME_FIELD);
        map.put("JobStats", JOB_STATS_FIELD);
        map.put("ExportingLocation", EXPORTING_LOCATION_FIELD);
        map.put("Message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdentityResolutionJob, T> g) {
        return obj -> g.apply((IdentityResolutionJob) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdentityResolutionJob> {
        /**
         * <p>
         * The unique name of the domain.
         * </p>
         * 
         * @param domainName
         *        The unique name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The unique identifier of the Identity Resolution Job.
         * </p>
         * 
         * @param jobId
         *        The unique identifier of the Identity Resolution Job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The status of the Identity Resolution Job.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code>: The Identity Resolution Job is scheduled but has not started yet. If you turn off the
         * Identity Resolution feature in your domain, jobs in the <code>PENDING</code> state are deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PREPROCESSING</code>: The Identity Resolution Job is loading your data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FIND_MATCHING</code>: The Identity Resolution Job is using the machine learning model to identify
         * profiles that belong to the same matching group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MERGING</code>: The Identity Resolution Job is merging duplicate profiles.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETED</code>: The Identity Resolution Job completed successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PARTIAL_SUCCESS</code>: There's a system error and not all of the data is merged. The Identity
         * Resolution Job writes a message indicating the source of the problem.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>: The Identity Resolution Job did not merge any data. It writes a message indicating the
         * source of the problem.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the Identity Resolution Job.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code>: The Identity Resolution Job is scheduled but has not started yet. If you turn
         *        off the Identity Resolution feature in your domain, jobs in the <code>PENDING</code> state are
         *        deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PREPROCESSING</code>: The Identity Resolution Job is loading your data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FIND_MATCHING</code>: The Identity Resolution Job is using the machine learning model to
         *        identify profiles that belong to the same matching group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MERGING</code>: The Identity Resolution Job is merging duplicate profiles.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETED</code>: The Identity Resolution Job completed successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PARTIAL_SUCCESS</code>: There's a system error and not all of the data is merged. The Identity
         *        Resolution Job writes a message indicating the source of the problem.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>: The Identity Resolution Job did not merge any data. It writes a message
         *        indicating the source of the problem.
         *        </p>
         *        </li>
         * @see IdentityResolutionJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityResolutionJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the Identity Resolution Job.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code>: The Identity Resolution Job is scheduled but has not started yet. If you turn off the
         * Identity Resolution feature in your domain, jobs in the <code>PENDING</code> state are deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PREPROCESSING</code>: The Identity Resolution Job is loading your data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FIND_MATCHING</code>: The Identity Resolution Job is using the machine learning model to identify
         * profiles that belong to the same matching group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MERGING</code>: The Identity Resolution Job is merging duplicate profiles.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETED</code>: The Identity Resolution Job completed successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PARTIAL_SUCCESS</code>: There's a system error and not all of the data is merged. The Identity
         * Resolution Job writes a message indicating the source of the problem.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>: The Identity Resolution Job did not merge any data. It writes a message indicating the
         * source of the problem.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the Identity Resolution Job.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code>: The Identity Resolution Job is scheduled but has not started yet. If you turn
         *        off the Identity Resolution feature in your domain, jobs in the <code>PENDING</code> state are
         *        deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PREPROCESSING</code>: The Identity Resolution Job is loading your data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FIND_MATCHING</code>: The Identity Resolution Job is using the machine learning model to
         *        identify profiles that belong to the same matching group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MERGING</code>: The Identity Resolution Job is merging duplicate profiles.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETED</code>: The Identity Resolution Job completed successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PARTIAL_SUCCESS</code>: There's a system error and not all of the data is merged. The Identity
         *        Resolution Job writes a message indicating the source of the problem.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>: The Identity Resolution Job did not merge any data. It writes a message
         *        indicating the source of the problem.
         *        </p>
         *        </li>
         * @see IdentityResolutionJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityResolutionJobStatus
         */
        Builder status(IdentityResolutionJobStatus status);

        /**
         * <p>
         * The timestamp of when the job was started or will be started.
         * </p>
         * 
         * @param jobStartTime
         *        The timestamp of when the job was started or will be started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobStartTime(Instant jobStartTime);

        /**
         * <p>
         * The timestamp of when the job was completed.
         * </p>
         * 
         * @param jobEndTime
         *        The timestamp of when the job was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobEndTime(Instant jobEndTime);

        /**
         * <p>
         * Statistics about an Identity Resolution Job.
         * </p>
         * 
         * @param jobStats
         *        Statistics about an Identity Resolution Job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobStats(JobStats jobStats);

        /**
         * <p>
         * Statistics about an Identity Resolution Job.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobStats.Builder} avoiding the need to
         * create one manually via {@link JobStats#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobStats.Builder#build()} is called immediately and its result is
         * passed to {@link #jobStats(JobStats)}.
         * 
         * @param jobStats
         *        a consumer that will call methods on {@link JobStats.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobStats(JobStats)
         */
        default Builder jobStats(Consumer<JobStats.Builder> jobStats) {
            return jobStats(JobStats.builder().applyMutation(jobStats).build());
        }

        /**
         * <p>
         * The S3 location where the Identity Resolution Job writes result files.
         * </p>
         * 
         * @param exportingLocation
         *        The S3 location where the Identity Resolution Job writes result files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportingLocation(ExportingLocation exportingLocation);

        /**
         * <p>
         * The S3 location where the Identity Resolution Job writes result files.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportingLocation.Builder} avoiding the
         * need to create one manually via {@link ExportingLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportingLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #exportingLocation(ExportingLocation)}.
         * 
         * @param exportingLocation
         *        a consumer that will call methods on {@link ExportingLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportingLocation(ExportingLocation)
         */
        default Builder exportingLocation(Consumer<ExportingLocation.Builder> exportingLocation) {
            return exportingLocation(ExportingLocation.builder().applyMutation(exportingLocation).build());
        }

        /**
         * <p>
         * The error messages that are generated when the Identity Resolution Job runs.
         * </p>
         * 
         * @param message
         *        The error messages that are generated when the Identity Resolution Job runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String domainName;

        private String jobId;

        private String status;

        private Instant jobStartTime;

        private Instant jobEndTime;

        private JobStats jobStats;

        private ExportingLocation exportingLocation;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityResolutionJob model) {
            domainName(model.domainName);
            jobId(model.jobId);
            status(model.status);
            jobStartTime(model.jobStartTime);
            jobEndTime(model.jobEndTime);
            jobStats(model.jobStats);
            exportingLocation(model.exportingLocation);
            message(model.message);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IdentityResolutionJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getJobStartTime() {
            return jobStartTime;
        }

        public final void setJobStartTime(Instant jobStartTime) {
            this.jobStartTime = jobStartTime;
        }

        @Override
        public final Builder jobStartTime(Instant jobStartTime) {
            this.jobStartTime = jobStartTime;
            return this;
        }

        public final Instant getJobEndTime() {
            return jobEndTime;
        }

        public final void setJobEndTime(Instant jobEndTime) {
            this.jobEndTime = jobEndTime;
        }

        @Override
        public final Builder jobEndTime(Instant jobEndTime) {
            this.jobEndTime = jobEndTime;
            return this;
        }

        public final JobStats.Builder getJobStats() {
            return jobStats != null ? jobStats.toBuilder() : null;
        }

        public final void setJobStats(JobStats.BuilderImpl jobStats) {
            this.jobStats = jobStats != null ? jobStats.build() : null;
        }

        @Override
        public final Builder jobStats(JobStats jobStats) {
            this.jobStats = jobStats;
            return this;
        }

        public final ExportingLocation.Builder getExportingLocation() {
            return exportingLocation != null ? exportingLocation.toBuilder() : null;
        }

        public final void setExportingLocation(ExportingLocation.BuilderImpl exportingLocation) {
            this.exportingLocation = exportingLocation != null ? exportingLocation.build() : null;
        }

        @Override
        public final Builder exportingLocation(ExportingLocation exportingLocation) {
            this.exportingLocation = exportingLocation;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public IdentityResolutionJob build() {
            return new IdentityResolutionJob(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
