/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a single calculated attribute for a profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCalculatedAttributeForProfileItem implements SdkPojo, Serializable,
        ToCopyableBuilder<ListCalculatedAttributeForProfileItem.Builder, ListCalculatedAttributeForProfileItem> {
    private static final SdkField<String> CALCULATED_ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CalculatedAttributeName").getter(getter(ListCalculatedAttributeForProfileItem::calculatedAttributeName))
            .setter(setter(Builder::calculatedAttributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatedAttributeName").build())
            .build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(ListCalculatedAttributeForProfileItem::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> IS_DATA_PARTIAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IsDataPartial").getter(getter(ListCalculatedAttributeForProfileItem::isDataPartial))
            .setter(setter(Builder::isDataPartial))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDataPartial").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(ListCalculatedAttributeForProfileItem::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<Instant> LAST_OBJECT_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastObjectTimestamp").getter(getter(ListCalculatedAttributeForProfileItem::lastObjectTimestamp))
            .setter(setter(Builder::lastObjectTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastObjectTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CALCULATED_ATTRIBUTE_NAME_FIELD, DISPLAY_NAME_FIELD, IS_DATA_PARTIAL_FIELD,
                    VALUE_FIELD, LAST_OBJECT_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String calculatedAttributeName;

    private final String displayName;

    private final String isDataPartial;

    private final String value;

    private final Instant lastObjectTimestamp;

    private ListCalculatedAttributeForProfileItem(BuilderImpl builder) {
        this.calculatedAttributeName = builder.calculatedAttributeName;
        this.displayName = builder.displayName;
        this.isDataPartial = builder.isDataPartial;
        this.value = builder.value;
        this.lastObjectTimestamp = builder.lastObjectTimestamp;
    }

    /**
     * <p>
     * The unique name of the calculated attribute.
     * </p>
     * 
     * @return The unique name of the calculated attribute.
     */
    public final String calculatedAttributeName() {
        return calculatedAttributeName;
    }

    /**
     * <p>
     * The display name of the calculated attribute.
     * </p>
     * 
     * @return The display name of the calculated attribute.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * Indicates whether the calculated attribute’s value is based on partial data. If data is partial, it is set to
     * true.
     * </p>
     * 
     * @return Indicates whether the calculated attribute’s value is based on partial data. If data is partial, it is
     *         set to true.
     */
    public final String isDataPartial() {
        return isDataPartial;
    }

    /**
     * <p>
     * The value of the calculated attribute.
     * </p>
     * 
     * @return The value of the calculated attribute.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * The timestamp of the newest object included in the calculated attribute calculation.
     * </p>
     * 
     * @return The timestamp of the newest object included in the calculated attribute calculation.
     */
    public final Instant lastObjectTimestamp() {
        return lastObjectTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(calculatedAttributeName());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(isDataPartial());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(lastObjectTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCalculatedAttributeForProfileItem)) {
            return false;
        }
        ListCalculatedAttributeForProfileItem other = (ListCalculatedAttributeForProfileItem) obj;
        return Objects.equals(calculatedAttributeName(), other.calculatedAttributeName())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(isDataPartial(), other.isDataPartial())
                && Objects.equals(value(), other.value()) && Objects.equals(lastObjectTimestamp(), other.lastObjectTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCalculatedAttributeForProfileItem")
                .add("CalculatedAttributeName", calculatedAttributeName()).add("DisplayName", displayName())
                .add("IsDataPartial", isDataPartial()).add("Value", value()).add("LastObjectTimestamp", lastObjectTimestamp())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CalculatedAttributeName":
            return Optional.ofNullable(clazz.cast(calculatedAttributeName()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "IsDataPartial":
            return Optional.ofNullable(clazz.cast(isDataPartial()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "LastObjectTimestamp":
            return Optional.ofNullable(clazz.cast(lastObjectTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CalculatedAttributeName", CALCULATED_ATTRIBUTE_NAME_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("IsDataPartial", IS_DATA_PARTIAL_FIELD);
        map.put("Value", VALUE_FIELD);
        map.put("LastObjectTimestamp", LAST_OBJECT_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCalculatedAttributeForProfileItem, T> g) {
        return obj -> g.apply((ListCalculatedAttributeForProfileItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListCalculatedAttributeForProfileItem> {
        /**
         * <p>
         * The unique name of the calculated attribute.
         * </p>
         * 
         * @param calculatedAttributeName
         *        The unique name of the calculated attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calculatedAttributeName(String calculatedAttributeName);

        /**
         * <p>
         * The display name of the calculated attribute.
         * </p>
         * 
         * @param displayName
         *        The display name of the calculated attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * Indicates whether the calculated attribute’s value is based on partial data. If data is partial, it is set to
         * true.
         * </p>
         * 
         * @param isDataPartial
         *        Indicates whether the calculated attribute’s value is based on partial data. If data is partial, it is
         *        set to true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDataPartial(String isDataPartial);

        /**
         * <p>
         * The value of the calculated attribute.
         * </p>
         * 
         * @param value
         *        The value of the calculated attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The timestamp of the newest object included in the calculated attribute calculation.
         * </p>
         * 
         * @param lastObjectTimestamp
         *        The timestamp of the newest object included in the calculated attribute calculation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastObjectTimestamp(Instant lastObjectTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String calculatedAttributeName;

        private String displayName;

        private String isDataPartial;

        private String value;

        private Instant lastObjectTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCalculatedAttributeForProfileItem model) {
            calculatedAttributeName(model.calculatedAttributeName);
            displayName(model.displayName);
            isDataPartial(model.isDataPartial);
            value(model.value);
            lastObjectTimestamp(model.lastObjectTimestamp);
        }

        public final String getCalculatedAttributeName() {
            return calculatedAttributeName;
        }

        public final void setCalculatedAttributeName(String calculatedAttributeName) {
            this.calculatedAttributeName = calculatedAttributeName;
        }

        @Override
        public final Builder calculatedAttributeName(String calculatedAttributeName) {
            this.calculatedAttributeName = calculatedAttributeName;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getIsDataPartial() {
            return isDataPartial;
        }

        public final void setIsDataPartial(String isDataPartial) {
            this.isDataPartial = isDataPartial;
        }

        @Override
        public final Builder isDataPartial(String isDataPartial) {
            this.isDataPartial = isDataPartial;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final Instant getLastObjectTimestamp() {
            return lastObjectTimestamp;
        }

        public final void setLastObjectTimestamp(Instant lastObjectTimestamp) {
            this.lastObjectTimestamp = lastObjectTimestamp;
        }

        @Override
        public final Builder lastObjectTimestamp(Instant lastObjectTimestamp) {
            this.lastObjectTimestamp = lastObjectTimestamp;
            return this;
        }

        @Override
        public ListCalculatedAttributeForProfileItem build() {
            return new ListCalculatedAttributeForProfileItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
