/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProfileHistoryRecordsRequest extends CustomerProfilesRequest implements
        ToCopyableBuilder<ListProfileHistoryRecordsRequest.Builder, ListProfileHistoryRecordsRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(ListProfileHistoryRecordsRequest::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()).build();

    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileId").getter(getter(ListProfileHistoryRecordsRequest::profileId))
            .setter(setter(Builder::profileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileId").build()).build();

    private static final SdkField<String> OBJECT_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectTypeName").getter(getter(ListProfileHistoryRecordsRequest::objectTypeName))
            .setter(setter(Builder::objectTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectTypeName").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListProfileHistoryRecordsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next-token").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListProfileHistoryRecordsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("max-results").build()).build();

    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActionType").getter(getter(ListProfileHistoryRecordsRequest::actionTypeAsString))
            .setter(setter(Builder::actionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionType").build()).build();

    private static final SdkField<String> PERFORMED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PerformedBy").getter(getter(ListProfileHistoryRecordsRequest::performedBy))
            .setter(setter(Builder::performedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, PROFILE_ID_FIELD, OBJECT_TYPE_NAME_FIELD, NEXT_TOKEN_FIELD,
                    MAX_RESULTS_FIELD, ACTION_TYPE_FIELD, PERFORMED_BY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainName;

    private final String profileId;

    private final String objectTypeName;

    private final String nextToken;

    private final Integer maxResults;

    private final String actionType;

    private final String performedBy;

    private ListProfileHistoryRecordsRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.profileId = builder.profileId;
        this.objectTypeName = builder.objectTypeName;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.actionType = builder.actionType;
        this.performedBy = builder.performedBy;
    }

    /**
     * <p>
     * The unique name of the domain for which to return profile history records.
     * </p>
     * 
     * @return The unique name of the domain for which to return profile history records.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The identifier of the profile to be taken.
     * </p>
     * 
     * @return The identifier of the profile to be taken.
     */
    public final String profileId() {
        return profileId;
    }

    /**
     * <p>
     * Applies a filter to include profile history records only with the specified <code>ObjectTypeName</code> value in
     * the response.
     * </p>
     * 
     * @return Applies a filter to include profile history records only with the specified <code>ObjectTypeName</code>
     *         value in the response.
     */
    public final String objectTypeName() {
        return objectTypeName;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return per page.
     * </p>
     * 
     * @return The maximum number of results to return per page.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Applies a filter to include profile history records only with the specified <code>ActionType</code> value in the
     * response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link ActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionTypeAsString}.
     * </p>
     * 
     * @return Applies a filter to include profile history records only with the specified <code>ActionType</code> value
     *         in the response.
     * @see ActionType
     */
    public final ActionType actionType() {
        return ActionType.fromValue(actionType);
    }

    /**
     * <p>
     * Applies a filter to include profile history records only with the specified <code>ActionType</code> value in the
     * response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link ActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionTypeAsString}.
     * </p>
     * 
     * @return Applies a filter to include profile history records only with the specified <code>ActionType</code> value
     *         in the response.
     * @see ActionType
     */
    public final String actionTypeAsString() {
        return actionType;
    }

    /**
     * <p>
     * Applies a filter to include profile history records only with the specified <code>PerformedBy</code> value in the
     * response. The <code>PerformedBy</code> value can be the Amazon Resource Name (ARN) of the person or service
     * principal who performed the action.
     * </p>
     * 
     * @return Applies a filter to include profile history records only with the specified <code>PerformedBy</code>
     *         value in the response. The <code>PerformedBy</code> value can be the Amazon Resource Name (ARN) of the
     *         person or service principal who performed the action.
     */
    public final String performedBy() {
        return performedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(profileId());
        hashCode = 31 * hashCode + Objects.hashCode(objectTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(performedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProfileHistoryRecordsRequest)) {
            return false;
        }
        ListProfileHistoryRecordsRequest other = (ListProfileHistoryRecordsRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(profileId(), other.profileId())
                && Objects.equals(objectTypeName(), other.objectTypeName()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(actionTypeAsString(), other.actionTypeAsString())
                && Objects.equals(performedBy(), other.performedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListProfileHistoryRecordsRequest").add("DomainName", domainName()).add("ProfileId", profileId())
                .add("ObjectTypeName", objectTypeName()).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("ActionType", actionTypeAsString()).add("PerformedBy", performedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "ProfileId":
            return Optional.ofNullable(clazz.cast(profileId()));
        case "ObjectTypeName":
            return Optional.ofNullable(clazz.cast(objectTypeName()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "ActionType":
            return Optional.ofNullable(clazz.cast(actionTypeAsString()));
        case "PerformedBy":
            return Optional.ofNullable(clazz.cast(performedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("ProfileId", PROFILE_ID_FIELD);
        map.put("ObjectTypeName", OBJECT_TYPE_NAME_FIELD);
        map.put("next-token", NEXT_TOKEN_FIELD);
        map.put("max-results", MAX_RESULTS_FIELD);
        map.put("ActionType", ACTION_TYPE_FIELD);
        map.put("PerformedBy", PERFORMED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListProfileHistoryRecordsRequest, T> g) {
        return obj -> g.apply((ListProfileHistoryRecordsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CustomerProfilesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListProfileHistoryRecordsRequest> {
        /**
         * <p>
         * The unique name of the domain for which to return profile history records.
         * </p>
         * 
         * @param domainName
         *        The unique name of the domain for which to return profile history records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The identifier of the profile to be taken.
         * </p>
         * 
         * @param profileId
         *        The identifier of the profile to be taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileId(String profileId);

        /**
         * <p>
         * Applies a filter to include profile history records only with the specified <code>ObjectTypeName</code> value
         * in the response.
         * </p>
         * 
         * @param objectTypeName
         *        Applies a filter to include profile history records only with the specified
         *        <code>ObjectTypeName</code> value in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectTypeName(String objectTypeName);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return per page.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Applies a filter to include profile history records only with the specified <code>ActionType</code> value in
         * the response.
         * </p>
         * 
         * @param actionType
         *        Applies a filter to include profile history records only with the specified <code>ActionType</code>
         *        value in the response.
         * @see ActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionType
         */
        Builder actionType(String actionType);

        /**
         * <p>
         * Applies a filter to include profile history records only with the specified <code>ActionType</code> value in
         * the response.
         * </p>
         * 
         * @param actionType
         *        Applies a filter to include profile history records only with the specified <code>ActionType</code>
         *        value in the response.
         * @see ActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionType
         */
        Builder actionType(ActionType actionType);

        /**
         * <p>
         * Applies a filter to include profile history records only with the specified <code>PerformedBy</code> value in
         * the response. The <code>PerformedBy</code> value can be the Amazon Resource Name (ARN) of the person or
         * service principal who performed the action.
         * </p>
         * 
         * @param performedBy
         *        Applies a filter to include profile history records only with the specified <code>PerformedBy</code>
         *        value in the response. The <code>PerformedBy</code> value can be the Amazon Resource Name (ARN) of the
         *        person or service principal who performed the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performedBy(String performedBy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CustomerProfilesRequest.BuilderImpl implements Builder {
        private String domainName;

        private String profileId;

        private String objectTypeName;

        private String nextToken;

        private Integer maxResults;

        private String actionType;

        private String performedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProfileHistoryRecordsRequest model) {
            super(model);
            domainName(model.domainName);
            profileId(model.profileId);
            objectTypeName(model.objectTypeName);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            actionType(model.actionType);
            performedBy(model.performedBy);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getProfileId() {
            return profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getObjectTypeName() {
            return objectTypeName;
        }

        public final void setObjectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
        }

        @Override
        public final Builder objectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getActionType() {
            return actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(ActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final String getPerformedBy() {
            return performedBy;
        }

        public final void setPerformedBy(String performedBy) {
            this.performedBy = performedBy;
        }

        @Override
        public final Builder performedBy(String performedBy) {
            this.performedBy = performedBy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListProfileHistoryRecordsRequest build() {
            return new ListProfileHistoryRecordsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
