/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A ProfileObject in a list of ProfileObjects.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProfileObjectsItem implements SdkPojo, Serializable,
        ToCopyableBuilder<ListProfileObjectsItem.Builder, ListProfileObjectsItem> {
    private static final SdkField<String> OBJECT_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectTypeName").getter(getter(ListProfileObjectsItem::objectTypeName))
            .setter(setter(Builder::objectTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectTypeName").build()).build();

    private static final SdkField<String> PROFILE_OBJECT_UNIQUE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileObjectUniqueKey").getter(getter(ListProfileObjectsItem::profileObjectUniqueKey))
            .setter(setter(Builder::profileObjectUniqueKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileObjectUniqueKey").build())
            .build();

    private static final SdkField<String> OBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Object")
            .getter(getter(ListProfileObjectsItem::object)).setter(setter(Builder::object))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Object").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_TYPE_NAME_FIELD,
            PROFILE_OBJECT_UNIQUE_KEY_FIELD, OBJECT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String objectTypeName;

    private final String profileObjectUniqueKey;

    private final String object;

    private ListProfileObjectsItem(BuilderImpl builder) {
        this.objectTypeName = builder.objectTypeName;
        this.profileObjectUniqueKey = builder.profileObjectUniqueKey;
        this.object = builder.object;
    }

    /**
     * <p>
     * Specifies the kind of object being added to a profile, such as "Salesforce-Account."
     * </p>
     * 
     * @return Specifies the kind of object being added to a profile, such as "Salesforce-Account."
     */
    public final String objectTypeName() {
        return objectTypeName;
    }

    /**
     * <p>
     * The unique identifier of the ProfileObject generated by the service.
     * </p>
     * 
     * @return The unique identifier of the ProfileObject generated by the service.
     */
    public final String profileObjectUniqueKey() {
        return profileObjectUniqueKey;
    }

    /**
     * <p>
     * A JSON representation of a ProfileObject that belongs to a profile.
     * </p>
     * 
     * @return A JSON representation of a ProfileObject that belongs to a profile.
     */
    public final String object() {
        return object;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(objectTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(profileObjectUniqueKey());
        hashCode = 31 * hashCode + Objects.hashCode(object());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProfileObjectsItem)) {
            return false;
        }
        ListProfileObjectsItem other = (ListProfileObjectsItem) obj;
        return Objects.equals(objectTypeName(), other.objectTypeName())
                && Objects.equals(profileObjectUniqueKey(), other.profileObjectUniqueKey())
                && Objects.equals(object(), other.object());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListProfileObjectsItem").add("ObjectTypeName", objectTypeName())
                .add("ProfileObjectUniqueKey", profileObjectUniqueKey())
                .add("Object", object() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ObjectTypeName":
            return Optional.ofNullable(clazz.cast(objectTypeName()));
        case "ProfileObjectUniqueKey":
            return Optional.ofNullable(clazz.cast(profileObjectUniqueKey()));
        case "Object":
            return Optional.ofNullable(clazz.cast(object()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ObjectTypeName", OBJECT_TYPE_NAME_FIELD);
        map.put("ProfileObjectUniqueKey", PROFILE_OBJECT_UNIQUE_KEY_FIELD);
        map.put("Object", OBJECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListProfileObjectsItem, T> g) {
        return obj -> g.apply((ListProfileObjectsItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListProfileObjectsItem> {
        /**
         * <p>
         * Specifies the kind of object being added to a profile, such as "Salesforce-Account."
         * </p>
         * 
         * @param objectTypeName
         *        Specifies the kind of object being added to a profile, such as "Salesforce-Account."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectTypeName(String objectTypeName);

        /**
         * <p>
         * The unique identifier of the ProfileObject generated by the service.
         * </p>
         * 
         * @param profileObjectUniqueKey
         *        The unique identifier of the ProfileObject generated by the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileObjectUniqueKey(String profileObjectUniqueKey);

        /**
         * <p>
         * A JSON representation of a ProfileObject that belongs to a profile.
         * </p>
         * 
         * @param object
         *        A JSON representation of a ProfileObject that belongs to a profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder object(String object);
    }

    static final class BuilderImpl implements Builder {
        private String objectTypeName;

        private String profileObjectUniqueKey;

        private String object;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProfileObjectsItem model) {
            objectTypeName(model.objectTypeName);
            profileObjectUniqueKey(model.profileObjectUniqueKey);
            object(model.object);
        }

        public final String getObjectTypeName() {
            return objectTypeName;
        }

        public final void setObjectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
        }

        @Override
        public final Builder objectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
            return this;
        }

        public final String getProfileObjectUniqueKey() {
            return profileObjectUniqueKey;
        }

        public final void setProfileObjectUniqueKey(String profileObjectUniqueKey) {
            this.profileObjectUniqueKey = profileObjectUniqueKey;
        }

        @Override
        public final Builder profileObjectUniqueKey(String profileObjectUniqueKey) {
            this.profileObjectUniqueKey = profileObjectUniqueKey;
            return this;
        }

        public final String getObject() {
            return object;
        }

        public final void setObject(String object) {
            this.object = object;
        }

        @Override
        public final Builder object(String object) {
            this.object = object;
            return this;
        }

        @Override
        public ListProfileObjectsItem build() {
            return new ListProfileObjectsItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
