/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Match group object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MatchItem implements SdkPojo, Serializable, ToCopyableBuilder<MatchItem.Builder, MatchItem> {
    private static final SdkField<String> MATCH_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MatchId").getter(getter(MatchItem::matchId)).setter(setter(Builder::matchId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchId").build()).build();

    private static final SdkField<List<String>> PROFILE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ProfileIds")
            .getter(getter(MatchItem::profileIds))
            .setter(setter(Builder::profileIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Double> CONFIDENCE_SCORE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ConfidenceScore").getter(getter(MatchItem::confidenceScore)).setter(setter(Builder::confidenceScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfidenceScore").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCH_ID_FIELD,
            PROFILE_IDS_FIELD, CONFIDENCE_SCORE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String matchId;

    private final List<String> profileIds;

    private final Double confidenceScore;

    private MatchItem(BuilderImpl builder) {
        this.matchId = builder.matchId;
        this.profileIds = builder.profileIds;
        this.confidenceScore = builder.confidenceScore;
    }

    /**
     * <p>
     * The unique identifiers for this group of profiles that match.
     * </p>
     * 
     * @return The unique identifiers for this group of profiles that match.
     */
    public final String matchId() {
        return matchId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProfileIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasProfileIds() {
        return profileIds != null && !(profileIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of identifiers for profiles that match.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProfileIds} method.
     * </p>
     * 
     * @return A list of identifiers for profiles that match.
     */
    public final List<String> profileIds() {
        return profileIds;
    }

    /**
     * <p>
     * A number between 0 and 1, where a higher score means higher similarity. Examining match confidence scores lets
     * you distinguish between groups of similar records in which the system is highly confident (which you may decide
     * to merge), groups of similar records about which the system is uncertain (which you may decide to have reviewed
     * by a human), and groups of similar records that the system deems to be unlikely (which you may decide to reject).
     * Given confidence scores vary as per the data input, it should not be used an absolute measure of matching
     * quality.
     * </p>
     * 
     * @return A number between 0 and 1, where a higher score means higher similarity. Examining match confidence scores
     *         lets you distinguish between groups of similar records in which the system is highly confident (which you
     *         may decide to merge), groups of similar records about which the system is uncertain (which you may decide
     *         to have reviewed by a human), and groups of similar records that the system deems to be unlikely (which
     *         you may decide to reject). Given confidence scores vary as per the data input, it should not be used an
     *         absolute measure of matching quality.
     */
    public final Double confidenceScore() {
        return confidenceScore;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(matchId());
        hashCode = 31 * hashCode + Objects.hashCode(hasProfileIds() ? profileIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(confidenceScore());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatchItem)) {
            return false;
        }
        MatchItem other = (MatchItem) obj;
        return Objects.equals(matchId(), other.matchId()) && hasProfileIds() == other.hasProfileIds()
                && Objects.equals(profileIds(), other.profileIds()) && Objects.equals(confidenceScore(), other.confidenceScore());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MatchItem").add("MatchId", matchId()).add("ProfileIds", hasProfileIds() ? profileIds() : null)
                .add("ConfidenceScore", confidenceScore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MatchId":
            return Optional.ofNullable(clazz.cast(matchId()));
        case "ProfileIds":
            return Optional.ofNullable(clazz.cast(profileIds()));
        case "ConfidenceScore":
            return Optional.ofNullable(clazz.cast(confidenceScore()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MatchId", MATCH_ID_FIELD);
        map.put("ProfileIds", PROFILE_IDS_FIELD);
        map.put("ConfidenceScore", CONFIDENCE_SCORE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MatchItem, T> g) {
        return obj -> g.apply((MatchItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MatchItem> {
        /**
         * <p>
         * The unique identifiers for this group of profiles that match.
         * </p>
         * 
         * @param matchId
         *        The unique identifiers for this group of profiles that match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchId(String matchId);

        /**
         * <p>
         * A list of identifiers for profiles that match.
         * </p>
         * 
         * @param profileIds
         *        A list of identifiers for profiles that match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileIds(Collection<String> profileIds);

        /**
         * <p>
         * A list of identifiers for profiles that match.
         * </p>
         * 
         * @param profileIds
         *        A list of identifiers for profiles that match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileIds(String... profileIds);

        /**
         * <p>
         * A number between 0 and 1, where a higher score means higher similarity. Examining match confidence scores
         * lets you distinguish between groups of similar records in which the system is highly confident (which you may
         * decide to merge), groups of similar records about which the system is uncertain (which you may decide to have
         * reviewed by a human), and groups of similar records that the system deems to be unlikely (which you may
         * decide to reject). Given confidence scores vary as per the data input, it should not be used an absolute
         * measure of matching quality.
         * </p>
         * 
         * @param confidenceScore
         *        A number between 0 and 1, where a higher score means higher similarity. Examining match confidence
         *        scores lets you distinguish between groups of similar records in which the system is highly confident
         *        (which you may decide to merge), groups of similar records about which the system is uncertain (which
         *        you may decide to have reviewed by a human), and groups of similar records that the system deems to be
         *        unlikely (which you may decide to reject). Given confidence scores vary as per the data input, it
         *        should not be used an absolute measure of matching quality.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidenceScore(Double confidenceScore);
    }

    static final class BuilderImpl implements Builder {
        private String matchId;

        private List<String> profileIds = DefaultSdkAutoConstructList.getInstance();

        private Double confidenceScore;

        private BuilderImpl() {
        }

        private BuilderImpl(MatchItem model) {
            matchId(model.matchId);
            profileIds(model.profileIds);
            confidenceScore(model.confidenceScore);
        }

        public final String getMatchId() {
            return matchId;
        }

        public final void setMatchId(String matchId) {
            this.matchId = matchId;
        }

        @Override
        public final Builder matchId(String matchId) {
            this.matchId = matchId;
            return this;
        }

        public final Collection<String> getProfileIds() {
            if (profileIds instanceof SdkAutoConstructList) {
                return null;
            }
            return profileIds;
        }

        public final void setProfileIds(Collection<String> profileIds) {
            this.profileIds = ProfileIdListCopier.copy(profileIds);
        }

        @Override
        public final Builder profileIds(Collection<String> profileIds) {
            this.profileIds = ProfileIdListCopier.copy(profileIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileIds(String... profileIds) {
            profileIds(Arrays.asList(profileIds));
            return this;
        }

        public final Double getConfidenceScore() {
            return confidenceScore;
        }

        public final void setConfidenceScore(Double confidenceScore) {
            this.confidenceScore = confidenceScore;
        }

        @Override
        public final Builder confidenceScore(Double confidenceScore) {
            this.confidenceScore = confidenceScore;
            return this;
        }

        @Override
        public MatchItem build() {
            return new MatchItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
