/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The object used to segment on attributes within the customer profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProfileAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<ProfileAttributes.Builder, ProfileAttributes> {
    private static final SdkField<ProfileDimension> ACCOUNT_NUMBER_FIELD = SdkField
            .<ProfileDimension> builder(MarshallingType.SDK_POJO).memberName("AccountNumber")
            .getter(getter(ProfileAttributes::accountNumber)).setter(setter(Builder::accountNumber))
            .constructor(ProfileDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountNumber").build()).build();

    private static final SdkField<ExtraLengthValueProfileDimension> ADDITIONAL_INFORMATION_FIELD = SdkField
            .<ExtraLengthValueProfileDimension> builder(MarshallingType.SDK_POJO).memberName("AdditionalInformation")
            .getter(getter(ProfileAttributes::additionalInformation)).setter(setter(Builder::additionalInformation))
            .constructor(ExtraLengthValueProfileDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalInformation").build())
            .build();

    private static final SdkField<ProfileDimension> FIRST_NAME_FIELD = SdkField
            .<ProfileDimension> builder(MarshallingType.SDK_POJO).memberName("FirstName")
            .getter(getter(ProfileAttributes::firstName)).setter(setter(Builder::firstName))
            .constructor(ProfileDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstName").build()).build();

    private static final SdkField<ProfileDimension> LAST_NAME_FIELD = SdkField
            .<ProfileDimension> builder(MarshallingType.SDK_POJO).memberName("LastName")
            .getter(getter(ProfileAttributes::lastName)).setter(setter(Builder::lastName)).constructor(ProfileDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastName").build()).build();

    private static final SdkField<ProfileDimension> MIDDLE_NAME_FIELD = SdkField
            .<ProfileDimension> builder(MarshallingType.SDK_POJO).memberName("MiddleName")
            .getter(getter(ProfileAttributes::middleName)).setter(setter(Builder::middleName))
            .constructor(ProfileDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MiddleName").build()).build();

    private static final SdkField<ProfileDimension> GENDER_STRING_FIELD = SdkField
            .<ProfileDimension> builder(MarshallingType.SDK_POJO).memberName("GenderString")
            .getter(getter(ProfileAttributes::genderString)).setter(setter(Builder::genderString))
            .constructor(ProfileDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenderString").build()).build();

    private static final SdkField<ProfileDimension> PARTY_TYPE_STRING_FIELD = SdkField
            .<ProfileDimension> builder(MarshallingType.SDK_POJO).memberName("PartyTypeString")
            .getter(getter(ProfileAttributes::partyTypeString)).setter(setter(Builder::partyTypeString))
            .constructor(ProfileDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartyTypeString").build()).build();

    private static final SdkField<DateDimension> BIRTH_DATE_FIELD = SdkField.<DateDimension> builder(MarshallingType.SDK_POJO)
            .memberName("BirthDate").getter(getter(ProfileAttributes::birthDate)).setter(setter(Builder::birthDate))
            .constructor(DateDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BirthDate").build()).build();

    private static final SdkField<ProfileDimension> PHONE_NUMBER_FIELD = SdkField
            .<ProfileDimension> builder(MarshallingType.SDK_POJO).memberName("PhoneNumber")
            .getter(getter(ProfileAttributes::phoneNumber)).setter(setter(Builder::phoneNumber))
            .constructor(ProfileDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()).build();

    private static final SdkField<ProfileDimension> BUSINESS_NAME_FIELD = SdkField
            .<ProfileDimension> builder(MarshallingType.SDK_POJO).memberName("BusinessName")
            .getter(getter(ProfileAttributes::businessName)).setter(setter(Builder::businessName))
            .constructor(ProfileDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessName").build()).build();

    private static final SdkField<ProfileDimension> BUSINESS_PHONE_NUMBER_FIELD = SdkField
            .<ProfileDimension> builder(MarshallingType.SDK_POJO).memberName("BusinessPhoneNumber")
            .getter(getter(ProfileAttributes::businessPhoneNumber)).setter(setter(Builder::businessPhoneNumber))
            .constructor(ProfileDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessPhoneNumber").build())
            .build();

    private static final SdkField<ProfileDimension> HOME_PHONE_NUMBER_FIELD = SdkField
            .<ProfileDimension> builder(MarshallingType.SDK_POJO).memberName("HomePhoneNumber")
            .getter(getter(ProfileAttributes::homePhoneNumber)).setter(setter(Builder::homePhoneNumber))
            .constructor(ProfileDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomePhoneNumber").build()).build();

    private static final SdkField<ProfileDimension> MOBILE_PHONE_NUMBER_FIELD = SdkField
            .<ProfileDimension> builder(MarshallingType.SDK_POJO).memberName("MobilePhoneNumber")
            .getter(getter(ProfileAttributes::mobilePhoneNumber)).setter(setter(Builder::mobilePhoneNumber))
            .constructor(ProfileDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MobilePhoneNumber").build()).build();

    private static final SdkField<ProfileDimension> EMAIL_ADDRESS_FIELD = SdkField
            .<ProfileDimension> builder(MarshallingType.SDK_POJO).memberName("EmailAddress")
            .getter(getter(ProfileAttributes::emailAddress)).setter(setter(Builder::emailAddress))
            .constructor(ProfileDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()).build();

    private static final SdkField<ProfileDimension> PERSONAL_EMAIL_ADDRESS_FIELD = SdkField
            .<ProfileDimension> builder(MarshallingType.SDK_POJO).memberName("PersonalEmailAddress")
            .getter(getter(ProfileAttributes::personalEmailAddress)).setter(setter(Builder::personalEmailAddress))
            .constructor(ProfileDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersonalEmailAddress").build())
            .build();

    private static final SdkField<ProfileDimension> BUSINESS_EMAIL_ADDRESS_FIELD = SdkField
            .<ProfileDimension> builder(MarshallingType.SDK_POJO).memberName("BusinessEmailAddress")
            .getter(getter(ProfileAttributes::businessEmailAddress)).setter(setter(Builder::businessEmailAddress))
            .constructor(ProfileDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessEmailAddress").build())
            .build();

    private static final SdkField<AddressDimension> ADDRESS_FIELD = SdkField.<AddressDimension> builder(MarshallingType.SDK_POJO)
            .memberName("Address").getter(getter(ProfileAttributes::address)).setter(setter(Builder::address))
            .constructor(AddressDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()).build();

    private static final SdkField<AddressDimension> SHIPPING_ADDRESS_FIELD = SdkField
            .<AddressDimension> builder(MarshallingType.SDK_POJO).memberName("ShippingAddress")
            .getter(getter(ProfileAttributes::shippingAddress)).setter(setter(Builder::shippingAddress))
            .constructor(AddressDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShippingAddress").build()).build();

    private static final SdkField<AddressDimension> MAILING_ADDRESS_FIELD = SdkField
            .<AddressDimension> builder(MarshallingType.SDK_POJO).memberName("MailingAddress")
            .getter(getter(ProfileAttributes::mailingAddress)).setter(setter(Builder::mailingAddress))
            .constructor(AddressDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MailingAddress").build()).build();

    private static final SdkField<AddressDimension> BILLING_ADDRESS_FIELD = SdkField
            .<AddressDimension> builder(MarshallingType.SDK_POJO).memberName("BillingAddress")
            .getter(getter(ProfileAttributes::billingAddress)).setter(setter(Builder::billingAddress))
            .constructor(AddressDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingAddress").build()).build();

    private static final SdkField<Map<String, AttributeDimension>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, AttributeDimension>> builder(MarshallingType.MAP)
            .memberName("Attributes")
            .getter(getter(ProfileAttributes::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AttributeDimension> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeDimension::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ProfileTypeDimension> PROFILE_TYPE_FIELD = SdkField
            .<ProfileTypeDimension> builder(MarshallingType.SDK_POJO).memberName("ProfileType")
            .getter(getter(ProfileAttributes::profileType)).setter(setter(Builder::profileType))
            .constructor(ProfileTypeDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_NUMBER_FIELD,
            ADDITIONAL_INFORMATION_FIELD, FIRST_NAME_FIELD, LAST_NAME_FIELD, MIDDLE_NAME_FIELD, GENDER_STRING_FIELD,
            PARTY_TYPE_STRING_FIELD, BIRTH_DATE_FIELD, PHONE_NUMBER_FIELD, BUSINESS_NAME_FIELD, BUSINESS_PHONE_NUMBER_FIELD,
            HOME_PHONE_NUMBER_FIELD, MOBILE_PHONE_NUMBER_FIELD, EMAIL_ADDRESS_FIELD, PERSONAL_EMAIL_ADDRESS_FIELD,
            BUSINESS_EMAIL_ADDRESS_FIELD, ADDRESS_FIELD, SHIPPING_ADDRESS_FIELD, MAILING_ADDRESS_FIELD, BILLING_ADDRESS_FIELD,
            ATTRIBUTES_FIELD, PROFILE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ProfileDimension accountNumber;

    private final ExtraLengthValueProfileDimension additionalInformation;

    private final ProfileDimension firstName;

    private final ProfileDimension lastName;

    private final ProfileDimension middleName;

    private final ProfileDimension genderString;

    private final ProfileDimension partyTypeString;

    private final DateDimension birthDate;

    private final ProfileDimension phoneNumber;

    private final ProfileDimension businessName;

    private final ProfileDimension businessPhoneNumber;

    private final ProfileDimension homePhoneNumber;

    private final ProfileDimension mobilePhoneNumber;

    private final ProfileDimension emailAddress;

    private final ProfileDimension personalEmailAddress;

    private final ProfileDimension businessEmailAddress;

    private final AddressDimension address;

    private final AddressDimension shippingAddress;

    private final AddressDimension mailingAddress;

    private final AddressDimension billingAddress;

    private final Map<String, AttributeDimension> attributes;

    private final ProfileTypeDimension profileType;

    private ProfileAttributes(BuilderImpl builder) {
        this.accountNumber = builder.accountNumber;
        this.additionalInformation = builder.additionalInformation;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.middleName = builder.middleName;
        this.genderString = builder.genderString;
        this.partyTypeString = builder.partyTypeString;
        this.birthDate = builder.birthDate;
        this.phoneNumber = builder.phoneNumber;
        this.businessName = builder.businessName;
        this.businessPhoneNumber = builder.businessPhoneNumber;
        this.homePhoneNumber = builder.homePhoneNumber;
        this.mobilePhoneNumber = builder.mobilePhoneNumber;
        this.emailAddress = builder.emailAddress;
        this.personalEmailAddress = builder.personalEmailAddress;
        this.businessEmailAddress = builder.businessEmailAddress;
        this.address = builder.address;
        this.shippingAddress = builder.shippingAddress;
        this.mailingAddress = builder.mailingAddress;
        this.billingAddress = builder.billingAddress;
        this.attributes = builder.attributes;
        this.profileType = builder.profileType;
    }

    /**
     * <p>
     * A field to describe values to segment on within account number.
     * </p>
     * 
     * @return A field to describe values to segment on within account number.
     */
    public final ProfileDimension accountNumber() {
        return accountNumber;
    }

    /**
     * <p>
     * A field to describe values to segment on within additional information.
     * </p>
     * 
     * @return A field to describe values to segment on within additional information.
     */
    public final ExtraLengthValueProfileDimension additionalInformation() {
        return additionalInformation;
    }

    /**
     * <p>
     * A field to describe values to segment on within first name.
     * </p>
     * 
     * @return A field to describe values to segment on within first name.
     */
    public final ProfileDimension firstName() {
        return firstName;
    }

    /**
     * <p>
     * A field to describe values to segment on within last name.
     * </p>
     * 
     * @return A field to describe values to segment on within last name.
     */
    public final ProfileDimension lastName() {
        return lastName;
    }

    /**
     * <p>
     * A field to describe values to segment on within middle name.
     * </p>
     * 
     * @return A field to describe values to segment on within middle name.
     */
    public final ProfileDimension middleName() {
        return middleName;
    }

    /**
     * <p>
     * A field to describe values to segment on within genderString.
     * </p>
     * 
     * @return A field to describe values to segment on within genderString.
     */
    public final ProfileDimension genderString() {
        return genderString;
    }

    /**
     * <p>
     * A field to describe values to segment on within partyTypeString.
     * </p>
     * 
     * @return A field to describe values to segment on within partyTypeString.
     */
    public final ProfileDimension partyTypeString() {
        return partyTypeString;
    }

    /**
     * <p>
     * A field to describe values to segment on within birthDate.
     * </p>
     * 
     * @return A field to describe values to segment on within birthDate.
     */
    public final DateDimension birthDate() {
        return birthDate;
    }

    /**
     * <p>
     * A field to describe values to segment on within phone number.
     * </p>
     * 
     * @return A field to describe values to segment on within phone number.
     */
    public final ProfileDimension phoneNumber() {
        return phoneNumber;
    }

    /**
     * <p>
     * A field to describe values to segment on within business name.
     * </p>
     * 
     * @return A field to describe values to segment on within business name.
     */
    public final ProfileDimension businessName() {
        return businessName;
    }

    /**
     * <p>
     * A field to describe values to segment on within business phone number.
     * </p>
     * 
     * @return A field to describe values to segment on within business phone number.
     */
    public final ProfileDimension businessPhoneNumber() {
        return businessPhoneNumber;
    }

    /**
     * <p>
     * A field to describe values to segment on within home phone number.
     * </p>
     * 
     * @return A field to describe values to segment on within home phone number.
     */
    public final ProfileDimension homePhoneNumber() {
        return homePhoneNumber;
    }

    /**
     * <p>
     * A field to describe values to segment on within mobile phone number.
     * </p>
     * 
     * @return A field to describe values to segment on within mobile phone number.
     */
    public final ProfileDimension mobilePhoneNumber() {
        return mobilePhoneNumber;
    }

    /**
     * <p>
     * A field to describe values to segment on within email address.
     * </p>
     * 
     * @return A field to describe values to segment on within email address.
     */
    public final ProfileDimension emailAddress() {
        return emailAddress;
    }

    /**
     * <p>
     * A field to describe values to segment on within personal email address.
     * </p>
     * 
     * @return A field to describe values to segment on within personal email address.
     */
    public final ProfileDimension personalEmailAddress() {
        return personalEmailAddress;
    }

    /**
     * <p>
     * A field to describe values to segment on within business email address.
     * </p>
     * 
     * @return A field to describe values to segment on within business email address.
     */
    public final ProfileDimension businessEmailAddress() {
        return businessEmailAddress;
    }

    /**
     * <p>
     * A field to describe values to segment on within address.
     * </p>
     * 
     * @return A field to describe values to segment on within address.
     */
    public final AddressDimension address() {
        return address;
    }

    /**
     * <p>
     * A field to describe values to segment on within shipping address.
     * </p>
     * 
     * @return A field to describe values to segment on within shipping address.
     */
    public final AddressDimension shippingAddress() {
        return shippingAddress;
    }

    /**
     * <p>
     * A field to describe values to segment on within mailing address.
     * </p>
     * 
     * @return A field to describe values to segment on within mailing address.
     */
    public final AddressDimension mailingAddress() {
        return mailingAddress;
    }

    /**
     * <p>
     * A field to describe values to segment on within billing address.
     * </p>
     * 
     * @return A field to describe values to segment on within billing address.
     */
    public final AddressDimension billingAddress() {
        return billingAddress;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A field to describe values to segment on within attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return A field to describe values to segment on within attributes.
     */
    public final Map<String, AttributeDimension> attributes() {
        return attributes;
    }

    /**
     * <p>
     * A field to describe values to segment on within profile type.
     * </p>
     * 
     * @return A field to describe values to segment on within profile type.
     */
    public final ProfileTypeDimension profileType() {
        return profileType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountNumber());
        hashCode = 31 * hashCode + Objects.hashCode(additionalInformation());
        hashCode = 31 * hashCode + Objects.hashCode(firstName());
        hashCode = 31 * hashCode + Objects.hashCode(lastName());
        hashCode = 31 * hashCode + Objects.hashCode(middleName());
        hashCode = 31 * hashCode + Objects.hashCode(genderString());
        hashCode = 31 * hashCode + Objects.hashCode(partyTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(birthDate());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(businessName());
        hashCode = 31 * hashCode + Objects.hashCode(businessPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(homePhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(mobilePhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(personalEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(businessEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(address());
        hashCode = 31 * hashCode + Objects.hashCode(shippingAddress());
        hashCode = 31 * hashCode + Objects.hashCode(mailingAddress());
        hashCode = 31 * hashCode + Objects.hashCode(billingAddress());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(profileType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfileAttributes)) {
            return false;
        }
        ProfileAttributes other = (ProfileAttributes) obj;
        return Objects.equals(accountNumber(), other.accountNumber())
                && Objects.equals(additionalInformation(), other.additionalInformation())
                && Objects.equals(firstName(), other.firstName()) && Objects.equals(lastName(), other.lastName())
                && Objects.equals(middleName(), other.middleName()) && Objects.equals(genderString(), other.genderString())
                && Objects.equals(partyTypeString(), other.partyTypeString()) && Objects.equals(birthDate(), other.birthDate())
                && Objects.equals(phoneNumber(), other.phoneNumber()) && Objects.equals(businessName(), other.businessName())
                && Objects.equals(businessPhoneNumber(), other.businessPhoneNumber())
                && Objects.equals(homePhoneNumber(), other.homePhoneNumber())
                && Objects.equals(mobilePhoneNumber(), other.mobilePhoneNumber())
                && Objects.equals(emailAddress(), other.emailAddress())
                && Objects.equals(personalEmailAddress(), other.personalEmailAddress())
                && Objects.equals(businessEmailAddress(), other.businessEmailAddress())
                && Objects.equals(address(), other.address()) && Objects.equals(shippingAddress(), other.shippingAddress())
                && Objects.equals(mailingAddress(), other.mailingAddress())
                && Objects.equals(billingAddress(), other.billingAddress()) && hasAttributes() == other.hasAttributes()
                && Objects.equals(attributes(), other.attributes()) && Objects.equals(profileType(), other.profileType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProfileAttributes").add("AccountNumber", accountNumber())
                .add("AdditionalInformation", additionalInformation()).add("FirstName", firstName()).add("LastName", lastName())
                .add("MiddleName", middleName()).add("GenderString", genderString()).add("PartyTypeString", partyTypeString())
                .add("BirthDate", birthDate()).add("PhoneNumber", phoneNumber()).add("BusinessName", businessName())
                .add("BusinessPhoneNumber", businessPhoneNumber()).add("HomePhoneNumber", homePhoneNumber())
                .add("MobilePhoneNumber", mobilePhoneNumber()).add("EmailAddress", emailAddress())
                .add("PersonalEmailAddress", personalEmailAddress()).add("BusinessEmailAddress", businessEmailAddress())
                .add("Address", address()).add("ShippingAddress", shippingAddress()).add("MailingAddress", mailingAddress())
                .add("BillingAddress", billingAddress()).add("Attributes", hasAttributes() ? attributes() : null)
                .add("ProfileType", profileType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountNumber":
            return Optional.ofNullable(clazz.cast(accountNumber()));
        case "AdditionalInformation":
            return Optional.ofNullable(clazz.cast(additionalInformation()));
        case "FirstName":
            return Optional.ofNullable(clazz.cast(firstName()));
        case "LastName":
            return Optional.ofNullable(clazz.cast(lastName()));
        case "MiddleName":
            return Optional.ofNullable(clazz.cast(middleName()));
        case "GenderString":
            return Optional.ofNullable(clazz.cast(genderString()));
        case "PartyTypeString":
            return Optional.ofNullable(clazz.cast(partyTypeString()));
        case "BirthDate":
            return Optional.ofNullable(clazz.cast(birthDate()));
        case "PhoneNumber":
            return Optional.ofNullable(clazz.cast(phoneNumber()));
        case "BusinessName":
            return Optional.ofNullable(clazz.cast(businessName()));
        case "BusinessPhoneNumber":
            return Optional.ofNullable(clazz.cast(businessPhoneNumber()));
        case "HomePhoneNumber":
            return Optional.ofNullable(clazz.cast(homePhoneNumber()));
        case "MobilePhoneNumber":
            return Optional.ofNullable(clazz.cast(mobilePhoneNumber()));
        case "EmailAddress":
            return Optional.ofNullable(clazz.cast(emailAddress()));
        case "PersonalEmailAddress":
            return Optional.ofNullable(clazz.cast(personalEmailAddress()));
        case "BusinessEmailAddress":
            return Optional.ofNullable(clazz.cast(businessEmailAddress()));
        case "Address":
            return Optional.ofNullable(clazz.cast(address()));
        case "ShippingAddress":
            return Optional.ofNullable(clazz.cast(shippingAddress()));
        case "MailingAddress":
            return Optional.ofNullable(clazz.cast(mailingAddress()));
        case "BillingAddress":
            return Optional.ofNullable(clazz.cast(billingAddress()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "ProfileType":
            return Optional.ofNullable(clazz.cast(profileType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccountNumber", ACCOUNT_NUMBER_FIELD);
        map.put("AdditionalInformation", ADDITIONAL_INFORMATION_FIELD);
        map.put("FirstName", FIRST_NAME_FIELD);
        map.put("LastName", LAST_NAME_FIELD);
        map.put("MiddleName", MIDDLE_NAME_FIELD);
        map.put("GenderString", GENDER_STRING_FIELD);
        map.put("PartyTypeString", PARTY_TYPE_STRING_FIELD);
        map.put("BirthDate", BIRTH_DATE_FIELD);
        map.put("PhoneNumber", PHONE_NUMBER_FIELD);
        map.put("BusinessName", BUSINESS_NAME_FIELD);
        map.put("BusinessPhoneNumber", BUSINESS_PHONE_NUMBER_FIELD);
        map.put("HomePhoneNumber", HOME_PHONE_NUMBER_FIELD);
        map.put("MobilePhoneNumber", MOBILE_PHONE_NUMBER_FIELD);
        map.put("EmailAddress", EMAIL_ADDRESS_FIELD);
        map.put("PersonalEmailAddress", PERSONAL_EMAIL_ADDRESS_FIELD);
        map.put("BusinessEmailAddress", BUSINESS_EMAIL_ADDRESS_FIELD);
        map.put("Address", ADDRESS_FIELD);
        map.put("ShippingAddress", SHIPPING_ADDRESS_FIELD);
        map.put("MailingAddress", MAILING_ADDRESS_FIELD);
        map.put("BillingAddress", BILLING_ADDRESS_FIELD);
        map.put("Attributes", ATTRIBUTES_FIELD);
        map.put("ProfileType", PROFILE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProfileAttributes, T> g) {
        return obj -> g.apply((ProfileAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProfileAttributes> {
        /**
         * <p>
         * A field to describe values to segment on within account number.
         * </p>
         * 
         * @param accountNumber
         *        A field to describe values to segment on within account number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountNumber(ProfileDimension accountNumber);

        /**
         * <p>
         * A field to describe values to segment on within account number.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProfileDimension.Builder} avoiding the
         * need to create one manually via {@link ProfileDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProfileDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #accountNumber(ProfileDimension)}.
         * 
         * @param accountNumber
         *        a consumer that will call methods on {@link ProfileDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountNumber(ProfileDimension)
         */
        default Builder accountNumber(Consumer<ProfileDimension.Builder> accountNumber) {
            return accountNumber(ProfileDimension.builder().applyMutation(accountNumber).build());
        }

        /**
         * <p>
         * A field to describe values to segment on within additional information.
         * </p>
         * 
         * @param additionalInformation
         *        A field to describe values to segment on within additional information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalInformation(ExtraLengthValueProfileDimension additionalInformation);

        /**
         * <p>
         * A field to describe values to segment on within additional information.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExtraLengthValueProfileDimension.Builder}
         * avoiding the need to create one manually via {@link ExtraLengthValueProfileDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExtraLengthValueProfileDimension.Builder#build()} is called
         * immediately and its result is passed to {@link #additionalInformation(ExtraLengthValueProfileDimension)}.
         * 
         * @param additionalInformation
         *        a consumer that will call methods on {@link ExtraLengthValueProfileDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalInformation(ExtraLengthValueProfileDimension)
         */
        default Builder additionalInformation(Consumer<ExtraLengthValueProfileDimension.Builder> additionalInformation) {
            return additionalInformation(ExtraLengthValueProfileDimension.builder().applyMutation(additionalInformation).build());
        }

        /**
         * <p>
         * A field to describe values to segment on within first name.
         * </p>
         * 
         * @param firstName
         *        A field to describe values to segment on within first name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstName(ProfileDimension firstName);

        /**
         * <p>
         * A field to describe values to segment on within first name.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProfileDimension.Builder} avoiding the
         * need to create one manually via {@link ProfileDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProfileDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #firstName(ProfileDimension)}.
         * 
         * @param firstName
         *        a consumer that will call methods on {@link ProfileDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firstName(ProfileDimension)
         */
        default Builder firstName(Consumer<ProfileDimension.Builder> firstName) {
            return firstName(ProfileDimension.builder().applyMutation(firstName).build());
        }

        /**
         * <p>
         * A field to describe values to segment on within last name.
         * </p>
         * 
         * @param lastName
         *        A field to describe values to segment on within last name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastName(ProfileDimension lastName);

        /**
         * <p>
         * A field to describe values to segment on within last name.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProfileDimension.Builder} avoiding the
         * need to create one manually via {@link ProfileDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProfileDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #lastName(ProfileDimension)}.
         * 
         * @param lastName
         *        a consumer that will call methods on {@link ProfileDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastName(ProfileDimension)
         */
        default Builder lastName(Consumer<ProfileDimension.Builder> lastName) {
            return lastName(ProfileDimension.builder().applyMutation(lastName).build());
        }

        /**
         * <p>
         * A field to describe values to segment on within middle name.
         * </p>
         * 
         * @param middleName
         *        A field to describe values to segment on within middle name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder middleName(ProfileDimension middleName);

        /**
         * <p>
         * A field to describe values to segment on within middle name.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProfileDimension.Builder} avoiding the
         * need to create one manually via {@link ProfileDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProfileDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #middleName(ProfileDimension)}.
         * 
         * @param middleName
         *        a consumer that will call methods on {@link ProfileDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #middleName(ProfileDimension)
         */
        default Builder middleName(Consumer<ProfileDimension.Builder> middleName) {
            return middleName(ProfileDimension.builder().applyMutation(middleName).build());
        }

        /**
         * <p>
         * A field to describe values to segment on within genderString.
         * </p>
         * 
         * @param genderString
         *        A field to describe values to segment on within genderString.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder genderString(ProfileDimension genderString);

        /**
         * <p>
         * A field to describe values to segment on within genderString.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProfileDimension.Builder} avoiding the
         * need to create one manually via {@link ProfileDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProfileDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #genderString(ProfileDimension)}.
         * 
         * @param genderString
         *        a consumer that will call methods on {@link ProfileDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #genderString(ProfileDimension)
         */
        default Builder genderString(Consumer<ProfileDimension.Builder> genderString) {
            return genderString(ProfileDimension.builder().applyMutation(genderString).build());
        }

        /**
         * <p>
         * A field to describe values to segment on within partyTypeString.
         * </p>
         * 
         * @param partyTypeString
         *        A field to describe values to segment on within partyTypeString.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partyTypeString(ProfileDimension partyTypeString);

        /**
         * <p>
         * A field to describe values to segment on within partyTypeString.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProfileDimension.Builder} avoiding the
         * need to create one manually via {@link ProfileDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProfileDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #partyTypeString(ProfileDimension)}.
         * 
         * @param partyTypeString
         *        a consumer that will call methods on {@link ProfileDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #partyTypeString(ProfileDimension)
         */
        default Builder partyTypeString(Consumer<ProfileDimension.Builder> partyTypeString) {
            return partyTypeString(ProfileDimension.builder().applyMutation(partyTypeString).build());
        }

        /**
         * <p>
         * A field to describe values to segment on within birthDate.
         * </p>
         * 
         * @param birthDate
         *        A field to describe values to segment on within birthDate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder birthDate(DateDimension birthDate);

        /**
         * <p>
         * A field to describe values to segment on within birthDate.
         * </p>
         * This is a convenience method that creates an instance of the {@link DateDimension.Builder} avoiding the need
         * to create one manually via {@link DateDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DateDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #birthDate(DateDimension)}.
         * 
         * @param birthDate
         *        a consumer that will call methods on {@link DateDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #birthDate(DateDimension)
         */
        default Builder birthDate(Consumer<DateDimension.Builder> birthDate) {
            return birthDate(DateDimension.builder().applyMutation(birthDate).build());
        }

        /**
         * <p>
         * A field to describe values to segment on within phone number.
         * </p>
         * 
         * @param phoneNumber
         *        A field to describe values to segment on within phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(ProfileDimension phoneNumber);

        /**
         * <p>
         * A field to describe values to segment on within phone number.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProfileDimension.Builder} avoiding the
         * need to create one manually via {@link ProfileDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProfileDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #phoneNumber(ProfileDimension)}.
         * 
         * @param phoneNumber
         *        a consumer that will call methods on {@link ProfileDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #phoneNumber(ProfileDimension)
         */
        default Builder phoneNumber(Consumer<ProfileDimension.Builder> phoneNumber) {
            return phoneNumber(ProfileDimension.builder().applyMutation(phoneNumber).build());
        }

        /**
         * <p>
         * A field to describe values to segment on within business name.
         * </p>
         * 
         * @param businessName
         *        A field to describe values to segment on within business name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessName(ProfileDimension businessName);

        /**
         * <p>
         * A field to describe values to segment on within business name.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProfileDimension.Builder} avoiding the
         * need to create one manually via {@link ProfileDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProfileDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #businessName(ProfileDimension)}.
         * 
         * @param businessName
         *        a consumer that will call methods on {@link ProfileDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #businessName(ProfileDimension)
         */
        default Builder businessName(Consumer<ProfileDimension.Builder> businessName) {
            return businessName(ProfileDimension.builder().applyMutation(businessName).build());
        }

        /**
         * <p>
         * A field to describe values to segment on within business phone number.
         * </p>
         * 
         * @param businessPhoneNumber
         *        A field to describe values to segment on within business phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessPhoneNumber(ProfileDimension businessPhoneNumber);

        /**
         * <p>
         * A field to describe values to segment on within business phone number.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProfileDimension.Builder} avoiding the
         * need to create one manually via {@link ProfileDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProfileDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #businessPhoneNumber(ProfileDimension)}.
         * 
         * @param businessPhoneNumber
         *        a consumer that will call methods on {@link ProfileDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #businessPhoneNumber(ProfileDimension)
         */
        default Builder businessPhoneNumber(Consumer<ProfileDimension.Builder> businessPhoneNumber) {
            return businessPhoneNumber(ProfileDimension.builder().applyMutation(businessPhoneNumber).build());
        }

        /**
         * <p>
         * A field to describe values to segment on within home phone number.
         * </p>
         * 
         * @param homePhoneNumber
         *        A field to describe values to segment on within home phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homePhoneNumber(ProfileDimension homePhoneNumber);

        /**
         * <p>
         * A field to describe values to segment on within home phone number.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProfileDimension.Builder} avoiding the
         * need to create one manually via {@link ProfileDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProfileDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #homePhoneNumber(ProfileDimension)}.
         * 
         * @param homePhoneNumber
         *        a consumer that will call methods on {@link ProfileDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #homePhoneNumber(ProfileDimension)
         */
        default Builder homePhoneNumber(Consumer<ProfileDimension.Builder> homePhoneNumber) {
            return homePhoneNumber(ProfileDimension.builder().applyMutation(homePhoneNumber).build());
        }

        /**
         * <p>
         * A field to describe values to segment on within mobile phone number.
         * </p>
         * 
         * @param mobilePhoneNumber
         *        A field to describe values to segment on within mobile phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mobilePhoneNumber(ProfileDimension mobilePhoneNumber);

        /**
         * <p>
         * A field to describe values to segment on within mobile phone number.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProfileDimension.Builder} avoiding the
         * need to create one manually via {@link ProfileDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProfileDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #mobilePhoneNumber(ProfileDimension)}.
         * 
         * @param mobilePhoneNumber
         *        a consumer that will call methods on {@link ProfileDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mobilePhoneNumber(ProfileDimension)
         */
        default Builder mobilePhoneNumber(Consumer<ProfileDimension.Builder> mobilePhoneNumber) {
            return mobilePhoneNumber(ProfileDimension.builder().applyMutation(mobilePhoneNumber).build());
        }

        /**
         * <p>
         * A field to describe values to segment on within email address.
         * </p>
         * 
         * @param emailAddress
         *        A field to describe values to segment on within email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(ProfileDimension emailAddress);

        /**
         * <p>
         * A field to describe values to segment on within email address.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProfileDimension.Builder} avoiding the
         * need to create one manually via {@link ProfileDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProfileDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #emailAddress(ProfileDimension)}.
         * 
         * @param emailAddress
         *        a consumer that will call methods on {@link ProfileDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emailAddress(ProfileDimension)
         */
        default Builder emailAddress(Consumer<ProfileDimension.Builder> emailAddress) {
            return emailAddress(ProfileDimension.builder().applyMutation(emailAddress).build());
        }

        /**
         * <p>
         * A field to describe values to segment on within personal email address.
         * </p>
         * 
         * @param personalEmailAddress
         *        A field to describe values to segment on within personal email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder personalEmailAddress(ProfileDimension personalEmailAddress);

        /**
         * <p>
         * A field to describe values to segment on within personal email address.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProfileDimension.Builder} avoiding the
         * need to create one manually via {@link ProfileDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProfileDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #personalEmailAddress(ProfileDimension)}.
         * 
         * @param personalEmailAddress
         *        a consumer that will call methods on {@link ProfileDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #personalEmailAddress(ProfileDimension)
         */
        default Builder personalEmailAddress(Consumer<ProfileDimension.Builder> personalEmailAddress) {
            return personalEmailAddress(ProfileDimension.builder().applyMutation(personalEmailAddress).build());
        }

        /**
         * <p>
         * A field to describe values to segment on within business email address.
         * </p>
         * 
         * @param businessEmailAddress
         *        A field to describe values to segment on within business email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessEmailAddress(ProfileDimension businessEmailAddress);

        /**
         * <p>
         * A field to describe values to segment on within business email address.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProfileDimension.Builder} avoiding the
         * need to create one manually via {@link ProfileDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProfileDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #businessEmailAddress(ProfileDimension)}.
         * 
         * @param businessEmailAddress
         *        a consumer that will call methods on {@link ProfileDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #businessEmailAddress(ProfileDimension)
         */
        default Builder businessEmailAddress(Consumer<ProfileDimension.Builder> businessEmailAddress) {
            return businessEmailAddress(ProfileDimension.builder().applyMutation(businessEmailAddress).build());
        }

        /**
         * <p>
         * A field to describe values to segment on within address.
         * </p>
         * 
         * @param address
         *        A field to describe values to segment on within address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(AddressDimension address);

        /**
         * <p>
         * A field to describe values to segment on within address.
         * </p>
         * This is a convenience method that creates an instance of the {@link AddressDimension.Builder} avoiding the
         * need to create one manually via {@link AddressDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AddressDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #address(AddressDimension)}.
         * 
         * @param address
         *        a consumer that will call methods on {@link AddressDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #address(AddressDimension)
         */
        default Builder address(Consumer<AddressDimension.Builder> address) {
            return address(AddressDimension.builder().applyMutation(address).build());
        }

        /**
         * <p>
         * A field to describe values to segment on within shipping address.
         * </p>
         * 
         * @param shippingAddress
         *        A field to describe values to segment on within shipping address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shippingAddress(AddressDimension shippingAddress);

        /**
         * <p>
         * A field to describe values to segment on within shipping address.
         * </p>
         * This is a convenience method that creates an instance of the {@link AddressDimension.Builder} avoiding the
         * need to create one manually via {@link AddressDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AddressDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #shippingAddress(AddressDimension)}.
         * 
         * @param shippingAddress
         *        a consumer that will call methods on {@link AddressDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shippingAddress(AddressDimension)
         */
        default Builder shippingAddress(Consumer<AddressDimension.Builder> shippingAddress) {
            return shippingAddress(AddressDimension.builder().applyMutation(shippingAddress).build());
        }

        /**
         * <p>
         * A field to describe values to segment on within mailing address.
         * </p>
         * 
         * @param mailingAddress
         *        A field to describe values to segment on within mailing address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mailingAddress(AddressDimension mailingAddress);

        /**
         * <p>
         * A field to describe values to segment on within mailing address.
         * </p>
         * This is a convenience method that creates an instance of the {@link AddressDimension.Builder} avoiding the
         * need to create one manually via {@link AddressDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AddressDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #mailingAddress(AddressDimension)}.
         * 
         * @param mailingAddress
         *        a consumer that will call methods on {@link AddressDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mailingAddress(AddressDimension)
         */
        default Builder mailingAddress(Consumer<AddressDimension.Builder> mailingAddress) {
            return mailingAddress(AddressDimension.builder().applyMutation(mailingAddress).build());
        }

        /**
         * <p>
         * A field to describe values to segment on within billing address.
         * </p>
         * 
         * @param billingAddress
         *        A field to describe values to segment on within billing address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingAddress(AddressDimension billingAddress);

        /**
         * <p>
         * A field to describe values to segment on within billing address.
         * </p>
         * This is a convenience method that creates an instance of the {@link AddressDimension.Builder} avoiding the
         * need to create one manually via {@link AddressDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AddressDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #billingAddress(AddressDimension)}.
         * 
         * @param billingAddress
         *        a consumer that will call methods on {@link AddressDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #billingAddress(AddressDimension)
         */
        default Builder billingAddress(Consumer<AddressDimension.Builder> billingAddress) {
            return billingAddress(AddressDimension.builder().applyMutation(billingAddress).build());
        }

        /**
         * <p>
         * A field to describe values to segment on within attributes.
         * </p>
         * 
         * @param attributes
         *        A field to describe values to segment on within attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, AttributeDimension> attributes);

        /**
         * <p>
         * A field to describe values to segment on within profile type.
         * </p>
         * 
         * @param profileType
         *        A field to describe values to segment on within profile type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileType(ProfileTypeDimension profileType);

        /**
         * <p>
         * A field to describe values to segment on within profile type.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProfileTypeDimension.Builder} avoiding
         * the need to create one manually via {@link ProfileTypeDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProfileTypeDimension.Builder#build()} is called immediately and
         * its result is passed to {@link #profileType(ProfileTypeDimension)}.
         * 
         * @param profileType
         *        a consumer that will call methods on {@link ProfileTypeDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #profileType(ProfileTypeDimension)
         */
        default Builder profileType(Consumer<ProfileTypeDimension.Builder> profileType) {
            return profileType(ProfileTypeDimension.builder().applyMutation(profileType).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ProfileDimension accountNumber;

        private ExtraLengthValueProfileDimension additionalInformation;

        private ProfileDimension firstName;

        private ProfileDimension lastName;

        private ProfileDimension middleName;

        private ProfileDimension genderString;

        private ProfileDimension partyTypeString;

        private DateDimension birthDate;

        private ProfileDimension phoneNumber;

        private ProfileDimension businessName;

        private ProfileDimension businessPhoneNumber;

        private ProfileDimension homePhoneNumber;

        private ProfileDimension mobilePhoneNumber;

        private ProfileDimension emailAddress;

        private ProfileDimension personalEmailAddress;

        private ProfileDimension businessEmailAddress;

        private AddressDimension address;

        private AddressDimension shippingAddress;

        private AddressDimension mailingAddress;

        private AddressDimension billingAddress;

        private Map<String, AttributeDimension> attributes = DefaultSdkAutoConstructMap.getInstance();

        private ProfileTypeDimension profileType;

        private BuilderImpl() {
        }

        private BuilderImpl(ProfileAttributes model) {
            accountNumber(model.accountNumber);
            additionalInformation(model.additionalInformation);
            firstName(model.firstName);
            lastName(model.lastName);
            middleName(model.middleName);
            genderString(model.genderString);
            partyTypeString(model.partyTypeString);
            birthDate(model.birthDate);
            phoneNumber(model.phoneNumber);
            businessName(model.businessName);
            businessPhoneNumber(model.businessPhoneNumber);
            homePhoneNumber(model.homePhoneNumber);
            mobilePhoneNumber(model.mobilePhoneNumber);
            emailAddress(model.emailAddress);
            personalEmailAddress(model.personalEmailAddress);
            businessEmailAddress(model.businessEmailAddress);
            address(model.address);
            shippingAddress(model.shippingAddress);
            mailingAddress(model.mailingAddress);
            billingAddress(model.billingAddress);
            attributes(model.attributes);
            profileType(model.profileType);
        }

        public final ProfileDimension.Builder getAccountNumber() {
            return accountNumber != null ? accountNumber.toBuilder() : null;
        }

        public final void setAccountNumber(ProfileDimension.BuilderImpl accountNumber) {
            this.accountNumber = accountNumber != null ? accountNumber.build() : null;
        }

        @Override
        public final Builder accountNumber(ProfileDimension accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        public final ExtraLengthValueProfileDimension.Builder getAdditionalInformation() {
            return additionalInformation != null ? additionalInformation.toBuilder() : null;
        }

        public final void setAdditionalInformation(ExtraLengthValueProfileDimension.BuilderImpl additionalInformation) {
            this.additionalInformation = additionalInformation != null ? additionalInformation.build() : null;
        }

        @Override
        public final Builder additionalInformation(ExtraLengthValueProfileDimension additionalInformation) {
            this.additionalInformation = additionalInformation;
            return this;
        }

        public final ProfileDimension.Builder getFirstName() {
            return firstName != null ? firstName.toBuilder() : null;
        }

        public final void setFirstName(ProfileDimension.BuilderImpl firstName) {
            this.firstName = firstName != null ? firstName.build() : null;
        }

        @Override
        public final Builder firstName(ProfileDimension firstName) {
            this.firstName = firstName;
            return this;
        }

        public final ProfileDimension.Builder getLastName() {
            return lastName != null ? lastName.toBuilder() : null;
        }

        public final void setLastName(ProfileDimension.BuilderImpl lastName) {
            this.lastName = lastName != null ? lastName.build() : null;
        }

        @Override
        public final Builder lastName(ProfileDimension lastName) {
            this.lastName = lastName;
            return this;
        }

        public final ProfileDimension.Builder getMiddleName() {
            return middleName != null ? middleName.toBuilder() : null;
        }

        public final void setMiddleName(ProfileDimension.BuilderImpl middleName) {
            this.middleName = middleName != null ? middleName.build() : null;
        }

        @Override
        public final Builder middleName(ProfileDimension middleName) {
            this.middleName = middleName;
            return this;
        }

        public final ProfileDimension.Builder getGenderString() {
            return genderString != null ? genderString.toBuilder() : null;
        }

        public final void setGenderString(ProfileDimension.BuilderImpl genderString) {
            this.genderString = genderString != null ? genderString.build() : null;
        }

        @Override
        public final Builder genderString(ProfileDimension genderString) {
            this.genderString = genderString;
            return this;
        }

        public final ProfileDimension.Builder getPartyTypeString() {
            return partyTypeString != null ? partyTypeString.toBuilder() : null;
        }

        public final void setPartyTypeString(ProfileDimension.BuilderImpl partyTypeString) {
            this.partyTypeString = partyTypeString != null ? partyTypeString.build() : null;
        }

        @Override
        public final Builder partyTypeString(ProfileDimension partyTypeString) {
            this.partyTypeString = partyTypeString;
            return this;
        }

        public final DateDimension.Builder getBirthDate() {
            return birthDate != null ? birthDate.toBuilder() : null;
        }

        public final void setBirthDate(DateDimension.BuilderImpl birthDate) {
            this.birthDate = birthDate != null ? birthDate.build() : null;
        }

        @Override
        public final Builder birthDate(DateDimension birthDate) {
            this.birthDate = birthDate;
            return this;
        }

        public final ProfileDimension.Builder getPhoneNumber() {
            return phoneNumber != null ? phoneNumber.toBuilder() : null;
        }

        public final void setPhoneNumber(ProfileDimension.BuilderImpl phoneNumber) {
            this.phoneNumber = phoneNumber != null ? phoneNumber.build() : null;
        }

        @Override
        public final Builder phoneNumber(ProfileDimension phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final ProfileDimension.Builder getBusinessName() {
            return businessName != null ? businessName.toBuilder() : null;
        }

        public final void setBusinessName(ProfileDimension.BuilderImpl businessName) {
            this.businessName = businessName != null ? businessName.build() : null;
        }

        @Override
        public final Builder businessName(ProfileDimension businessName) {
            this.businessName = businessName;
            return this;
        }

        public final ProfileDimension.Builder getBusinessPhoneNumber() {
            return businessPhoneNumber != null ? businessPhoneNumber.toBuilder() : null;
        }

        public final void setBusinessPhoneNumber(ProfileDimension.BuilderImpl businessPhoneNumber) {
            this.businessPhoneNumber = businessPhoneNumber != null ? businessPhoneNumber.build() : null;
        }

        @Override
        public final Builder businessPhoneNumber(ProfileDimension businessPhoneNumber) {
            this.businessPhoneNumber = businessPhoneNumber;
            return this;
        }

        public final ProfileDimension.Builder getHomePhoneNumber() {
            return homePhoneNumber != null ? homePhoneNumber.toBuilder() : null;
        }

        public final void setHomePhoneNumber(ProfileDimension.BuilderImpl homePhoneNumber) {
            this.homePhoneNumber = homePhoneNumber != null ? homePhoneNumber.build() : null;
        }

        @Override
        public final Builder homePhoneNumber(ProfileDimension homePhoneNumber) {
            this.homePhoneNumber = homePhoneNumber;
            return this;
        }

        public final ProfileDimension.Builder getMobilePhoneNumber() {
            return mobilePhoneNumber != null ? mobilePhoneNumber.toBuilder() : null;
        }

        public final void setMobilePhoneNumber(ProfileDimension.BuilderImpl mobilePhoneNumber) {
            this.mobilePhoneNumber = mobilePhoneNumber != null ? mobilePhoneNumber.build() : null;
        }

        @Override
        public final Builder mobilePhoneNumber(ProfileDimension mobilePhoneNumber) {
            this.mobilePhoneNumber = mobilePhoneNumber;
            return this;
        }

        public final ProfileDimension.Builder getEmailAddress() {
            return emailAddress != null ? emailAddress.toBuilder() : null;
        }

        public final void setEmailAddress(ProfileDimension.BuilderImpl emailAddress) {
            this.emailAddress = emailAddress != null ? emailAddress.build() : null;
        }

        @Override
        public final Builder emailAddress(ProfileDimension emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final ProfileDimension.Builder getPersonalEmailAddress() {
            return personalEmailAddress != null ? personalEmailAddress.toBuilder() : null;
        }

        public final void setPersonalEmailAddress(ProfileDimension.BuilderImpl personalEmailAddress) {
            this.personalEmailAddress = personalEmailAddress != null ? personalEmailAddress.build() : null;
        }

        @Override
        public final Builder personalEmailAddress(ProfileDimension personalEmailAddress) {
            this.personalEmailAddress = personalEmailAddress;
            return this;
        }

        public final ProfileDimension.Builder getBusinessEmailAddress() {
            return businessEmailAddress != null ? businessEmailAddress.toBuilder() : null;
        }

        public final void setBusinessEmailAddress(ProfileDimension.BuilderImpl businessEmailAddress) {
            this.businessEmailAddress = businessEmailAddress != null ? businessEmailAddress.build() : null;
        }

        @Override
        public final Builder businessEmailAddress(ProfileDimension businessEmailAddress) {
            this.businessEmailAddress = businessEmailAddress;
            return this;
        }

        public final AddressDimension.Builder getAddress() {
            return address != null ? address.toBuilder() : null;
        }

        public final void setAddress(AddressDimension.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        @Override
        public final Builder address(AddressDimension address) {
            this.address = address;
            return this;
        }

        public final AddressDimension.Builder getShippingAddress() {
            return shippingAddress != null ? shippingAddress.toBuilder() : null;
        }

        public final void setShippingAddress(AddressDimension.BuilderImpl shippingAddress) {
            this.shippingAddress = shippingAddress != null ? shippingAddress.build() : null;
        }

        @Override
        public final Builder shippingAddress(AddressDimension shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        public final AddressDimension.Builder getMailingAddress() {
            return mailingAddress != null ? mailingAddress.toBuilder() : null;
        }

        public final void setMailingAddress(AddressDimension.BuilderImpl mailingAddress) {
            this.mailingAddress = mailingAddress != null ? mailingAddress.build() : null;
        }

        @Override
        public final Builder mailingAddress(AddressDimension mailingAddress) {
            this.mailingAddress = mailingAddress;
            return this;
        }

        public final AddressDimension.Builder getBillingAddress() {
            return billingAddress != null ? billingAddress.toBuilder() : null;
        }

        public final void setBillingAddress(AddressDimension.BuilderImpl billingAddress) {
            this.billingAddress = billingAddress != null ? billingAddress.build() : null;
        }

        @Override
        public final Builder billingAddress(AddressDimension billingAddress) {
            this.billingAddress = billingAddress;
            return this;
        }

        public final Map<String, AttributeDimension.Builder> getAttributes() {
            Map<String, AttributeDimension.Builder> result = CustomAttributesCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Map<String, AttributeDimension.BuilderImpl> attributes) {
            this.attributes = CustomAttributesCopier.copyFromBuilder(attributes);
        }

        @Override
        public final Builder attributes(Map<String, AttributeDimension> attributes) {
            this.attributes = CustomAttributesCopier.copy(attributes);
            return this;
        }

        public final ProfileTypeDimension.Builder getProfileType() {
            return profileType != null ? profileType.toBuilder() : null;
        }

        public final void setProfileType(ProfileTypeDimension.BuilderImpl profileType) {
            this.profileType = profileType != null ? profileType.build() : null;
        }

        @Override
        public final Builder profileType(ProfileTypeDimension profileType) {
            this.profileType = profileType;
            return this;
        }

        @Override
        public ProfileAttributes build() {
            return new ProfileAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
