/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The relative time period over which data is included in the aggregation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Range implements SdkPojo, Serializable, ToCopyableBuilder<Range.Builder, Range> {
    private static final SdkField<Integer> VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Value")
            .getter(getter(Range::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Unit")
            .getter(getter(Range::unitAsString)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()).build();

    private static final SdkField<ValueRange> VALUE_RANGE_FIELD = SdkField.<ValueRange> builder(MarshallingType.SDK_POJO)
            .memberName("ValueRange").getter(getter(Range::valueRange)).setter(setter(Builder::valueRange))
            .constructor(ValueRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueRange").build()).build();

    private static final SdkField<String> TIMESTAMP_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimestampSource").getter(getter(Range::timestampSource)).setter(setter(Builder::timestampSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampSource").build()).build();

    private static final SdkField<String> TIMESTAMP_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimestampFormat").getter(getter(Range::timestampFormat)).setter(setter(Builder::timestampFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampFormat").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, UNIT_FIELD,
            VALUE_RANGE_FIELD, TIMESTAMP_SOURCE_FIELD, TIMESTAMP_FORMAT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer value;

    private final String unit;

    private final ValueRange valueRange;

    private final String timestampSource;

    private final String timestampFormat;

    private Range(BuilderImpl builder) {
        this.value = builder.value;
        this.unit = builder.unit;
        this.valueRange = builder.valueRange;
        this.timestampSource = builder.timestampSource;
        this.timestampFormat = builder.timestampFormat;
    }

    /**
     * <p>
     * The amount of time of the specified unit.
     * </p>
     * 
     * @return The amount of time of the specified unit.
     */
    public final Integer value() {
        return value;
    }

    /**
     * <p>
     * The unit of time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link Unit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit of time.
     * @see Unit
     */
    public final Unit unit() {
        return Unit.fromValue(unit);
    }

    /**
     * <p>
     * The unit of time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link Unit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit of time.
     * @see Unit
     */
    public final String unitAsString() {
        return unit;
    }

    /**
     * <p>
     * A structure letting customers specify a relative time window over which over which data is included in the
     * Calculated Attribute. Use positive numbers to indicate that the endpoint is in the past, and negative numbers to
     * indicate it is in the future. ValueRange overrides Value.
     * </p>
     * 
     * @return A structure letting customers specify a relative time window over which over which data is included in
     *         the Calculated Attribute. Use positive numbers to indicate that the endpoint is in the past, and negative
     *         numbers to indicate it is in the future. ValueRange overrides Value.
     */
    public final ValueRange valueRange() {
        return valueRange;
    }

    /**
     * <p>
     * An expression specifying the field in your JSON object from which the date should be parsed. The expression
     * should follow the structure of \
     * "{ObjectTypeName.&lt;Location of timestamp field in JSON pointer format&gt;}\". E.g. if your object type is MyType and source JSON is {"
     * generatedAt": {"timestamp": "1737587945945"}}, then TimestampSource should be "{MyType.generatedAt.timestamp}".
     * </p>
     * 
     * @return An expression specifying the field in your JSON object from which the date should be parsed. The
     *         expression should follow the structure of \
     *         "{ObjectTypeName.&lt;Location of timestamp field in JSON pointer format&gt;}\". E.g. if your object type is MyType and source JSON is {"
     *         generatedAt
     *         ": {"timestamp": "1737587945945"}}, then TimestampSource should be "{MyType.generatedAt.timestamp}".
     */
    public final String timestampSource() {
        return timestampSource;
    }

    /**
     * <p>
     * The format the timestamp field in your JSON object is specified. This value should be one of EPOCHMILLI (for Unix
     * epoch timestamps with second/millisecond level precision) or ISO_8601 (following ISO_8601 format with
     * second/millisecond level precision, with an optional offset of Z or in the format HH:MM or HHMM.). E.g. if your
     * object type is MyType and source JSON is {"generatedAt": {"timestamp": "2001-07-04T12:08:56.235-0700"}}, then
     * TimestampFormat should be "ISO_8601".
     * </p>
     * 
     * @return The format the timestamp field in your JSON object is specified. This value should be one of EPOCHMILLI
     *         (for Unix epoch timestamps with second/millisecond level precision) or ISO_8601 (following ISO_8601
     *         format with second/millisecond level precision, with an optional offset of Z or in the format HH:MM or
     *         HHMM.). E.g. if your object type is MyType and source JSON is {"generatedAt": {"timestamp":
     *         "2001-07-04T12:08:56.235-0700"}}, then TimestampFormat should be "ISO_8601".
     */
    public final String timestampFormat() {
        return timestampFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(valueRange());
        hashCode = 31 * hashCode + Objects.hashCode(timestampSource());
        hashCode = 31 * hashCode + Objects.hashCode(timestampFormat());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Range)) {
            return false;
        }
        Range other = (Range) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(unitAsString(), other.unitAsString())
                && Objects.equals(valueRange(), other.valueRange()) && Objects.equals(timestampSource(), other.timestampSource())
                && Objects.equals(timestampFormat(), other.timestampFormat());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Range").add("Value", value()).add("Unit", unitAsString()).add("ValueRange", valueRange())
                .add("TimestampSource", timestampSource()).add("TimestampFormat", timestampFormat()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Unit":
            return Optional.ofNullable(clazz.cast(unitAsString()));
        case "ValueRange":
            return Optional.ofNullable(clazz.cast(valueRange()));
        case "TimestampSource":
            return Optional.ofNullable(clazz.cast(timestampSource()));
        case "TimestampFormat":
            return Optional.ofNullable(clazz.cast(timestampFormat()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Value", VALUE_FIELD);
        map.put("Unit", UNIT_FIELD);
        map.put("ValueRange", VALUE_RANGE_FIELD);
        map.put("TimestampSource", TIMESTAMP_SOURCE_FIELD);
        map.put("TimestampFormat", TIMESTAMP_FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Range, T> g) {
        return obj -> g.apply((Range) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Range> {
        /**
         * <p>
         * The amount of time of the specified unit.
         * </p>
         * 
         * @param value
         *        The amount of time of the specified unit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Integer value);

        /**
         * <p>
         * The unit of time.
         * </p>
         * 
         * @param unit
         *        The unit of time.
         * @see Unit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Unit
         */
        Builder unit(String unit);

        /**
         * <p>
         * The unit of time.
         * </p>
         * 
         * @param unit
         *        The unit of time.
         * @see Unit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Unit
         */
        Builder unit(Unit unit);

        /**
         * <p>
         * A structure letting customers specify a relative time window over which over which data is included in the
         * Calculated Attribute. Use positive numbers to indicate that the endpoint is in the past, and negative numbers
         * to indicate it is in the future. ValueRange overrides Value.
         * </p>
         * 
         * @param valueRange
         *        A structure letting customers specify a relative time window over which over which data is included in
         *        the Calculated Attribute. Use positive numbers to indicate that the endpoint is in the past, and
         *        negative numbers to indicate it is in the future. ValueRange overrides Value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueRange(ValueRange valueRange);

        /**
         * <p>
         * A structure letting customers specify a relative time window over which over which data is included in the
         * Calculated Attribute. Use positive numbers to indicate that the endpoint is in the past, and negative numbers
         * to indicate it is in the future. ValueRange overrides Value.
         * </p>
         * This is a convenience method that creates an instance of the {@link ValueRange.Builder} avoiding the need to
         * create one manually via {@link ValueRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ValueRange.Builder#build()} is called immediately and its result
         * is passed to {@link #valueRange(ValueRange)}.
         * 
         * @param valueRange
         *        a consumer that will call methods on {@link ValueRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #valueRange(ValueRange)
         */
        default Builder valueRange(Consumer<ValueRange.Builder> valueRange) {
            return valueRange(ValueRange.builder().applyMutation(valueRange).build());
        }

        /**
         * <p>
         * An expression specifying the field in your JSON object from which the date should be parsed. The expression
         * should follow the structure of \
         * "{ObjectTypeName.&lt;Location of timestamp field in JSON pointer format&gt;}\". E.g. if your object type is MyType and source JSON is {"
         * generatedAt
         * ": {"timestamp": "1737587945945"}}, then TimestampSource should be "{MyType.generatedAt.timestamp}".
         * </p>
         * 
         * @param timestampSource
         *        An expression specifying the field in your JSON object from which the date should be parsed. The
         *        expression should follow the structure of \
         *        "{ObjectTypeName.&lt;Location of timestamp field in JSON pointer format&gt;}\". E.g. if your object type is MyType and source JSON is {"
         *        generatedAt
         *        ": {"timestamp": "1737587945945"}}, then TimestampSource should be "{MyType.generatedAt.timestamp}".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampSource(String timestampSource);

        /**
         * <p>
         * The format the timestamp field in your JSON object is specified. This value should be one of EPOCHMILLI (for
         * Unix epoch timestamps with second/millisecond level precision) or ISO_8601 (following ISO_8601 format with
         * second/millisecond level precision, with an optional offset of Z or in the format HH:MM or HHMM.). E.g. if
         * your object type is MyType and source JSON is {"generatedAt": {"timestamp": "2001-07-04T12:08:56.235-0700"}},
         * then TimestampFormat should be "ISO_8601".
         * </p>
         * 
         * @param timestampFormat
         *        The format the timestamp field in your JSON object is specified. This value should be one of
         *        EPOCHMILLI (for Unix epoch timestamps with second/millisecond level precision) or ISO_8601 (following
         *        ISO_8601 format with second/millisecond level precision, with an optional offset of Z or in the format
         *        HH:MM or HHMM.). E.g. if your object type is MyType and source JSON is {"generatedAt": {"timestamp":
         *        "2001-07-04T12:08:56.235-0700"}}, then TimestampFormat should be "ISO_8601".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampFormat(String timestampFormat);
    }

    static final class BuilderImpl implements Builder {
        private Integer value;

        private String unit;

        private ValueRange valueRange;

        private String timestampSource;

        private String timestampFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(Range model) {
            value(model.value);
            unit(model.unit);
            valueRange(model.valueRange);
            timestampSource(model.timestampSource);
            timestampFormat(model.timestampFormat);
        }

        public final Integer getValue() {
            return value;
        }

        public final void setValue(Integer value) {
            this.value = value;
        }

        @Override
        public final Builder value(Integer value) {
            this.value = value;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(Unit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final ValueRange.Builder getValueRange() {
            return valueRange != null ? valueRange.toBuilder() : null;
        }

        public final void setValueRange(ValueRange.BuilderImpl valueRange) {
            this.valueRange = valueRange != null ? valueRange.build() : null;
        }

        @Override
        public final Builder valueRange(ValueRange valueRange) {
            this.valueRange = valueRange;
            return this;
        }

        public final String getTimestampSource() {
            return timestampSource;
        }

        public final void setTimestampSource(String timestampSource) {
            this.timestampSource = timestampSource;
        }

        @Override
        public final Builder timestampSource(String timestampSource) {
            this.timestampSource = timestampSource;
            return this;
        }

        public final String getTimestampFormat() {
            return timestampFormat;
        }

        public final void setTimestampFormat(String timestampFormat) {
            this.timestampFormat = timestampFormat;
        }

        @Override
        public final Builder timestampFormat(String timestampFormat) {
            this.timestampFormat = timestampFormat;
            return this;
        }

        @Override
        public Range build() {
            return new Range(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
