/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of results for an upload job, including the number of updated, created, and failed records.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResultsSummary implements SdkPojo, Serializable, ToCopyableBuilder<ResultsSummary.Builder, ResultsSummary> {
    private static final SdkField<Long> UPDATED_RECORDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("UpdatedRecords").getter(getter(ResultsSummary::updatedRecords)).setter(setter(Builder::updatedRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedRecords").build()).build();

    private static final SdkField<Long> CREATED_RECORDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("CreatedRecords").getter(getter(ResultsSummary::createdRecords)).setter(setter(Builder::createdRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedRecords").build()).build();

    private static final SdkField<Long> FAILED_RECORDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("FailedRecords").getter(getter(ResultsSummary::failedRecords)).setter(setter(Builder::failedRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedRecords").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATED_RECORDS_FIELD,
            CREATED_RECORDS_FIELD, FAILED_RECORDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long updatedRecords;

    private final Long createdRecords;

    private final Long failedRecords;

    private ResultsSummary(BuilderImpl builder) {
        this.updatedRecords = builder.updatedRecords;
        this.createdRecords = builder.createdRecords;
        this.failedRecords = builder.failedRecords;
    }

    /**
     * <p>
     * The number of records that were updated during the upload job.
     * </p>
     * 
     * @return The number of records that were updated during the upload job.
     */
    public final Long updatedRecords() {
        return updatedRecords;
    }

    /**
     * <p>
     * The number of records that were newly created during the upload job.
     * </p>
     * 
     * @return The number of records that were newly created during the upload job.
     */
    public final Long createdRecords() {
        return createdRecords;
    }

    /**
     * <p>
     * The number of records that failed to be processed during the upload job.
     * </p>
     * 
     * @return The number of records that failed to be processed during the upload job.
     */
    public final Long failedRecords() {
        return failedRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(updatedRecords());
        hashCode = 31 * hashCode + Objects.hashCode(createdRecords());
        hashCode = 31 * hashCode + Objects.hashCode(failedRecords());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultsSummary)) {
            return false;
        }
        ResultsSummary other = (ResultsSummary) obj;
        return Objects.equals(updatedRecords(), other.updatedRecords())
                && Objects.equals(createdRecords(), other.createdRecords())
                && Objects.equals(failedRecords(), other.failedRecords());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResultsSummary").add("UpdatedRecords", updatedRecords()).add("CreatedRecords", createdRecords())
                .add("FailedRecords", failedRecords()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UpdatedRecords":
            return Optional.ofNullable(clazz.cast(updatedRecords()));
        case "CreatedRecords":
            return Optional.ofNullable(clazz.cast(createdRecords()));
        case "FailedRecords":
            return Optional.ofNullable(clazz.cast(failedRecords()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UpdatedRecords", UPDATED_RECORDS_FIELD);
        map.put("CreatedRecords", CREATED_RECORDS_FIELD);
        map.put("FailedRecords", FAILED_RECORDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResultsSummary, T> g) {
        return obj -> g.apply((ResultsSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResultsSummary> {
        /**
         * <p>
         * The number of records that were updated during the upload job.
         * </p>
         * 
         * @param updatedRecords
         *        The number of records that were updated during the upload job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedRecords(Long updatedRecords);

        /**
         * <p>
         * The number of records that were newly created during the upload job.
         * </p>
         * 
         * @param createdRecords
         *        The number of records that were newly created during the upload job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdRecords(Long createdRecords);

        /**
         * <p>
         * The number of records that failed to be processed during the upload job.
         * </p>
         * 
         * @param failedRecords
         *        The number of records that failed to be processed during the upload job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedRecords(Long failedRecords);
    }

    static final class BuilderImpl implements Builder {
        private Long updatedRecords;

        private Long createdRecords;

        private Long failedRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(ResultsSummary model) {
            updatedRecords(model.updatedRecords);
            createdRecords(model.createdRecords);
            failedRecords(model.failedRecords);
        }

        public final Long getUpdatedRecords() {
            return updatedRecords;
        }

        public final void setUpdatedRecords(Long updatedRecords) {
            this.updatedRecords = updatedRecords;
        }

        @Override
        public final Builder updatedRecords(Long updatedRecords) {
            this.updatedRecords = updatedRecords;
            return this;
        }

        public final Long getCreatedRecords() {
            return createdRecords;
        }

        public final void setCreatedRecords(Long createdRecords) {
            this.createdRecords = createdRecords;
        }

        @Override
        public final Builder createdRecords(Long createdRecords) {
            this.createdRecords = createdRecords;
            return this;
        }

        public final Long getFailedRecords() {
            return failedRecords;
        }

        public final void setFailedRecords(Long failedRecords) {
            this.failedRecords = failedRecords;
        }

        @Override
        public final Builder failedRecords(Long failedRecords) {
            this.failedRecords = failedRecords;
            return this;
        }

        @Override
        public ResultsSummary build() {
            return new ResultsSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
