/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDomainLayoutResponse extends CustomerProfilesResponse implements
        ToCopyableBuilder<UpdateDomainLayoutResponse.Builder, UpdateDomainLayoutResponse> {
    private static final SdkField<String> LAYOUT_DEFINITION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LayoutDefinitionName").getter(getter(UpdateDomainLayoutResponse::layoutDefinitionName))
            .setter(setter(Builder::layoutDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayoutDefinitionName").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateDomainLayoutResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(UpdateDomainLayoutResponse::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsDefault").getter(getter(UpdateDomainLayoutResponse::isDefault)).setter(setter(Builder::isDefault))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefault").build()).build();

    private static final SdkField<String> LAYOUT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LayoutType").getter(getter(UpdateDomainLayoutResponse::layoutTypeAsString))
            .setter(setter(Builder::layoutType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayoutType").build()).build();

    private static final SdkField<String> LAYOUT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Layout")
            .getter(getter(UpdateDomainLayoutResponse::layout)).setter(setter(Builder::layout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Layout").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(UpdateDomainLayoutResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(UpdateDomainLayoutResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAt").getter(getter(UpdateDomainLayoutResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(UpdateDomainLayoutResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYOUT_DEFINITION_NAME_FIELD,
            DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, IS_DEFAULT_FIELD, LAYOUT_TYPE_FIELD, LAYOUT_FIELD, VERSION_FIELD,
            CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String layoutDefinitionName;

    private final String description;

    private final String displayName;

    private final Boolean isDefault;

    private final String layoutType;

    private final String layout;

    private final String version;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final Map<String, String> tags;

    private UpdateDomainLayoutResponse(BuilderImpl builder) {
        super(builder);
        this.layoutDefinitionName = builder.layoutDefinitionName;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.isDefault = builder.isDefault;
        this.layoutType = builder.layoutType;
        this.layout = builder.layout;
        this.version = builder.version;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique name of the layout.
     * </p>
     * 
     * @return The unique name of the layout.
     */
    public final String layoutDefinitionName() {
        return layoutDefinitionName;
    }

    /**
     * <p>
     * The description of the layout
     * </p>
     * 
     * @return The description of the layout
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The display name of the layout
     * </p>
     * 
     * @return The display name of the layout
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * If set to true for a layout, this layout will be used by default to view data. If set to false, then the layout
     * will not be used by default, but it can be used to view data by explicitly selecting it in the console.
     * </p>
     * 
     * @return If set to true for a layout, this layout will be used by default to view data. If set to false, then the
     *         layout will not be used by default, but it can be used to view data by explicitly selecting it in the
     *         console.
     */
    public final Boolean isDefault() {
        return isDefault;
    }

    /**
     * <p>
     * The type of layout that can be used to view data under a Customer Profiles domain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #layoutType} will
     * return {@link LayoutType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #layoutTypeAsString}.
     * </p>
     * 
     * @return The type of layout that can be used to view data under a Customer Profiles domain.
     * @see LayoutType
     */
    public final LayoutType layoutType() {
        return LayoutType.fromValue(layoutType);
    }

    /**
     * <p>
     * The type of layout that can be used to view data under a Customer Profiles domain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #layoutType} will
     * return {@link LayoutType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #layoutTypeAsString}.
     * </p>
     * 
     * @return The type of layout that can be used to view data under a Customer Profiles domain.
     * @see LayoutType
     */
    public final String layoutTypeAsString() {
        return layoutType;
    }

    /**
     * <p>
     * A customizable layout that can be used to view data under a Customer Profiles domain.
     * </p>
     * 
     * @return A customizable layout that can be used to view data under a Customer Profiles domain.
     */
    public final String layout() {
        return layout;
    }

    /**
     * <p>
     * The version used to create layout.
     * </p>
     * 
     * @return The version used to create layout.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The timestamp of when the layout was created.
     * </p>
     * 
     * @return The timestamp of when the layout was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp of when the layout was most recently updated.
     * </p>
     * 
     * @return The timestamp of when the layout was most recently updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(layoutDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(isDefault());
        hashCode = 31 * hashCode + Objects.hashCode(layoutTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(layout());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainLayoutResponse)) {
            return false;
        }
        UpdateDomainLayoutResponse other = (UpdateDomainLayoutResponse) obj;
        return Objects.equals(layoutDefinitionName(), other.layoutDefinitionName())
                && Objects.equals(description(), other.description()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(isDefault(), other.isDefault())
                && Objects.equals(layoutTypeAsString(), other.layoutTypeAsString()) && Objects.equals(layout(), other.layout())
                && Objects.equals(version(), other.version()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDomainLayoutResponse").add("LayoutDefinitionName", layoutDefinitionName())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DisplayName", displayName()).add("IsDefault", isDefault()).add("LayoutType", layoutTypeAsString())
                .add("Layout", layout() == null ? null : "*** Sensitive Data Redacted ***").add("Version", version())
                .add("CreatedAt", createdAt()).add("LastUpdatedAt", lastUpdatedAt()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LayoutDefinitionName":
            return Optional.ofNullable(clazz.cast(layoutDefinitionName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "IsDefault":
            return Optional.ofNullable(clazz.cast(isDefault()));
        case "LayoutType":
            return Optional.ofNullable(clazz.cast(layoutTypeAsString()));
        case "Layout":
            return Optional.ofNullable(clazz.cast(layout()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LayoutDefinitionName", LAYOUT_DEFINITION_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("IsDefault", IS_DEFAULT_FIELD);
        map.put("LayoutType", LAYOUT_TYPE_FIELD);
        map.put("Layout", LAYOUT_FIELD);
        map.put("Version", VERSION_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDomainLayoutResponse, T> g) {
        return obj -> g.apply((UpdateDomainLayoutResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CustomerProfilesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateDomainLayoutResponse> {
        /**
         * <p>
         * The unique name of the layout.
         * </p>
         * 
         * @param layoutDefinitionName
         *        The unique name of the layout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layoutDefinitionName(String layoutDefinitionName);

        /**
         * <p>
         * The description of the layout
         * </p>
         * 
         * @param description
         *        The description of the layout
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The display name of the layout
         * </p>
         * 
         * @param displayName
         *        The display name of the layout
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * If set to true for a layout, this layout will be used by default to view data. If set to false, then the
         * layout will not be used by default, but it can be used to view data by explicitly selecting it in the
         * console.
         * </p>
         * 
         * @param isDefault
         *        If set to true for a layout, this layout will be used by default to view data. If set to false, then
         *        the layout will not be used by default, but it can be used to view data by explicitly selecting it in
         *        the console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefault(Boolean isDefault);

        /**
         * <p>
         * The type of layout that can be used to view data under a Customer Profiles domain.
         * </p>
         * 
         * @param layoutType
         *        The type of layout that can be used to view data under a Customer Profiles domain.
         * @see LayoutType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LayoutType
         */
        Builder layoutType(String layoutType);

        /**
         * <p>
         * The type of layout that can be used to view data under a Customer Profiles domain.
         * </p>
         * 
         * @param layoutType
         *        The type of layout that can be used to view data under a Customer Profiles domain.
         * @see LayoutType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LayoutType
         */
        Builder layoutType(LayoutType layoutType);

        /**
         * <p>
         * A customizable layout that can be used to view data under a Customer Profiles domain.
         * </p>
         * 
         * @param layout
         *        A customizable layout that can be used to view data under a Customer Profiles domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layout(String layout);

        /**
         * <p>
         * The version used to create layout.
         * </p>
         * 
         * @param version
         *        The version used to create layout.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The timestamp of when the layout was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the layout was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp of when the layout was most recently updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The timestamp of when the layout was most recently updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends CustomerProfilesResponse.BuilderImpl implements Builder {
        private String layoutDefinitionName;

        private String description;

        private String displayName;

        private Boolean isDefault;

        private String layoutType;

        private String layout;

        private String version;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainLayoutResponse model) {
            super(model);
            layoutDefinitionName(model.layoutDefinitionName);
            description(model.description);
            displayName(model.displayName);
            isDefault(model.isDefault);
            layoutType(model.layoutType);
            layout(model.layout);
            version(model.version);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            tags(model.tags);
        }

        public final String getLayoutDefinitionName() {
            return layoutDefinitionName;
        }

        public final void setLayoutDefinitionName(String layoutDefinitionName) {
            this.layoutDefinitionName = layoutDefinitionName;
        }

        @Override
        public final Builder layoutDefinitionName(String layoutDefinitionName) {
            this.layoutDefinitionName = layoutDefinitionName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Boolean getIsDefault() {
            return isDefault;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final String getLayoutType() {
            return layoutType;
        }

        public final void setLayoutType(String layoutType) {
            this.layoutType = layoutType;
        }

        @Override
        public final Builder layoutType(String layoutType) {
            this.layoutType = layoutType;
            return this;
        }

        @Override
        public final Builder layoutType(LayoutType layoutType) {
            this.layoutType(layoutType == null ? null : layoutType.toString());
            return this;
        }

        public final String getLayout() {
            return layout;
        }

        public final void setLayout(String layout) {
            this.layout = layout;
        }

        @Override
        public final Builder layout(String layout) {
            this.layout = layout;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public UpdateDomainLayoutResponse build() {
            return new UpdateDomainLayoutResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
