/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class UploadJobsListCopier {
    static List<UploadJobItem> copy(Collection<? extends UploadJobItem> uploadJobsListParam) {
        List<UploadJobItem> list;
        if (uploadJobsListParam == null || uploadJobsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<UploadJobItem> modifiableList = new ArrayList<>(uploadJobsListParam.size());
            uploadJobsListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<UploadJobItem> copyFromBuilder(Collection<? extends UploadJobItem.Builder> uploadJobsListParam) {
        List<UploadJobItem> list;
        if (uploadJobsListParam == null || uploadJobsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<UploadJobItem> modifiableList = new ArrayList<>(uploadJobsListParam.size());
            uploadJobsListParam.forEach(entry -> {
                UploadJobItem member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<UploadJobItem.Builder> copyToBuilder(Collection<? extends UploadJobItem> uploadJobsListParam) {
        List<UploadJobItem.Builder> list;
        if (uploadJobsListParam == null || uploadJobsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<UploadJobItem.Builder> modifiableList = new ArrayList<>(uploadJobsListParam.size());
            uploadJobsListParam.forEach(entry -> {
                UploadJobItem.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
