/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Structure to hold workflow attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkflowAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkflowAttributes.Builder, WorkflowAttributes> {
    private static final SdkField<AppflowIntegrationWorkflowAttributes> APPFLOW_INTEGRATION_FIELD = SdkField
            .<AppflowIntegrationWorkflowAttributes> builder(MarshallingType.SDK_POJO).memberName("AppflowIntegration")
            .getter(getter(WorkflowAttributes::appflowIntegration)).setter(setter(Builder::appflowIntegration))
            .constructor(AppflowIntegrationWorkflowAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppflowIntegration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPFLOW_INTEGRATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AppflowIntegrationWorkflowAttributes appflowIntegration;

    private WorkflowAttributes(BuilderImpl builder) {
        this.appflowIntegration = builder.appflowIntegration;
    }

    /**
     * <p>
     * Workflow attributes specific to <code>APPFLOW_INTEGRATION</code> workflow.
     * </p>
     * 
     * @return Workflow attributes specific to <code>APPFLOW_INTEGRATION</code> workflow.
     */
    public final AppflowIntegrationWorkflowAttributes appflowIntegration() {
        return appflowIntegration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appflowIntegration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowAttributes)) {
            return false;
        }
        WorkflowAttributes other = (WorkflowAttributes) obj;
        return Objects.equals(appflowIntegration(), other.appflowIntegration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkflowAttributes").add("AppflowIntegration", appflowIntegration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppflowIntegration":
            return Optional.ofNullable(clazz.cast(appflowIntegration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AppflowIntegration", APPFLOW_INTEGRATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkflowAttributes, T> g) {
        return obj -> g.apply((WorkflowAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkflowAttributes> {
        /**
         * <p>
         * Workflow attributes specific to <code>APPFLOW_INTEGRATION</code> workflow.
         * </p>
         * 
         * @param appflowIntegration
         *        Workflow attributes specific to <code>APPFLOW_INTEGRATION</code> workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appflowIntegration(AppflowIntegrationWorkflowAttributes appflowIntegration);

        /**
         * <p>
         * Workflow attributes specific to <code>APPFLOW_INTEGRATION</code> workflow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AppflowIntegrationWorkflowAttributes.Builder} avoiding the need to create one manually via
         * {@link AppflowIntegrationWorkflowAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AppflowIntegrationWorkflowAttributes.Builder#build()} is called
         * immediately and its result is passed to {@link #appflowIntegration(AppflowIntegrationWorkflowAttributes)}.
         * 
         * @param appflowIntegration
         *        a consumer that will call methods on {@link AppflowIntegrationWorkflowAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appflowIntegration(AppflowIntegrationWorkflowAttributes)
         */
        default Builder appflowIntegration(Consumer<AppflowIntegrationWorkflowAttributes.Builder> appflowIntegration) {
            return appflowIntegration(AppflowIntegrationWorkflowAttributes.builder().applyMutation(appflowIntegration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AppflowIntegrationWorkflowAttributes appflowIntegration;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowAttributes model) {
            appflowIntegration(model.appflowIntegration);
        }

        public final AppflowIntegrationWorkflowAttributes.Builder getAppflowIntegration() {
            return appflowIntegration != null ? appflowIntegration.toBuilder() : null;
        }

        public final void setAppflowIntegration(AppflowIntegrationWorkflowAttributes.BuilderImpl appflowIntegration) {
            this.appflowIntegration = appflowIntegration != null ? appflowIntegration.build() : null;
        }

        @Override
        public final Builder appflowIntegration(AppflowIntegrationWorkflowAttributes appflowIntegration) {
            this.appflowIntegration = appflowIntegration;
            return this;
        }

        @Override
        public WorkflowAttributes build() {
            return new WorkflowAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
