/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class _foundByListCopier {
    static List<FoundByKeyValue> copy(Collection<? extends FoundByKeyValue> foundByListParam) {
        List<FoundByKeyValue> list;
        if (foundByListParam == null || foundByListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<FoundByKeyValue> modifiableList = new ArrayList<>(foundByListParam.size());
            foundByListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<FoundByKeyValue> copyFromBuilder(Collection<? extends FoundByKeyValue.Builder> foundByListParam) {
        List<FoundByKeyValue> list;
        if (foundByListParam == null || foundByListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<FoundByKeyValue> modifiableList = new ArrayList<>(foundByListParam.size());
            foundByListParam.forEach(entry -> {
                FoundByKeyValue member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<FoundByKeyValue.Builder> copyToBuilder(Collection<? extends FoundByKeyValue> foundByListParam) {
        List<FoundByKeyValue.Builder> list;
        if (foundByListParam == null || foundByListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<FoundByKeyValue.Builder> modifiableList = new ArrayList<>(foundByListParam.size());
            foundByListParam.forEach(entry -> {
                FoundByKeyValue.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
