/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.customerprofiles.model.ContactType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContactPreference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContactPreference> {
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyName").getter(ContactPreference.getter(ContactPreference::keyName)).setter(ContactPreference.setter(Builder::keyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").build()}).build();
    private static final SdkField<String> KEY_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyValue").getter(ContactPreference.getter(ContactPreference::keyValue)).setter(ContactPreference.setter(Builder::keyValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyValue").build()}).build();
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileId").getter(ContactPreference.getter(ContactPreference::profileId)).setter(ContactPreference.setter(Builder::profileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileId").build()}).build();
    private static final SdkField<String> CONTACT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactType").getter(ContactPreference.getter(ContactPreference::contactTypeAsString)).setter(ContactPreference.setter(Builder::contactType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_NAME_FIELD, KEY_VALUE_FIELD, PROFILE_ID_FIELD, CONTACT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContactPreference.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String keyName;
    private final String keyValue;
    private final String profileId;
    private final String contactType;

    private ContactPreference(BuilderImpl builder) {
        this.keyName = builder.keyName;
        this.keyValue = builder.keyValue;
        this.profileId = builder.profileId;
        this.contactType = builder.contactType;
    }

    public final String keyName() {
        return this.keyName;
    }

    public final String keyValue() {
        return this.keyValue;
    }

    public final String profileId() {
        return this.profileId;
    }

    public final ContactType contactType() {
        return ContactType.fromValue(this.contactType);
    }

    public final String contactTypeAsString() {
        return this.contactType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactPreference)) {
            return false;
        }
        ContactPreference other = (ContactPreference)obj;
        return Objects.equals(this.keyName(), other.keyName()) && Objects.equals(this.keyValue(), other.keyValue()) && Objects.equals(this.profileId(), other.profileId()) && Objects.equals(this.contactTypeAsString(), other.contactTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ContactPreference").add("KeyName", (Object)this.keyName()).add("KeyValue", (Object)this.keyValue()).add("ProfileId", (Object)this.profileId()).add("ContactType", (Object)this.contactTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyName": {
                return Optional.ofNullable(clazz.cast(this.keyName()));
            }
            case "KeyValue": {
                return Optional.ofNullable(clazz.cast(this.keyValue()));
            }
            case "ProfileId": {
                return Optional.ofNullable(clazz.cast(this.profileId()));
            }
            case "ContactType": {
                return Optional.ofNullable(clazz.cast(this.contactTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("KeyName", KEY_NAME_FIELD);
        map.put("KeyValue", KEY_VALUE_FIELD);
        map.put("ProfileId", PROFILE_ID_FIELD);
        map.put("ContactType", CONTACT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContactPreference, T> g) {
        return obj -> g.apply((ContactPreference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String keyName;
        private String keyValue;
        private String profileId;
        private String contactType;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactPreference model) {
            this.keyName(model.keyName);
            this.keyValue(model.keyValue);
            this.profileId(model.profileId);
            this.contactType(model.contactType);
        }

        public final String getKeyName() {
            return this.keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final String getKeyValue() {
            return this.keyValue;
        }

        public final void setKeyValue(String keyValue) {
            this.keyValue = keyValue;
        }

        @Override
        public final Builder keyValue(String keyValue) {
            this.keyValue = keyValue;
            return this;
        }

        public final String getProfileId() {
            return this.profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getContactType() {
            return this.contactType;
        }

        public final void setContactType(String contactType) {
            this.contactType = contactType;
        }

        @Override
        public final Builder contactType(String contactType) {
            this.contactType = contactType;
            return this;
        }

        @Override
        public final Builder contactType(ContactType contactType) {
            this.contactType(contactType == null ? null : contactType.toString());
            return this;
        }

        public ContactPreference build() {
            return new ContactPreference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContactPreference> {
        public Builder keyName(String var1);

        public Builder keyValue(String var1);

        public Builder profileId(String var1);

        public Builder contactType(String var1);

        public Builder contactType(ContactType var1);
    }
}

