/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.customerprofiles.model.ActionType;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProfileHistoryRecordsRequest
extends CustomerProfilesRequest
implements ToCopyableBuilder<Builder, ListProfileHistoryRecordsRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(ListProfileHistoryRecordsRequest.getter(ListProfileHistoryRecordsRequest::domainName)).setter(ListProfileHistoryRecordsRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()}).build();
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileId").getter(ListProfileHistoryRecordsRequest.getter(ListProfileHistoryRecordsRequest::profileId)).setter(ListProfileHistoryRecordsRequest.setter(Builder::profileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileId").build()}).build();
    private static final SdkField<String> OBJECT_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectTypeName").getter(ListProfileHistoryRecordsRequest.getter(ListProfileHistoryRecordsRequest::objectTypeName)).setter(ListProfileHistoryRecordsRequest.setter(Builder::objectTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectTypeName").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListProfileHistoryRecordsRequest.getter(ListProfileHistoryRecordsRequest::nextToken)).setter(ListProfileHistoryRecordsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next-token").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListProfileHistoryRecordsRequest.getter(ListProfileHistoryRecordsRequest::maxResults)).setter(ListProfileHistoryRecordsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("max-results").build()}).build();
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionType").getter(ListProfileHistoryRecordsRequest.getter(ListProfileHistoryRecordsRequest::actionTypeAsString)).setter(ListProfileHistoryRecordsRequest.setter(Builder::actionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActionType").build()}).build();
    private static final SdkField<String> PERFORMED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PerformedBy").getter(ListProfileHistoryRecordsRequest.getter(ListProfileHistoryRecordsRequest::performedBy)).setter(ListProfileHistoryRecordsRequest.setter(Builder::performedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, PROFILE_ID_FIELD, OBJECT_TYPE_NAME_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, ACTION_TYPE_FIELD, PERFORMED_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListProfileHistoryRecordsRequest.memberNameToFieldInitializer();
    private final String domainName;
    private final String profileId;
    private final String objectTypeName;
    private final String nextToken;
    private final Integer maxResults;
    private final String actionType;
    private final String performedBy;

    private ListProfileHistoryRecordsRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.profileId = builder.profileId;
        this.objectTypeName = builder.objectTypeName;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.actionType = builder.actionType;
        this.performedBy = builder.performedBy;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String profileId() {
        return this.profileId;
    }

    public final String objectTypeName() {
        return this.objectTypeName;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final ActionType actionType() {
        return ActionType.fromValue(this.actionType);
    }

    public final String actionTypeAsString() {
        return this.actionType;
    }

    public final String performedBy() {
        return this.performedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.performedBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProfileHistoryRecordsRequest)) {
            return false;
        }
        ListProfileHistoryRecordsRequest other = (ListProfileHistoryRecordsRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.profileId(), other.profileId()) && Objects.equals(this.objectTypeName(), other.objectTypeName()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.actionTypeAsString(), other.actionTypeAsString()) && Objects.equals(this.performedBy(), other.performedBy());
    }

    public final String toString() {
        return ToString.builder((String)"ListProfileHistoryRecordsRequest").add("DomainName", (Object)this.domainName()).add("ProfileId", (Object)this.profileId()).add("ObjectTypeName", (Object)this.objectTypeName()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("ActionType", (Object)this.actionTypeAsString()).add("PerformedBy", (Object)this.performedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "ProfileId": {
                return Optional.ofNullable(clazz.cast(this.profileId()));
            }
            case "ObjectTypeName": {
                return Optional.ofNullable(clazz.cast(this.objectTypeName()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "ActionType": {
                return Optional.ofNullable(clazz.cast(this.actionTypeAsString()));
            }
            case "PerformedBy": {
                return Optional.ofNullable(clazz.cast(this.performedBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("ProfileId", PROFILE_ID_FIELD);
        map.put("ObjectTypeName", OBJECT_TYPE_NAME_FIELD);
        map.put("next-token", NEXT_TOKEN_FIELD);
        map.put("max-results", MAX_RESULTS_FIELD);
        map.put("ActionType", ACTION_TYPE_FIELD);
        map.put("PerformedBy", PERFORMED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListProfileHistoryRecordsRequest, T> g) {
        return obj -> g.apply((ListProfileHistoryRecordsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String profileId;
        private String objectTypeName;
        private String nextToken;
        private Integer maxResults;
        private String actionType;
        private String performedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProfileHistoryRecordsRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.profileId(model.profileId);
            this.objectTypeName(model.objectTypeName);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.actionType(model.actionType);
            this.performedBy(model.performedBy);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getProfileId() {
            return this.profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getObjectTypeName() {
            return this.objectTypeName;
        }

        public final void setObjectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
        }

        @Override
        public final Builder objectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getActionType() {
            return this.actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(ActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final String getPerformedBy() {
            return this.performedBy;
        }

        public final void setPerformedBy(String performedBy) {
            this.performedBy = performedBy;
        }

        @Override
        public final Builder performedBy(String performedBy) {
            this.performedBy = performedBy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListProfileHistoryRecordsRequest build() {
            return new ListProfileHistoryRecordsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CustomerProfilesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProfileHistoryRecordsRequest> {
        public Builder domainName(String var1);

        public Builder profileId(String var1);

        public Builder objectTypeName(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder actionType(String var1);

        public Builder actionType(ActionType var1);

        public Builder performedBy(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

