/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.customerprofiles.CustomerProfilesAsyncClient;
import software.amazon.awssdk.services.customerprofiles.internal.UserAgentUtils;
import software.amazon.awssdk.services.customerprofiles.model.GetSimilarProfilesRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetSimilarProfilesResponse;

public class GetSimilarProfilesPublisher
implements SdkPublisher<GetSimilarProfilesResponse> {
    private final CustomerProfilesAsyncClient client;
    private final GetSimilarProfilesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetSimilarProfilesPublisher(CustomerProfilesAsyncClient client, GetSimilarProfilesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetSimilarProfilesPublisher(CustomerProfilesAsyncClient client, GetSimilarProfilesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetSimilarProfilesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetSimilarProfilesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> profileIds() {
        Function<GetSimilarProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.profileIds() != null) {
                return response.profileIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetSimilarProfilesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetSimilarProfilesResponseFetcher
    implements AsyncPageFetcher<GetSimilarProfilesResponse> {
        private GetSimilarProfilesResponseFetcher() {
        }

        public boolean hasNextPage(GetSimilarProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetSimilarProfilesResponse> nextPage(GetSimilarProfilesResponse previousPage) {
            if (previousPage == null) {
                return GetSimilarProfilesPublisher.this.client.getSimilarProfiles(GetSimilarProfilesPublisher.this.firstRequest);
            }
            return GetSimilarProfilesPublisher.this.client.getSimilarProfiles((GetSimilarProfilesRequest)((Object)GetSimilarProfilesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

