/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReloadTablesRequest extends DatabaseMigrationRequest implements
        ToCopyableBuilder<ReloadTablesRequest.Builder, ReloadTablesRequest> {
    private static final SdkField<String> REPLICATION_TASK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationTaskArn").getter(getter(ReloadTablesRequest::replicationTaskArn))
            .setter(setter(Builder::replicationTaskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskArn").build())
            .build();

    private static final SdkField<List<TableToReload>> TABLES_TO_RELOAD_FIELD = SdkField
            .<List<TableToReload>> builder(MarshallingType.LIST)
            .memberName("TablesToReload")
            .getter(getter(ReloadTablesRequest::tablesToReload))
            .setter(setter(Builder::tablesToReload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablesToReload").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TableToReload> builder(MarshallingType.SDK_POJO)
                                            .constructor(TableToReload::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RELOAD_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReloadOption").getter(getter(ReloadTablesRequest::reloadOptionAsString))
            .setter(setter(Builder::reloadOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReloadOption").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_TASK_ARN_FIELD,
            TABLES_TO_RELOAD_FIELD, RELOAD_OPTION_FIELD));

    private final String replicationTaskArn;

    private final List<TableToReload> tablesToReload;

    private final String reloadOption;

    private ReloadTablesRequest(BuilderImpl builder) {
        super(builder);
        this.replicationTaskArn = builder.replicationTaskArn;
        this.tablesToReload = builder.tablesToReload;
        this.reloadOption = builder.reloadOption;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the replication task.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the replication task.
     */
    public final String replicationTaskArn() {
        return replicationTaskArn;
    }

    /**
     * Returns true if the TablesToReload property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTablesToReload() {
        return tablesToReload != null && !(tablesToReload instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name and schema of the table to be reloaded.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTablesToReload()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The name and schema of the table to be reloaded.
     */
    public final List<TableToReload> tablesToReload() {
        return tablesToReload;
    }

    /**
     * <p>
     * Options for reload. Specify <code>data-reload</code> to reload the data and re-validate it if validation is
     * enabled. Specify <code>validate-only</code> to re-validate the table. This option applies only when validation is
     * enabled for the task.
     * </p>
     * <p>
     * Valid values: data-reload, validate-only
     * </p>
     * <p>
     * Default value is data-reload.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reloadOption} will
     * return {@link ReloadOptionValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reloadOptionAsString}.
     * </p>
     * 
     * @return Options for reload. Specify <code>data-reload</code> to reload the data and re-validate it if validation
     *         is enabled. Specify <code>validate-only</code> to re-validate the table. This option applies only when
     *         validation is enabled for the task. </p>
     *         <p>
     *         Valid values: data-reload, validate-only
     *         </p>
     *         <p>
     *         Default value is data-reload.
     * @see ReloadOptionValue
     */
    public final ReloadOptionValue reloadOption() {
        return ReloadOptionValue.fromValue(reloadOption);
    }

    /**
     * <p>
     * Options for reload. Specify <code>data-reload</code> to reload the data and re-validate it if validation is
     * enabled. Specify <code>validate-only</code> to re-validate the table. This option applies only when validation is
     * enabled for the task.
     * </p>
     * <p>
     * Valid values: data-reload, validate-only
     * </p>
     * <p>
     * Default value is data-reload.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reloadOption} will
     * return {@link ReloadOptionValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reloadOptionAsString}.
     * </p>
     * 
     * @return Options for reload. Specify <code>data-reload</code> to reload the data and re-validate it if validation
     *         is enabled. Specify <code>validate-only</code> to re-validate the table. This option applies only when
     *         validation is enabled for the task. </p>
     *         <p>
     *         Valid values: data-reload, validate-only
     *         </p>
     *         <p>
     *         Default value is data-reload.
     * @see ReloadOptionValue
     */
    public final String reloadOptionAsString() {
        return reloadOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationTaskArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTablesToReload() ? tablesToReload() : null);
        hashCode = 31 * hashCode + Objects.hashCode(reloadOptionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReloadTablesRequest)) {
            return false;
        }
        ReloadTablesRequest other = (ReloadTablesRequest) obj;
        return Objects.equals(replicationTaskArn(), other.replicationTaskArn())
                && hasTablesToReload() == other.hasTablesToReload() && Objects.equals(tablesToReload(), other.tablesToReload())
                && Objects.equals(reloadOptionAsString(), other.reloadOptionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReloadTablesRequest").add("ReplicationTaskArn", replicationTaskArn())
                .add("TablesToReload", hasTablesToReload() ? tablesToReload() : null).add("ReloadOption", reloadOptionAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationTaskArn":
            return Optional.ofNullable(clazz.cast(replicationTaskArn()));
        case "TablesToReload":
            return Optional.ofNullable(clazz.cast(tablesToReload()));
        case "ReloadOption":
            return Optional.ofNullable(clazz.cast(reloadOptionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReloadTablesRequest, T> g) {
        return obj -> g.apply((ReloadTablesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationRequest.Builder, SdkPojo, CopyableBuilder<Builder, ReloadTablesRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the replication task.
         * </p>
         * 
         * @param replicationTaskArn
         *        The Amazon Resource Name (ARN) of the replication task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskArn(String replicationTaskArn);

        /**
         * <p>
         * The name and schema of the table to be reloaded.
         * </p>
         * 
         * @param tablesToReload
         *        The name and schema of the table to be reloaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tablesToReload(Collection<TableToReload> tablesToReload);

        /**
         * <p>
         * The name and schema of the table to be reloaded.
         * </p>
         * 
         * @param tablesToReload
         *        The name and schema of the table to be reloaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tablesToReload(TableToReload... tablesToReload);

        /**
         * <p>
         * The name and schema of the table to be reloaded.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TableToReload>.Builder} avoiding the need
         * to create one manually via {@link List<TableToReload>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TableToReload>.Builder#build()} is called immediately and
         * its result is passed to {@link #tablesToReload(List<TableToReload>)}.
         * 
         * @param tablesToReload
         *        a consumer that will call methods on {@link List<TableToReload>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tablesToReload(List<TableToReload>)
         */
        Builder tablesToReload(Consumer<TableToReload.Builder>... tablesToReload);

        /**
         * <p>
         * Options for reload. Specify <code>data-reload</code> to reload the data and re-validate it if validation is
         * enabled. Specify <code>validate-only</code> to re-validate the table. This option applies only when
         * validation is enabled for the task.
         * </p>
         * <p>
         * Valid values: data-reload, validate-only
         * </p>
         * <p>
         * Default value is data-reload.
         * </p>
         * 
         * @param reloadOption
         *        Options for reload. Specify <code>data-reload</code> to reload the data and re-validate it if
         *        validation is enabled. Specify <code>validate-only</code> to re-validate the table. This option
         *        applies only when validation is enabled for the task. </p>
         *        <p>
         *        Valid values: data-reload, validate-only
         *        </p>
         *        <p>
         *        Default value is data-reload.
         * @see ReloadOptionValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReloadOptionValue
         */
        Builder reloadOption(String reloadOption);

        /**
         * <p>
         * Options for reload. Specify <code>data-reload</code> to reload the data and re-validate it if validation is
         * enabled. Specify <code>validate-only</code> to re-validate the table. This option applies only when
         * validation is enabled for the task.
         * </p>
         * <p>
         * Valid values: data-reload, validate-only
         * </p>
         * <p>
         * Default value is data-reload.
         * </p>
         * 
         * @param reloadOption
         *        Options for reload. Specify <code>data-reload</code> to reload the data and re-validate it if
         *        validation is enabled. Specify <code>validate-only</code> to re-validate the table. This option
         *        applies only when validation is enabled for the task. </p>
         *        <p>
         *        Valid values: data-reload, validate-only
         *        </p>
         *        <p>
         *        Default value is data-reload.
         * @see ReloadOptionValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReloadOptionValue
         */
        Builder reloadOption(ReloadOptionValue reloadOption);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DatabaseMigrationRequest.BuilderImpl implements Builder {
        private String replicationTaskArn;

        private List<TableToReload> tablesToReload = DefaultSdkAutoConstructList.getInstance();

        private String reloadOption;

        private BuilderImpl() {
        }

        private BuilderImpl(ReloadTablesRequest model) {
            super(model);
            replicationTaskArn(model.replicationTaskArn);
            tablesToReload(model.tablesToReload);
            reloadOption(model.reloadOption);
        }

        public final String getReplicationTaskArn() {
            return replicationTaskArn;
        }

        @Override
        public final Builder replicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
            return this;
        }

        public final void setReplicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
        }

        public final List<TableToReload.Builder> getTablesToReload() {
            List<TableToReload.Builder> result = TableListToReloadCopier.copyToBuilder(this.tablesToReload);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tablesToReload(Collection<TableToReload> tablesToReload) {
            this.tablesToReload = TableListToReloadCopier.copy(tablesToReload);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tablesToReload(TableToReload... tablesToReload) {
            tablesToReload(Arrays.asList(tablesToReload));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tablesToReload(Consumer<TableToReload.Builder>... tablesToReload) {
            tablesToReload(Stream.of(tablesToReload).map(c -> TableToReload.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTablesToReload(Collection<TableToReload.BuilderImpl> tablesToReload) {
            this.tablesToReload = TableListToReloadCopier.copyFromBuilder(tablesToReload);
        }

        public final String getReloadOption() {
            return reloadOption;
        }

        @Override
        public final Builder reloadOption(String reloadOption) {
            this.reloadOption = reloadOption;
            return this;
        }

        @Override
        public final Builder reloadOption(ReloadOptionValue reloadOption) {
            this.reloadOption(reloadOption == null ? null : reloadOption.toString());
            return this;
        }

        public final void setReloadOption(String reloadOption) {
            this.reloadOption = reloadOption;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ReloadTablesRequest build() {
            return new ReloadTablesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
