/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.databasemigration.model.AccessDeniedException;
import software.amazon.awssdk.services.databasemigration.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.databasemigration.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.databasemigration.model.ApplyPendingMaintenanceActionRequest;
import software.amazon.awssdk.services.databasemigration.model.ApplyPendingMaintenanceActionResponse;
import software.amazon.awssdk.services.databasemigration.model.CancelReplicationTaskAssessmentRunRequest;
import software.amazon.awssdk.services.databasemigration.model.CancelReplicationTaskAssessmentRunResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateEndpointRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateEndpointResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateEventSubscriptionRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateEventSubscriptionResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationInstanceRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationInstanceResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationSubnetGroupRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationSubnetGroupResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationException;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteCertificateRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteCertificateResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteConnectionRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteConnectionResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteEventSubscriptionRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteEventSubscriptionResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationInstanceRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationInstanceResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationSubnetGroupRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationSubnetGroupResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskAssessmentRunRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskAssessmentRunResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventCategoriesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventCategoriesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeRefreshSchemasStatusRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeRefreshSchemasStatusResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeSchemasRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeSchemasResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsResponse;
import software.amazon.awssdk.services.databasemigration.model.ImportCertificateRequest;
import software.amazon.awssdk.services.databasemigration.model.ImportCertificateResponse;
import software.amazon.awssdk.services.databasemigration.model.InsufficientResourceCapacityException;
import software.amazon.awssdk.services.databasemigration.model.InvalidCertificateException;
import software.amazon.awssdk.services.databasemigration.model.InvalidResourceStateException;
import software.amazon.awssdk.services.databasemigration.model.InvalidSubnetException;
import software.amazon.awssdk.services.databasemigration.model.KmsAccessDeniedException;
import software.amazon.awssdk.services.databasemigration.model.KmsDisabledException;
import software.amazon.awssdk.services.databasemigration.model.KmsException;
import software.amazon.awssdk.services.databasemigration.model.KmsInvalidStateException;
import software.amazon.awssdk.services.databasemigration.model.KmsKeyNotAccessibleException;
import software.amazon.awssdk.services.databasemigration.model.KmsNotFoundException;
import software.amazon.awssdk.services.databasemigration.model.KmsThrottlingException;
import software.amazon.awssdk.services.databasemigration.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.databasemigration.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyEndpointRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyEndpointResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyEventSubscriptionRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyEventSubscriptionResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationInstanceRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationInstanceResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationSubnetGroupRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationSubnetGroupResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.MoveReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.MoveReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.RebootReplicationInstanceRequest;
import software.amazon.awssdk.services.databasemigration.model.RebootReplicationInstanceResponse;
import software.amazon.awssdk.services.databasemigration.model.RefreshSchemasRequest;
import software.amazon.awssdk.services.databasemigration.model.RefreshSchemasResponse;
import software.amazon.awssdk.services.databasemigration.model.ReloadTablesRequest;
import software.amazon.awssdk.services.databasemigration.model.ReloadTablesResponse;
import software.amazon.awssdk.services.databasemigration.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.databasemigration.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.databasemigration.model.ReplicationSubnetGroupDoesNotCoverEnoughAZsException;
import software.amazon.awssdk.services.databasemigration.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.databasemigration.model.ResourceNotFoundException;
import software.amazon.awssdk.services.databasemigration.model.ResourceQuotaExceededException;
import software.amazon.awssdk.services.databasemigration.model.S3AccessDeniedException;
import software.amazon.awssdk.services.databasemigration.model.S3ResourceNotFoundException;
import software.amazon.awssdk.services.databasemigration.model.SnsInvalidTopicException;
import software.amazon.awssdk.services.databasemigration.model.SnsNoAuthorizationException;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentRequest;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentResponse;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentRunRequest;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentRunResponse;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.StopReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.StopReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.StorageQuotaExceededException;
import software.amazon.awssdk.services.databasemigration.model.SubnetAlreadyInUseException;
import software.amazon.awssdk.services.databasemigration.model.TestConnectionRequest;
import software.amazon.awssdk.services.databasemigration.model.TestConnectionResponse;
import software.amazon.awssdk.services.databasemigration.model.UpgradeDependencyFailureException;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeApplicableIndividualAssessmentsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeCertificatesIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeConnectionsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointSettingsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointTypesIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeEventSubscriptionsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeEventsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeOrderableReplicationInstancesIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribePendingMaintenanceActionsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstanceTaskLogsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstancesIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationSubnetGroupsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentResultsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentRunsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskIndividualAssessmentsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTasksIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeSchemasIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeTableStatisticsIterable;
import software.amazon.awssdk.services.databasemigration.transform.AddTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ApplyPendingMaintenanceActionRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CancelReplicationTaskAssessmentRunRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CreateEndpointRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CreateEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CreateReplicationInstanceRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CreateReplicationSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.CreateReplicationTaskRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteCertificateRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteConnectionRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteEndpointRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteReplicationInstanceRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteReplicationSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteReplicationTaskAssessmentRunRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DeleteReplicationTaskRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeAccountAttributesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeApplicableIndividualAssessmentsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeCertificatesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeConnectionsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeEndpointSettingsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeEndpointTypesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeEndpointsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeEventCategoriesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeEventSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeEventsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeOrderableReplicationInstancesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribePendingMaintenanceActionsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeRefreshSchemasStatusRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeReplicationInstanceTaskLogsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeReplicationInstancesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeReplicationSubnetGroupsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeReplicationTaskAssessmentResultsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeReplicationTaskAssessmentRunsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeReplicationTaskIndividualAssessmentsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeReplicationTasksRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeSchemasRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.DescribeTableStatisticsRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ImportCertificateRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ModifyEndpointRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ModifyEventSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ModifyReplicationInstanceRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ModifyReplicationSubnetGroupRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ModifyReplicationTaskRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.MoveReplicationTaskRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.RebootReplicationInstanceRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.RefreshSchemasRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.ReloadTablesRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.RemoveTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StartReplicationTaskAssessmentRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StartReplicationTaskAssessmentRunRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StartReplicationTaskRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.StopReplicationTaskRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.transform.TestConnectionRequestMarshaller;
import software.amazon.awssdk.services.databasemigration.waiters.DatabaseMigrationWaiter;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link DatabaseMigrationClient}.
 *
 * @see DatabaseMigrationClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultDatabaseMigrationClient implements DatabaseMigrationClient {
    private static final Logger log = Logger.loggerFor(DefaultDatabaseMigrationClient.class);

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultDatabaseMigrationClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Adds metadata tags to an DMS resource, including replication instance, endpoint, security group, and migration
     * task. These tags can also be used with cost allocation reporting to track cost associated with DMS resources, or
     * used in a Condition statement in an IAM policy for DMS. For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html"> <code>Tag</code> </a> data type
     * description.
     * </p>
     *
     * @param addTagsToResourceRequest
     *        Associates a set of tags with an DMS resource.
     * @return Result of the AddTagsToResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AddTagsToResourceResponse addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AddTagsToResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AddTagsToResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addTagsToResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddTagsToResource");

            return clientHandler.execute(new ClientExecutionParams<AddTagsToResourceRequest, AddTagsToResourceResponse>()
                    .withOperationName("AddTagsToResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(addTagsToResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AddTagsToResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Applies a pending maintenance action to a resource (for example, to a replication instance).
     * </p>
     *
     * @param applyPendingMaintenanceActionRequest
     * @return Result of the ApplyPendingMaintenanceAction operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ApplyPendingMaintenanceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ApplyPendingMaintenanceAction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ApplyPendingMaintenanceActionResponse applyPendingMaintenanceAction(
            ApplyPendingMaintenanceActionRequest applyPendingMaintenanceActionRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ApplyPendingMaintenanceActionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ApplyPendingMaintenanceActionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                applyPendingMaintenanceActionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ApplyPendingMaintenanceAction");

            return clientHandler
                    .execute(new ClientExecutionParams<ApplyPendingMaintenanceActionRequest, ApplyPendingMaintenanceActionResponse>()
                            .withOperationName("ApplyPendingMaintenanceAction").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(applyPendingMaintenanceActionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ApplyPendingMaintenanceActionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels a single premigration assessment run.
     * </p>
     * <p>
     * This operation prevents any individual assessments from running if they haven't started running. It also attempts
     * to cancel any individual assessments that are currently running.
     * </p>
     *
     * @param cancelReplicationTaskAssessmentRunRequest
     * @return Result of the CancelReplicationTaskAssessmentRun operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CancelReplicationTaskAssessmentRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CancelReplicationTaskAssessmentRun"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CancelReplicationTaskAssessmentRunResponse cancelReplicationTaskAssessmentRun(
            CancelReplicationTaskAssessmentRunRequest cancelReplicationTaskAssessmentRunRequest) throws AccessDeniedException,
            ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelReplicationTaskAssessmentRunResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CancelReplicationTaskAssessmentRunResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                cancelReplicationTaskAssessmentRunRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelReplicationTaskAssessmentRun");

            return clientHandler
                    .execute(new ClientExecutionParams<CancelReplicationTaskAssessmentRunRequest, CancelReplicationTaskAssessmentRunResponse>()
                            .withOperationName("CancelReplicationTaskAssessmentRun").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(cancelReplicationTaskAssessmentRunRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CancelReplicationTaskAssessmentRunRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an endpoint using the provided settings.
     * </p>
     * <note>
     * <p>
     * For a MySQL source or target endpoint, don't explicitly specify the database using the <code>DatabaseName</code>
     * request parameter on the <code>CreateEndpoint</code> API call. Specifying <code>DatabaseName</code> when you
     * create a MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify
     * the database only when you specify the schema in the table-mapping rules of the DMS task.
     * </p>
     * </note>
     *
     * @param createEndpointRequest
     * @return Result of the CreateEndpoint operation returned by the service.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws S3AccessDeniedException
     *         Insufficient privileges are preventing access to an Amazon S3 object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateEndpointResponse createEndpoint(CreateEndpointRequest createEndpointRequest)
            throws KmsKeyNotAccessibleException, ResourceAlreadyExistsException, ResourceQuotaExceededException,
            InvalidResourceStateException, ResourceNotFoundException, AccessDeniedException, S3AccessDeniedException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateEndpointResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEndpoint");

            return clientHandler.execute(new ClientExecutionParams<CreateEndpointRequest, CreateEndpointResponse>()
                    .withOperationName("CreateEndpoint").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createEndpointRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an DMS event notification subscription.
     * </p>
     * <p>
     * You can specify the type of source (<code>SourceType</code>) you want to be notified of, provide a list of DMS
     * source IDs (<code>SourceIds</code>) that triggers the events, and provide a list of event categories (
     * <code>EventCategories</code>) for events you want to be notified of. If you specify both the
     * <code>SourceType</code> and <code>SourceIds</code>, such as <code>SourceType = replication-instance</code> and
     * <code>SourceIdentifier = my-replinstance</code>, you will be notified of all the replication instance events for
     * the specified source. If you specify a <code>SourceType</code> but don't specify a <code>SourceIdentifier</code>,
     * you receive notice of the events for that source type for all your DMS sources. If you don't specify either
     * <code>SourceType</code> nor <code>SourceIdentifier</code>, you will be notified of events generated from all DMS
     * sources belonging to your customer account.
     * </p>
     * <p>
     * For more information about DMS events, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     *
     * @param createEventSubscriptionRequest
     * @return Result of the CreateEventSubscription operation returned by the service.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws SnsInvalidTopicException
     *         The SNS topic is invalid.
     * @throws SnsNoAuthorizationException
     *         You are not authorized for the SNS subscription.
     * @throws KmsAccessDeniedException
     *         The ciphertext references a key that doesn't exist or that the DMS account doesn't have access to.
     * @throws KmsDisabledException
     *         The specified master key (CMK) isn't enabled.
     * @throws KmsInvalidStateException
     *         The state of the specified KMS resource isn't valid for this request.
     * @throws KmsNotFoundException
     *         The specified KMS entity or resource can't be found.
     * @throws KmsThrottlingException
     *         This request triggered KMS request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateEventSubscriptionResponse createEventSubscription(CreateEventSubscriptionRequest createEventSubscriptionRequest)
            throws ResourceQuotaExceededException, ResourceNotFoundException, ResourceAlreadyExistsException,
            SnsInvalidTopicException, SnsNoAuthorizationException, KmsAccessDeniedException, KmsDisabledException,
            KmsInvalidStateException, KmsNotFoundException, KmsThrottlingException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateEventSubscriptionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateEventSubscriptionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEventSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEventSubscription");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateEventSubscriptionRequest, CreateEventSubscriptionResponse>()
                            .withOperationName("CreateEventSubscription").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createEventSubscriptionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateEventSubscriptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates the replication instance using the specified parameters.
     * </p>
     * <p>
     * DMS requires that your account have certain roles with appropriate permissions before you can create a
     * replication instance. For information on the required roles, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.APIRole">Creating the IAM
     * Roles to Use With the CLI and DMS API</a>. For information on the required permissions, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.IAMPermissions">IAM
     * Permissions Needed to Use DMS</a>.
     * </p>
     *
     * @param createReplicationInstanceRequest
     * @return Result of the CreateReplicationInstance operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws InsufficientResourceCapacityException
     *         There are not enough resources allocated to the database migration.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws StorageQuotaExceededException
     *         The storage quota has been exceeded.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ReplicationSubnetGroupDoesNotCoverEnoughAZsException
     *         The replication subnet group does not cover enough Availability Zones (AZs). Edit the replication subnet
     *         group and add more AZs.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws InvalidSubnetException
     *         The subnet provided is invalid.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateReplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationInstance" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateReplicationInstanceResponse createReplicationInstance(
            CreateReplicationInstanceRequest createReplicationInstanceRequest) throws AccessDeniedException,
            ResourceAlreadyExistsException, InsufficientResourceCapacityException, ResourceQuotaExceededException,
            StorageQuotaExceededException, ResourceNotFoundException, ReplicationSubnetGroupDoesNotCoverEnoughAZsException,
            InvalidResourceStateException, InvalidSubnetException, KmsKeyNotAccessibleException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateReplicationInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateReplicationInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createReplicationInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateReplicationInstance");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateReplicationInstanceRequest, CreateReplicationInstanceResponse>()
                            .withOperationName("CreateReplicationInstance").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createReplicationInstanceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateReplicationInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a replication subnet group given a list of the subnet IDs in a VPC.
     * </p>
     *
     * @param createReplicationSubnetGroupRequest
     * @return Result of the CreateReplicationSubnetGroup operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws ReplicationSubnetGroupDoesNotCoverEnoughAZsException
     *         The replication subnet group does not cover enough Availability Zones (AZs). Edit the replication subnet
     *         group and add more AZs.
     * @throws InvalidSubnetException
     *         The subnet provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateReplicationSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateReplicationSubnetGroupResponse createReplicationSubnetGroup(
            CreateReplicationSubnetGroupRequest createReplicationSubnetGroupRequest) throws AccessDeniedException,
            ResourceAlreadyExistsException, ResourceNotFoundException, ResourceQuotaExceededException,
            ReplicationSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateReplicationSubnetGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateReplicationSubnetGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createReplicationSubnetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateReplicationSubnetGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateReplicationSubnetGroupRequest, CreateReplicationSubnetGroupResponse>()
                            .withOperationName("CreateReplicationSubnetGroup").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createReplicationSubnetGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateReplicationSubnetGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a replication task using the specified parameters.
     * </p>
     *
     * @param createReplicationTaskRequest
     * @return Result of the CreateReplicationTask operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateReplicationTaskResponse createReplicationTask(CreateReplicationTaskRequest createReplicationTaskRequest)
            throws AccessDeniedException, InvalidResourceStateException, ResourceAlreadyExistsException,
            ResourceNotFoundException, KmsKeyNotAccessibleException, ResourceQuotaExceededException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateReplicationTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateReplicationTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createReplicationTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateReplicationTask");

            return clientHandler.execute(new ClientExecutionParams<CreateReplicationTaskRequest, CreateReplicationTaskResponse>()
                    .withOperationName("CreateReplicationTask").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createReplicationTaskRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateReplicationTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified certificate.
     * </p>
     *
     * @param deleteCertificateRequest
     * @return Result of the DeleteCertificate operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteCertificateResponse deleteCertificate(DeleteCertificateRequest deleteCertificateRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCertificateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteCertificateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCertificate");

            return clientHandler.execute(new ClientExecutionParams<DeleteCertificateRequest, DeleteCertificateResponse>()
                    .withOperationName("DeleteCertificate").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteCertificateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteCertificateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the connection between a replication instance and an endpoint.
     * </p>
     *
     * @param deleteConnectionRequest
     * @return Result of the DeleteConnection operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteConnection" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteConnectionResponse deleteConnection(DeleteConnectionRequest deleteConnectionRequest)
            throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteConnectionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteConnectionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConnection");

            return clientHandler.execute(new ClientExecutionParams<DeleteConnectionRequest, DeleteConnectionResponse>()
                    .withOperationName("DeleteConnection").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteConnectionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteConnectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified endpoint.
     * </p>
     * <note>
     * <p>
     * All tasks associated with the endpoint must be deleted before you can delete the endpoint.
     * </p>
     * </note>
     * <p/>
     *
     * @param deleteEndpointRequest
     * @return Result of the DeleteEndpoint operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteEndpointResponse deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) throws ResourceNotFoundException,
            InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteEndpointResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEndpoint");

            return clientHandler.execute(new ClientExecutionParams<DeleteEndpointRequest, DeleteEndpointResponse>()
                    .withOperationName("DeleteEndpoint").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteEndpointRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an DMS event subscription.
     * </p>
     *
     * @param deleteEventSubscriptionRequest
     * @return Result of the DeleteEventSubscription operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteEventSubscriptionResponse deleteEventSubscription(DeleteEventSubscriptionRequest deleteEventSubscriptionRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteEventSubscriptionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteEventSubscriptionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEventSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEventSubscription");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteEventSubscriptionRequest, DeleteEventSubscriptionResponse>()
                            .withOperationName("DeleteEventSubscription").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteEventSubscriptionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteEventSubscriptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified replication instance.
     * </p>
     * <note>
     * <p>
     * You must delete any migration tasks that are associated with the replication instance before you can delete it.
     * </p>
     * </note>
     * <p/>
     *
     * @param deleteReplicationInstanceRequest
     * @return Result of the DeleteReplicationInstance operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteReplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationInstance" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteReplicationInstanceResponse deleteReplicationInstance(
            DeleteReplicationInstanceRequest deleteReplicationInstanceRequest) throws InvalidResourceStateException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteReplicationInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteReplicationInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteReplicationInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteReplicationInstance");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteReplicationInstanceRequest, DeleteReplicationInstanceResponse>()
                            .withOperationName("DeleteReplicationInstance").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteReplicationInstanceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteReplicationInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a subnet group.
     * </p>
     *
     * @param deleteReplicationSubnetGroupRequest
     * @return Result of the DeleteReplicationSubnetGroup operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteReplicationSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteReplicationSubnetGroupResponse deleteReplicationSubnetGroup(
            DeleteReplicationSubnetGroupRequest deleteReplicationSubnetGroupRequest) throws InvalidResourceStateException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteReplicationSubnetGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteReplicationSubnetGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteReplicationSubnetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteReplicationSubnetGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteReplicationSubnetGroupRequest, DeleteReplicationSubnetGroupResponse>()
                            .withOperationName("DeleteReplicationSubnetGroup").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteReplicationSubnetGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteReplicationSubnetGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified replication task.
     * </p>
     *
     * @param deleteReplicationTaskRequest
     * @return Result of the DeleteReplicationTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteReplicationTaskResponse deleteReplicationTask(DeleteReplicationTaskRequest deleteReplicationTaskRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteReplicationTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteReplicationTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteReplicationTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteReplicationTask");

            return clientHandler.execute(new ClientExecutionParams<DeleteReplicationTaskRequest, DeleteReplicationTaskResponse>()
                    .withOperationName("DeleteReplicationTask").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteReplicationTaskRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteReplicationTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the record of a single premigration assessment run.
     * </p>
     * <p>
     * This operation removes all metadata that DMS maintains about this assessment run. However, the operation leaves
     * untouched all information about this assessment run that is stored in your Amazon S3 bucket.
     * </p>
     *
     * @param deleteReplicationTaskAssessmentRunRequest
     * @return Result of the DeleteReplicationTaskAssessmentRun operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteReplicationTaskAssessmentRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationTaskAssessmentRun"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteReplicationTaskAssessmentRunResponse deleteReplicationTaskAssessmentRun(
            DeleteReplicationTaskAssessmentRunRequest deleteReplicationTaskAssessmentRunRequest) throws AccessDeniedException,
            ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteReplicationTaskAssessmentRunResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteReplicationTaskAssessmentRunResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteReplicationTaskAssessmentRunRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteReplicationTaskAssessmentRun");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteReplicationTaskAssessmentRunRequest, DeleteReplicationTaskAssessmentRunResponse>()
                            .withOperationName("DeleteReplicationTaskAssessmentRun").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteReplicationTaskAssessmentRunRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteReplicationTaskAssessmentRunRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all of the DMS attributes for a customer account. These attributes include DMS quotas for the account and a
     * unique account identifier in a particular DMS region. DMS quotas include a list of resource quotas supported by
     * the account, such as the number of replication instances allowed. The description for each resource quota,
     * includes the quota name, current usage toward that quota, and the quota's maximum value. DMS uses the unique
     * account identifier to name each artifact used by DMS in the given region.
     * </p>
     * <p>
     * This command does not take any parameters.
     * </p>
     *
     * @param describeAccountAttributesRequest
     * @return Result of the DescribeAccountAttributes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeAccountAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeAccountAttributesResponse describeAccountAttributes(
            DescribeAccountAttributesRequest describeAccountAttributesRequest) throws AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAccountAttributesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAccountAttributesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAccountAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountAttributes");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountAttributesRequest, DescribeAccountAttributesResponse>()
                            .withOperationName("DescribeAccountAttributes").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeAccountAttributesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAccountAttributesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides a list of individual assessments that you can specify for a new premigration assessment run, given one
     * or more parameters.
     * </p>
     * <p>
     * If you specify an existing migration task, this operation provides the default individual assessments you can
     * specify for that task. Otherwise, the specified parameters model elements of a possible migration task on which
     * to base a premigration assessment run.
     * </p>
     * <p>
     * To use these migration task modeling parameters, you must specify an existing replication instance, a source
     * database engine, a target database engine, and a migration type. This combination of parameters potentially
     * limits the default individual assessments available for an assessment run created for a corresponding migration
     * task.
     * </p>
     * <p>
     * If you specify no parameters, this operation provides a list of all possible individual assessments that you can
     * specify for an assessment run. If you specify any one of the task modeling parameters, you must specify all of
     * them or the operation cannot provide a list of individual assessments. The only parameter that you can specify
     * alone is for an existing migration task. The specified task definition then determines the default list of
     * individual assessments that you can specify in an assessment run for the task.
     * </p>
     *
     * @param describeApplicableIndividualAssessmentsRequest
     * @return Result of the DescribeApplicableIndividualAssessments operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeApplicableIndividualAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeApplicableIndividualAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeApplicableIndividualAssessmentsResponse describeApplicableIndividualAssessments(
            DescribeApplicableIndividualAssessmentsRequest describeApplicableIndividualAssessmentsRequest)
            throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeApplicableIndividualAssessmentsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeApplicableIndividualAssessmentsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeApplicableIndividualAssessmentsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeApplicableIndividualAssessments");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeApplicableIndividualAssessmentsRequest, DescribeApplicableIndividualAssessmentsResponse>()
                            .withOperationName("DescribeApplicableIndividualAssessments").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeApplicableIndividualAssessmentsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeApplicableIndividualAssessmentsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides a list of individual assessments that you can specify for a new premigration assessment run, given one
     * or more parameters.
     * </p>
     * <p>
     * If you specify an existing migration task, this operation provides the default individual assessments you can
     * specify for that task. Otherwise, the specified parameters model elements of a possible migration task on which
     * to base a premigration assessment run.
     * </p>
     * <p>
     * To use these migration task modeling parameters, you must specify an existing replication instance, a source
     * database engine, a target database engine, and a migration type. This combination of parameters potentially
     * limits the default individual assessments available for an assessment run created for a corresponding migration
     * task.
     * </p>
     * <p>
     * If you specify no parameters, this operation provides a list of all possible individual assessments that you can
     * specify for an assessment run. If you specify any one of the task modeling parameters, you must specify all of
     * them or the operation cannot provide a list of individual assessments. The only parameter that you can specify
     * alone is for an existing migration task. The specified task definition then determines the default list of
     * individual assessments that you can specify in an assessment run for the task.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeApplicableIndividualAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeApplicableIndividualAssessmentsIterable responses = client.describeApplicableIndividualAssessmentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeApplicableIndividualAssessmentsIterable responses = client
     *             .describeApplicableIndividualAssessmentsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeApplicableIndividualAssessmentsIterable responses = client.describeApplicableIndividualAssessmentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeApplicableIndividualAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeApplicableIndividualAssessmentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeApplicableIndividualAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeApplicableIndividualAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeApplicableIndividualAssessmentsIterable describeApplicableIndividualAssessmentsPaginator(
            DescribeApplicableIndividualAssessmentsRequest describeApplicableIndividualAssessmentsRequest)
            throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return new DescribeApplicableIndividualAssessmentsIterable(this,
                applyPaginatorUserAgent(describeApplicableIndividualAssessmentsRequest));
    }

    /**
     * <p>
     * Provides a description of the certificate.
     * </p>
     *
     * @param describeCertificatesRequest
     * @return Result of the DescribeCertificates operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeCertificatesResponse describeCertificates(DescribeCertificatesRequest describeCertificatesRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeCertificatesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeCertificatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCertificatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCertificates");

            return clientHandler.execute(new ClientExecutionParams<DescribeCertificatesRequest, DescribeCertificatesResponse>()
                    .withOperationName("DescribeCertificates").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeCertificatesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeCertificatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides a description of the certificate.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCertificates(software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeCertificatesIterable responses = client.describeCertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeCertificatesIterable responses = client
     *             .describeCertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeCertificatesIterable responses = client.describeCertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCertificates(software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeCertificatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeCertificatesIterable describeCertificatesPaginator(DescribeCertificatesRequest describeCertificatesRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeCertificatesIterable(this, applyPaginatorUserAgent(describeCertificatesRequest));
    }

    /**
     * <p>
     * Describes the status of the connections that have been made between the replication instance and an endpoint.
     * Connections are created when you test an endpoint.
     * </p>
     *
     * @param describeConnectionsRequest
     * @return Result of the DescribeConnections operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConnections" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeConnectionsResponse describeConnections(DescribeConnectionsRequest describeConnectionsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeConnectionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeConnectionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeConnectionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConnections");

            return clientHandler.execute(new ClientExecutionParams<DescribeConnectionsRequest, DescribeConnectionsResponse>()
                    .withOperationName("DescribeConnections").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeConnectionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeConnectionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the status of the connections that have been made between the replication instance and an endpoint.
     * Connections are created when you test an endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeConnections(software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeConnectionsIterable responses = client.describeConnectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeConnectionsIterable responses = client
     *             .describeConnectionsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeConnectionsIterable responses = client.describeConnectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConnections(software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeConnectionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConnections" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeConnectionsIterable describeConnectionsPaginator(DescribeConnectionsRequest describeConnectionsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeConnectionsIterable(this, applyPaginatorUserAgent(describeConnectionsRequest));
    }

    /**
     * <p>
     * Returns information about the possible endpoint settings available when you create an endpoint for a specific
     * database engine.
     * </p>
     *
     * @param describeEndpointSettingsRequest
     * @return Result of the DescribeEndpointSettings operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpointSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointSettings" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeEndpointSettingsResponse describeEndpointSettings(
            DescribeEndpointSettingsRequest describeEndpointSettingsRequest) throws AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeEndpointSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeEndpointSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEndpointSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEndpointSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeEndpointSettingsRequest, DescribeEndpointSettingsResponse>()
                            .withOperationName("DescribeEndpointSettings").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeEndpointSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeEndpointSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the possible endpoint settings available when you create an endpoint for a specific
     * database engine.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEndpointSettings(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointSettingsIterable responses = client.describeEndpointSettingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointSettingsIterable responses = client
     *             .describeEndpointSettingsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointSettingsIterable responses = client.describeEndpointSettingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEndpointSettings(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEndpointSettingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpointSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointSettings" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeEndpointSettingsIterable describeEndpointSettingsPaginator(
            DescribeEndpointSettingsRequest describeEndpointSettingsRequest) throws AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return new DescribeEndpointSettingsIterable(this, applyPaginatorUserAgent(describeEndpointSettingsRequest));
    }

    /**
     * <p>
     * Returns information about the type of endpoints available.
     * </p>
     *
     * @param describeEndpointTypesRequest
     * @return Result of the DescribeEndpointTypes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpointTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointTypes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeEndpointTypesResponse describeEndpointTypes(DescribeEndpointTypesRequest describeEndpointTypesRequest)
            throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeEndpointTypesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeEndpointTypesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEndpointTypesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEndpointTypes");

            return clientHandler.execute(new ClientExecutionParams<DescribeEndpointTypesRequest, DescribeEndpointTypesResponse>()
                    .withOperationName("DescribeEndpointTypes").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeEndpointTypesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeEndpointTypesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the type of endpoints available.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEndpointTypes(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointTypesIterable responses = client.describeEndpointTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointTypesIterable responses = client
     *             .describeEndpointTypesPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointTypesIterable responses = client.describeEndpointTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEndpointTypes(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEndpointTypesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpointTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointTypes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeEndpointTypesIterable describeEndpointTypesPaginator(DescribeEndpointTypesRequest describeEndpointTypesRequest)
            throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeEndpointTypesIterable(this, applyPaginatorUserAgent(describeEndpointTypesRequest));
    }

    /**
     * <p>
     * Returns information about the endpoints for your account in the current region.
     * </p>
     *
     * @param describeEndpointsRequest
     * @return Result of the DescribeEndpoints operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeEndpointsResponse describeEndpoints(DescribeEndpointsRequest describeEndpointsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeEndpointsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeEndpointsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEndpointsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEndpoints");

            return clientHandler.execute(new ClientExecutionParams<DescribeEndpointsRequest, DescribeEndpointsResponse>()
                    .withOperationName("DescribeEndpoints").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeEndpointsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeEndpointsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the endpoints for your account in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEndpoints(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointsIterable responses = client.describeEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointsIterable responses = client
     *             .describeEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointsIterable responses = client.describeEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEndpoints(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEndpointsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeEndpointsIterable describeEndpointsPaginator(DescribeEndpointsRequest describeEndpointsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeEndpointsIterable(this, applyPaginatorUserAgent(describeEndpointsRequest));
    }

    /**
     * <p>
     * Lists categories for all event source types, or, if specified, for a specified source type. You can see a list of
     * the event categories and source types in <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     *
     * @param describeEventCategoriesRequest
     * @return Result of the DescribeEventCategories operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEventCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventCategories" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeEventCategoriesResponse describeEventCategories(DescribeEventCategoriesRequest describeEventCategoriesRequest)
            throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeEventCategoriesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeEventCategoriesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEventCategoriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEventCategories");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeEventCategoriesRequest, DescribeEventCategoriesResponse>()
                            .withOperationName("DescribeEventCategories").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeEventCategoriesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeEventCategoriesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all the event subscriptions for a customer account. The description of a subscription includes
     * <code>SubscriptionName</code>, <code>SNSTopicARN</code>, <code>CustomerID</code>, <code>SourceType</code>,
     * <code>SourceID</code>, <code>CreationTime</code>, and <code>Status</code>.
     * </p>
     * <p>
     * If you specify <code>SubscriptionName</code>, this action lists the description for that subscription.
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     * @return Result of the DescribeEventSubscriptions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeEventSubscriptionsResponse describeEventSubscriptions(
            DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeEventSubscriptionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeEventSubscriptionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEventSubscriptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEventSubscriptions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeEventSubscriptionsRequest, DescribeEventSubscriptionsResponse>()
                            .withOperationName("DescribeEventSubscriptions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeEventSubscriptionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeEventSubscriptionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all the event subscriptions for a customer account. The description of a subscription includes
     * <code>SubscriptionName</code>, <code>SNSTopicARN</code>, <code>CustomerID</code>, <code>SourceType</code>,
     * <code>SourceID</code>, <code>CreationTime</code>, and <code>Status</code>.
     * </p>
     * <p>
     * If you specify <code>SubscriptionName</code>, this action lists the description for that subscription.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventSubscriptionsIterable responses = client.describeEventSubscriptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeEventSubscriptionsIterable responses = client
     *             .describeEventSubscriptionsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventSubscriptionsIterable responses = client.describeEventSubscriptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeEventSubscriptionsIterable describeEventSubscriptionsPaginator(
            DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeEventSubscriptionsIterable(this, applyPaginatorUserAgent(describeEventSubscriptionsRequest));
    }

    /**
     * <p>
     * Lists events for a given source identifier and source type. You can also specify a start and end time. For more
     * information on DMS events, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     *
     * @param describeEventsRequest
     * @return Result of the DescribeEvents operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeEventsResponse describeEvents(DescribeEventsRequest describeEventsRequest) throws AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeEventsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeEventsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEventsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEvents");

            return clientHandler.execute(new ClientExecutionParams<DescribeEventsRequest, DescribeEventsResponse>()
                    .withOperationName("DescribeEvents").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeEventsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeEventsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists events for a given source identifier and source type. You can also specify a start and end time. For more
     * information on DMS events, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEvents(software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeEventsIterable responses = client
     *             .describeEventsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEventsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeEventsIterable describeEventsPaginator(DescribeEventsRequest describeEventsRequest)
            throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeEventsIterable(this, applyPaginatorUserAgent(describeEventsRequest));
    }

    /**
     * <p>
     * Returns information about the replication instance types that can be created in the specified region.
     * </p>
     *
     * @param describeOrderableReplicationInstancesRequest
     * @return Result of the DescribeOrderableReplicationInstances operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeOrderableReplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeOrderableReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeOrderableReplicationInstancesResponse describeOrderableReplicationInstances(
            DescribeOrderableReplicationInstancesRequest describeOrderableReplicationInstancesRequest)
            throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeOrderableReplicationInstancesResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeOrderableReplicationInstancesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeOrderableReplicationInstancesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOrderableReplicationInstances");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeOrderableReplicationInstancesRequest, DescribeOrderableReplicationInstancesResponse>()
                            .withOperationName("DescribeOrderableReplicationInstances").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeOrderableReplicationInstancesRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeOrderableReplicationInstancesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the replication instance types that can be created in the specified region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeOrderableReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeOrderableReplicationInstancesIterable responses = client.describeOrderableReplicationInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeOrderableReplicationInstancesIterable responses = client
     *             .describeOrderableReplicationInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeOrderableReplicationInstancesIterable responses = client.describeOrderableReplicationInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrderableReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOrderableReplicationInstancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeOrderableReplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeOrderableReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeOrderableReplicationInstancesIterable describeOrderableReplicationInstancesPaginator(
            DescribeOrderableReplicationInstancesRequest describeOrderableReplicationInstancesRequest)
            throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeOrderableReplicationInstancesIterable(this,
                applyPaginatorUserAgent(describeOrderableReplicationInstancesRequest));
    }

    /**
     * <p>
     * For internal use only
     * </p>
     *
     * @param describePendingMaintenanceActionsRequest
     * @return Result of the DescribePendingMaintenanceActions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribePendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribePendingMaintenanceActionsResponse describePendingMaintenanceActions(
            DescribePendingMaintenanceActionsRequest describePendingMaintenanceActionsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribePendingMaintenanceActionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribePendingMaintenanceActionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describePendingMaintenanceActionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePendingMaintenanceActions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribePendingMaintenanceActionsRequest, DescribePendingMaintenanceActionsResponse>()
                            .withOperationName("DescribePendingMaintenanceActions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describePendingMaintenanceActionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribePendingMaintenanceActionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * For internal use only
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePendingMaintenanceActions(software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribePendingMaintenanceActionsIterable responses = client.describePendingMaintenanceActionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribePendingMaintenanceActionsIterable responses = client
     *             .describePendingMaintenanceActionsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribePendingMaintenanceActionsIterable responses = client.describePendingMaintenanceActionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePendingMaintenanceActions(software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePendingMaintenanceActionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribePendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribePendingMaintenanceActionsIterable describePendingMaintenanceActionsPaginator(
            DescribePendingMaintenanceActionsRequest describePendingMaintenanceActionsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribePendingMaintenanceActionsIterable(this,
                applyPaginatorUserAgent(describePendingMaintenanceActionsRequest));
    }

    /**
     * <p>
     * Returns the status of the RefreshSchemas operation.
     * </p>
     *
     * @param describeRefreshSchemasStatusRequest
     * @return Result of the DescribeRefreshSchemasStatus operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeRefreshSchemasStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRefreshSchemasStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeRefreshSchemasStatusResponse describeRefreshSchemasStatus(
            DescribeRefreshSchemasStatusRequest describeRefreshSchemasStatusRequest) throws InvalidResourceStateException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeRefreshSchemasStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeRefreshSchemasStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeRefreshSchemasStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRefreshSchemasStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeRefreshSchemasStatusRequest, DescribeRefreshSchemasStatusResponse>()
                            .withOperationName("DescribeRefreshSchemasStatus").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeRefreshSchemasStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeRefreshSchemasStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the task logs for the specified task.
     * </p>
     *
     * @param describeReplicationInstanceTaskLogsRequest
     * @return Result of the DescribeReplicationInstanceTaskLogs operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationInstanceTaskLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstanceTaskLogs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeReplicationInstanceTaskLogsResponse describeReplicationInstanceTaskLogs(
            DescribeReplicationInstanceTaskLogsRequest describeReplicationInstanceTaskLogsRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeReplicationInstanceTaskLogsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeReplicationInstanceTaskLogsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeReplicationInstanceTaskLogsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReplicationInstanceTaskLogs");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeReplicationInstanceTaskLogsRequest, DescribeReplicationInstanceTaskLogsResponse>()
                            .withOperationName("DescribeReplicationInstanceTaskLogs").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeReplicationInstanceTaskLogsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeReplicationInstanceTaskLogsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the task logs for the specified task.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationInstanceTaskLogs(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstanceTaskLogsIterable responses = client.describeReplicationInstanceTaskLogsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstanceTaskLogsIterable responses = client
     *             .describeReplicationInstanceTaskLogsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstanceTaskLogsIterable responses = client.describeReplicationInstanceTaskLogsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationInstanceTaskLogs(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationInstanceTaskLogsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationInstanceTaskLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstanceTaskLogs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeReplicationInstanceTaskLogsIterable describeReplicationInstanceTaskLogsPaginator(
            DescribeReplicationInstanceTaskLogsRequest describeReplicationInstanceTaskLogsRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return new DescribeReplicationInstanceTaskLogsIterable(this,
                applyPaginatorUserAgent(describeReplicationInstanceTaskLogsRequest));
    }

    /**
     * <p>
     * Returns information about replication instances for your account in the current region.
     * </p>
     *
     * @param describeReplicationInstancesRequest
     * @return Result of the DescribeReplicationInstances operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeReplicationInstancesResponse describeReplicationInstances(
            DescribeReplicationInstancesRequest describeReplicationInstancesRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeReplicationInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeReplicationInstancesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeReplicationInstancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReplicationInstances");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeReplicationInstancesRequest, DescribeReplicationInstancesResponse>()
                            .withOperationName("DescribeReplicationInstances").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeReplicationInstancesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeReplicationInstancesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about replication instances for your account in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstancesIterable responses = client.describeReplicationInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstancesIterable responses = client
     *             .describeReplicationInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstancesIterable responses = client.describeReplicationInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationInstancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeReplicationInstancesIterable describeReplicationInstancesPaginator(
            DescribeReplicationInstancesRequest describeReplicationInstancesRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeReplicationInstancesIterable(this, applyPaginatorUserAgent(describeReplicationInstancesRequest));
    }

    /**
     * <p>
     * Returns information about the replication subnet groups.
     * </p>
     *
     * @param describeReplicationSubnetGroupsRequest
     * @return Result of the DescribeReplicationSubnetGroups operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeReplicationSubnetGroupsResponse describeReplicationSubnetGroups(
            DescribeReplicationSubnetGroupsRequest describeReplicationSubnetGroupsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeReplicationSubnetGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeReplicationSubnetGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeReplicationSubnetGroupsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReplicationSubnetGroups");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeReplicationSubnetGroupsRequest, DescribeReplicationSubnetGroupsResponse>()
                            .withOperationName("DescribeReplicationSubnetGroups").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeReplicationSubnetGroupsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeReplicationSubnetGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the replication subnet groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationSubnetGroups(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationSubnetGroupsIterable responses = client.describeReplicationSubnetGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationSubnetGroupsIterable responses = client
     *             .describeReplicationSubnetGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationSubnetGroupsIterable responses = client.describeReplicationSubnetGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationSubnetGroups(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationSubnetGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeReplicationSubnetGroupsIterable describeReplicationSubnetGroupsPaginator(
            DescribeReplicationSubnetGroupsRequest describeReplicationSubnetGroupsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeReplicationSubnetGroupsIterable(this, applyPaginatorUserAgent(describeReplicationSubnetGroupsRequest));
    }

    /**
     * <p>
     * Returns the task assessment results from the Amazon S3 bucket that DMS creates in your account. This action
     * always returns the latest results.
     * </p>
     * <p>
     * For more information about DMS task assessments, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html">Creating a task
     * assessment report</a> in the <a
     * href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/dms/latest/userguide/Welcome.html"> Database
     * Migration Service User Guide</a>.
     * </p>
     *
     * @param describeReplicationTaskAssessmentResultsRequest
     * @return Result of the DescribeReplicationTaskAssessmentResults operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTaskAssessmentResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentResults"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeReplicationTaskAssessmentResultsResponse describeReplicationTaskAssessmentResults(
            DescribeReplicationTaskAssessmentResultsRequest describeReplicationTaskAssessmentResultsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeReplicationTaskAssessmentResultsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeReplicationTaskAssessmentResultsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeReplicationTaskAssessmentResultsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReplicationTaskAssessmentResults");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeReplicationTaskAssessmentResultsRequest, DescribeReplicationTaskAssessmentResultsResponse>()
                            .withOperationName("DescribeReplicationTaskAssessmentResults").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeReplicationTaskAssessmentResultsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeReplicationTaskAssessmentResultsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the task assessment results from the Amazon S3 bucket that DMS creates in your account. This action
     * always returns the latest results.
     * </p>
     * <p>
     * For more information about DMS task assessments, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html">Creating a task
     * assessment report</a> in the <a
     * href="https://docs.aws.amazon.com/https:/docs.aws.amazon.com/dms/latest/userguide/Welcome.html"> Database
     * Migration Service User Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationTaskAssessmentResults(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentResultsIterable responses = client.describeReplicationTaskAssessmentResultsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentResultsIterable responses = client
     *             .describeReplicationTaskAssessmentResultsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentResultsIterable responses = client.describeReplicationTaskAssessmentResultsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationTaskAssessmentResults(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationTaskAssessmentResultsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTaskAssessmentResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentResults"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeReplicationTaskAssessmentResultsIterable describeReplicationTaskAssessmentResultsPaginator(
            DescribeReplicationTaskAssessmentResultsRequest describeReplicationTaskAssessmentResultsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeReplicationTaskAssessmentResultsIterable(this,
                applyPaginatorUserAgent(describeReplicationTaskAssessmentResultsRequest));
    }

    /**
     * <p>
     * Returns a paginated list of premigration assessment runs based on filter settings.
     * </p>
     * <p>
     * These filter settings can specify a combination of premigration assessment runs, migration tasks, replication
     * instances, and assessment run status values.
     * </p>
     * <note>
     * <p>
     * This operation doesn't return information about individual assessments. For this information, see the
     * <code>DescribeReplicationTaskIndividualAssessments</code> operation.
     * </p>
     * </note>
     *
     * @param describeReplicationTaskAssessmentRunsRequest
     * @return Result of the DescribeReplicationTaskAssessmentRuns operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTaskAssessmentRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentRuns"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeReplicationTaskAssessmentRunsResponse describeReplicationTaskAssessmentRuns(
            DescribeReplicationTaskAssessmentRunsRequest describeReplicationTaskAssessmentRunsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeReplicationTaskAssessmentRunsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeReplicationTaskAssessmentRunsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeReplicationTaskAssessmentRunsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReplicationTaskAssessmentRuns");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeReplicationTaskAssessmentRunsRequest, DescribeReplicationTaskAssessmentRunsResponse>()
                            .withOperationName("DescribeReplicationTaskAssessmentRuns").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeReplicationTaskAssessmentRunsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeReplicationTaskAssessmentRunsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a paginated list of premigration assessment runs based on filter settings.
     * </p>
     * <p>
     * These filter settings can specify a combination of premigration assessment runs, migration tasks, replication
     * instances, and assessment run status values.
     * </p>
     * <note>
     * <p>
     * This operation doesn't return information about individual assessments. For this information, see the
     * <code>DescribeReplicationTaskIndividualAssessments</code> operation.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationTaskAssessmentRuns(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentRunsIterable responses = client.describeReplicationTaskAssessmentRunsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentRunsIterable responses = client
     *             .describeReplicationTaskAssessmentRunsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentRunsIterable responses = client.describeReplicationTaskAssessmentRunsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationTaskAssessmentRuns(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationTaskAssessmentRunsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTaskAssessmentRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentRuns"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeReplicationTaskAssessmentRunsIterable describeReplicationTaskAssessmentRunsPaginator(
            DescribeReplicationTaskAssessmentRunsRequest describeReplicationTaskAssessmentRunsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeReplicationTaskAssessmentRunsIterable(this,
                applyPaginatorUserAgent(describeReplicationTaskAssessmentRunsRequest));
    }

    /**
     * <p>
     * Returns a paginated list of individual assessments based on filter settings.
     * </p>
     * <p>
     * These filter settings can specify a combination of premigration assessment runs, migration tasks, and assessment
     * status values.
     * </p>
     *
     * @param describeReplicationTaskIndividualAssessmentsRequest
     * @return Result of the DescribeReplicationTaskIndividualAssessments operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTaskIndividualAssessments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskIndividualAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeReplicationTaskIndividualAssessmentsResponse describeReplicationTaskIndividualAssessments(
            DescribeReplicationTaskIndividualAssessmentsRequest describeReplicationTaskIndividualAssessmentsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeReplicationTaskIndividualAssessmentsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeReplicationTaskIndividualAssessmentsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeReplicationTaskIndividualAssessmentsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReplicationTaskIndividualAssessments");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeReplicationTaskIndividualAssessmentsRequest, DescribeReplicationTaskIndividualAssessmentsResponse>()
                            .withOperationName("DescribeReplicationTaskIndividualAssessments")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeReplicationTaskIndividualAssessmentsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeReplicationTaskIndividualAssessmentsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a paginated list of individual assessments based on filter settings.
     * </p>
     * <p>
     * These filter settings can specify a combination of premigration assessment runs, migration tasks, and assessment
     * status values.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationTaskIndividualAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskIndividualAssessmentsIterable responses = client.describeReplicationTaskIndividualAssessmentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskIndividualAssessmentsIterable responses = client
     *             .describeReplicationTaskIndividualAssessmentsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskIndividualAssessmentsIterable responses = client.describeReplicationTaskIndividualAssessmentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationTaskIndividualAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationTaskIndividualAssessmentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTaskIndividualAssessments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskIndividualAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeReplicationTaskIndividualAssessmentsIterable describeReplicationTaskIndividualAssessmentsPaginator(
            DescribeReplicationTaskIndividualAssessmentsRequest describeReplicationTaskIndividualAssessmentsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeReplicationTaskIndividualAssessmentsIterable(this,
                applyPaginatorUserAgent(describeReplicationTaskIndividualAssessmentsRequest));
    }

    /**
     * <p>
     * Returns information about replication tasks for your account in the current region.
     * </p>
     *
     * @param describeReplicationTasksRequest
     * @return Result of the DescribeReplicationTasks operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTasks" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeReplicationTasksResponse describeReplicationTasks(
            DescribeReplicationTasksRequest describeReplicationTasksRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeReplicationTasksResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeReplicationTasksResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeReplicationTasksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeReplicationTasks");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeReplicationTasksRequest, DescribeReplicationTasksResponse>()
                            .withOperationName("DescribeReplicationTasks").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeReplicationTasksRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeReplicationTasksRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about replication tasks for your account in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationTasks(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTasksIterable responses = client.describeReplicationTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTasksIterable responses = client
     *             .describeReplicationTasksPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTasksIterable responses = client.describeReplicationTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationTasks(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationTasksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTasks" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeReplicationTasksIterable describeReplicationTasksPaginator(
            DescribeReplicationTasksRequest describeReplicationTasksRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeReplicationTasksIterable(this, applyPaginatorUserAgent(describeReplicationTasksRequest));
    }

    /**
     * <p>
     * Returns information about the schema for the specified endpoint.
     * </p>
     * <p/>
     *
     * @param describeSchemasRequest
     * @return Result of the DescribeSchemas operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeSchemasResponse describeSchemas(DescribeSchemasRequest describeSchemasRequest)
            throws InvalidResourceStateException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeSchemasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeSchemasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSchemasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSchemas");

            return clientHandler.execute(new ClientExecutionParams<DescribeSchemasRequest, DescribeSchemasResponse>()
                    .withOperationName("DescribeSchemas").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeSchemasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeSchemasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the schema for the specified endpoint.
     * </p>
     * <p/>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeSchemas(software.amazon.awssdk.services.databasemigration.model.DescribeSchemasRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeSchemasIterable responses = client.describeSchemasPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeSchemasIterable responses = client
     *             .describeSchemasPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeSchemasResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeSchemasIterable responses = client.describeSchemasPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSchemas(software.amazon.awssdk.services.databasemigration.model.DescribeSchemasRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSchemasRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeSchemasIterable describeSchemasPaginator(DescribeSchemasRequest describeSchemasRequest)
            throws InvalidResourceStateException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return new DescribeSchemasIterable(this, applyPaginatorUserAgent(describeSchemasRequest));
    }

    /**
     * <p>
     * Returns table statistics on the database migration task, including table name, rows inserted, rows updated, and
     * rows deleted.
     * </p>
     * <p>
     * Note that the "last updated" column the DMS console only indicates the time that DMS last updated the table
     * statistics record for a table. It does not indicate the time of the last update to the table.
     * </p>
     *
     * @param describeTableStatisticsRequest
     * @return Result of the DescribeTableStatistics operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeTableStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeTableStatistics" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeTableStatisticsResponse describeTableStatistics(DescribeTableStatisticsRequest describeTableStatisticsRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeTableStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeTableStatisticsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTableStatisticsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTableStatistics");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeTableStatisticsRequest, DescribeTableStatisticsResponse>()
                            .withOperationName("DescribeTableStatistics").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeTableStatisticsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeTableStatisticsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns table statistics on the database migration task, including table name, rows inserted, rows updated, and
     * rows deleted.
     * </p>
     * <p>
     * Note that the "last updated" column the DMS console only indicates the time that DMS last updated the table
     * statistics record for a table. It does not indicate the time of the last update to the table.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeTableStatistics(software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeTableStatisticsIterable responses = client.describeTableStatisticsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeTableStatisticsIterable responses = client
     *             .describeTableStatisticsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeTableStatisticsIterable responses = client.describeTableStatisticsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTableStatistics(software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeTableStatisticsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeTableStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeTableStatistics" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeTableStatisticsIterable describeTableStatisticsPaginator(
            DescribeTableStatisticsRequest describeTableStatisticsRequest) throws ResourceNotFoundException,
            InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return new DescribeTableStatisticsIterable(this, applyPaginatorUserAgent(describeTableStatisticsRequest));
    }

    /**
     * <p>
     * Uploads the specified certificate.
     * </p>
     *
     * @param importCertificateRequest
     * @return Result of the ImportCertificate operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws InvalidCertificateException
     *         The certificate was not valid.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ImportCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ImportCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ImportCertificateResponse importCertificate(ImportCertificateRequest importCertificateRequest)
            throws ResourceAlreadyExistsException, InvalidCertificateException, ResourceQuotaExceededException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ImportCertificateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ImportCertificateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportCertificate");

            return clientHandler.execute(new ClientExecutionParams<ImportCertificateRequest, ImportCertificateResponse>()
                    .withOperationName("ImportCertificate").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(importCertificateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ImportCertificateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all metadata tags attached to an DMS resource, including replication instance, endpoint, security group,
     * and migration task. For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html"> <code>Tag</code> </a> data type
     * description.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the specified endpoint.
     * </p>
     * <note>
     * <p>
     * For a MySQL source or target endpoint, don't explicitly specify the database using the <code>DatabaseName</code>
     * request parameter on the <code>ModifyEndpoint</code> API call. Specifying <code>DatabaseName</code> when you
     * modify a MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify
     * the database only when you specify the schema in the table-mapping rules of the DMS task.
     * </p>
     * </note>
     *
     * @param modifyEndpointRequest
     * @return Result of the ModifyEndpoint operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ModifyEndpointResponse modifyEndpoint(ModifyEndpointRequest modifyEndpointRequest)
            throws InvalidResourceStateException, ResourceNotFoundException, ResourceAlreadyExistsException,
            KmsKeyNotAccessibleException, AccessDeniedException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ModifyEndpointResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ModifyEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyEndpoint");

            return clientHandler.execute(new ClientExecutionParams<ModifyEndpointRequest, ModifyEndpointResponse>()
                    .withOperationName("ModifyEndpoint").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(modifyEndpointRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ModifyEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies an existing DMS event notification subscription.
     * </p>
     *
     * @param modifyEventSubscriptionRequest
     * @return Result of the ModifyEventSubscription operation returned by the service.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SnsInvalidTopicException
     *         The SNS topic is invalid.
     * @throws SnsNoAuthorizationException
     *         You are not authorized for the SNS subscription.
     * @throws KmsAccessDeniedException
     *         The ciphertext references a key that doesn't exist or that the DMS account doesn't have access to.
     * @throws KmsDisabledException
     *         The specified master key (CMK) isn't enabled.
     * @throws KmsInvalidStateException
     *         The state of the specified KMS resource isn't valid for this request.
     * @throws KmsNotFoundException
     *         The specified KMS entity or resource can't be found.
     * @throws KmsThrottlingException
     *         This request triggered KMS request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ModifyEventSubscriptionResponse modifyEventSubscription(ModifyEventSubscriptionRequest modifyEventSubscriptionRequest)
            throws ResourceQuotaExceededException, ResourceNotFoundException, SnsInvalidTopicException,
            SnsNoAuthorizationException, KmsAccessDeniedException, KmsDisabledException, KmsInvalidStateException,
            KmsNotFoundException, KmsThrottlingException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ModifyEventSubscriptionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ModifyEventSubscriptionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyEventSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyEventSubscription");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyEventSubscriptionRequest, ModifyEventSubscriptionResponse>()
                            .withOperationName("ModifyEventSubscription").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(modifyEventSubscriptionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyEventSubscriptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the replication instance to apply new settings. You can change one or more parameters by specifying
     * these parameters and the new values in the request.
     * </p>
     * <p>
     * Some settings are applied during the maintenance window.
     * </p>
     * <p/>
     *
     * @param modifyReplicationInstanceRequest
     * @return Result of the ModifyReplicationInstance operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InsufficientResourceCapacityException
     *         There are not enough resources allocated to the database migration.
     * @throws StorageQuotaExceededException
     *         The storage quota has been exceeded.
     * @throws UpgradeDependencyFailureException
     *         An upgrade dependency is preventing the database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyReplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationInstance" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ModifyReplicationInstanceResponse modifyReplicationInstance(
            ModifyReplicationInstanceRequest modifyReplicationInstanceRequest) throws AccessDeniedException,
            InvalidResourceStateException, ResourceAlreadyExistsException, ResourceNotFoundException,
            InsufficientResourceCapacityException, StorageQuotaExceededException, UpgradeDependencyFailureException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ModifyReplicationInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ModifyReplicationInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyReplicationInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyReplicationInstance");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyReplicationInstanceRequest, ModifyReplicationInstanceResponse>()
                            .withOperationName("ModifyReplicationInstance").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(modifyReplicationInstanceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyReplicationInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the settings for the specified replication subnet group.
     * </p>
     *
     * @param modifyReplicationSubnetGroupRequest
     * @return Result of the ModifyReplicationSubnetGroup operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws SubnetAlreadyInUseException
     *         The specified subnet is already in use.
     * @throws ReplicationSubnetGroupDoesNotCoverEnoughAZsException
     *         The replication subnet group does not cover enough Availability Zones (AZs). Edit the replication subnet
     *         group and add more AZs.
     * @throws InvalidSubnetException
     *         The subnet provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyReplicationSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyReplicationSubnetGroupResponse modifyReplicationSubnetGroup(
            ModifyReplicationSubnetGroupRequest modifyReplicationSubnetGroupRequest) throws AccessDeniedException,
            ResourceNotFoundException, ResourceQuotaExceededException, SubnetAlreadyInUseException,
            ReplicationSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ModifyReplicationSubnetGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ModifyReplicationSubnetGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyReplicationSubnetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyReplicationSubnetGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyReplicationSubnetGroupRequest, ModifyReplicationSubnetGroupResponse>()
                            .withOperationName("ModifyReplicationSubnetGroup").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(modifyReplicationSubnetGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyReplicationSubnetGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the specified replication task.
     * </p>
     * <p>
     * You can't modify the task endpoints. The task must be stopped before you can modify it.
     * </p>
     * <p>
     * For more information about DMS tasks, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html">Working with Migration Tasks</a> in the
     * <i>Database Migration Service User Guide</i>.
     * </p>
     *
     * @param modifyReplicationTaskRequest
     * @return Result of the ModifyReplicationTask operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ModifyReplicationTaskResponse modifyReplicationTask(ModifyReplicationTaskRequest modifyReplicationTaskRequest)
            throws InvalidResourceStateException, ResourceNotFoundException, ResourceAlreadyExistsException,
            KmsKeyNotAccessibleException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ModifyReplicationTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ModifyReplicationTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyReplicationTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyReplicationTask");

            return clientHandler.execute(new ClientExecutionParams<ModifyReplicationTaskRequest, ModifyReplicationTaskResponse>()
                    .withOperationName("ModifyReplicationTask").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(modifyReplicationTaskRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ModifyReplicationTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Moves a replication task from its current replication instance to a different target replication instance using
     * the specified parameters. The target replication instance must be created with the same or later DMS version as
     * the current replication instance.
     * </p>
     *
     * @param moveReplicationTaskRequest
     * @return Result of the MoveReplicationTask operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.MoveReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/MoveReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public MoveReplicationTaskResponse moveReplicationTask(MoveReplicationTaskRequest moveReplicationTaskRequest)
            throws AccessDeniedException, InvalidResourceStateException, ResourceNotFoundException, KmsKeyNotAccessibleException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<MoveReplicationTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, MoveReplicationTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, moveReplicationTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "MoveReplicationTask");

            return clientHandler.execute(new ClientExecutionParams<MoveReplicationTaskRequest, MoveReplicationTaskResponse>()
                    .withOperationName("MoveReplicationTask").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(moveReplicationTaskRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new MoveReplicationTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Reboots a replication instance. Rebooting results in a momentary outage, until the replication instance becomes
     * available again.
     * </p>
     *
     * @param rebootReplicationInstanceRequest
     * @return Result of the RebootReplicationInstance operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.RebootReplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RebootReplicationInstance" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public RebootReplicationInstanceResponse rebootReplicationInstance(
            RebootReplicationInstanceRequest rebootReplicationInstanceRequest) throws ResourceNotFoundException,
            InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RebootReplicationInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RebootReplicationInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, rebootReplicationInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RebootReplicationInstance");

            return clientHandler
                    .execute(new ClientExecutionParams<RebootReplicationInstanceRequest, RebootReplicationInstanceResponse>()
                            .withOperationName("RebootReplicationInstance").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(rebootReplicationInstanceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RebootReplicationInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Populates the schema for the specified endpoint. This is an asynchronous operation and can take several minutes.
     * You can check the status of this operation by calling the DescribeRefreshSchemasStatus operation.
     * </p>
     *
     * @param refreshSchemasRequest
     * @return Result of the RefreshSchemas operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.RefreshSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RefreshSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public RefreshSchemasResponse refreshSchemas(RefreshSchemasRequest refreshSchemasRequest)
            throws InvalidResourceStateException, ResourceNotFoundException, KmsKeyNotAccessibleException,
            ResourceQuotaExceededException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RefreshSchemasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                RefreshSchemasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, refreshSchemasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RefreshSchemas");

            return clientHandler.execute(new ClientExecutionParams<RefreshSchemasRequest, RefreshSchemasResponse>()
                    .withOperationName("RefreshSchemas").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(refreshSchemasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RefreshSchemasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Reloads the target database table with the source data.
     * </p>
     *
     * @param reloadTablesRequest
     * @return Result of the ReloadTables operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ReloadTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ReloadTables" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ReloadTablesResponse reloadTables(ReloadTablesRequest reloadTablesRequest) throws ResourceNotFoundException,
            InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ReloadTablesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ReloadTablesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, reloadTablesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ReloadTables");

            return clientHandler.execute(new ClientExecutionParams<ReloadTablesRequest, ReloadTablesResponse>()
                    .withOperationName("ReloadTables").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(reloadTablesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ReloadTablesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes metadata tags from an DMS resource, including replication instance, endpoint, security group, and
     * migration task. For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html"> <code>Tag</code> </a> data type
     * description.
     * </p>
     *
     * @param removeTagsFromResourceRequest
     *        Removes one or more tags from an DMS resource.
     * @return Result of the RemoveTagsFromResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.RemoveTagsFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RemoveTagsFromResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public RemoveTagsFromResourceResponse removeTagsFromResource(RemoveTagsFromResourceRequest removeTagsFromResourceRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RemoveTagsFromResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RemoveTagsFromResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeTagsFromResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveTagsFromResource");

            return clientHandler
                    .execute(new ClientExecutionParams<RemoveTagsFromResourceRequest, RemoveTagsFromResourceResponse>()
                            .withOperationName("RemoveTagsFromResource").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(removeTagsFromResourceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RemoveTagsFromResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts the replication task.
     * </p>
     * <p>
     * For more information about DMS tasks, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html">Working with Migration Tasks </a> in the
     * <i>Database Migration Service User Guide.</i>
     * </p>
     *
     * @param startReplicationTaskRequest
     * @return Result of the StartReplicationTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StartReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartReplicationTaskResponse startReplicationTask(StartReplicationTaskRequest startReplicationTaskRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AccessDeniedException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartReplicationTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartReplicationTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startReplicationTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartReplicationTask");

            return clientHandler.execute(new ClientExecutionParams<StartReplicationTaskRequest, StartReplicationTaskResponse>()
                    .withOperationName("StartReplicationTask").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(startReplicationTaskRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartReplicationTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts the replication task assessment for unsupported data types in the source database.
     * </p>
     *
     * @param startReplicationTaskAssessmentRequest
     * @return Result of the StartReplicationTaskAssessment operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StartReplicationTaskAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTaskAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartReplicationTaskAssessmentResponse startReplicationTaskAssessment(
            StartReplicationTaskAssessmentRequest startReplicationTaskAssessmentRequest) throws InvalidResourceStateException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartReplicationTaskAssessmentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartReplicationTaskAssessmentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                startReplicationTaskAssessmentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartReplicationTaskAssessment");

            return clientHandler
                    .execute(new ClientExecutionParams<StartReplicationTaskAssessmentRequest, StartReplicationTaskAssessmentResponse>()
                            .withOperationName("StartReplicationTaskAssessment").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(startReplicationTaskAssessmentRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartReplicationTaskAssessmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts a new premigration assessment run for one or more individual assessments of a migration task.
     * </p>
     * <p>
     * The assessments that you can specify depend on the source and target database engine and the migration type
     * defined for the given task. To run this operation, your migration task must already be created. After you run
     * this operation, you can review the status of each individual assessment. You can also run the migration task
     * manually after the assessment run and its individual assessments complete.
     * </p>
     *
     * @param startReplicationTaskAssessmentRunRequest
     * @return Result of the StartReplicationTaskAssessmentRun operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws KmsAccessDeniedException
     *         The ciphertext references a key that doesn't exist or that the DMS account doesn't have access to.
     * @throws KmsDisabledException
     *         The specified master key (CMK) isn't enabled.
     * @throws KmsException
     *         An Key Management Service (KMS) error is preventing access to KMS.
     * @throws KmsInvalidStateException
     *         The state of the specified KMS resource isn't valid for this request.
     * @throws KmsNotFoundException
     *         The specified KMS entity or resource can't be found.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws S3AccessDeniedException
     *         Insufficient privileges are preventing access to an Amazon S3 object.
     * @throws S3ResourceNotFoundException
     *         A specified Amazon S3 bucket, bucket folder, or other object can't be found.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StartReplicationTaskAssessmentRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTaskAssessmentRun"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartReplicationTaskAssessmentRunResponse startReplicationTaskAssessmentRun(
            StartReplicationTaskAssessmentRunRequest startReplicationTaskAssessmentRunRequest) throws AccessDeniedException,
            ResourceNotFoundException, InvalidResourceStateException, KmsAccessDeniedException, KmsDisabledException,
            KmsException, KmsInvalidStateException, KmsNotFoundException, KmsKeyNotAccessibleException, S3AccessDeniedException,
            S3ResourceNotFoundException, ResourceAlreadyExistsException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartReplicationTaskAssessmentRunResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartReplicationTaskAssessmentRunResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                startReplicationTaskAssessmentRunRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartReplicationTaskAssessmentRun");

            return clientHandler
                    .execute(new ClientExecutionParams<StartReplicationTaskAssessmentRunRequest, StartReplicationTaskAssessmentRunResponse>()
                            .withOperationName("StartReplicationTaskAssessmentRun").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(startReplicationTaskAssessmentRunRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartReplicationTaskAssessmentRunRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops the replication task.
     * </p>
     *
     * @param stopReplicationTaskRequest
     * @return Result of the StopReplicationTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StopReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StopReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StopReplicationTaskResponse stopReplicationTask(StopReplicationTaskRequest stopReplicationTaskRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopReplicationTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StopReplicationTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopReplicationTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopReplicationTask");

            return clientHandler.execute(new ClientExecutionParams<StopReplicationTaskRequest, StopReplicationTaskResponse>()
                    .withOperationName("StopReplicationTask").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(stopReplicationTaskRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StopReplicationTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Tests the connection between the replication instance and the endpoint.
     * </p>
     *
     * @param testConnectionRequest
     * @return Result of the TestConnection operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.TestConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/TestConnection" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TestConnectionResponse testConnection(TestConnectionRequest testConnectionRequest) throws ResourceNotFoundException,
            InvalidResourceStateException, KmsKeyNotAccessibleException, ResourceQuotaExceededException, AccessDeniedException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TestConnectionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TestConnectionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, testConnectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Database Migration Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TestConnection");

            return clientHandler.execute(new ClientExecutionParams<TestConnectionRequest, TestConnectionResponse>()
                    .withOperationName("TestConnection").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(testConnectionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TestConnectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(DatabaseMigrationException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("KMSThrottlingFault")
                                .exceptionBuilderSupplier(KmsThrottlingException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidCertificateFault")
                                .exceptionBuilderSupplier(InvalidCertificateException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("KMSInvalidStateFault")
                                .exceptionBuilderSupplier(KmsInvalidStateException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("KMSNotFoundFault")
                                .exceptionBuilderSupplier(KmsNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("KMSKeyNotAccessibleFault")
                                .exceptionBuilderSupplier(KmsKeyNotAccessibleException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientResourceCapacityFault")
                                .exceptionBuilderSupplier(InsufficientResourceCapacityException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceQuotaExceededFault")
                                .exceptionBuilderSupplier(ResourceQuotaExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("S3AccessDeniedFault")
                                .exceptionBuilderSupplier(S3AccessDeniedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundFault")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("KMSAccessDeniedFault")
                                .exceptionBuilderSupplier(KmsAccessDeniedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubnetAlreadyInUse")
                                .exceptionBuilderSupplier(SubnetAlreadyInUseException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsFault")
                                .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSubnet")
                                .exceptionBuilderSupplier(InvalidSubnetException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("KMSFault").exceptionBuilderSupplier(KmsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UpgradeDependencyFailureFault")
                                .exceptionBuilderSupplier(UpgradeDependencyFailureException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SNSInvalidTopicFault")
                                .exceptionBuilderSupplier(SnsInvalidTopicException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedFault")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidResourceStateFault")
                                .exceptionBuilderSupplier(InvalidResourceStateException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SNSNoAuthorizationFault")
                                .exceptionBuilderSupplier(SnsNoAuthorizationException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("KMSDisabledFault")
                                .exceptionBuilderSupplier(KmsDisabledException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StorageQuotaExceededFault")
                                .exceptionBuilderSupplier(StorageQuotaExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("S3ResourceNotFoundFault")
                                .exceptionBuilderSupplier(S3ResourceNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReplicationSubnetGroupDoesNotCoverEnoughAZs")
                                .exceptionBuilderSupplier(ReplicationSubnetGroupDoesNotCoverEnoughAZsException::builder).build());
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends DatabaseMigrationRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    @Override
    public DatabaseMigrationWaiter waiter() {
        return DatabaseMigrationWaiter.builder().client(this).build();
    }
}
