/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information that describes a premigration assessment run that you have started using the
 * <code>StartReplicationTaskAssessmentRun</code> operation.
 * </p>
 * <p>
 * Some of the information appears based on other operations that can return the
 * <code>ReplicationTaskAssessmentRun</code> object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationTaskAssessmentRun implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicationTaskAssessmentRun.Builder, ReplicationTaskAssessmentRun> {
    private static final SdkField<String> REPLICATION_TASK_ASSESSMENT_RUN_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReplicationTaskAssessmentRunArn")
            .getter(getter(ReplicationTaskAssessmentRun::replicationTaskAssessmentRunArn))
            .setter(setter(Builder::replicationTaskAssessmentRunArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskAssessmentRunArn")
                    .build()).build();

    private static final SdkField<String> REPLICATION_TASK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationTaskArn").getter(getter(ReplicationTaskAssessmentRun::replicationTaskArn))
            .setter(setter(Builder::replicationTaskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskArn").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ReplicationTaskAssessmentRun::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> REPLICATION_TASK_ASSESSMENT_RUN_CREATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ReplicationTaskAssessmentRunCreationDate")
            .getter(getter(ReplicationTaskAssessmentRun::replicationTaskAssessmentRunCreationDate))
            .setter(setter(Builder::replicationTaskAssessmentRunCreationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ReplicationTaskAssessmentRunCreationDate").build()).build();

    private static final SdkField<ReplicationTaskAssessmentRunProgress> ASSESSMENT_PROGRESS_FIELD = SdkField
            .<ReplicationTaskAssessmentRunProgress> builder(MarshallingType.SDK_POJO).memberName("AssessmentProgress")
            .getter(getter(ReplicationTaskAssessmentRun::assessmentProgress)).setter(setter(Builder::assessmentProgress))
            .constructor(ReplicationTaskAssessmentRunProgress::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssessmentProgress").build())
            .build();

    private static final SdkField<String> LAST_FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastFailureMessage").getter(getter(ReplicationTaskAssessmentRun::lastFailureMessage))
            .setter(setter(Builder::lastFailureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastFailureMessage").build())
            .build();

    private static final SdkField<String> SERVICE_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceAccessRoleArn").getter(getter(ReplicationTaskAssessmentRun::serviceAccessRoleArn))
            .setter(setter(Builder::serviceAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccessRoleArn").build())
            .build();

    private static final SdkField<String> RESULT_LOCATION_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResultLocationBucket").getter(getter(ReplicationTaskAssessmentRun::resultLocationBucket))
            .setter(setter(Builder::resultLocationBucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultLocationBucket").build())
            .build();

    private static final SdkField<String> RESULT_LOCATION_FOLDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResultLocationFolder").getter(getter(ReplicationTaskAssessmentRun::resultLocationFolder))
            .setter(setter(Builder::resultLocationFolder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultLocationFolder").build())
            .build();

    private static final SdkField<String> RESULT_ENCRYPTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResultEncryptionMode").getter(getter(ReplicationTaskAssessmentRun::resultEncryptionMode))
            .setter(setter(Builder::resultEncryptionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultEncryptionMode").build())
            .build();

    private static final SdkField<String> RESULT_KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResultKmsKeyArn").getter(getter(ReplicationTaskAssessmentRun::resultKmsKeyArn))
            .setter(setter(Builder::resultKmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultKmsKeyArn").build()).build();

    private static final SdkField<String> ASSESSMENT_RUN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssessmentRunName").getter(getter(ReplicationTaskAssessmentRun::assessmentRunName))
            .setter(setter(Builder::assessmentRunName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssessmentRunName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            REPLICATION_TASK_ASSESSMENT_RUN_ARN_FIELD, REPLICATION_TASK_ARN_FIELD, STATUS_FIELD,
            REPLICATION_TASK_ASSESSMENT_RUN_CREATION_DATE_FIELD, ASSESSMENT_PROGRESS_FIELD, LAST_FAILURE_MESSAGE_FIELD,
            SERVICE_ACCESS_ROLE_ARN_FIELD, RESULT_LOCATION_BUCKET_FIELD, RESULT_LOCATION_FOLDER_FIELD,
            RESULT_ENCRYPTION_MODE_FIELD, RESULT_KMS_KEY_ARN_FIELD, ASSESSMENT_RUN_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String replicationTaskAssessmentRunArn;

    private final String replicationTaskArn;

    private final String status;

    private final Instant replicationTaskAssessmentRunCreationDate;

    private final ReplicationTaskAssessmentRunProgress assessmentProgress;

    private final String lastFailureMessage;

    private final String serviceAccessRoleArn;

    private final String resultLocationBucket;

    private final String resultLocationFolder;

    private final String resultEncryptionMode;

    private final String resultKmsKeyArn;

    private final String assessmentRunName;

    private ReplicationTaskAssessmentRun(BuilderImpl builder) {
        this.replicationTaskAssessmentRunArn = builder.replicationTaskAssessmentRunArn;
        this.replicationTaskArn = builder.replicationTaskArn;
        this.status = builder.status;
        this.replicationTaskAssessmentRunCreationDate = builder.replicationTaskAssessmentRunCreationDate;
        this.assessmentProgress = builder.assessmentProgress;
        this.lastFailureMessage = builder.lastFailureMessage;
        this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
        this.resultLocationBucket = builder.resultLocationBucket;
        this.resultLocationFolder = builder.resultLocationFolder;
        this.resultEncryptionMode = builder.resultEncryptionMode;
        this.resultKmsKeyArn = builder.resultKmsKeyArn;
        this.assessmentRunName = builder.assessmentRunName;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of this assessment run.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of this assessment run.
     */
    public final String replicationTaskAssessmentRunArn() {
        return replicationTaskAssessmentRunArn;
    }

    /**
     * <p>
     * ARN of the migration task associated with this premigration assessment run.
     * </p>
     * 
     * @return ARN of the migration task associated with this premigration assessment run.
     */
    public final String replicationTaskArn() {
        return replicationTaskArn;
    }

    /**
     * <p>
     * Assessment run status.
     * </p>
     * <p>
     * This status can have one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>"cancelling"</code> – The assessment run was canceled by the
     * <code>CancelReplicationTaskAssessmentRun</code> operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"deleting"</code> – The assessment run was deleted by the <code>DeleteReplicationTaskAssessmentRun</code>
     * operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"failed"</code> – At least one individual assessment completed with a <code>failed</code> status.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"error-provisioning"</code> – An internal error occurred while resources were provisioned (during
     * <code>provisioning</code> status).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"error-executing"</code> – An internal error occurred while individual assessments ran (during
     * <code>running</code> status).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"invalid state"</code> – The assessment run is in an unknown state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"passed"</code> – All individual assessments have completed, and none has a <code>failed</code> status.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"provisioning"</code> – Resources required to run individual assessments are being provisioned.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"running"</code> – Individual assessments are being run.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"starting"</code> – The assessment run is starting, but resources are not yet being provisioned for
     * individual assessments.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Assessment run status. </p>
     *         <p>
     *         This status can have one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>"cancelling"</code> – The assessment run was canceled by the
     *         <code>CancelReplicationTaskAssessmentRun</code> operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"deleting"</code> – The assessment run was deleted by the
     *         <code>DeleteReplicationTaskAssessmentRun</code> operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"failed"</code> – At least one individual assessment completed with a <code>failed</code> status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"error-provisioning"</code> – An internal error occurred while resources were provisioned (during
     *         <code>provisioning</code> status).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"error-executing"</code> – An internal error occurred while individual assessments ran (during
     *         <code>running</code> status).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"invalid state"</code> – The assessment run is in an unknown state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"passed"</code> – All individual assessments have completed, and none has a <code>failed</code>
     *         status.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"provisioning"</code> – Resources required to run individual assessments are being provisioned.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"running"</code> – Individual assessments are being run.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"starting"</code> – The assessment run is starting, but resources are not yet being provisioned for
     *         individual assessments.
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * Date on which the assessment run was created using the <code>StartReplicationTaskAssessmentRun</code> operation.
     * </p>
     * 
     * @return Date on which the assessment run was created using the <code>StartReplicationTaskAssessmentRun</code>
     *         operation.
     */
    public final Instant replicationTaskAssessmentRunCreationDate() {
        return replicationTaskAssessmentRunCreationDate;
    }

    /**
     * <p>
     * Indication of the completion progress for the individual assessments specified to run.
     * </p>
     * 
     * @return Indication of the completion progress for the individual assessments specified to run.
     */
    public final ReplicationTaskAssessmentRunProgress assessmentProgress() {
        return assessmentProgress;
    }

    /**
     * <p>
     * Last message generated by an individual assessment failure.
     * </p>
     * 
     * @return Last message generated by an individual assessment failure.
     */
    public final String lastFailureMessage() {
        return lastFailureMessage;
    }

    /**
     * <p>
     * ARN of the service role used to start the assessment run using the <code>StartReplicationTaskAssessmentRun</code>
     * operation. The role must allow the <code>iam:PassRole</code> action.
     * </p>
     * 
     * @return ARN of the service role used to start the assessment run using the
     *         <code>StartReplicationTaskAssessmentRun</code> operation. The role must allow the
     *         <code>iam:PassRole</code> action.
     */
    public final String serviceAccessRoleArn() {
        return serviceAccessRoleArn;
    }

    /**
     * <p>
     * Amazon S3 bucket where DMS stores the results of this assessment run.
     * </p>
     * 
     * @return Amazon S3 bucket where DMS stores the results of this assessment run.
     */
    public final String resultLocationBucket() {
        return resultLocationBucket;
    }

    /**
     * <p>
     * Folder in an Amazon S3 bucket where DMS stores the results of this assessment run.
     * </p>
     * 
     * @return Folder in an Amazon S3 bucket where DMS stores the results of this assessment run.
     */
    public final String resultLocationFolder() {
        return resultLocationFolder;
    }

    /**
     * <p>
     * Encryption mode used to encrypt the assessment run results.
     * </p>
     * 
     * @return Encryption mode used to encrypt the assessment run results.
     */
    public final String resultEncryptionMode() {
        return resultEncryptionMode;
    }

    /**
     * <p>
     * ARN of the KMS encryption key used to encrypt the assessment run results.
     * </p>
     * 
     * @return ARN of the KMS encryption key used to encrypt the assessment run results.
     */
    public final String resultKmsKeyArn() {
        return resultKmsKeyArn;
    }

    /**
     * <p>
     * Unique name of the assessment run.
     * </p>
     * 
     * @return Unique name of the assessment run.
     */
    public final String assessmentRunName() {
        return assessmentRunName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(replicationTaskAssessmentRunArn());
        hashCode = 31 * hashCode + Objects.hashCode(replicationTaskArn());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(replicationTaskAssessmentRunCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentProgress());
        hashCode = 31 * hashCode + Objects.hashCode(lastFailureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(resultLocationBucket());
        hashCode = 31 * hashCode + Objects.hashCode(resultLocationFolder());
        hashCode = 31 * hashCode + Objects.hashCode(resultEncryptionMode());
        hashCode = 31 * hashCode + Objects.hashCode(resultKmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentRunName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationTaskAssessmentRun)) {
            return false;
        }
        ReplicationTaskAssessmentRun other = (ReplicationTaskAssessmentRun) obj;
        return Objects.equals(replicationTaskAssessmentRunArn(), other.replicationTaskAssessmentRunArn())
                && Objects.equals(replicationTaskArn(), other.replicationTaskArn()) && Objects.equals(status(), other.status())
                && Objects.equals(replicationTaskAssessmentRunCreationDate(), other.replicationTaskAssessmentRunCreationDate())
                && Objects.equals(assessmentProgress(), other.assessmentProgress())
                && Objects.equals(lastFailureMessage(), other.lastFailureMessage())
                && Objects.equals(serviceAccessRoleArn(), other.serviceAccessRoleArn())
                && Objects.equals(resultLocationBucket(), other.resultLocationBucket())
                && Objects.equals(resultLocationFolder(), other.resultLocationFolder())
                && Objects.equals(resultEncryptionMode(), other.resultEncryptionMode())
                && Objects.equals(resultKmsKeyArn(), other.resultKmsKeyArn())
                && Objects.equals(assessmentRunName(), other.assessmentRunName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicationTaskAssessmentRun")
                .add("ReplicationTaskAssessmentRunArn", replicationTaskAssessmentRunArn())
                .add("ReplicationTaskArn", replicationTaskArn()).add("Status", status())
                .add("ReplicationTaskAssessmentRunCreationDate", replicationTaskAssessmentRunCreationDate())
                .add("AssessmentProgress", assessmentProgress()).add("LastFailureMessage", lastFailureMessage())
                .add("ServiceAccessRoleArn", serviceAccessRoleArn()).add("ResultLocationBucket", resultLocationBucket())
                .add("ResultLocationFolder", resultLocationFolder()).add("ResultEncryptionMode", resultEncryptionMode())
                .add("ResultKmsKeyArn", resultKmsKeyArn()).add("AssessmentRunName", assessmentRunName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationTaskAssessmentRunArn":
            return Optional.ofNullable(clazz.cast(replicationTaskAssessmentRunArn()));
        case "ReplicationTaskArn":
            return Optional.ofNullable(clazz.cast(replicationTaskArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "ReplicationTaskAssessmentRunCreationDate":
            return Optional.ofNullable(clazz.cast(replicationTaskAssessmentRunCreationDate()));
        case "AssessmentProgress":
            return Optional.ofNullable(clazz.cast(assessmentProgress()));
        case "LastFailureMessage":
            return Optional.ofNullable(clazz.cast(lastFailureMessage()));
        case "ServiceAccessRoleArn":
            return Optional.ofNullable(clazz.cast(serviceAccessRoleArn()));
        case "ResultLocationBucket":
            return Optional.ofNullable(clazz.cast(resultLocationBucket()));
        case "ResultLocationFolder":
            return Optional.ofNullable(clazz.cast(resultLocationFolder()));
        case "ResultEncryptionMode":
            return Optional.ofNullable(clazz.cast(resultEncryptionMode()));
        case "ResultKmsKeyArn":
            return Optional.ofNullable(clazz.cast(resultKmsKeyArn()));
        case "AssessmentRunName":
            return Optional.ofNullable(clazz.cast(assessmentRunName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationTaskAssessmentRun, T> g) {
        return obj -> g.apply((ReplicationTaskAssessmentRun) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationTaskAssessmentRun> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of this assessment run.
         * </p>
         * 
         * @param replicationTaskAssessmentRunArn
         *        Amazon Resource Name (ARN) of this assessment run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskAssessmentRunArn(String replicationTaskAssessmentRunArn);

        /**
         * <p>
         * ARN of the migration task associated with this premigration assessment run.
         * </p>
         * 
         * @param replicationTaskArn
         *        ARN of the migration task associated with this premigration assessment run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskArn(String replicationTaskArn);

        /**
         * <p>
         * Assessment run status.
         * </p>
         * <p>
         * This status can have one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>"cancelling"</code> – The assessment run was canceled by the
         * <code>CancelReplicationTaskAssessmentRun</code> operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"deleting"</code> – The assessment run was deleted by the
         * <code>DeleteReplicationTaskAssessmentRun</code> operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"failed"</code> – At least one individual assessment completed with a <code>failed</code> status.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"error-provisioning"</code> – An internal error occurred while resources were provisioned (during
         * <code>provisioning</code> status).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"error-executing"</code> – An internal error occurred while individual assessments ran (during
         * <code>running</code> status).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"invalid state"</code> – The assessment run is in an unknown state.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"passed"</code> – All individual assessments have completed, and none has a <code>failed</code> status.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"provisioning"</code> – Resources required to run individual assessments are being provisioned.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"running"</code> – Individual assessments are being run.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"starting"</code> – The assessment run is starting, but resources are not yet being provisioned for
         * individual assessments.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Assessment run status. </p>
         *        <p>
         *        This status can have one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>"cancelling"</code> – The assessment run was canceled by the
         *        <code>CancelReplicationTaskAssessmentRun</code> operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"deleting"</code> – The assessment run was deleted by the
         *        <code>DeleteReplicationTaskAssessmentRun</code> operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"failed"</code> – At least one individual assessment completed with a <code>failed</code>
         *        status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"error-provisioning"</code> – An internal error occurred while resources were provisioned
         *        (during <code>provisioning</code> status).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"error-executing"</code> – An internal error occurred while individual assessments ran (during
         *        <code>running</code> status).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"invalid state"</code> – The assessment run is in an unknown state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"passed"</code> – All individual assessments have completed, and none has a <code>failed</code>
         *        status.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"provisioning"</code> – Resources required to run individual assessments are being provisioned.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"running"</code> – Individual assessments are being run.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"starting"</code> – The assessment run is starting, but resources are not yet being provisioned
         *        for individual assessments.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Date on which the assessment run was created using the <code>StartReplicationTaskAssessmentRun</code>
         * operation.
         * </p>
         * 
         * @param replicationTaskAssessmentRunCreationDate
         *        Date on which the assessment run was created using the <code>StartReplicationTaskAssessmentRun</code>
         *        operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskAssessmentRunCreationDate(Instant replicationTaskAssessmentRunCreationDate);

        /**
         * <p>
         * Indication of the completion progress for the individual assessments specified to run.
         * </p>
         * 
         * @param assessmentProgress
         *        Indication of the completion progress for the individual assessments specified to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentProgress(ReplicationTaskAssessmentRunProgress assessmentProgress);

        /**
         * <p>
         * Indication of the completion progress for the individual assessments specified to run.
         * </p>
         * This is a convenience that creates an instance of the {@link ReplicationTaskAssessmentRunProgress.Builder}
         * avoiding the need to create one manually via {@link ReplicationTaskAssessmentRunProgress#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReplicationTaskAssessmentRunProgress.Builder#build()} is called
         * immediately and its result is passed to {@link #assessmentProgress(ReplicationTaskAssessmentRunProgress)}.
         * 
         * @param assessmentProgress
         *        a consumer that will call methods on {@link ReplicationTaskAssessmentRunProgress.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assessmentProgress(ReplicationTaskAssessmentRunProgress)
         */
        default Builder assessmentProgress(Consumer<ReplicationTaskAssessmentRunProgress.Builder> assessmentProgress) {
            return assessmentProgress(ReplicationTaskAssessmentRunProgress.builder().applyMutation(assessmentProgress).build());
        }

        /**
         * <p>
         * Last message generated by an individual assessment failure.
         * </p>
         * 
         * @param lastFailureMessage
         *        Last message generated by an individual assessment failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastFailureMessage(String lastFailureMessage);

        /**
         * <p>
         * ARN of the service role used to start the assessment run using the
         * <code>StartReplicationTaskAssessmentRun</code> operation. The role must allow the <code>iam:PassRole</code>
         * action.
         * </p>
         * 
         * @param serviceAccessRoleArn
         *        ARN of the service role used to start the assessment run using the
         *        <code>StartReplicationTaskAssessmentRun</code> operation. The role must allow the
         *        <code>iam:PassRole</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccessRoleArn(String serviceAccessRoleArn);

        /**
         * <p>
         * Amazon S3 bucket where DMS stores the results of this assessment run.
         * </p>
         * 
         * @param resultLocationBucket
         *        Amazon S3 bucket where DMS stores the results of this assessment run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultLocationBucket(String resultLocationBucket);

        /**
         * <p>
         * Folder in an Amazon S3 bucket where DMS stores the results of this assessment run.
         * </p>
         * 
         * @param resultLocationFolder
         *        Folder in an Amazon S3 bucket where DMS stores the results of this assessment run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultLocationFolder(String resultLocationFolder);

        /**
         * <p>
         * Encryption mode used to encrypt the assessment run results.
         * </p>
         * 
         * @param resultEncryptionMode
         *        Encryption mode used to encrypt the assessment run results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultEncryptionMode(String resultEncryptionMode);

        /**
         * <p>
         * ARN of the KMS encryption key used to encrypt the assessment run results.
         * </p>
         * 
         * @param resultKmsKeyArn
         *        ARN of the KMS encryption key used to encrypt the assessment run results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultKmsKeyArn(String resultKmsKeyArn);

        /**
         * <p>
         * Unique name of the assessment run.
         * </p>
         * 
         * @param assessmentRunName
         *        Unique name of the assessment run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentRunName(String assessmentRunName);
    }

    static final class BuilderImpl implements Builder {
        private String replicationTaskAssessmentRunArn;

        private String replicationTaskArn;

        private String status;

        private Instant replicationTaskAssessmentRunCreationDate;

        private ReplicationTaskAssessmentRunProgress assessmentProgress;

        private String lastFailureMessage;

        private String serviceAccessRoleArn;

        private String resultLocationBucket;

        private String resultLocationFolder;

        private String resultEncryptionMode;

        private String resultKmsKeyArn;

        private String assessmentRunName;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationTaskAssessmentRun model) {
            replicationTaskAssessmentRunArn(model.replicationTaskAssessmentRunArn);
            replicationTaskArn(model.replicationTaskArn);
            status(model.status);
            replicationTaskAssessmentRunCreationDate(model.replicationTaskAssessmentRunCreationDate);
            assessmentProgress(model.assessmentProgress);
            lastFailureMessage(model.lastFailureMessage);
            serviceAccessRoleArn(model.serviceAccessRoleArn);
            resultLocationBucket(model.resultLocationBucket);
            resultLocationFolder(model.resultLocationFolder);
            resultEncryptionMode(model.resultEncryptionMode);
            resultKmsKeyArn(model.resultKmsKeyArn);
            assessmentRunName(model.assessmentRunName);
        }

        public final String getReplicationTaskAssessmentRunArn() {
            return replicationTaskAssessmentRunArn;
        }

        @Override
        public final Builder replicationTaskAssessmentRunArn(String replicationTaskAssessmentRunArn) {
            this.replicationTaskAssessmentRunArn = replicationTaskAssessmentRunArn;
            return this;
        }

        public final void setReplicationTaskAssessmentRunArn(String replicationTaskAssessmentRunArn) {
            this.replicationTaskAssessmentRunArn = replicationTaskAssessmentRunArn;
        }

        public final String getReplicationTaskArn() {
            return replicationTaskArn;
        }

        @Override
        public final Builder replicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
            return this;
        }

        public final void setReplicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getReplicationTaskAssessmentRunCreationDate() {
            return replicationTaskAssessmentRunCreationDate;
        }

        @Override
        public final Builder replicationTaskAssessmentRunCreationDate(Instant replicationTaskAssessmentRunCreationDate) {
            this.replicationTaskAssessmentRunCreationDate = replicationTaskAssessmentRunCreationDate;
            return this;
        }

        public final void setReplicationTaskAssessmentRunCreationDate(Instant replicationTaskAssessmentRunCreationDate) {
            this.replicationTaskAssessmentRunCreationDate = replicationTaskAssessmentRunCreationDate;
        }

        public final ReplicationTaskAssessmentRunProgress.Builder getAssessmentProgress() {
            return assessmentProgress != null ? assessmentProgress.toBuilder() : null;
        }

        @Override
        public final Builder assessmentProgress(ReplicationTaskAssessmentRunProgress assessmentProgress) {
            this.assessmentProgress = assessmentProgress;
            return this;
        }

        public final void setAssessmentProgress(ReplicationTaskAssessmentRunProgress.BuilderImpl assessmentProgress) {
            this.assessmentProgress = assessmentProgress != null ? assessmentProgress.build() : null;
        }

        public final String getLastFailureMessage() {
            return lastFailureMessage;
        }

        @Override
        public final Builder lastFailureMessage(String lastFailureMessage) {
            this.lastFailureMessage = lastFailureMessage;
            return this;
        }

        public final void setLastFailureMessage(String lastFailureMessage) {
            this.lastFailureMessage = lastFailureMessage;
        }

        public final String getServiceAccessRoleArn() {
            return serviceAccessRoleArn;
        }

        @Override
        public final Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        public final void setServiceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
        }

        public final String getResultLocationBucket() {
            return resultLocationBucket;
        }

        @Override
        public final Builder resultLocationBucket(String resultLocationBucket) {
            this.resultLocationBucket = resultLocationBucket;
            return this;
        }

        public final void setResultLocationBucket(String resultLocationBucket) {
            this.resultLocationBucket = resultLocationBucket;
        }

        public final String getResultLocationFolder() {
            return resultLocationFolder;
        }

        @Override
        public final Builder resultLocationFolder(String resultLocationFolder) {
            this.resultLocationFolder = resultLocationFolder;
            return this;
        }

        public final void setResultLocationFolder(String resultLocationFolder) {
            this.resultLocationFolder = resultLocationFolder;
        }

        public final String getResultEncryptionMode() {
            return resultEncryptionMode;
        }

        @Override
        public final Builder resultEncryptionMode(String resultEncryptionMode) {
            this.resultEncryptionMode = resultEncryptionMode;
            return this;
        }

        public final void setResultEncryptionMode(String resultEncryptionMode) {
            this.resultEncryptionMode = resultEncryptionMode;
        }

        public final String getResultKmsKeyArn() {
            return resultKmsKeyArn;
        }

        @Override
        public final Builder resultKmsKeyArn(String resultKmsKeyArn) {
            this.resultKmsKeyArn = resultKmsKeyArn;
            return this;
        }

        public final void setResultKmsKeyArn(String resultKmsKeyArn) {
            this.resultKmsKeyArn = resultKmsKeyArn;
        }

        public final String getAssessmentRunName() {
            return assessmentRunName;
        }

        @Override
        public final Builder assessmentRunName(String assessmentRunName) {
            this.assessmentRunName = assessmentRunName;
            return this;
        }

        public final void setAssessmentRunName(String assessmentRunName) {
            this.assessmentRunName = assessmentRunName;
        }

        @Override
        public ReplicationTaskAssessmentRun build() {
            return new ReplicationTaskAssessmentRun(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
