/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEndpointSettingsResponse extends DatabaseMigrationResponse implements
        ToCopyableBuilder<DescribeEndpointSettingsResponse.Builder, DescribeEndpointSettingsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeEndpointSettingsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<EndpointSetting>> ENDPOINT_SETTINGS_FIELD = SdkField
            .<List<EndpointSetting>> builder(MarshallingType.LIST)
            .memberName("EndpointSettings")
            .getter(getter(DescribeEndpointSettingsResponse::endpointSettings))
            .setter(setter(Builder::endpointSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EndpointSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(EndpointSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            ENDPOINT_SETTINGS_FIELD));

    private final String marker;

    private final List<EndpointSetting> endpointSettings;

    private DescribeEndpointSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.endpointSettings = builder.endpointSettings;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the EndpointSettings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEndpointSettings() {
        return endpointSettings != null && !(endpointSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Descriptions of the endpoint settings available for your source or target database engine.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEndpointSettings} method.
     * </p>
     * 
     * @return Descriptions of the endpoint settings available for your source or target database engine.
     */
    public final List<EndpointSetting> endpointSettings() {
        return endpointSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasEndpointSettings() ? endpointSettings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEndpointSettingsResponse)) {
            return false;
        }
        DescribeEndpointSettingsResponse other = (DescribeEndpointSettingsResponse) obj;
        return Objects.equals(marker(), other.marker()) && hasEndpointSettings() == other.hasEndpointSettings()
                && Objects.equals(endpointSettings(), other.endpointSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEndpointSettingsResponse").add("Marker", marker())
                .add("EndpointSettings", hasEndpointSettings() ? endpointSettings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "EndpointSettings":
            return Optional.ofNullable(clazz.cast(endpointSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEndpointSettingsResponse, T> g) {
        return obj -> g.apply((DescribeEndpointSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeEndpointSettingsResponse> {
        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Descriptions of the endpoint settings available for your source or target database engine.
         * </p>
         * 
         * @param endpointSettings
         *        Descriptions of the endpoint settings available for your source or target database engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointSettings(Collection<EndpointSetting> endpointSettings);

        /**
         * <p>
         * Descriptions of the endpoint settings available for your source or target database engine.
         * </p>
         * 
         * @param endpointSettings
         *        Descriptions of the endpoint settings available for your source or target database engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointSettings(EndpointSetting... endpointSettings);

        /**
         * <p>
         * Descriptions of the endpoint settings available for your source or target database engine.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EndpointSetting>.Builder} avoiding the need
         * to create one manually via {@link List<EndpointSetting>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EndpointSetting>.Builder#build()} is called immediately and
         * its result is passed to {@link #endpointSettings(List<EndpointSetting>)}.
         * 
         * @param endpointSettings
         *        a consumer that will call methods on {@link List<EndpointSetting>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointSettings(List<EndpointSetting>)
         */
        Builder endpointSettings(Consumer<EndpointSetting.Builder>... endpointSettings);
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private String marker;

        private List<EndpointSetting> endpointSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEndpointSettingsResponse model) {
            super(model);
            marker(model.marker);
            endpointSettings(model.endpointSettings);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<EndpointSetting.Builder> getEndpointSettings() {
            List<EndpointSetting.Builder> result = EndpointSettingsListCopier.copyToBuilder(this.endpointSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEndpointSettings(Collection<EndpointSetting.BuilderImpl> endpointSettings) {
            this.endpointSettings = EndpointSettingsListCopier.copyFromBuilder(endpointSettings);
        }

        @Override
        @Transient
        public final Builder endpointSettings(Collection<EndpointSetting> endpointSettings) {
            this.endpointSettings = EndpointSettingsListCopier.copy(endpointSettings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder endpointSettings(EndpointSetting... endpointSettings) {
            endpointSettings(Arrays.asList(endpointSettings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder endpointSettings(Consumer<EndpointSetting.Builder>... endpointSettings) {
            endpointSettings(Stream.of(endpointSettings).map(c -> EndpointSetting.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeEndpointSettingsResponse build() {
            return new DescribeEndpointSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
