/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information that describes an Amazon Kinesis Data Stream endpoint. This information includes the output
 * format of records applied to the endpoint and details of transaction and control table data information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KinesisSettings implements SdkPojo, Serializable, ToCopyableBuilder<KinesisSettings.Builder, KinesisSettings> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamArn").getter(getter(KinesisSettings::streamArn)).setter(setter(Builder::streamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamArn").build()).build();

    private static final SdkField<String> MESSAGE_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageFormat").getter(getter(KinesisSettings::messageFormatAsString))
            .setter(setter(Builder::messageFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageFormat").build()).build();

    private static final SdkField<String> SERVICE_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceAccessRoleArn").getter(getter(KinesisSettings::serviceAccessRoleArn))
            .setter(setter(Builder::serviceAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccessRoleArn").build())
            .build();

    private static final SdkField<Boolean> INCLUDE_TRANSACTION_DETAILS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("IncludeTransactionDetails")
            .getter(getter(KinesisSettings::includeTransactionDetails)).setter(setter(Builder::includeTransactionDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeTransactionDetails").build())
            .build();

    private static final SdkField<Boolean> INCLUDE_PARTITION_VALUE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludePartitionValue").getter(getter(KinesisSettings::includePartitionValue))
            .setter(setter(Builder::includePartitionValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludePartitionValue").build())
            .build();

    private static final SdkField<Boolean> PARTITION_INCLUDE_SCHEMA_TABLE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PartitionIncludeSchemaTable")
            .getter(getter(KinesisSettings::partitionIncludeSchemaTable))
            .setter(setter(Builder::partitionIncludeSchemaTable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionIncludeSchemaTable")
                    .build()).build();

    private static final SdkField<Boolean> INCLUDE_TABLE_ALTER_OPERATIONS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeTableAlterOperations")
            .getter(getter(KinesisSettings::includeTableAlterOperations))
            .setter(setter(Builder::includeTableAlterOperations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeTableAlterOperations")
                    .build()).build();

    private static final SdkField<Boolean> INCLUDE_CONTROL_DETAILS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeControlDetails").getter(getter(KinesisSettings::includeControlDetails))
            .setter(setter(Builder::includeControlDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeControlDetails").build())
            .build();

    private static final SdkField<Boolean> INCLUDE_NULL_AND_EMPTY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeNullAndEmpty").getter(getter(KinesisSettings::includeNullAndEmpty))
            .setter(setter(Builder::includeNullAndEmpty))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeNullAndEmpty").build())
            .build();

    private static final SdkField<Boolean> NO_HEX_PREFIX_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("NoHexPrefix").getter(getter(KinesisSettings::noHexPrefix)).setter(setter(Builder::noHexPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoHexPrefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD,
            MESSAGE_FORMAT_FIELD, SERVICE_ACCESS_ROLE_ARN_FIELD, INCLUDE_TRANSACTION_DETAILS_FIELD,
            INCLUDE_PARTITION_VALUE_FIELD, PARTITION_INCLUDE_SCHEMA_TABLE_FIELD, INCLUDE_TABLE_ALTER_OPERATIONS_FIELD,
            INCLUDE_CONTROL_DETAILS_FIELD, INCLUDE_NULL_AND_EMPTY_FIELD, NO_HEX_PREFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String streamArn;

    private final String messageFormat;

    private final String serviceAccessRoleArn;

    private final Boolean includeTransactionDetails;

    private final Boolean includePartitionValue;

    private final Boolean partitionIncludeSchemaTable;

    private final Boolean includeTableAlterOperations;

    private final Boolean includeControlDetails;

    private final Boolean includeNullAndEmpty;

    private final Boolean noHexPrefix;

    private KinesisSettings(BuilderImpl builder) {
        this.streamArn = builder.streamArn;
        this.messageFormat = builder.messageFormat;
        this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
        this.includeTransactionDetails = builder.includeTransactionDetails;
        this.includePartitionValue = builder.includePartitionValue;
        this.partitionIncludeSchemaTable = builder.partitionIncludeSchemaTable;
        this.includeTableAlterOperations = builder.includeTableAlterOperations;
        this.includeControlDetails = builder.includeControlDetails;
        this.includeNullAndEmpty = builder.includeNullAndEmpty;
        this.noHexPrefix = builder.noHexPrefix;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the Amazon Kinesis Data Streams endpoint.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the Amazon Kinesis Data Streams endpoint.
     */
    public final String streamArn() {
        return streamArn;
    }

    /**
     * <p>
     * The output format for the records created on the endpoint. The message format is <code>JSON</code> (default) or
     * <code>JSON_UNFORMATTED</code> (a single line with no tab).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageFormat}
     * will return {@link MessageFormatValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #messageFormatAsString}.
     * </p>
     * 
     * @return The output format for the records created on the endpoint. The message format is <code>JSON</code>
     *         (default) or <code>JSON_UNFORMATTED</code> (a single line with no tab).
     * @see MessageFormatValue
     */
    public final MessageFormatValue messageFormat() {
        return MessageFormatValue.fromValue(messageFormat);
    }

    /**
     * <p>
     * The output format for the records created on the endpoint. The message format is <code>JSON</code> (default) or
     * <code>JSON_UNFORMATTED</code> (a single line with no tab).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageFormat}
     * will return {@link MessageFormatValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #messageFormatAsString}.
     * </p>
     * 
     * @return The output format for the records created on the endpoint. The message format is <code>JSON</code>
     *         (default) or <code>JSON_UNFORMATTED</code> (a single line with no tab).
     * @see MessageFormatValue
     */
    public final String messageFormatAsString() {
        return messageFormat;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the IAM role that DMS uses to write to the Kinesis data stream. The role must
     * allow the <code>iam:PassRole</code> action.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the IAM role that DMS uses to write to the Kinesis data stream. The
     *         role must allow the <code>iam:PassRole</code> action.
     */
    public final String serviceAccessRoleArn() {
        return serviceAccessRoleArn;
    }

    /**
     * <p>
     * Provides detailed transaction information from the source database. This information includes a commit timestamp,
     * a log position, and values for <code>transaction_id</code>, previous <code>transaction_id</code>, and
     * <code>transaction_record_id</code> (the record offset within a transaction). The default is <code>false</code>.
     * </p>
     * 
     * @return Provides detailed transaction information from the source database. This information includes a commit
     *         timestamp, a log position, and values for <code>transaction_id</code>, previous
     *         <code>transaction_id</code>, and <code>transaction_record_id</code> (the record offset within a
     *         transaction). The default is <code>false</code>.
     */
    public final Boolean includeTransactionDetails() {
        return includeTransactionDetails;
    }

    /**
     * <p>
     * Shows the partition value within the Kinesis message output, unless the partition type is
     * <code>schema-table-type</code>. The default is <code>false</code>.
     * </p>
     * 
     * @return Shows the partition value within the Kinesis message output, unless the partition type is
     *         <code>schema-table-type</code>. The default is <code>false</code>.
     */
    public final Boolean includePartitionValue() {
        return includePartitionValue;
    }

    /**
     * <p>
     * Prefixes schema and table names to partition values, when the partition type is <code>primary-key-type</code>.
     * Doing this increases data distribution among Kinesis shards. For example, suppose that a SysBench schema has
     * thousands of tables and each table has only limited range for a primary key. In this case, the same primary key
     * is sent from thousands of tables to the same shard, which causes throttling. The default is <code>false</code>.
     * </p>
     * 
     * @return Prefixes schema and table names to partition values, when the partition type is
     *         <code>primary-key-type</code>. Doing this increases data distribution among Kinesis shards. For example,
     *         suppose that a SysBench schema has thousands of tables and each table has only limited range for a
     *         primary key. In this case, the same primary key is sent from thousands of tables to the same shard, which
     *         causes throttling. The default is <code>false</code>.
     */
    public final Boolean partitionIncludeSchemaTable() {
        return partitionIncludeSchemaTable;
    }

    /**
     * <p>
     * Includes any data definition language (DDL) operations that change the table in the control data, such as
     * <code>rename-table</code>, <code>drop-table</code>, <code>add-column</code>, <code>drop-column</code>, and
     * <code>rename-column</code>. The default is <code>false</code>.
     * </p>
     * 
     * @return Includes any data definition language (DDL) operations that change the table in the control data, such as
     *         <code>rename-table</code>, <code>drop-table</code>, <code>add-column</code>, <code>drop-column</code>,
     *         and <code>rename-column</code>. The default is <code>false</code>.
     */
    public final Boolean includeTableAlterOperations() {
        return includeTableAlterOperations;
    }

    /**
     * <p>
     * Shows detailed control information for table definition, column definition, and table and column changes in the
     * Kinesis message output. The default is <code>false</code>.
     * </p>
     * 
     * @return Shows detailed control information for table definition, column definition, and table and column changes
     *         in the Kinesis message output. The default is <code>false</code>.
     */
    public final Boolean includeControlDetails() {
        return includeControlDetails;
    }

    /**
     * <p>
     * Include NULL and empty columns for records migrated to the endpoint. The default is <code>false</code>.
     * </p>
     * 
     * @return Include NULL and empty columns for records migrated to the endpoint. The default is <code>false</code>.
     */
    public final Boolean includeNullAndEmpty() {
        return includeNullAndEmpty;
    }

    /**
     * <p>
     * Set this optional parameter to <code>true</code> to avoid adding a '0x' prefix to raw data in hexadecimal format.
     * For example, by default, DMS adds a '0x' prefix to the LOB column type in hexadecimal format moving from an
     * Oracle source to an Amazon Kinesis target. Use the <code>NoHexPrefix</code> endpoint setting to enable migration
     * of RAW data type columns without adding the '0x' prefix.
     * </p>
     * 
     * @return Set this optional parameter to <code>true</code> to avoid adding a '0x' prefix to raw data in hexadecimal
     *         format. For example, by default, DMS adds a '0x' prefix to the LOB column type in hexadecimal format
     *         moving from an Oracle source to an Amazon Kinesis target. Use the <code>NoHexPrefix</code> endpoint
     *         setting to enable migration of RAW data type columns without adding the '0x' prefix.
     */
    public final Boolean noHexPrefix() {
        return noHexPrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(messageFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(includeTransactionDetails());
        hashCode = 31 * hashCode + Objects.hashCode(includePartitionValue());
        hashCode = 31 * hashCode + Objects.hashCode(partitionIncludeSchemaTable());
        hashCode = 31 * hashCode + Objects.hashCode(includeTableAlterOperations());
        hashCode = 31 * hashCode + Objects.hashCode(includeControlDetails());
        hashCode = 31 * hashCode + Objects.hashCode(includeNullAndEmpty());
        hashCode = 31 * hashCode + Objects.hashCode(noHexPrefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisSettings)) {
            return false;
        }
        KinesisSettings other = (KinesisSettings) obj;
        return Objects.equals(streamArn(), other.streamArn())
                && Objects.equals(messageFormatAsString(), other.messageFormatAsString())
                && Objects.equals(serviceAccessRoleArn(), other.serviceAccessRoleArn())
                && Objects.equals(includeTransactionDetails(), other.includeTransactionDetails())
                && Objects.equals(includePartitionValue(), other.includePartitionValue())
                && Objects.equals(partitionIncludeSchemaTable(), other.partitionIncludeSchemaTable())
                && Objects.equals(includeTableAlterOperations(), other.includeTableAlterOperations())
                && Objects.equals(includeControlDetails(), other.includeControlDetails())
                && Objects.equals(includeNullAndEmpty(), other.includeNullAndEmpty())
                && Objects.equals(noHexPrefix(), other.noHexPrefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KinesisSettings").add("StreamArn", streamArn()).add("MessageFormat", messageFormatAsString())
                .add("ServiceAccessRoleArn", serviceAccessRoleArn())
                .add("IncludeTransactionDetails", includeTransactionDetails())
                .add("IncludePartitionValue", includePartitionValue())
                .add("PartitionIncludeSchemaTable", partitionIncludeSchemaTable())
                .add("IncludeTableAlterOperations", includeTableAlterOperations())
                .add("IncludeControlDetails", includeControlDetails()).add("IncludeNullAndEmpty", includeNullAndEmpty())
                .add("NoHexPrefix", noHexPrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamArn":
            return Optional.ofNullable(clazz.cast(streamArn()));
        case "MessageFormat":
            return Optional.ofNullable(clazz.cast(messageFormatAsString()));
        case "ServiceAccessRoleArn":
            return Optional.ofNullable(clazz.cast(serviceAccessRoleArn()));
        case "IncludeTransactionDetails":
            return Optional.ofNullable(clazz.cast(includeTransactionDetails()));
        case "IncludePartitionValue":
            return Optional.ofNullable(clazz.cast(includePartitionValue()));
        case "PartitionIncludeSchemaTable":
            return Optional.ofNullable(clazz.cast(partitionIncludeSchemaTable()));
        case "IncludeTableAlterOperations":
            return Optional.ofNullable(clazz.cast(includeTableAlterOperations()));
        case "IncludeControlDetails":
            return Optional.ofNullable(clazz.cast(includeControlDetails()));
        case "IncludeNullAndEmpty":
            return Optional.ofNullable(clazz.cast(includeNullAndEmpty()));
        case "NoHexPrefix":
            return Optional.ofNullable(clazz.cast(noHexPrefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KinesisSettings, T> g) {
        return obj -> g.apply((KinesisSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KinesisSettings> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the Amazon Kinesis Data Streams endpoint.
         * </p>
         * 
         * @param streamArn
         *        The Amazon Resource Name (ARN) for the Amazon Kinesis Data Streams endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamArn(String streamArn);

        /**
         * <p>
         * The output format for the records created on the endpoint. The message format is <code>JSON</code> (default)
         * or <code>JSON_UNFORMATTED</code> (a single line with no tab).
         * </p>
         * 
         * @param messageFormat
         *        The output format for the records created on the endpoint. The message format is <code>JSON</code>
         *        (default) or <code>JSON_UNFORMATTED</code> (a single line with no tab).
         * @see MessageFormatValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageFormatValue
         */
        Builder messageFormat(String messageFormat);

        /**
         * <p>
         * The output format for the records created on the endpoint. The message format is <code>JSON</code> (default)
         * or <code>JSON_UNFORMATTED</code> (a single line with no tab).
         * </p>
         * 
         * @param messageFormat
         *        The output format for the records created on the endpoint. The message format is <code>JSON</code>
         *        (default) or <code>JSON_UNFORMATTED</code> (a single line with no tab).
         * @see MessageFormatValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageFormatValue
         */
        Builder messageFormat(MessageFormatValue messageFormat);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the IAM role that DMS uses to write to the Kinesis data stream. The role
         * must allow the <code>iam:PassRole</code> action.
         * </p>
         * 
         * @param serviceAccessRoleArn
         *        The Amazon Resource Name (ARN) for the IAM role that DMS uses to write to the Kinesis data stream. The
         *        role must allow the <code>iam:PassRole</code> action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccessRoleArn(String serviceAccessRoleArn);

        /**
         * <p>
         * Provides detailed transaction information from the source database. This information includes a commit
         * timestamp, a log position, and values for <code>transaction_id</code>, previous <code>transaction_id</code>,
         * and <code>transaction_record_id</code> (the record offset within a transaction). The default is
         * <code>false</code>.
         * </p>
         * 
         * @param includeTransactionDetails
         *        Provides detailed transaction information from the source database. This information includes a commit
         *        timestamp, a log position, and values for <code>transaction_id</code>, previous
         *        <code>transaction_id</code>, and <code>transaction_record_id</code> (the record offset within a
         *        transaction). The default is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeTransactionDetails(Boolean includeTransactionDetails);

        /**
         * <p>
         * Shows the partition value within the Kinesis message output, unless the partition type is
         * <code>schema-table-type</code>. The default is <code>false</code>.
         * </p>
         * 
         * @param includePartitionValue
         *        Shows the partition value within the Kinesis message output, unless the partition type is
         *        <code>schema-table-type</code>. The default is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includePartitionValue(Boolean includePartitionValue);

        /**
         * <p>
         * Prefixes schema and table names to partition values, when the partition type is <code>primary-key-type</code>
         * . Doing this increases data distribution among Kinesis shards. For example, suppose that a SysBench schema
         * has thousands of tables and each table has only limited range for a primary key. In this case, the same
         * primary key is sent from thousands of tables to the same shard, which causes throttling. The default is
         * <code>false</code>.
         * </p>
         * 
         * @param partitionIncludeSchemaTable
         *        Prefixes schema and table names to partition values, when the partition type is
         *        <code>primary-key-type</code>. Doing this increases data distribution among Kinesis shards. For
         *        example, suppose that a SysBench schema has thousands of tables and each table has only limited range
         *        for a primary key. In this case, the same primary key is sent from thousands of tables to the same
         *        shard, which causes throttling. The default is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionIncludeSchemaTable(Boolean partitionIncludeSchemaTable);

        /**
         * <p>
         * Includes any data definition language (DDL) operations that change the table in the control data, such as
         * <code>rename-table</code>, <code>drop-table</code>, <code>add-column</code>, <code>drop-column</code>, and
         * <code>rename-column</code>. The default is <code>false</code>.
         * </p>
         * 
         * @param includeTableAlterOperations
         *        Includes any data definition language (DDL) operations that change the table in the control data, such
         *        as <code>rename-table</code>, <code>drop-table</code>, <code>add-column</code>,
         *        <code>drop-column</code>, and <code>rename-column</code>. The default is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeTableAlterOperations(Boolean includeTableAlterOperations);

        /**
         * <p>
         * Shows detailed control information for table definition, column definition, and table and column changes in
         * the Kinesis message output. The default is <code>false</code>.
         * </p>
         * 
         * @param includeControlDetails
         *        Shows detailed control information for table definition, column definition, and table and column
         *        changes in the Kinesis message output. The default is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeControlDetails(Boolean includeControlDetails);

        /**
         * <p>
         * Include NULL and empty columns for records migrated to the endpoint. The default is <code>false</code>.
         * </p>
         * 
         * @param includeNullAndEmpty
         *        Include NULL and empty columns for records migrated to the endpoint. The default is <code>false</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeNullAndEmpty(Boolean includeNullAndEmpty);

        /**
         * <p>
         * Set this optional parameter to <code>true</code> to avoid adding a '0x' prefix to raw data in hexadecimal
         * format. For example, by default, DMS adds a '0x' prefix to the LOB column type in hexadecimal format moving
         * from an Oracle source to an Amazon Kinesis target. Use the <code>NoHexPrefix</code> endpoint setting to
         * enable migration of RAW data type columns without adding the '0x' prefix.
         * </p>
         * 
         * @param noHexPrefix
         *        Set this optional parameter to <code>true</code> to avoid adding a '0x' prefix to raw data in
         *        hexadecimal format. For example, by default, DMS adds a '0x' prefix to the LOB column type in
         *        hexadecimal format moving from an Oracle source to an Amazon Kinesis target. Use the
         *        <code>NoHexPrefix</code> endpoint setting to enable migration of RAW data type columns without adding
         *        the '0x' prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noHexPrefix(Boolean noHexPrefix);
    }

    static final class BuilderImpl implements Builder {
        private String streamArn;

        private String messageFormat;

        private String serviceAccessRoleArn;

        private Boolean includeTransactionDetails;

        private Boolean includePartitionValue;

        private Boolean partitionIncludeSchemaTable;

        private Boolean includeTableAlterOperations;

        private Boolean includeControlDetails;

        private Boolean includeNullAndEmpty;

        private Boolean noHexPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisSettings model) {
            streamArn(model.streamArn);
            messageFormat(model.messageFormat);
            serviceAccessRoleArn(model.serviceAccessRoleArn);
            includeTransactionDetails(model.includeTransactionDetails);
            includePartitionValue(model.includePartitionValue);
            partitionIncludeSchemaTable(model.partitionIncludeSchemaTable);
            includeTableAlterOperations(model.includeTableAlterOperations);
            includeControlDetails(model.includeControlDetails);
            includeNullAndEmpty(model.includeNullAndEmpty);
            noHexPrefix(model.noHexPrefix);
        }

        public final String getStreamArn() {
            return streamArn;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        @Override
        @Transient
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final String getMessageFormat() {
            return messageFormat;
        }

        public final void setMessageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
        }

        @Override
        @Transient
        public final Builder messageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
            return this;
        }

        @Override
        @Transient
        public final Builder messageFormat(MessageFormatValue messageFormat) {
            this.messageFormat(messageFormat == null ? null : messageFormat.toString());
            return this;
        }

        public final String getServiceAccessRoleArn() {
            return serviceAccessRoleArn;
        }

        public final void setServiceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
        }

        @Override
        @Transient
        public final Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        public final Boolean getIncludeTransactionDetails() {
            return includeTransactionDetails;
        }

        public final void setIncludeTransactionDetails(Boolean includeTransactionDetails) {
            this.includeTransactionDetails = includeTransactionDetails;
        }

        @Override
        @Transient
        public final Builder includeTransactionDetails(Boolean includeTransactionDetails) {
            this.includeTransactionDetails = includeTransactionDetails;
            return this;
        }

        public final Boolean getIncludePartitionValue() {
            return includePartitionValue;
        }

        public final void setIncludePartitionValue(Boolean includePartitionValue) {
            this.includePartitionValue = includePartitionValue;
        }

        @Override
        @Transient
        public final Builder includePartitionValue(Boolean includePartitionValue) {
            this.includePartitionValue = includePartitionValue;
            return this;
        }

        public final Boolean getPartitionIncludeSchemaTable() {
            return partitionIncludeSchemaTable;
        }

        public final void setPartitionIncludeSchemaTable(Boolean partitionIncludeSchemaTable) {
            this.partitionIncludeSchemaTable = partitionIncludeSchemaTable;
        }

        @Override
        @Transient
        public final Builder partitionIncludeSchemaTable(Boolean partitionIncludeSchemaTable) {
            this.partitionIncludeSchemaTable = partitionIncludeSchemaTable;
            return this;
        }

        public final Boolean getIncludeTableAlterOperations() {
            return includeTableAlterOperations;
        }

        public final void setIncludeTableAlterOperations(Boolean includeTableAlterOperations) {
            this.includeTableAlterOperations = includeTableAlterOperations;
        }

        @Override
        @Transient
        public final Builder includeTableAlterOperations(Boolean includeTableAlterOperations) {
            this.includeTableAlterOperations = includeTableAlterOperations;
            return this;
        }

        public final Boolean getIncludeControlDetails() {
            return includeControlDetails;
        }

        public final void setIncludeControlDetails(Boolean includeControlDetails) {
            this.includeControlDetails = includeControlDetails;
        }

        @Override
        @Transient
        public final Builder includeControlDetails(Boolean includeControlDetails) {
            this.includeControlDetails = includeControlDetails;
            return this;
        }

        public final Boolean getIncludeNullAndEmpty() {
            return includeNullAndEmpty;
        }

        public final void setIncludeNullAndEmpty(Boolean includeNullAndEmpty) {
            this.includeNullAndEmpty = includeNullAndEmpty;
        }

        @Override
        @Transient
        public final Builder includeNullAndEmpty(Boolean includeNullAndEmpty) {
            this.includeNullAndEmpty = includeNullAndEmpty;
            return this;
        }

        public final Boolean getNoHexPrefix() {
            return noHexPrefix;
        }

        public final void setNoHexPrefix(Boolean noHexPrefix) {
            this.noHexPrefix = noHexPrefix;
        }

        @Override
        @Transient
        public final Builder noHexPrefix(Boolean noHexPrefix) {
            this.noHexPrefix = noHexPrefix;
            return this;
        }

        @Override
        public KinesisSettings build() {
            return new KinesisSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
