/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartReplicationTaskRequest extends DatabaseMigrationRequest implements
        ToCopyableBuilder<StartReplicationTaskRequest.Builder, StartReplicationTaskRequest> {
    private static final SdkField<String> REPLICATION_TASK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationTaskArn").getter(getter(StartReplicationTaskRequest::replicationTaskArn))
            .setter(setter(Builder::replicationTaskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskArn").build())
            .build();

    private static final SdkField<String> START_REPLICATION_TASK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartReplicationTaskType").getter(getter(StartReplicationTaskRequest::startReplicationTaskTypeAsString))
            .setter(setter(Builder::startReplicationTaskType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartReplicationTaskType").build())
            .build();

    private static final SdkField<Instant> CDC_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CdcStartTime").getter(getter(StartReplicationTaskRequest::cdcStartTime))
            .setter(setter(Builder::cdcStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcStartTime").build()).build();

    private static final SdkField<String> CDC_START_POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CdcStartPosition").getter(getter(StartReplicationTaskRequest::cdcStartPosition))
            .setter(setter(Builder::cdcStartPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcStartPosition").build()).build();

    private static final SdkField<String> CDC_STOP_POSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CdcStopPosition").getter(getter(StartReplicationTaskRequest::cdcStopPosition))
            .setter(setter(Builder::cdcStopPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcStopPosition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_TASK_ARN_FIELD,
            START_REPLICATION_TASK_TYPE_FIELD, CDC_START_TIME_FIELD, CDC_START_POSITION_FIELD, CDC_STOP_POSITION_FIELD));

    private final String replicationTaskArn;

    private final String startReplicationTaskType;

    private final Instant cdcStartTime;

    private final String cdcStartPosition;

    private final String cdcStopPosition;

    private StartReplicationTaskRequest(BuilderImpl builder) {
        super(builder);
        this.replicationTaskArn = builder.replicationTaskArn;
        this.startReplicationTaskType = builder.startReplicationTaskType;
        this.cdcStartTime = builder.cdcStartTime;
        this.cdcStartPosition = builder.cdcStartPosition;
        this.cdcStopPosition = builder.cdcStopPosition;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the replication task to be started.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the replication task to be started.
     */
    public final String replicationTaskArn() {
        return replicationTaskArn;
    }

    /**
     * <p>
     * The type of replication task to start.
     * </p>
     * <p>
     * When the migration type is <code>full-load</code> or <code>full-load-and-cdc</code>, the only valid value for the
     * first run of the task is <code>start-replication</code>. You use <code>reload-target</code> to restart the task
     * and <code>resume-processing</code> to resume the task.
     * </p>
     * <p>
     * When the migration type is <code>cdc</code>, you use <code>start-replication</code> to start or restart the task,
     * and <code>resume-processing</code> to resume the task. <code>reload-target</code> is not a valid value for a task
     * with migration type of <code>cdc</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #startReplicationTaskType} will return {@link StartReplicationTaskTypeValue#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #startReplicationTaskTypeAsString}.
     * </p>
     * 
     * @return The type of replication task to start.</p>
     *         <p>
     *         When the migration type is <code>full-load</code> or <code>full-load-and-cdc</code>, the only valid value
     *         for the first run of the task is <code>start-replication</code>. You use <code>reload-target</code> to
     *         restart the task and <code>resume-processing</code> to resume the task.
     *         </p>
     *         <p>
     *         When the migration type is <code>cdc</code>, you use <code>start-replication</code> to start or restart
     *         the task, and <code>resume-processing</code> to resume the task. <code>reload-target</code> is not a
     *         valid value for a task with migration type of <code>cdc</code>.
     * @see StartReplicationTaskTypeValue
     */
    public final StartReplicationTaskTypeValue startReplicationTaskType() {
        return StartReplicationTaskTypeValue.fromValue(startReplicationTaskType);
    }

    /**
     * <p>
     * The type of replication task to start.
     * </p>
     * <p>
     * When the migration type is <code>full-load</code> or <code>full-load-and-cdc</code>, the only valid value for the
     * first run of the task is <code>start-replication</code>. You use <code>reload-target</code> to restart the task
     * and <code>resume-processing</code> to resume the task.
     * </p>
     * <p>
     * When the migration type is <code>cdc</code>, you use <code>start-replication</code> to start or restart the task,
     * and <code>resume-processing</code> to resume the task. <code>reload-target</code> is not a valid value for a task
     * with migration type of <code>cdc</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #startReplicationTaskType} will return {@link StartReplicationTaskTypeValue#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #startReplicationTaskTypeAsString}.
     * </p>
     * 
     * @return The type of replication task to start.</p>
     *         <p>
     *         When the migration type is <code>full-load</code> or <code>full-load-and-cdc</code>, the only valid value
     *         for the first run of the task is <code>start-replication</code>. You use <code>reload-target</code> to
     *         restart the task and <code>resume-processing</code> to resume the task.
     *         </p>
     *         <p>
     *         When the migration type is <code>cdc</code>, you use <code>start-replication</code> to start or restart
     *         the task, and <code>resume-processing</code> to resume the task. <code>reload-target</code> is not a
     *         valid value for a task with migration type of <code>cdc</code>.
     * @see StartReplicationTaskTypeValue
     */
    public final String startReplicationTaskTypeAsString() {
        return startReplicationTaskType;
    }

    /**
     * <p>
     * Indicates the start time for a change data capture (CDC) operation. Use either CdcStartTime or CdcStartPosition
     * to specify when you want a CDC operation to start. Specifying both values results in an error.
     * </p>
     * <p>
     * Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”
     * </p>
     * 
     * @return Indicates the start time for a change data capture (CDC) operation. Use either CdcStartTime or
     *         CdcStartPosition to specify when you want a CDC operation to start. Specifying both values results in an
     *         error.</p>
     *         <p>
     *         Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”
     */
    public final Instant cdcStartTime() {
        return cdcStartTime;
    }

    /**
     * <p>
     * Indicates when you want a change data capture (CDC) operation to start. Use either CdcStartPosition or
     * CdcStartTime to specify when you want a CDC operation to start. Specifying both values results in an error.
     * </p>
     * <p>
     * The value can be in date, checkpoint, or LSN/SCN format.
     * </p>
     * <p>
     * Date Example: --cdc-start-position “2018-03-08T12:12:12”
     * </p>
     * <p>
     * Checkpoint Example: --cdc-start-position
     * "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"
     * </p>
     * <p>
     * LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”
     * </p>
     * <note>
     * <p>
     * When you use this task setting with a source PostgreSQL database, a logical replication slot should already be
     * created and associated with the source endpoint. You can verify this by setting the <code>slotName</code> extra
     * connection attribute to the name of this logical replication slot. For more information, see <a href=
     * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib"
     * >Extra Connection Attributes When Using PostgreSQL as a Source for DMS</a>.
     * </p>
     * </note>
     * 
     * @return Indicates when you want a change data capture (CDC) operation to start. Use either CdcStartPosition or
     *         CdcStartTime to specify when you want a CDC operation to start. Specifying both values results in an
     *         error.</p>
     *         <p>
     *         The value can be in date, checkpoint, or LSN/SCN format.
     *         </p>
     *         <p>
     *         Date Example: --cdc-start-position “2018-03-08T12:12:12”
     *         </p>
     *         <p>
     *         Checkpoint Example: --cdc-start-position
     *         "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"
     *         </p>
     *         <p>
     *         LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”
     *         </p>
     *         <note>
     *         <p>
     *         When you use this task setting with a source PostgreSQL database, a logical replication slot should
     *         already be created and associated with the source endpoint. You can verify this by setting the
     *         <code>slotName</code> extra connection attribute to the name of this logical replication slot. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib"
     *         >Extra Connection Attributes When Using PostgreSQL as a Source for DMS</a>.
     *         </p>
     */
    public final String cdcStartPosition() {
        return cdcStartPosition;
    }

    /**
     * <p>
     * Indicates when you want a change data capture (CDC) operation to stop. The value can be either server time or
     * commit time.
     * </p>
     * <p>
     * Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”
     * </p>
     * <p>
     * Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “
     * </p>
     * 
     * @return Indicates when you want a change data capture (CDC) operation to stop. The value can be either server
     *         time or commit time.</p>
     *         <p>
     *         Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”
     *         </p>
     *         <p>
     *         Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “
     */
    public final String cdcStopPosition() {
        return cdcStopPosition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationTaskArn());
        hashCode = 31 * hashCode + Objects.hashCode(startReplicationTaskTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cdcStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(cdcStartPosition());
        hashCode = 31 * hashCode + Objects.hashCode(cdcStopPosition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartReplicationTaskRequest)) {
            return false;
        }
        StartReplicationTaskRequest other = (StartReplicationTaskRequest) obj;
        return Objects.equals(replicationTaskArn(), other.replicationTaskArn())
                && Objects.equals(startReplicationTaskTypeAsString(), other.startReplicationTaskTypeAsString())
                && Objects.equals(cdcStartTime(), other.cdcStartTime())
                && Objects.equals(cdcStartPosition(), other.cdcStartPosition())
                && Objects.equals(cdcStopPosition(), other.cdcStopPosition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartReplicationTaskRequest").add("ReplicationTaskArn", replicationTaskArn())
                .add("StartReplicationTaskType", startReplicationTaskTypeAsString()).add("CdcStartTime", cdcStartTime())
                .add("CdcStartPosition", cdcStartPosition()).add("CdcStopPosition", cdcStopPosition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationTaskArn":
            return Optional.ofNullable(clazz.cast(replicationTaskArn()));
        case "StartReplicationTaskType":
            return Optional.ofNullable(clazz.cast(startReplicationTaskTypeAsString()));
        case "CdcStartTime":
            return Optional.ofNullable(clazz.cast(cdcStartTime()));
        case "CdcStartPosition":
            return Optional.ofNullable(clazz.cast(cdcStartPosition()));
        case "CdcStopPosition":
            return Optional.ofNullable(clazz.cast(cdcStopPosition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartReplicationTaskRequest, T> g) {
        return obj -> g.apply((StartReplicationTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartReplicationTaskRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the replication task to be started.
         * </p>
         * 
         * @param replicationTaskArn
         *        The Amazon Resource Name (ARN) of the replication task to be started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskArn(String replicationTaskArn);

        /**
         * <p>
         * The type of replication task to start.
         * </p>
         * <p>
         * When the migration type is <code>full-load</code> or <code>full-load-and-cdc</code>, the only valid value for
         * the first run of the task is <code>start-replication</code>. You use <code>reload-target</code> to restart
         * the task and <code>resume-processing</code> to resume the task.
         * </p>
         * <p>
         * When the migration type is <code>cdc</code>, you use <code>start-replication</code> to start or restart the
         * task, and <code>resume-processing</code> to resume the task. <code>reload-target</code> is not a valid value
         * for a task with migration type of <code>cdc</code>.
         * </p>
         * 
         * @param startReplicationTaskType
         *        The type of replication task to start.</p>
         *        <p>
         *        When the migration type is <code>full-load</code> or <code>full-load-and-cdc</code>, the only valid
         *        value for the first run of the task is <code>start-replication</code>. You use
         *        <code>reload-target</code> to restart the task and <code>resume-processing</code> to resume the task.
         *        </p>
         *        <p>
         *        When the migration type is <code>cdc</code>, you use <code>start-replication</code> to start or
         *        restart the task, and <code>resume-processing</code> to resume the task. <code>reload-target</code> is
         *        not a valid value for a task with migration type of <code>cdc</code>.
         * @see StartReplicationTaskTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StartReplicationTaskTypeValue
         */
        Builder startReplicationTaskType(String startReplicationTaskType);

        /**
         * <p>
         * The type of replication task to start.
         * </p>
         * <p>
         * When the migration type is <code>full-load</code> or <code>full-load-and-cdc</code>, the only valid value for
         * the first run of the task is <code>start-replication</code>. You use <code>reload-target</code> to restart
         * the task and <code>resume-processing</code> to resume the task.
         * </p>
         * <p>
         * When the migration type is <code>cdc</code>, you use <code>start-replication</code> to start or restart the
         * task, and <code>resume-processing</code> to resume the task. <code>reload-target</code> is not a valid value
         * for a task with migration type of <code>cdc</code>.
         * </p>
         * 
         * @param startReplicationTaskType
         *        The type of replication task to start.</p>
         *        <p>
         *        When the migration type is <code>full-load</code> or <code>full-load-and-cdc</code>, the only valid
         *        value for the first run of the task is <code>start-replication</code>. You use
         *        <code>reload-target</code> to restart the task and <code>resume-processing</code> to resume the task.
         *        </p>
         *        <p>
         *        When the migration type is <code>cdc</code>, you use <code>start-replication</code> to start or
         *        restart the task, and <code>resume-processing</code> to resume the task. <code>reload-target</code> is
         *        not a valid value for a task with migration type of <code>cdc</code>.
         * @see StartReplicationTaskTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StartReplicationTaskTypeValue
         */
        Builder startReplicationTaskType(StartReplicationTaskTypeValue startReplicationTaskType);

        /**
         * <p>
         * Indicates the start time for a change data capture (CDC) operation. Use either CdcStartTime or
         * CdcStartPosition to specify when you want a CDC operation to start. Specifying both values results in an
         * error.
         * </p>
         * <p>
         * Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”
         * </p>
         * 
         * @param cdcStartTime
         *        Indicates the start time for a change data capture (CDC) operation. Use either CdcStartTime or
         *        CdcStartPosition to specify when you want a CDC operation to start. Specifying both values results in
         *        an error.</p>
         *        <p>
         *        Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdcStartTime(Instant cdcStartTime);

        /**
         * <p>
         * Indicates when you want a change data capture (CDC) operation to start. Use either CdcStartPosition or
         * CdcStartTime to specify when you want a CDC operation to start. Specifying both values results in an error.
         * </p>
         * <p>
         * The value can be in date, checkpoint, or LSN/SCN format.
         * </p>
         * <p>
         * Date Example: --cdc-start-position “2018-03-08T12:12:12”
         * </p>
         * <p>
         * Checkpoint Example: --cdc-start-position
         * "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"
         * </p>
         * <p>
         * LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”
         * </p>
         * <note>
         * <p>
         * When you use this task setting with a source PostgreSQL database, a logical replication slot should already
         * be created and associated with the source endpoint. You can verify this by setting the <code>slotName</code>
         * extra connection attribute to the name of this logical replication slot. For more information, see <a href=
         * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib"
         * >Extra Connection Attributes When Using PostgreSQL as a Source for DMS</a>.
         * </p>
         * </note>
         * 
         * @param cdcStartPosition
         *        Indicates when you want a change data capture (CDC) operation to start. Use either CdcStartPosition or
         *        CdcStartTime to specify when you want a CDC operation to start. Specifying both values results in an
         *        error.</p>
         *        <p>
         *        The value can be in date, checkpoint, or LSN/SCN format.
         *        </p>
         *        <p>
         *        Date Example: --cdc-start-position “2018-03-08T12:12:12”
         *        </p>
         *        <p>
         *        Checkpoint Example: --cdc-start-position
         *        "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"
         *        </p>
         *        <p>
         *        LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”
         *        </p>
         *        <note>
         *        <p>
         *        When you use this task setting with a source PostgreSQL database, a logical replication slot should
         *        already be created and associated with the source endpoint. You can verify this by setting the
         *        <code>slotName</code> extra connection attribute to the name of this logical replication slot. For
         *        more information, see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib"
         *        >Extra Connection Attributes When Using PostgreSQL as a Source for DMS</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdcStartPosition(String cdcStartPosition);

        /**
         * <p>
         * Indicates when you want a change data capture (CDC) operation to stop. The value can be either server time or
         * commit time.
         * </p>
         * <p>
         * Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”
         * </p>
         * <p>
         * Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “
         * </p>
         * 
         * @param cdcStopPosition
         *        Indicates when you want a change data capture (CDC) operation to stop. The value can be either server
         *        time or commit time.</p>
         *        <p>
         *        Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”
         *        </p>
         *        <p>
         *        Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12 “
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdcStopPosition(String cdcStopPosition);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DatabaseMigrationRequest.BuilderImpl implements Builder {
        private String replicationTaskArn;

        private String startReplicationTaskType;

        private Instant cdcStartTime;

        private String cdcStartPosition;

        private String cdcStopPosition;

        private BuilderImpl() {
        }

        private BuilderImpl(StartReplicationTaskRequest model) {
            super(model);
            replicationTaskArn(model.replicationTaskArn);
            startReplicationTaskType(model.startReplicationTaskType);
            cdcStartTime(model.cdcStartTime);
            cdcStartPosition(model.cdcStartPosition);
            cdcStopPosition(model.cdcStopPosition);
        }

        public final String getReplicationTaskArn() {
            return replicationTaskArn;
        }

        public final void setReplicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
        }

        @Override
        @Transient
        public final Builder replicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
            return this;
        }

        public final String getStartReplicationTaskType() {
            return startReplicationTaskType;
        }

        public final void setStartReplicationTaskType(String startReplicationTaskType) {
            this.startReplicationTaskType = startReplicationTaskType;
        }

        @Override
        @Transient
        public final Builder startReplicationTaskType(String startReplicationTaskType) {
            this.startReplicationTaskType = startReplicationTaskType;
            return this;
        }

        @Override
        @Transient
        public final Builder startReplicationTaskType(StartReplicationTaskTypeValue startReplicationTaskType) {
            this.startReplicationTaskType(startReplicationTaskType == null ? null : startReplicationTaskType.toString());
            return this;
        }

        public final Instant getCdcStartTime() {
            return cdcStartTime;
        }

        public final void setCdcStartTime(Instant cdcStartTime) {
            this.cdcStartTime = cdcStartTime;
        }

        @Override
        @Transient
        public final Builder cdcStartTime(Instant cdcStartTime) {
            this.cdcStartTime = cdcStartTime;
            return this;
        }

        public final String getCdcStartPosition() {
            return cdcStartPosition;
        }

        public final void setCdcStartPosition(String cdcStartPosition) {
            this.cdcStartPosition = cdcStartPosition;
        }

        @Override
        @Transient
        public final Builder cdcStartPosition(String cdcStartPosition) {
            this.cdcStartPosition = cdcStartPosition;
            return this;
        }

        public final String getCdcStopPosition() {
            return cdcStopPosition;
        }

        public final void setCdcStopPosition(String cdcStopPosition) {
            this.cdcStopPosition = cdcStopPosition;
        }

        @Override
        @Transient
        public final Builder cdcStopPosition(String cdcStopPosition) {
            this.cdcStopPosition = cdcStopPosition;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartReplicationTaskRequest build() {
            return new StartReplicationTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
