/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RebootReplicationInstanceRequest
extends DatabaseMigrationRequest
implements ToCopyableBuilder<Builder, RebootReplicationInstanceRequest> {
    private static final SdkField<String> REPLICATION_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationInstanceArn").getter(RebootReplicationInstanceRequest.getter(RebootReplicationInstanceRequest::replicationInstanceArn)).setter(RebootReplicationInstanceRequest.setter(Builder::replicationInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceArn").build()}).build();
    private static final SdkField<Boolean> FORCE_FAILOVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ForceFailover").getter(RebootReplicationInstanceRequest.getter(RebootReplicationInstanceRequest::forceFailover)).setter(RebootReplicationInstanceRequest.setter(Builder::forceFailover)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForceFailover").build()}).build();
    private static final SdkField<Boolean> FORCE_PLANNED_FAILOVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ForcePlannedFailover").getter(RebootReplicationInstanceRequest.getter(RebootReplicationInstanceRequest::forcePlannedFailover)).setter(RebootReplicationInstanceRequest.setter(Builder::forcePlannedFailover)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForcePlannedFailover").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_INSTANCE_ARN_FIELD, FORCE_FAILOVER_FIELD, FORCE_PLANNED_FAILOVER_FIELD));
    private final String replicationInstanceArn;
    private final Boolean forceFailover;
    private final Boolean forcePlannedFailover;

    private RebootReplicationInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.replicationInstanceArn = builder.replicationInstanceArn;
        this.forceFailover = builder.forceFailover;
        this.forcePlannedFailover = builder.forcePlannedFailover;
    }

    public final String replicationInstanceArn() {
        return this.replicationInstanceArn;
    }

    public final Boolean forceFailover() {
        return this.forceFailover;
    }

    public final Boolean forcePlannedFailover() {
        return this.forcePlannedFailover;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.forceFailover());
        hashCode = 31 * hashCode + Objects.hashCode(this.forcePlannedFailover());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RebootReplicationInstanceRequest)) {
            return false;
        }
        RebootReplicationInstanceRequest other = (RebootReplicationInstanceRequest)((Object)obj);
        return Objects.equals(this.replicationInstanceArn(), other.replicationInstanceArn()) && Objects.equals(this.forceFailover(), other.forceFailover()) && Objects.equals(this.forcePlannedFailover(), other.forcePlannedFailover());
    }

    public final String toString() {
        return ToString.builder((String)"RebootReplicationInstanceRequest").add("ReplicationInstanceArn", (Object)this.replicationInstanceArn()).add("ForceFailover", (Object)this.forceFailover()).add("ForcePlannedFailover", (Object)this.forcePlannedFailover()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.replicationInstanceArn()));
            }
            case "ForceFailover": {
                return Optional.ofNullable(clazz.cast(this.forceFailover()));
            }
            case "ForcePlannedFailover": {
                return Optional.ofNullable(clazz.cast(this.forcePlannedFailover()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RebootReplicationInstanceRequest, T> g) {
        return obj -> g.apply((RebootReplicationInstanceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationRequest.BuilderImpl
    implements Builder {
        private String replicationInstanceArn;
        private Boolean forceFailover;
        private Boolean forcePlannedFailover;

        private BuilderImpl() {
        }

        private BuilderImpl(RebootReplicationInstanceRequest model) {
            super(model);
            this.replicationInstanceArn(model.replicationInstanceArn);
            this.forceFailover(model.forceFailover);
            this.forcePlannedFailover(model.forcePlannedFailover);
        }

        public final String getReplicationInstanceArn() {
            return this.replicationInstanceArn;
        }

        public final void setReplicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
        }

        @Override
        @Transient
        public final Builder replicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
            return this;
        }

        public final Boolean getForceFailover() {
            return this.forceFailover;
        }

        public final void setForceFailover(Boolean forceFailover) {
            this.forceFailover = forceFailover;
        }

        @Override
        @Transient
        public final Builder forceFailover(Boolean forceFailover) {
            this.forceFailover = forceFailover;
            return this;
        }

        public final Boolean getForcePlannedFailover() {
            return this.forcePlannedFailover;
        }

        public final void setForcePlannedFailover(Boolean forcePlannedFailover) {
            this.forcePlannedFailover = forcePlannedFailover;
        }

        @Override
        @Transient
        public final Builder forcePlannedFailover(Boolean forcePlannedFailover) {
            this.forcePlannedFailover = forcePlannedFailover;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RebootReplicationInstanceRequest build() {
            return new RebootReplicationInstanceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DatabaseMigrationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RebootReplicationInstanceRequest> {
        public Builder replicationInstanceArn(String var1);

        public Builder forceFailover(Boolean var1);

        public Builder forcePlannedFailover(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

