/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.databasemigration.model.AccessDeniedException;
import software.amazon.awssdk.services.databasemigration.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.databasemigration.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.databasemigration.model.ApplyPendingMaintenanceActionRequest;
import software.amazon.awssdk.services.databasemigration.model.ApplyPendingMaintenanceActionResponse;
import software.amazon.awssdk.services.databasemigration.model.CancelReplicationTaskAssessmentRunRequest;
import software.amazon.awssdk.services.databasemigration.model.CancelReplicationTaskAssessmentRunResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateEndpointRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateEndpointResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateEventSubscriptionRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateEventSubscriptionResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationInstanceRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationInstanceResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationSubnetGroupRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationSubnetGroupResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationException;
import software.amazon.awssdk.services.databasemigration.model.DeleteCertificateRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteCertificateResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteConnectionRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteConnectionResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteEventSubscriptionRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteEventSubscriptionResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationInstanceRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationInstanceResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationSubnetGroupRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationSubnetGroupResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskAssessmentRunRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskAssessmentRunResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventCategoriesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventCategoriesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeRefreshSchemasStatusRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeRefreshSchemasStatusResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeSchemasRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeSchemasResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsResponse;
import software.amazon.awssdk.services.databasemigration.model.ImportCertificateRequest;
import software.amazon.awssdk.services.databasemigration.model.ImportCertificateResponse;
import software.amazon.awssdk.services.databasemigration.model.InsufficientResourceCapacityException;
import software.amazon.awssdk.services.databasemigration.model.InvalidCertificateException;
import software.amazon.awssdk.services.databasemigration.model.InvalidResourceStateException;
import software.amazon.awssdk.services.databasemigration.model.InvalidSubnetException;
import software.amazon.awssdk.services.databasemigration.model.KmsAccessDeniedException;
import software.amazon.awssdk.services.databasemigration.model.KmsDisabledException;
import software.amazon.awssdk.services.databasemigration.model.KmsException;
import software.amazon.awssdk.services.databasemigration.model.KmsInvalidStateException;
import software.amazon.awssdk.services.databasemigration.model.KmsKeyNotAccessibleException;
import software.amazon.awssdk.services.databasemigration.model.KmsNotFoundException;
import software.amazon.awssdk.services.databasemigration.model.KmsThrottlingException;
import software.amazon.awssdk.services.databasemigration.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.databasemigration.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyEndpointRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyEndpointResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyEventSubscriptionRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyEventSubscriptionResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationInstanceRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationInstanceResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationSubnetGroupRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationSubnetGroupResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.MoveReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.MoveReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.RebootReplicationInstanceRequest;
import software.amazon.awssdk.services.databasemigration.model.RebootReplicationInstanceResponse;
import software.amazon.awssdk.services.databasemigration.model.RefreshSchemasRequest;
import software.amazon.awssdk.services.databasemigration.model.RefreshSchemasResponse;
import software.amazon.awssdk.services.databasemigration.model.ReloadTablesRequest;
import software.amazon.awssdk.services.databasemigration.model.ReloadTablesResponse;
import software.amazon.awssdk.services.databasemigration.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.databasemigration.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.databasemigration.model.ReplicationSubnetGroupDoesNotCoverEnoughAZsException;
import software.amazon.awssdk.services.databasemigration.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.databasemigration.model.ResourceNotFoundException;
import software.amazon.awssdk.services.databasemigration.model.ResourceQuotaExceededException;
import software.amazon.awssdk.services.databasemigration.model.S3AccessDeniedException;
import software.amazon.awssdk.services.databasemigration.model.S3ResourceNotFoundException;
import software.amazon.awssdk.services.databasemigration.model.SnsInvalidTopicException;
import software.amazon.awssdk.services.databasemigration.model.SnsNoAuthorizationException;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentRequest;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentResponse;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentRunRequest;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentRunResponse;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.StopReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.StopReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.StorageQuotaExceededException;
import software.amazon.awssdk.services.databasemigration.model.SubnetAlreadyInUseException;
import software.amazon.awssdk.services.databasemigration.model.TestConnectionRequest;
import software.amazon.awssdk.services.databasemigration.model.TestConnectionResponse;
import software.amazon.awssdk.services.databasemigration.model.UpgradeDependencyFailureException;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeApplicableIndividualAssessmentsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeCertificatesIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeConnectionsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointSettingsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointTypesIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeEventSubscriptionsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeEventsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeOrderableReplicationInstancesIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribePendingMaintenanceActionsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstanceTaskLogsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstancesIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationSubnetGroupsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentResultsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentRunsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskIndividualAssessmentsIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTasksIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeSchemasIterable;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeTableStatisticsIterable;
import software.amazon.awssdk.services.databasemigration.waiters.DatabaseMigrationWaiter;

/**
 * Service client for accessing AWS Database Migration Service. This can be created using the static {@link #builder()}
 * method.
 *
 * <fullname>Database Migration Service</fullname>
 * <p>
 * Database Migration Service (DMS) can migrate your data to and from the most widely used commercial and open-source
 * databases such as Oracle, PostgreSQL, Microsoft SQL Server, Amazon Redshift, MariaDB, Amazon Aurora, MySQL, and SAP
 * Adaptive Server Enterprise (ASE). The service supports homogeneous migrations such as Oracle to Oracle, as well as
 * heterogeneous migrations between different database platforms, such as Oracle to MySQL or SQL Server to PostgreSQL.
 * </p>
 * <p>
 * For more information about DMS, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/Welcome.html">What Is
 * Database Migration Service?</a> in the <i>Database Migration Service User Guide.</i>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface DatabaseMigrationClient extends SdkClient {
    String SERVICE_NAME = "dms";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "dms";

    /**
     * Create a {@link DatabaseMigrationClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static DatabaseMigrationClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link DatabaseMigrationClient}.
     */
    static DatabaseMigrationClientBuilder builder() {
        return new DefaultDatabaseMigrationClientBuilder();
    }

    /**
     * <p>
     * Adds metadata tags to an DMS resource, including replication instance, endpoint, security group, and migration
     * task. These tags can also be used with cost allocation reporting to track cost associated with DMS resources, or
     * used in a Condition statement in an IAM policy for DMS. For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html"> <code>Tag</code> </a> data type
     * description.
     * </p>
     *
     * @param addTagsToResourceRequest
     *        Associates a set of tags with an DMS resource.
     * @return Result of the AddTagsToResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    default AddTagsToResourceResponse addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds metadata tags to an DMS resource, including replication instance, endpoint, security group, and migration
     * task. These tags can also be used with cost allocation reporting to track cost associated with DMS resources, or
     * used in a Condition statement in an IAM policy for DMS. For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html"> <code>Tag</code> </a> data type
     * description.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddTagsToResourceRequest.Builder} avoiding the need
     * to create one manually via {@link AddTagsToResourceRequest#builder()}
     * </p>
     *
     * @param addTagsToResourceRequest
     *        A {@link Consumer} that will call methods on {@link AddTagsToResourceMessage.Builder} to create a request.
     *        Associates a set of tags with an DMS resource.
     * @return Result of the AddTagsToResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    default AddTagsToResourceResponse addTagsToResource(Consumer<AddTagsToResourceRequest.Builder> addTagsToResourceRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return addTagsToResource(AddTagsToResourceRequest.builder().applyMutation(addTagsToResourceRequest).build());
    }

    /**
     * <p>
     * Applies a pending maintenance action to a resource (for example, to a replication instance).
     * </p>
     *
     * @param applyPendingMaintenanceActionRequest
     * @return Result of the ApplyPendingMaintenanceAction operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ApplyPendingMaintenanceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ApplyPendingMaintenanceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default ApplyPendingMaintenanceActionResponse applyPendingMaintenanceAction(
            ApplyPendingMaintenanceActionRequest applyPendingMaintenanceActionRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies a pending maintenance action to a resource (for example, to a replication instance).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ApplyPendingMaintenanceActionRequest.Builder}
     * avoiding the need to create one manually via {@link ApplyPendingMaintenanceActionRequest#builder()}
     * </p>
     *
     * @param applyPendingMaintenanceActionRequest
     *        A {@link Consumer} that will call methods on {@link ApplyPendingMaintenanceActionMessage.Builder} to
     *        create a request.
     * @return Result of the ApplyPendingMaintenanceAction operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ApplyPendingMaintenanceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ApplyPendingMaintenanceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default ApplyPendingMaintenanceActionResponse applyPendingMaintenanceAction(
            Consumer<ApplyPendingMaintenanceActionRequest.Builder> applyPendingMaintenanceActionRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return applyPendingMaintenanceAction(ApplyPendingMaintenanceActionRequest.builder()
                .applyMutation(applyPendingMaintenanceActionRequest).build());
    }

    /**
     * <p>
     * Cancels a single premigration assessment run.
     * </p>
     * <p>
     * This operation prevents any individual assessments from running if they haven't started running. It also attempts
     * to cancel any individual assessments that are currently running.
     * </p>
     *
     * @param cancelReplicationTaskAssessmentRunRequest
     * @return Result of the CancelReplicationTaskAssessmentRun operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CancelReplicationTaskAssessmentRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CancelReplicationTaskAssessmentRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelReplicationTaskAssessmentRunResponse cancelReplicationTaskAssessmentRun(
            CancelReplicationTaskAssessmentRunRequest cancelReplicationTaskAssessmentRunRequest) throws AccessDeniedException,
            ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a single premigration assessment run.
     * </p>
     * <p>
     * This operation prevents any individual assessments from running if they haven't started running. It also attempts
     * to cancel any individual assessments that are currently running.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelReplicationTaskAssessmentRunRequest.Builder}
     * avoiding the need to create one manually via {@link CancelReplicationTaskAssessmentRunRequest#builder()}
     * </p>
     *
     * @param cancelReplicationTaskAssessmentRunRequest
     *        A {@link Consumer} that will call methods on {@link CancelReplicationTaskAssessmentRunMessage.Builder} to
     *        create a request.
     * @return Result of the CancelReplicationTaskAssessmentRun operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CancelReplicationTaskAssessmentRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CancelReplicationTaskAssessmentRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelReplicationTaskAssessmentRunResponse cancelReplicationTaskAssessmentRun(
            Consumer<CancelReplicationTaskAssessmentRunRequest.Builder> cancelReplicationTaskAssessmentRunRequest)
            throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return cancelReplicationTaskAssessmentRun(CancelReplicationTaskAssessmentRunRequest.builder()
                .applyMutation(cancelReplicationTaskAssessmentRunRequest).build());
    }

    /**
     * <p>
     * Creates an endpoint using the provided settings.
     * </p>
     * <note>
     * <p>
     * For a MySQL source or target endpoint, don't explicitly specify the database using the <code>DatabaseName</code>
     * request parameter on the <code>CreateEndpoint</code> API call. Specifying <code>DatabaseName</code> when you
     * create a MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify
     * the database only when you specify the schema in the table-mapping rules of the DMS task.
     * </p>
     * </note>
     *
     * @param createEndpointRequest
     * @return Result of the CreateEndpoint operation returned by the service.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws S3AccessDeniedException
     *         Insufficient privileges are preventing access to an Amazon S3 object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateEndpointResponse createEndpoint(CreateEndpointRequest createEndpointRequest)
            throws KmsKeyNotAccessibleException, ResourceAlreadyExistsException, ResourceQuotaExceededException,
            InvalidResourceStateException, ResourceNotFoundException, AccessDeniedException, S3AccessDeniedException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an endpoint using the provided settings.
     * </p>
     * <note>
     * <p>
     * For a MySQL source or target endpoint, don't explicitly specify the database using the <code>DatabaseName</code>
     * request parameter on the <code>CreateEndpoint</code> API call. Specifying <code>DatabaseName</code> when you
     * create a MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify
     * the database only when you specify the schema in the table-mapping rules of the DMS task.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link CreateEndpointRequest#builder()}
     * </p>
     *
     * @param createEndpointRequest
     *        A {@link Consumer} that will call methods on {@link CreateEndpointMessage.Builder} to create a request.
     * @return Result of the CreateEndpoint operation returned by the service.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws S3AccessDeniedException
     *         Insufficient privileges are preventing access to an Amazon S3 object.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateEndpointResponse createEndpoint(Consumer<CreateEndpointRequest.Builder> createEndpointRequest)
            throws KmsKeyNotAccessibleException, ResourceAlreadyExistsException, ResourceQuotaExceededException,
            InvalidResourceStateException, ResourceNotFoundException, AccessDeniedException, S3AccessDeniedException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return createEndpoint(CreateEndpointRequest.builder().applyMutation(createEndpointRequest).build());
    }

    /**
     * <p>
     * Creates an DMS event notification subscription.
     * </p>
     * <p>
     * You can specify the type of source (<code>SourceType</code>) you want to be notified of, provide a list of DMS
     * source IDs (<code>SourceIds</code>) that triggers the events, and provide a list of event categories (
     * <code>EventCategories</code>) for events you want to be notified of. If you specify both the
     * <code>SourceType</code> and <code>SourceIds</code>, such as <code>SourceType = replication-instance</code> and
     * <code>SourceIdentifier = my-replinstance</code>, you will be notified of all the replication instance events for
     * the specified source. If you specify a <code>SourceType</code> but don't specify a <code>SourceIdentifier</code>,
     * you receive notice of the events for that source type for all your DMS sources. If you don't specify either
     * <code>SourceType</code> nor <code>SourceIdentifier</code>, you will be notified of events generated from all DMS
     * sources belonging to your customer account.
     * </p>
     * <p>
     * For more information about DMS events, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     *
     * @param createEventSubscriptionRequest
     * @return Result of the CreateEventSubscription operation returned by the service.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws SnsInvalidTopicException
     *         The SNS topic is invalid.
     * @throws SnsNoAuthorizationException
     *         You are not authorized for the SNS subscription.
     * @throws KmsAccessDeniedException
     *         The ciphertext references a key that doesn't exist or that the DMS account doesn't have access to.
     * @throws KmsDisabledException
     *         The specified KMS key isn't enabled.
     * @throws KmsInvalidStateException
     *         The state of the specified KMS resource isn't valid for this request.
     * @throws KmsNotFoundException
     *         The specified KMS entity or resource can't be found.
     * @throws KmsThrottlingException
     *         This request triggered KMS request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateEventSubscriptionResponse createEventSubscription(CreateEventSubscriptionRequest createEventSubscriptionRequest)
            throws ResourceQuotaExceededException, ResourceNotFoundException, ResourceAlreadyExistsException,
            SnsInvalidTopicException, SnsNoAuthorizationException, KmsAccessDeniedException, KmsDisabledException,
            KmsInvalidStateException, KmsNotFoundException, KmsThrottlingException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an DMS event notification subscription.
     * </p>
     * <p>
     * You can specify the type of source (<code>SourceType</code>) you want to be notified of, provide a list of DMS
     * source IDs (<code>SourceIds</code>) that triggers the events, and provide a list of event categories (
     * <code>EventCategories</code>) for events you want to be notified of. If you specify both the
     * <code>SourceType</code> and <code>SourceIds</code>, such as <code>SourceType = replication-instance</code> and
     * <code>SourceIdentifier = my-replinstance</code>, you will be notified of all the replication instance events for
     * the specified source. If you specify a <code>SourceType</code> but don't specify a <code>SourceIdentifier</code>,
     * you receive notice of the events for that source type for all your DMS sources. If you don't specify either
     * <code>SourceType</code> nor <code>SourceIdentifier</code>, you will be notified of events generated from all DMS
     * sources belonging to your customer account.
     * </p>
     * <p>
     * For more information about DMS events, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateEventSubscriptionRequest#builder()}
     * </p>
     *
     * @param createEventSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link CreateEventSubscriptionMessage.Builder} to create a
     *        request.
     * @return Result of the CreateEventSubscription operation returned by the service.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws SnsInvalidTopicException
     *         The SNS topic is invalid.
     * @throws SnsNoAuthorizationException
     *         You are not authorized for the SNS subscription.
     * @throws KmsAccessDeniedException
     *         The ciphertext references a key that doesn't exist or that the DMS account doesn't have access to.
     * @throws KmsDisabledException
     *         The specified KMS key isn't enabled.
     * @throws KmsInvalidStateException
     *         The state of the specified KMS resource isn't valid for this request.
     * @throws KmsNotFoundException
     *         The specified KMS entity or resource can't be found.
     * @throws KmsThrottlingException
     *         This request triggered KMS request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateEventSubscriptionResponse createEventSubscription(
            Consumer<CreateEventSubscriptionRequest.Builder> createEventSubscriptionRequest)
            throws ResourceQuotaExceededException, ResourceNotFoundException, ResourceAlreadyExistsException,
            SnsInvalidTopicException, SnsNoAuthorizationException, KmsAccessDeniedException, KmsDisabledException,
            KmsInvalidStateException, KmsNotFoundException, KmsThrottlingException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return createEventSubscription(CreateEventSubscriptionRequest.builder().applyMutation(createEventSubscriptionRequest)
                .build());
    }

    /**
     * <p>
     * Creates the replication instance using the specified parameters.
     * </p>
     * <p>
     * DMS requires that your account have certain roles with appropriate permissions before you can create a
     * replication instance. For information on the required roles, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.APIRole">Creating the IAM
     * Roles to Use With the CLI and DMS API</a>. For information on the required permissions, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.IAMPermissions">IAM
     * Permissions Needed to Use DMS</a>.
     * </p>
     *
     * @param createReplicationInstanceRequest
     * @return Result of the CreateReplicationInstance operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws InsufficientResourceCapacityException
     *         There are not enough resources allocated to the database migration.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws StorageQuotaExceededException
     *         The storage quota has been exceeded.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ReplicationSubnetGroupDoesNotCoverEnoughAZsException
     *         The replication subnet group does not cover enough Availability Zones (AZs). Edit the replication subnet
     *         group and add more AZs.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws InvalidSubnetException
     *         The subnet provided is invalid.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateReplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateReplicationInstanceResponse createReplicationInstance(
            CreateReplicationInstanceRequest createReplicationInstanceRequest) throws AccessDeniedException,
            ResourceAlreadyExistsException, InsufficientResourceCapacityException, ResourceQuotaExceededException,
            StorageQuotaExceededException, ResourceNotFoundException, ReplicationSubnetGroupDoesNotCoverEnoughAZsException,
            InvalidResourceStateException, InvalidSubnetException, KmsKeyNotAccessibleException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the replication instance using the specified parameters.
     * </p>
     * <p>
     * DMS requires that your account have certain roles with appropriate permissions before you can create a
     * replication instance. For information on the required roles, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.APIRole">Creating the IAM
     * Roles to Use With the CLI and DMS API</a>. For information on the required permissions, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.IAMPermissions">IAM
     * Permissions Needed to Use DMS</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReplicationInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link CreateReplicationInstanceRequest#builder()}
     * </p>
     *
     * @param createReplicationInstanceRequest
     *        A {@link Consumer} that will call methods on {@link CreateReplicationInstanceMessage.Builder} to create a
     *        request.
     * @return Result of the CreateReplicationInstance operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws InsufficientResourceCapacityException
     *         There are not enough resources allocated to the database migration.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws StorageQuotaExceededException
     *         The storage quota has been exceeded.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ReplicationSubnetGroupDoesNotCoverEnoughAZsException
     *         The replication subnet group does not cover enough Availability Zones (AZs). Edit the replication subnet
     *         group and add more AZs.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws InvalidSubnetException
     *         The subnet provided is invalid.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateReplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateReplicationInstanceResponse createReplicationInstance(
            Consumer<CreateReplicationInstanceRequest.Builder> createReplicationInstanceRequest) throws AccessDeniedException,
            ResourceAlreadyExistsException, InsufficientResourceCapacityException, ResourceQuotaExceededException,
            StorageQuotaExceededException, ResourceNotFoundException, ReplicationSubnetGroupDoesNotCoverEnoughAZsException,
            InvalidResourceStateException, InvalidSubnetException, KmsKeyNotAccessibleException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return createReplicationInstance(CreateReplicationInstanceRequest.builder()
                .applyMutation(createReplicationInstanceRequest).build());
    }

    /**
     * <p>
     * Creates a replication subnet group given a list of the subnet IDs in a VPC.
     * </p>
     * <p>
     * The VPC needs to have at least one subnet in at least two availability zones in the Amazon Web Services Region,
     * otherwise the service will throw a <code>ReplicationSubnetGroupDoesNotCoverEnoughAZs</code> exception.
     * </p>
     *
     * @param createReplicationSubnetGroupRequest
     * @return Result of the CreateReplicationSubnetGroup operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws ReplicationSubnetGroupDoesNotCoverEnoughAZsException
     *         The replication subnet group does not cover enough Availability Zones (AZs). Edit the replication subnet
     *         group and add more AZs.
     * @throws InvalidSubnetException
     *         The subnet provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateReplicationSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateReplicationSubnetGroupResponse createReplicationSubnetGroup(
            CreateReplicationSubnetGroupRequest createReplicationSubnetGroupRequest) throws AccessDeniedException,
            ResourceAlreadyExistsException, ResourceNotFoundException, ResourceQuotaExceededException,
            ReplicationSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a replication subnet group given a list of the subnet IDs in a VPC.
     * </p>
     * <p>
     * The VPC needs to have at least one subnet in at least two availability zones in the Amazon Web Services Region,
     * otherwise the service will throw a <code>ReplicationSubnetGroupDoesNotCoverEnoughAZs</code> exception.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReplicationSubnetGroupRequest.Builder}
     * avoiding the need to create one manually via {@link CreateReplicationSubnetGroupRequest#builder()}
     * </p>
     *
     * @param createReplicationSubnetGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateReplicationSubnetGroupMessage.Builder} to create
     *        a request.
     * @return Result of the CreateReplicationSubnetGroup operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws ReplicationSubnetGroupDoesNotCoverEnoughAZsException
     *         The replication subnet group does not cover enough Availability Zones (AZs). Edit the replication subnet
     *         group and add more AZs.
     * @throws InvalidSubnetException
     *         The subnet provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateReplicationSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateReplicationSubnetGroupResponse createReplicationSubnetGroup(
            Consumer<CreateReplicationSubnetGroupRequest.Builder> createReplicationSubnetGroupRequest)
            throws AccessDeniedException, ResourceAlreadyExistsException, ResourceNotFoundException,
            ResourceQuotaExceededException, ReplicationSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return createReplicationSubnetGroup(CreateReplicationSubnetGroupRequest.builder()
                .applyMutation(createReplicationSubnetGroupRequest).build());
    }

    /**
     * <p>
     * Creates a replication task using the specified parameters.
     * </p>
     *
     * @param createReplicationTaskRequest
     * @return Result of the CreateReplicationTask operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateReplicationTaskResponse createReplicationTask(CreateReplicationTaskRequest createReplicationTaskRequest)
            throws AccessDeniedException, InvalidResourceStateException, ResourceAlreadyExistsException,
            ResourceNotFoundException, KmsKeyNotAccessibleException, ResourceQuotaExceededException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a replication task using the specified parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReplicationTaskRequest.Builder} avoiding the
     * need to create one manually via {@link CreateReplicationTaskRequest#builder()}
     * </p>
     *
     * @param createReplicationTaskRequest
     *        A {@link Consumer} that will call methods on {@link CreateReplicationTaskMessage.Builder} to create a
     *        request.
     * @return Result of the CreateReplicationTask operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.CreateReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateReplicationTaskResponse createReplicationTask(
            Consumer<CreateReplicationTaskRequest.Builder> createReplicationTaskRequest) throws AccessDeniedException,
            InvalidResourceStateException, ResourceAlreadyExistsException, ResourceNotFoundException,
            KmsKeyNotAccessibleException, ResourceQuotaExceededException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return createReplicationTask(CreateReplicationTaskRequest.builder().applyMutation(createReplicationTaskRequest).build());
    }

    /**
     * <p>
     * Deletes the specified certificate.
     * </p>
     *
     * @param deleteCertificateRequest
     * @return Result of the DeleteCertificate operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteCertificateResponse deleteCertificate(DeleteCertificateRequest deleteCertificateRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified certificate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCertificateRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteCertificateRequest#builder()}
     * </p>
     *
     * @param deleteCertificateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCertificateMessage.Builder} to create a request.
     * @return Result of the DeleteCertificate operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteCertificateResponse deleteCertificate(Consumer<DeleteCertificateRequest.Builder> deleteCertificateRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return deleteCertificate(DeleteCertificateRequest.builder().applyMutation(deleteCertificateRequest).build());
    }

    /**
     * <p>
     * Deletes the connection between a replication instance and an endpoint.
     * </p>
     *
     * @param deleteConnectionRequest
     * @return Result of the DeleteConnection operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteConnectionResponse deleteConnection(DeleteConnectionRequest deleteConnectionRequest)
            throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the connection between a replication instance and an endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteConnectionRequest#builder()}
     * </p>
     *
     * @param deleteConnectionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteConnectionMessage.Builder} to create a request.
     * @return Result of the DeleteConnection operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteConnectionResponse deleteConnection(Consumer<DeleteConnectionRequest.Builder> deleteConnectionRequest)
            throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return deleteConnection(DeleteConnectionRequest.builder().applyMutation(deleteConnectionRequest).build());
    }

    /**
     * <p>
     * Deletes the specified endpoint.
     * </p>
     * <note>
     * <p>
     * All tasks associated with the endpoint must be deleted before you can delete the endpoint.
     * </p>
     * </note>
     * <p/>
     *
     * @param deleteEndpointRequest
     * @return Result of the DeleteEndpoint operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteEndpointResponse deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) throws ResourceNotFoundException,
            InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified endpoint.
     * </p>
     * <note>
     * <p>
     * All tasks associated with the endpoint must be deleted before you can delete the endpoint.
     * </p>
     * </note>
     * <p/>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteEndpointRequest#builder()}
     * </p>
     *
     * @param deleteEndpointRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEndpointMessage.Builder} to create a request.
     * @return Result of the DeleteEndpoint operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteEndpointResponse deleteEndpoint(Consumer<DeleteEndpointRequest.Builder> deleteEndpointRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return deleteEndpoint(DeleteEndpointRequest.builder().applyMutation(deleteEndpointRequest).build());
    }

    /**
     * <p>
     * Deletes an DMS event subscription.
     * </p>
     *
     * @param deleteEventSubscriptionRequest
     * @return Result of the DeleteEventSubscription operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteEventSubscriptionResponse deleteEventSubscription(DeleteEventSubscriptionRequest deleteEventSubscriptionRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an DMS event subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteEventSubscriptionRequest#builder()}
     * </p>
     *
     * @param deleteEventSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEventSubscriptionMessage.Builder} to create a
     *        request.
     * @return Result of the DeleteEventSubscription operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteEventSubscriptionResponse deleteEventSubscription(
            Consumer<DeleteEventSubscriptionRequest.Builder> deleteEventSubscriptionRequest) throws ResourceNotFoundException,
            InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return deleteEventSubscription(DeleteEventSubscriptionRequest.builder().applyMutation(deleteEventSubscriptionRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified replication instance.
     * </p>
     * <note>
     * <p>
     * You must delete any migration tasks that are associated with the replication instance before you can delete it.
     * </p>
     * </note>
     * <p/>
     *
     * @param deleteReplicationInstanceRequest
     * @return Result of the DeleteReplicationInstance operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteReplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteReplicationInstanceResponse deleteReplicationInstance(
            DeleteReplicationInstanceRequest deleteReplicationInstanceRequest) throws InvalidResourceStateException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified replication instance.
     * </p>
     * <note>
     * <p>
     * You must delete any migration tasks that are associated with the replication instance before you can delete it.
     * </p>
     * </note>
     * <p/>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReplicationInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteReplicationInstanceRequest#builder()}
     * </p>
     *
     * @param deleteReplicationInstanceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteReplicationInstanceMessage.Builder} to create a
     *        request.
     * @return Result of the DeleteReplicationInstance operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteReplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteReplicationInstanceResponse deleteReplicationInstance(
            Consumer<DeleteReplicationInstanceRequest.Builder> deleteReplicationInstanceRequest)
            throws InvalidResourceStateException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return deleteReplicationInstance(DeleteReplicationInstanceRequest.builder()
                .applyMutation(deleteReplicationInstanceRequest).build());
    }

    /**
     * <p>
     * Deletes a subnet group.
     * </p>
     *
     * @param deleteReplicationSubnetGroupRequest
     * @return Result of the DeleteReplicationSubnetGroup operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteReplicationSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteReplicationSubnetGroupResponse deleteReplicationSubnetGroup(
            DeleteReplicationSubnetGroupRequest deleteReplicationSubnetGroupRequest) throws InvalidResourceStateException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a subnet group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReplicationSubnetGroupRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteReplicationSubnetGroupRequest#builder()}
     * </p>
     *
     * @param deleteReplicationSubnetGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteReplicationSubnetGroupMessage.Builder} to create
     *        a request.
     * @return Result of the DeleteReplicationSubnetGroup operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteReplicationSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteReplicationSubnetGroupResponse deleteReplicationSubnetGroup(
            Consumer<DeleteReplicationSubnetGroupRequest.Builder> deleteReplicationSubnetGroupRequest)
            throws InvalidResourceStateException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return deleteReplicationSubnetGroup(DeleteReplicationSubnetGroupRequest.builder()
                .applyMutation(deleteReplicationSubnetGroupRequest).build());
    }

    /**
     * <p>
     * Deletes the specified replication task.
     * </p>
     *
     * @param deleteReplicationTaskRequest
     * @return Result of the DeleteReplicationTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteReplicationTaskResponse deleteReplicationTask(DeleteReplicationTaskRequest deleteReplicationTaskRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified replication task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReplicationTaskRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteReplicationTaskRequest#builder()}
     * </p>
     *
     * @param deleteReplicationTaskRequest
     *        A {@link Consumer} that will call methods on {@link DeleteReplicationTaskMessage.Builder} to create a
     *        request.
     * @return Result of the DeleteReplicationTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteReplicationTaskResponse deleteReplicationTask(
            Consumer<DeleteReplicationTaskRequest.Builder> deleteReplicationTaskRequest) throws ResourceNotFoundException,
            InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return deleteReplicationTask(DeleteReplicationTaskRequest.builder().applyMutation(deleteReplicationTaskRequest).build());
    }

    /**
     * <p>
     * Deletes the record of a single premigration assessment run.
     * </p>
     * <p>
     * This operation removes all metadata that DMS maintains about this assessment run. However, the operation leaves
     * untouched all information about this assessment run that is stored in your Amazon S3 bucket.
     * </p>
     *
     * @param deleteReplicationTaskAssessmentRunRequest
     * @return Result of the DeleteReplicationTaskAssessmentRun operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteReplicationTaskAssessmentRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationTaskAssessmentRun"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteReplicationTaskAssessmentRunResponse deleteReplicationTaskAssessmentRun(
            DeleteReplicationTaskAssessmentRunRequest deleteReplicationTaskAssessmentRunRequest) throws AccessDeniedException,
            ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the record of a single premigration assessment run.
     * </p>
     * <p>
     * This operation removes all metadata that DMS maintains about this assessment run. However, the operation leaves
     * untouched all information about this assessment run that is stored in your Amazon S3 bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReplicationTaskAssessmentRunRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteReplicationTaskAssessmentRunRequest#builder()}
     * </p>
     *
     * @param deleteReplicationTaskAssessmentRunRequest
     *        A {@link Consumer} that will call methods on {@link DeleteReplicationTaskAssessmentRunMessage.Builder} to
     *        create a request.
     * @return Result of the DeleteReplicationTaskAssessmentRun operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DeleteReplicationTaskAssessmentRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationTaskAssessmentRun"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteReplicationTaskAssessmentRunResponse deleteReplicationTaskAssessmentRun(
            Consumer<DeleteReplicationTaskAssessmentRunRequest.Builder> deleteReplicationTaskAssessmentRunRequest)
            throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return deleteReplicationTaskAssessmentRun(DeleteReplicationTaskAssessmentRunRequest.builder()
                .applyMutation(deleteReplicationTaskAssessmentRunRequest).build());
    }

    /**
     * <p>
     * Lists all of the DMS attributes for a customer account. These attributes include DMS quotas for the account and a
     * unique account identifier in a particular DMS region. DMS quotas include a list of resource quotas supported by
     * the account, such as the number of replication instances allowed. The description for each resource quota,
     * includes the quota name, current usage toward that quota, and the quota's maximum value. DMS uses the unique
     * account identifier to name each artifact used by DMS in the given region.
     * </p>
     * <p>
     * This command does not take any parameters.
     * </p>
     *
     * @return Result of the DescribeAccountAttributes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeAccountAttributes
     * @see #describeAccountAttributes(DescribeAccountAttributesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeAccountAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAccountAttributesResponse describeAccountAttributes() throws AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return describeAccountAttributes(DescribeAccountAttributesRequest.builder().build());
    }

    /**
     * <p>
     * Lists all of the DMS attributes for a customer account. These attributes include DMS quotas for the account and a
     * unique account identifier in a particular DMS region. DMS quotas include a list of resource quotas supported by
     * the account, such as the number of replication instances allowed. The description for each resource quota,
     * includes the quota name, current usage toward that quota, and the quota's maximum value. DMS uses the unique
     * account identifier to name each artifact used by DMS in the given region.
     * </p>
     * <p>
     * This command does not take any parameters.
     * </p>
     *
     * @param describeAccountAttributesRequest
     * @return Result of the DescribeAccountAttributes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeAccountAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAccountAttributesResponse describeAccountAttributes(
            DescribeAccountAttributesRequest describeAccountAttributesRequest) throws AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the DMS attributes for a customer account. These attributes include DMS quotas for the account and a
     * unique account identifier in a particular DMS region. DMS quotas include a list of resource quotas supported by
     * the account, such as the number of replication instances allowed. The description for each resource quota,
     * includes the quota name, current usage toward that quota, and the quota's maximum value. DMS uses the unique
     * account identifier to name each artifact used by DMS in the given region.
     * </p>
     * <p>
     * This command does not take any parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAccountAttributesRequest#builder()}
     * </p>
     *
     * @param describeAccountAttributesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAccountAttributesMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeAccountAttributes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeAccountAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAccountAttributesResponse describeAccountAttributes(
            Consumer<DescribeAccountAttributesRequest.Builder> describeAccountAttributesRequest) throws AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeAccountAttributes(DescribeAccountAttributesRequest.builder()
                .applyMutation(describeAccountAttributesRequest).build());
    }

    /**
     * <p>
     * Provides a list of individual assessments that you can specify for a new premigration assessment run, given one
     * or more parameters.
     * </p>
     * <p>
     * If you specify an existing migration task, this operation provides the default individual assessments you can
     * specify for that task. Otherwise, the specified parameters model elements of a possible migration task on which
     * to base a premigration assessment run.
     * </p>
     * <p>
     * To use these migration task modeling parameters, you must specify an existing replication instance, a source
     * database engine, a target database engine, and a migration type. This combination of parameters potentially
     * limits the default individual assessments available for an assessment run created for a corresponding migration
     * task.
     * </p>
     * <p>
     * If you specify no parameters, this operation provides a list of all possible individual assessments that you can
     * specify for an assessment run. If you specify any one of the task modeling parameters, you must specify all of
     * them or the operation cannot provide a list of individual assessments. The only parameter that you can specify
     * alone is for an existing migration task. The specified task definition then determines the default list of
     * individual assessments that you can specify in an assessment run for the task.
     * </p>
     *
     * @param describeApplicableIndividualAssessmentsRequest
     * @return Result of the DescribeApplicableIndividualAssessments operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeApplicableIndividualAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeApplicableIndividualAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicableIndividualAssessmentsResponse describeApplicableIndividualAssessments(
            DescribeApplicableIndividualAssessmentsRequest describeApplicableIndividualAssessmentsRequest)
            throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of individual assessments that you can specify for a new premigration assessment run, given one
     * or more parameters.
     * </p>
     * <p>
     * If you specify an existing migration task, this operation provides the default individual assessments you can
     * specify for that task. Otherwise, the specified parameters model elements of a possible migration task on which
     * to base a premigration assessment run.
     * </p>
     * <p>
     * To use these migration task modeling parameters, you must specify an existing replication instance, a source
     * database engine, a target database engine, and a migration type. This combination of parameters potentially
     * limits the default individual assessments available for an assessment run created for a corresponding migration
     * task.
     * </p>
     * <p>
     * If you specify no parameters, this operation provides a list of all possible individual assessments that you can
     * specify for an assessment run. If you specify any one of the task modeling parameters, you must specify all of
     * them or the operation cannot provide a list of individual assessments. The only parameter that you can specify
     * alone is for an existing migration task. The specified task definition then determines the default list of
     * individual assessments that you can specify in an assessment run for the task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeApplicableIndividualAssessmentsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeApplicableIndividualAssessmentsRequest#builder()}
     * </p>
     *
     * @param describeApplicableIndividualAssessmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeApplicableIndividualAssessmentsMessage.Builder} to create a request.
     * @return Result of the DescribeApplicableIndividualAssessments operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeApplicableIndividualAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeApplicableIndividualAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicableIndividualAssessmentsResponse describeApplicableIndividualAssessments(
            Consumer<DescribeApplicableIndividualAssessmentsRequest.Builder> describeApplicableIndividualAssessmentsRequest)
            throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeApplicableIndividualAssessments(DescribeApplicableIndividualAssessmentsRequest.builder()
                .applyMutation(describeApplicableIndividualAssessmentsRequest).build());
    }

    /**
     * <p>
     * Provides a list of individual assessments that you can specify for a new premigration assessment run, given one
     * or more parameters.
     * </p>
     * <p>
     * If you specify an existing migration task, this operation provides the default individual assessments you can
     * specify for that task. Otherwise, the specified parameters model elements of a possible migration task on which
     * to base a premigration assessment run.
     * </p>
     * <p>
     * To use these migration task modeling parameters, you must specify an existing replication instance, a source
     * database engine, a target database engine, and a migration type. This combination of parameters potentially
     * limits the default individual assessments available for an assessment run created for a corresponding migration
     * task.
     * </p>
     * <p>
     * If you specify no parameters, this operation provides a list of all possible individual assessments that you can
     * specify for an assessment run. If you specify any one of the task modeling parameters, you must specify all of
     * them or the operation cannot provide a list of individual assessments. The only parameter that you can specify
     * alone is for an existing migration task. The specified task definition then determines the default list of
     * individual assessments that you can specify in an assessment run for the task.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeApplicableIndividualAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeApplicableIndividualAssessmentsIterable responses = client.describeApplicableIndividualAssessmentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeApplicableIndividualAssessmentsIterable responses = client
     *             .describeApplicableIndividualAssessmentsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeApplicableIndividualAssessmentsIterable responses = client.describeApplicableIndividualAssessmentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeApplicableIndividualAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeApplicableIndividualAssessmentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeApplicableIndividualAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeApplicableIndividualAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicableIndividualAssessmentsIterable describeApplicableIndividualAssessmentsPaginator(
            DescribeApplicableIndividualAssessmentsRequest describeApplicableIndividualAssessmentsRequest)
            throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of individual assessments that you can specify for a new premigration assessment run, given one
     * or more parameters.
     * </p>
     * <p>
     * If you specify an existing migration task, this operation provides the default individual assessments you can
     * specify for that task. Otherwise, the specified parameters model elements of a possible migration task on which
     * to base a premigration assessment run.
     * </p>
     * <p>
     * To use these migration task modeling parameters, you must specify an existing replication instance, a source
     * database engine, a target database engine, and a migration type. This combination of parameters potentially
     * limits the default individual assessments available for an assessment run created for a corresponding migration
     * task.
     * </p>
     * <p>
     * If you specify no parameters, this operation provides a list of all possible individual assessments that you can
     * specify for an assessment run. If you specify any one of the task modeling parameters, you must specify all of
     * them or the operation cannot provide a list of individual assessments. The only parameter that you can specify
     * alone is for an existing migration task. The specified task definition then determines the default list of
     * individual assessments that you can specify in an assessment run for the task.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeApplicableIndividualAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeApplicableIndividualAssessmentsIterable responses = client.describeApplicableIndividualAssessmentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeApplicableIndividualAssessmentsIterable responses = client
     *             .describeApplicableIndividualAssessmentsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeApplicableIndividualAssessmentsIterable responses = client.describeApplicableIndividualAssessmentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeApplicableIndividualAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeApplicableIndividualAssessmentsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeApplicableIndividualAssessmentsRequest#builder()}
     * </p>
     *
     * @param describeApplicableIndividualAssessmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeApplicableIndividualAssessmentsMessage.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeApplicableIndividualAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeApplicableIndividualAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicableIndividualAssessmentsIterable describeApplicableIndividualAssessmentsPaginator(
            Consumer<DescribeApplicableIndividualAssessmentsRequest.Builder> describeApplicableIndividualAssessmentsRequest)
            throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeApplicableIndividualAssessmentsPaginator(DescribeApplicableIndividualAssessmentsRequest.builder()
                .applyMutation(describeApplicableIndividualAssessmentsRequest).build());
    }

    /**
     * <p>
     * Provides a description of the certificate.
     * </p>
     *
     * @return Result of the DescribeCertificates operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeCertificates
     * @see #describeCertificates(DescribeCertificatesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCertificatesResponse describeCertificates() throws ResourceNotFoundException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeCertificates(DescribeCertificatesRequest.builder().build());
    }

    /**
     * <p>
     * Provides a description of the certificate.
     * </p>
     *
     * @param describeCertificatesRequest
     * @return Result of the DescribeCertificates operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCertificatesResponse describeCertificates(DescribeCertificatesRequest describeCertificatesRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a description of the certificate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCertificatesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCertificatesRequest#builder()}
     * </p>
     *
     * @param describeCertificatesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCertificatesMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeCertificates operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCertificatesResponse describeCertificates(
            Consumer<DescribeCertificatesRequest.Builder> describeCertificatesRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeCertificates(DescribeCertificatesRequest.builder().applyMutation(describeCertificatesRequest).build());
    }

    /**
     * <p>
     * Provides a description of the certificate.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCertificates(software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeCertificatesIterable responses = client.describeCertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeCertificatesIterable responses = client
     *             .describeCertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeCertificatesIterable responses = client.describeCertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCertificates(software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeCertificates
     * @see #describeCertificatesPaginator(DescribeCertificatesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCertificatesIterable describeCertificatesPaginator() throws ResourceNotFoundException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeCertificatesPaginator(DescribeCertificatesRequest.builder().build());
    }

    /**
     * <p>
     * Provides a description of the certificate.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCertificates(software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeCertificatesIterable responses = client.describeCertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeCertificatesIterable responses = client
     *             .describeCertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeCertificatesIterable responses = client.describeCertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCertificates(software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeCertificatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCertificatesIterable describeCertificatesPaginator(DescribeCertificatesRequest describeCertificatesRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a description of the certificate.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCertificates(software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeCertificatesIterable responses = client.describeCertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeCertificatesIterable responses = client
     *             .describeCertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeCertificatesIterable responses = client.describeCertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCertificates(software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCertificatesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCertificatesRequest#builder()}
     * </p>
     *
     * @param describeCertificatesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCertificatesMessage.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCertificatesIterable describeCertificatesPaginator(
            Consumer<DescribeCertificatesRequest.Builder> describeCertificatesRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeCertificatesPaginator(DescribeCertificatesRequest.builder().applyMutation(describeCertificatesRequest)
                .build());
    }

    /**
     * <p>
     * Describes the status of the connections that have been made between the replication instance and an endpoint.
     * Connections are created when you test an endpoint.
     * </p>
     *
     * @return Result of the DescribeConnections operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeConnections
     * @see #describeConnections(DescribeConnectionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeConnectionsResponse describeConnections() throws ResourceNotFoundException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeConnections(DescribeConnectionsRequest.builder().build());
    }

    /**
     * <p>
     * Describes the status of the connections that have been made between the replication instance and an endpoint.
     * Connections are created when you test an endpoint.
     * </p>
     *
     * @param describeConnectionsRequest
     * @return Result of the DescribeConnections operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeConnectionsResponse describeConnections(DescribeConnectionsRequest describeConnectionsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the status of the connections that have been made between the replication instance and an endpoint.
     * Connections are created when you test an endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConnectionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeConnectionsRequest#builder()}
     * </p>
     *
     * @param describeConnectionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeConnectionsMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeConnections operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeConnectionsResponse describeConnections(
            Consumer<DescribeConnectionsRequest.Builder> describeConnectionsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeConnections(DescribeConnectionsRequest.builder().applyMutation(describeConnectionsRequest).build());
    }

    /**
     * <p>
     * Describes the status of the connections that have been made between the replication instance and an endpoint.
     * Connections are created when you test an endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeConnections(software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeConnectionsIterable responses = client.describeConnectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeConnectionsIterable responses = client
     *             .describeConnectionsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeConnectionsIterable responses = client.describeConnectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConnections(software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeConnections
     * @see #describeConnectionsPaginator(DescribeConnectionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeConnectionsIterable describeConnectionsPaginator() throws ResourceNotFoundException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeConnectionsPaginator(DescribeConnectionsRequest.builder().build());
    }

    /**
     * <p>
     * Describes the status of the connections that have been made between the replication instance and an endpoint.
     * Connections are created when you test an endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeConnections(software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeConnectionsIterable responses = client.describeConnectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeConnectionsIterable responses = client
     *             .describeConnectionsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeConnectionsIterable responses = client.describeConnectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConnections(software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeConnectionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeConnectionsIterable describeConnectionsPaginator(DescribeConnectionsRequest describeConnectionsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the status of the connections that have been made between the replication instance and an endpoint.
     * Connections are created when you test an endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeConnections(software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeConnectionsIterable responses = client.describeConnectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeConnectionsIterable responses = client
     *             .describeConnectionsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeConnectionsIterable responses = client.describeConnectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConnections(software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConnectionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeConnectionsRequest#builder()}
     * </p>
     *
     * @param describeConnectionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeConnectionsMessage.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeConnectionsIterable describeConnectionsPaginator(
            Consumer<DescribeConnectionsRequest.Builder> describeConnectionsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeConnectionsPaginator(DescribeConnectionsRequest.builder().applyMutation(describeConnectionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about the possible endpoint settings available when you create an endpoint for a specific
     * database engine.
     * </p>
     *
     * @param describeEndpointSettingsRequest
     * @return Result of the DescribeEndpointSettings operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpointSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEndpointSettingsResponse describeEndpointSettings(
            DescribeEndpointSettingsRequest describeEndpointSettingsRequest) throws AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the possible endpoint settings available when you create an endpoint for a specific
     * database engine.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointSettingsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEndpointSettingsRequest#builder()}
     * </p>
     *
     * @param describeEndpointSettingsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEndpointSettingsMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeEndpointSettings operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpointSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEndpointSettingsResponse describeEndpointSettings(
            Consumer<DescribeEndpointSettingsRequest.Builder> describeEndpointSettingsRequest) throws AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeEndpointSettings(DescribeEndpointSettingsRequest.builder().applyMutation(describeEndpointSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about the possible endpoint settings available when you create an endpoint for a specific
     * database engine.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEndpointSettings(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointSettingsIterable responses = client.describeEndpointSettingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointSettingsIterable responses = client
     *             .describeEndpointSettingsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointSettingsIterable responses = client.describeEndpointSettingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEndpointSettings(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEndpointSettingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpointSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEndpointSettingsIterable describeEndpointSettingsPaginator(
            DescribeEndpointSettingsRequest describeEndpointSettingsRequest) throws AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the possible endpoint settings available when you create an endpoint for a specific
     * database engine.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEndpointSettings(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointSettingsIterable responses = client.describeEndpointSettingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointSettingsIterable responses = client
     *             .describeEndpointSettingsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointSettingsIterable responses = client.describeEndpointSettingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEndpointSettings(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointSettingsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEndpointSettingsRequest#builder()}
     * </p>
     *
     * @param describeEndpointSettingsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEndpointSettingsMessage.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpointSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEndpointSettingsIterable describeEndpointSettingsPaginator(
            Consumer<DescribeEndpointSettingsRequest.Builder> describeEndpointSettingsRequest) throws AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeEndpointSettingsPaginator(DescribeEndpointSettingsRequest.builder()
                .applyMutation(describeEndpointSettingsRequest).build());
    }

    /**
     * <p>
     * Returns information about the type of endpoints available.
     * </p>
     *
     * @return Result of the DescribeEndpointTypes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpointTypes
     * @see #describeEndpointTypes(DescribeEndpointTypesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEndpointTypesResponse describeEndpointTypes() throws AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return describeEndpointTypes(DescribeEndpointTypesRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about the type of endpoints available.
     * </p>
     *
     * @param describeEndpointTypesRequest
     * @return Result of the DescribeEndpointTypes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpointTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEndpointTypesResponse describeEndpointTypes(DescribeEndpointTypesRequest describeEndpointTypesRequest)
            throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the type of endpoints available.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointTypesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEndpointTypesRequest#builder()}
     * </p>
     *
     * @param describeEndpointTypesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEndpointTypesMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeEndpointTypes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpointTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEndpointTypesResponse describeEndpointTypes(
            Consumer<DescribeEndpointTypesRequest.Builder> describeEndpointTypesRequest) throws AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeEndpointTypes(DescribeEndpointTypesRequest.builder().applyMutation(describeEndpointTypesRequest).build());
    }

    /**
     * <p>
     * Returns information about the type of endpoints available.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEndpointTypes(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointTypesIterable responses = client.describeEndpointTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointTypesIterable responses = client
     *             .describeEndpointTypesPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointTypesIterable responses = client.describeEndpointTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEndpointTypes(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpointTypes
     * @see #describeEndpointTypesPaginator(DescribeEndpointTypesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEndpointTypesIterable describeEndpointTypesPaginator() throws AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return describeEndpointTypesPaginator(DescribeEndpointTypesRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about the type of endpoints available.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEndpointTypes(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointTypesIterable responses = client.describeEndpointTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointTypesIterable responses = client
     *             .describeEndpointTypesPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointTypesIterable responses = client.describeEndpointTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEndpointTypes(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEndpointTypesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpointTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEndpointTypesIterable describeEndpointTypesPaginator(DescribeEndpointTypesRequest describeEndpointTypesRequest)
            throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the type of endpoints available.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEndpointTypes(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointTypesIterable responses = client.describeEndpointTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointTypesIterable responses = client
     *             .describeEndpointTypesPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointTypesIterable responses = client.describeEndpointTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEndpointTypes(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointTypesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEndpointTypesRequest#builder()}
     * </p>
     *
     * @param describeEndpointTypesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEndpointTypesMessage.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpointTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEndpointTypesIterable describeEndpointTypesPaginator(
            Consumer<DescribeEndpointTypesRequest.Builder> describeEndpointTypesRequest) throws AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeEndpointTypesPaginator(DescribeEndpointTypesRequest.builder().applyMutation(describeEndpointTypesRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about the endpoints for your account in the current region.
     * </p>
     *
     * @return Result of the DescribeEndpoints operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpoints
     * @see #describeEndpoints(DescribeEndpointsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEndpointsResponse describeEndpoints() throws ResourceNotFoundException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeEndpoints(DescribeEndpointsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about the endpoints for your account in the current region.
     * </p>
     *
     * @param describeEndpointsRequest
     * @return Result of the DescribeEndpoints operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEndpointsResponse describeEndpoints(DescribeEndpointsRequest describeEndpointsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the endpoints for your account in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeEndpointsRequest#builder()}
     * </p>
     *
     * @param describeEndpointsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEndpointsMessage.Builder} to create a request.
     * @return Result of the DescribeEndpoints operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEndpointsResponse describeEndpoints(Consumer<DescribeEndpointsRequest.Builder> describeEndpointsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeEndpoints(DescribeEndpointsRequest.builder().applyMutation(describeEndpointsRequest).build());
    }

    /**
     * <p>
     * Returns information about the endpoints for your account in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEndpoints(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointsIterable responses = client.describeEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointsIterable responses = client
     *             .describeEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointsIterable responses = client.describeEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEndpoints(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpoints
     * @see #describeEndpointsPaginator(DescribeEndpointsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEndpointsIterable describeEndpointsPaginator() throws ResourceNotFoundException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeEndpointsPaginator(DescribeEndpointsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about the endpoints for your account in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEndpoints(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointsIterable responses = client.describeEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointsIterable responses = client
     *             .describeEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointsIterable responses = client.describeEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEndpoints(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEndpointsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEndpointsIterable describeEndpointsPaginator(DescribeEndpointsRequest describeEndpointsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the endpoints for your account in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEndpoints(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointsIterable responses = client.describeEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointsIterable responses = client
     *             .describeEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointsIterable responses = client.describeEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEndpoints(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeEndpointsRequest#builder()}
     * </p>
     *
     * @param describeEndpointsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEndpointsMessage.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEndpointsIterable describeEndpointsPaginator(
            Consumer<DescribeEndpointsRequest.Builder> describeEndpointsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeEndpointsPaginator(DescribeEndpointsRequest.builder().applyMutation(describeEndpointsRequest).build());
    }

    /**
     * <p>
     * Lists categories for all event source types, or, if specified, for a specified source type. You can see a list of
     * the event categories and source types in <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     *
     * @return Result of the DescribeEventCategories operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEventCategories
     * @see #describeEventCategories(DescribeEventCategoriesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventCategories" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEventCategoriesResponse describeEventCategories() throws AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return describeEventCategories(DescribeEventCategoriesRequest.builder().build());
    }

    /**
     * <p>
     * Lists categories for all event source types, or, if specified, for a specified source type. You can see a list of
     * the event categories and source types in <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     *
     * @param describeEventCategoriesRequest
     * @return Result of the DescribeEventCategories operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEventCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventCategories" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEventCategoriesResponse describeEventCategories(DescribeEventCategoriesRequest describeEventCategoriesRequest)
            throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists categories for all event source types, or, if specified, for a specified source type. You can see a list of
     * the event categories and source types in <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventCategoriesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEventCategoriesRequest#builder()}
     * </p>
     *
     * @param describeEventCategoriesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventCategoriesMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeEventCategories operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEventCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventCategories" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEventCategoriesResponse describeEventCategories(
            Consumer<DescribeEventCategoriesRequest.Builder> describeEventCategoriesRequest) throws AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeEventCategories(DescribeEventCategoriesRequest.builder().applyMutation(describeEventCategoriesRequest)
                .build());
    }

    /**
     * <p>
     * Lists all the event subscriptions for a customer account. The description of a subscription includes
     * <code>SubscriptionName</code>, <code>SNSTopicARN</code>, <code>CustomerID</code>, <code>SourceType</code>,
     * <code>SourceID</code>, <code>CreationTime</code>, and <code>Status</code>.
     * </p>
     * <p>
     * If you specify <code>SubscriptionName</code>, this action lists the description for that subscription.
     * </p>
     *
     * @return Result of the DescribeEventSubscriptions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEventSubscriptions
     * @see #describeEventSubscriptions(DescribeEventSubscriptionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsResponse describeEventSubscriptions() throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeEventSubscriptions(DescribeEventSubscriptionsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all the event subscriptions for a customer account. The description of a subscription includes
     * <code>SubscriptionName</code>, <code>SNSTopicARN</code>, <code>CustomerID</code>, <code>SourceType</code>,
     * <code>SourceID</code>, <code>CreationTime</code>, and <code>Status</code>.
     * </p>
     * <p>
     * If you specify <code>SubscriptionName</code>, this action lists the description for that subscription.
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     * @return Result of the DescribeEventSubscriptions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsResponse describeEventSubscriptions(
            DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the event subscriptions for a customer account. The description of a subscription includes
     * <code>SubscriptionName</code>, <code>SNSTopicARN</code>, <code>CustomerID</code>, <code>SourceType</code>,
     * <code>SourceID</code>, <code>CreationTime</code>, and <code>Status</code>.
     * </p>
     * <p>
     * If you specify <code>SubscriptionName</code>, this action lists the description for that subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventSubscriptionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEventSubscriptionsRequest#builder()}
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventSubscriptionsMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeEventSubscriptions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsResponse describeEventSubscriptions(
            Consumer<DescribeEventSubscriptionsRequest.Builder> describeEventSubscriptionsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeEventSubscriptions(DescribeEventSubscriptionsRequest.builder()
                .applyMutation(describeEventSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Lists all the event subscriptions for a customer account. The description of a subscription includes
     * <code>SubscriptionName</code>, <code>SNSTopicARN</code>, <code>CustomerID</code>, <code>SourceType</code>,
     * <code>SourceID</code>, <code>CreationTime</code>, and <code>Status</code>.
     * </p>
     * <p>
     * If you specify <code>SubscriptionName</code>, this action lists the description for that subscription.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventSubscriptionsIterable responses = client.describeEventSubscriptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeEventSubscriptionsIterable responses = client
     *             .describeEventSubscriptionsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventSubscriptionsIterable responses = client.describeEventSubscriptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEventSubscriptions
     * @see #describeEventSubscriptionsPaginator(DescribeEventSubscriptionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsIterable describeEventSubscriptionsPaginator() throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeEventSubscriptionsPaginator(DescribeEventSubscriptionsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all the event subscriptions for a customer account. The description of a subscription includes
     * <code>SubscriptionName</code>, <code>SNSTopicARN</code>, <code>CustomerID</code>, <code>SourceType</code>,
     * <code>SourceID</code>, <code>CreationTime</code>, and <code>Status</code>.
     * </p>
     * <p>
     * If you specify <code>SubscriptionName</code>, this action lists the description for that subscription.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventSubscriptionsIterable responses = client.describeEventSubscriptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeEventSubscriptionsIterable responses = client
     *             .describeEventSubscriptionsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventSubscriptionsIterable responses = client.describeEventSubscriptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsIterable describeEventSubscriptionsPaginator(
            DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the event subscriptions for a customer account. The description of a subscription includes
     * <code>SubscriptionName</code>, <code>SNSTopicARN</code>, <code>CustomerID</code>, <code>SourceType</code>,
     * <code>SourceID</code>, <code>CreationTime</code>, and <code>Status</code>.
     * </p>
     * <p>
     * If you specify <code>SubscriptionName</code>, this action lists the description for that subscription.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventSubscriptionsIterable responses = client.describeEventSubscriptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeEventSubscriptionsIterable responses = client
     *             .describeEventSubscriptionsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventSubscriptionsIterable responses = client.describeEventSubscriptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventSubscriptionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEventSubscriptionsRequest#builder()}
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventSubscriptionsMessage.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsIterable describeEventSubscriptionsPaginator(
            Consumer<DescribeEventSubscriptionsRequest.Builder> describeEventSubscriptionsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeEventSubscriptionsPaginator(DescribeEventSubscriptionsRequest.builder()
                .applyMutation(describeEventSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Lists events for a given source identifier and source type. You can also specify a start and end time. For more
     * information on DMS events, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     *
     * @return Result of the DescribeEvents operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEvents
     * @see #describeEvents(DescribeEventsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsResponse describeEvents() throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeEvents(DescribeEventsRequest.builder().build());
    }

    /**
     * <p>
     * Lists events for a given source identifier and source type. You can also specify a start and end time. For more
     * information on DMS events, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     *
     * @param describeEventsRequest
     * @return Result of the DescribeEvents operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsResponse describeEvents(DescribeEventsRequest describeEventsRequest) throws AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists events for a given source identifier and source type. You can also specify a start and end time. For more
     * information on DMS events, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEventsRequest#builder()}
     * </p>
     *
     * @param describeEventsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventsMessage.Builder} to create a request.
     * @return Result of the DescribeEvents operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsResponse describeEvents(Consumer<DescribeEventsRequest.Builder> describeEventsRequest)
            throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeEvents(DescribeEventsRequest.builder().applyMutation(describeEventsRequest).build());
    }

    /**
     * <p>
     * Lists events for a given source identifier and source type. You can also specify a start and end time. For more
     * information on DMS events, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEvents(software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeEventsIterable responses = client
     *             .describeEventsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEvents
     * @see #describeEventsPaginator(DescribeEventsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsIterable describeEventsPaginator() throws AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return describeEventsPaginator(DescribeEventsRequest.builder().build());
    }

    /**
     * <p>
     * Lists events for a given source identifier and source type. You can also specify a start and end time. For more
     * information on DMS events, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEvents(software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeEventsIterable responses = client
     *             .describeEventsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEventsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsIterable describeEventsPaginator(DescribeEventsRequest describeEventsRequest)
            throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists events for a given source identifier and source type. You can also specify a start and end time. For more
     * information on DMS events, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEvents(software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeEventsIterable responses = client
     *             .describeEventsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEventsRequest#builder()}
     * </p>
     *
     * @param describeEventsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventsMessage.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsIterable describeEventsPaginator(Consumer<DescribeEventsRequest.Builder> describeEventsRequest)
            throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeEventsPaginator(DescribeEventsRequest.builder().applyMutation(describeEventsRequest).build());
    }

    /**
     * <p>
     * Returns information about the replication instance types that can be created in the specified region.
     * </p>
     *
     * @return Result of the DescribeOrderableReplicationInstances operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeOrderableReplicationInstances
     * @see #describeOrderableReplicationInstances(DescribeOrderableReplicationInstancesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeOrderableReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableReplicationInstancesResponse describeOrderableReplicationInstances() throws AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeOrderableReplicationInstances(DescribeOrderableReplicationInstancesRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about the replication instance types that can be created in the specified region.
     * </p>
     *
     * @param describeOrderableReplicationInstancesRequest
     * @return Result of the DescribeOrderableReplicationInstances operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeOrderableReplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeOrderableReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableReplicationInstancesResponse describeOrderableReplicationInstances(
            DescribeOrderableReplicationInstancesRequest describeOrderableReplicationInstancesRequest)
            throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the replication instance types that can be created in the specified region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeOrderableReplicationInstancesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeOrderableReplicationInstancesRequest#builder()}
     * </p>
     *
     * @param describeOrderableReplicationInstancesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeOrderableReplicationInstancesMessage.Builder}
     *        to create a request.
     * @return Result of the DescribeOrderableReplicationInstances operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeOrderableReplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeOrderableReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableReplicationInstancesResponse describeOrderableReplicationInstances(
            Consumer<DescribeOrderableReplicationInstancesRequest.Builder> describeOrderableReplicationInstancesRequest)
            throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeOrderableReplicationInstances(DescribeOrderableReplicationInstancesRequest.builder()
                .applyMutation(describeOrderableReplicationInstancesRequest).build());
    }

    /**
     * <p>
     * Returns information about the replication instance types that can be created in the specified region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeOrderableReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeOrderableReplicationInstancesIterable responses = client.describeOrderableReplicationInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeOrderableReplicationInstancesIterable responses = client
     *             .describeOrderableReplicationInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeOrderableReplicationInstancesIterable responses = client.describeOrderableReplicationInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrderableReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeOrderableReplicationInstances
     * @see #describeOrderableReplicationInstancesPaginator(DescribeOrderableReplicationInstancesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeOrderableReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableReplicationInstancesIterable describeOrderableReplicationInstancesPaginator()
            throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeOrderableReplicationInstancesPaginator(DescribeOrderableReplicationInstancesRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about the replication instance types that can be created in the specified region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeOrderableReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeOrderableReplicationInstancesIterable responses = client.describeOrderableReplicationInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeOrderableReplicationInstancesIterable responses = client
     *             .describeOrderableReplicationInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeOrderableReplicationInstancesIterable responses = client.describeOrderableReplicationInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrderableReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOrderableReplicationInstancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeOrderableReplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeOrderableReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableReplicationInstancesIterable describeOrderableReplicationInstancesPaginator(
            DescribeOrderableReplicationInstancesRequest describeOrderableReplicationInstancesRequest)
            throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the replication instance types that can be created in the specified region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeOrderableReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeOrderableReplicationInstancesIterable responses = client.describeOrderableReplicationInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeOrderableReplicationInstancesIterable responses = client
     *             .describeOrderableReplicationInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeOrderableReplicationInstancesIterable responses = client.describeOrderableReplicationInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrderableReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeOrderableReplicationInstancesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeOrderableReplicationInstancesRequest#builder()}
     * </p>
     *
     * @param describeOrderableReplicationInstancesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeOrderableReplicationInstancesMessage.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeOrderableReplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeOrderableReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableReplicationInstancesIterable describeOrderableReplicationInstancesPaginator(
            Consumer<DescribeOrderableReplicationInstancesRequest.Builder> describeOrderableReplicationInstancesRequest)
            throws AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeOrderableReplicationInstancesPaginator(DescribeOrderableReplicationInstancesRequest.builder()
                .applyMutation(describeOrderableReplicationInstancesRequest).build());
    }

    /**
     * <p>
     * For internal use only
     * </p>
     *
     * @param describePendingMaintenanceActionsRequest
     * @return Result of the DescribePendingMaintenanceActions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribePendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePendingMaintenanceActionsResponse describePendingMaintenanceActions(
            DescribePendingMaintenanceActionsRequest describePendingMaintenanceActionsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For internal use only
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePendingMaintenanceActionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribePendingMaintenanceActionsRequest#builder()}
     * </p>
     *
     * @param describePendingMaintenanceActionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribePendingMaintenanceActionsMessage.Builder} to
     *        create a request.
     * @return Result of the DescribePendingMaintenanceActions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribePendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePendingMaintenanceActionsResponse describePendingMaintenanceActions(
            Consumer<DescribePendingMaintenanceActionsRequest.Builder> describePendingMaintenanceActionsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describePendingMaintenanceActions(DescribePendingMaintenanceActionsRequest.builder()
                .applyMutation(describePendingMaintenanceActionsRequest).build());
    }

    /**
     * <p>
     * For internal use only
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePendingMaintenanceActions(software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribePendingMaintenanceActionsIterable responses = client.describePendingMaintenanceActionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribePendingMaintenanceActionsIterable responses = client
     *             .describePendingMaintenanceActionsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribePendingMaintenanceActionsIterable responses = client.describePendingMaintenanceActionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePendingMaintenanceActions(software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePendingMaintenanceActionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribePendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePendingMaintenanceActionsIterable describePendingMaintenanceActionsPaginator(
            DescribePendingMaintenanceActionsRequest describePendingMaintenanceActionsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For internal use only
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePendingMaintenanceActions(software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribePendingMaintenanceActionsIterable responses = client.describePendingMaintenanceActionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribePendingMaintenanceActionsIterable responses = client
     *             .describePendingMaintenanceActionsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribePendingMaintenanceActionsIterable responses = client.describePendingMaintenanceActionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePendingMaintenanceActions(software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePendingMaintenanceActionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribePendingMaintenanceActionsRequest#builder()}
     * </p>
     *
     * @param describePendingMaintenanceActionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribePendingMaintenanceActionsMessage.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribePendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePendingMaintenanceActionsIterable describePendingMaintenanceActionsPaginator(
            Consumer<DescribePendingMaintenanceActionsRequest.Builder> describePendingMaintenanceActionsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describePendingMaintenanceActionsPaginator(DescribePendingMaintenanceActionsRequest.builder()
                .applyMutation(describePendingMaintenanceActionsRequest).build());
    }

    /**
     * <p>
     * Returns the status of the RefreshSchemas operation.
     * </p>
     *
     * @param describeRefreshSchemasStatusRequest
     * @return Result of the DescribeRefreshSchemasStatus operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeRefreshSchemasStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRefreshSchemasStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRefreshSchemasStatusResponse describeRefreshSchemasStatus(
            DescribeRefreshSchemasStatusRequest describeRefreshSchemasStatusRequest) throws InvalidResourceStateException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the status of the RefreshSchemas operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRefreshSchemasStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRefreshSchemasStatusRequest#builder()}
     * </p>
     *
     * @param describeRefreshSchemasStatusRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRefreshSchemasStatusMessage.Builder} to create
     *        a request.
     * @return Result of the DescribeRefreshSchemasStatus operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeRefreshSchemasStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRefreshSchemasStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRefreshSchemasStatusResponse describeRefreshSchemasStatus(
            Consumer<DescribeRefreshSchemasStatusRequest.Builder> describeRefreshSchemasStatusRequest)
            throws InvalidResourceStateException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return describeRefreshSchemasStatus(DescribeRefreshSchemasStatusRequest.builder()
                .applyMutation(describeRefreshSchemasStatusRequest).build());
    }

    /**
     * <p>
     * Returns information about the task logs for the specified task.
     * </p>
     *
     * @param describeReplicationInstanceTaskLogsRequest
     * @return Result of the DescribeReplicationInstanceTaskLogs operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationInstanceTaskLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstanceTaskLogs"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationInstanceTaskLogsResponse describeReplicationInstanceTaskLogs(
            DescribeReplicationInstanceTaskLogsRequest describeReplicationInstanceTaskLogsRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the task logs for the specified task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationInstanceTaskLogsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReplicationInstanceTaskLogsRequest#builder()}
     * </p>
     *
     * @param describeReplicationInstanceTaskLogsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReplicationInstanceTaskLogsMessage.Builder} to
     *        create a request.
     * @return Result of the DescribeReplicationInstanceTaskLogs operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationInstanceTaskLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstanceTaskLogs"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationInstanceTaskLogsResponse describeReplicationInstanceTaskLogs(
            Consumer<DescribeReplicationInstanceTaskLogsRequest.Builder> describeReplicationInstanceTaskLogsRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return describeReplicationInstanceTaskLogs(DescribeReplicationInstanceTaskLogsRequest.builder()
                .applyMutation(describeReplicationInstanceTaskLogsRequest).build());
    }

    /**
     * <p>
     * Returns information about the task logs for the specified task.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationInstanceTaskLogs(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstanceTaskLogsIterable responses = client.describeReplicationInstanceTaskLogsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstanceTaskLogsIterable responses = client
     *             .describeReplicationInstanceTaskLogsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstanceTaskLogsIterable responses = client.describeReplicationInstanceTaskLogsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationInstanceTaskLogs(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationInstanceTaskLogsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationInstanceTaskLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstanceTaskLogs"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationInstanceTaskLogsIterable describeReplicationInstanceTaskLogsPaginator(
            DescribeReplicationInstanceTaskLogsRequest describeReplicationInstanceTaskLogsRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the task logs for the specified task.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationInstanceTaskLogs(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstanceTaskLogsIterable responses = client.describeReplicationInstanceTaskLogsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstanceTaskLogsIterable responses = client
     *             .describeReplicationInstanceTaskLogsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstanceTaskLogsIterable responses = client.describeReplicationInstanceTaskLogsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationInstanceTaskLogs(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationInstanceTaskLogsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReplicationInstanceTaskLogsRequest#builder()}
     * </p>
     *
     * @param describeReplicationInstanceTaskLogsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReplicationInstanceTaskLogsMessage.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationInstanceTaskLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstanceTaskLogs"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationInstanceTaskLogsIterable describeReplicationInstanceTaskLogsPaginator(
            Consumer<DescribeReplicationInstanceTaskLogsRequest.Builder> describeReplicationInstanceTaskLogsRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return describeReplicationInstanceTaskLogsPaginator(DescribeReplicationInstanceTaskLogsRequest.builder()
                .applyMutation(describeReplicationInstanceTaskLogsRequest).build());
    }

    /**
     * <p>
     * Returns information about replication instances for your account in the current region.
     * </p>
     *
     * @return Result of the DescribeReplicationInstances operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationInstances
     * @see #describeReplicationInstances(DescribeReplicationInstancesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationInstancesResponse describeReplicationInstances() throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationInstances(DescribeReplicationInstancesRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about replication instances for your account in the current region.
     * </p>
     *
     * @param describeReplicationInstancesRequest
     * @return Result of the DescribeReplicationInstances operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationInstancesResponse describeReplicationInstances(
            DescribeReplicationInstancesRequest describeReplicationInstancesRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about replication instances for your account in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationInstancesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReplicationInstancesRequest#builder()}
     * </p>
     *
     * @param describeReplicationInstancesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReplicationInstancesMessage.Builder} to create
     *        a request.
     * @return Result of the DescribeReplicationInstances operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationInstancesResponse describeReplicationInstances(
            Consumer<DescribeReplicationInstancesRequest.Builder> describeReplicationInstancesRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationInstances(DescribeReplicationInstancesRequest.builder()
                .applyMutation(describeReplicationInstancesRequest).build());
    }

    /**
     * <p>
     * Returns information about replication instances for your account in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstancesIterable responses = client.describeReplicationInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstancesIterable responses = client
     *             .describeReplicationInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstancesIterable responses = client.describeReplicationInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationInstances
     * @see #describeReplicationInstancesPaginator(DescribeReplicationInstancesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationInstancesIterable describeReplicationInstancesPaginator() throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationInstancesPaginator(DescribeReplicationInstancesRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about replication instances for your account in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstancesIterable responses = client.describeReplicationInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstancesIterable responses = client
     *             .describeReplicationInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstancesIterable responses = client.describeReplicationInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationInstancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationInstancesIterable describeReplicationInstancesPaginator(
            DescribeReplicationInstancesRequest describeReplicationInstancesRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about replication instances for your account in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstancesIterable responses = client.describeReplicationInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstancesIterable responses = client
     *             .describeReplicationInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstancesIterable responses = client.describeReplicationInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationInstancesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReplicationInstancesRequest#builder()}
     * </p>
     *
     * @param describeReplicationInstancesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReplicationInstancesMessage.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationInstancesIterable describeReplicationInstancesPaginator(
            Consumer<DescribeReplicationInstancesRequest.Builder> describeReplicationInstancesRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationInstancesPaginator(DescribeReplicationInstancesRequest.builder()
                .applyMutation(describeReplicationInstancesRequest).build());
    }

    /**
     * <p>
     * Returns information about the replication subnet groups.
     * </p>
     *
     * @return Result of the DescribeReplicationSubnetGroups operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationSubnetGroups
     * @see #describeReplicationSubnetGroups(DescribeReplicationSubnetGroupsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationSubnetGroupsResponse describeReplicationSubnetGroups() throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationSubnetGroups(DescribeReplicationSubnetGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about the replication subnet groups.
     * </p>
     *
     * @param describeReplicationSubnetGroupsRequest
     * @return Result of the DescribeReplicationSubnetGroups operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationSubnetGroupsResponse describeReplicationSubnetGroups(
            DescribeReplicationSubnetGroupsRequest describeReplicationSubnetGroupsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the replication subnet groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationSubnetGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReplicationSubnetGroupsRequest#builder()}
     * </p>
     *
     * @param describeReplicationSubnetGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReplicationSubnetGroupsMessage.Builder} to
     *        create a request.
     * @return Result of the DescribeReplicationSubnetGroups operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationSubnetGroupsResponse describeReplicationSubnetGroups(
            Consumer<DescribeReplicationSubnetGroupsRequest.Builder> describeReplicationSubnetGroupsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationSubnetGroups(DescribeReplicationSubnetGroupsRequest.builder()
                .applyMutation(describeReplicationSubnetGroupsRequest).build());
    }

    /**
     * <p>
     * Returns information about the replication subnet groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationSubnetGroups(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationSubnetGroupsIterable responses = client.describeReplicationSubnetGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationSubnetGroupsIterable responses = client
     *             .describeReplicationSubnetGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationSubnetGroupsIterable responses = client.describeReplicationSubnetGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationSubnetGroups(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationSubnetGroups
     * @see #describeReplicationSubnetGroupsPaginator(DescribeReplicationSubnetGroupsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationSubnetGroupsIterable describeReplicationSubnetGroupsPaginator() throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationSubnetGroupsPaginator(DescribeReplicationSubnetGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about the replication subnet groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationSubnetGroups(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationSubnetGroupsIterable responses = client.describeReplicationSubnetGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationSubnetGroupsIterable responses = client
     *             .describeReplicationSubnetGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationSubnetGroupsIterable responses = client.describeReplicationSubnetGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationSubnetGroups(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationSubnetGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationSubnetGroupsIterable describeReplicationSubnetGroupsPaginator(
            DescribeReplicationSubnetGroupsRequest describeReplicationSubnetGroupsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the replication subnet groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationSubnetGroups(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationSubnetGroupsIterable responses = client.describeReplicationSubnetGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationSubnetGroupsIterable responses = client
     *             .describeReplicationSubnetGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationSubnetGroupsIterable responses = client.describeReplicationSubnetGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationSubnetGroups(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationSubnetGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReplicationSubnetGroupsRequest#builder()}
     * </p>
     *
     * @param describeReplicationSubnetGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReplicationSubnetGroupsMessage.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationSubnetGroupsIterable describeReplicationSubnetGroupsPaginator(
            Consumer<DescribeReplicationSubnetGroupsRequest.Builder> describeReplicationSubnetGroupsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationSubnetGroupsPaginator(DescribeReplicationSubnetGroupsRequest.builder()
                .applyMutation(describeReplicationSubnetGroupsRequest).build());
    }

    /**
     * <p>
     * Returns the task assessment results from the Amazon S3 bucket that DMS creates in your Amazon Web Services
     * account. This action always returns the latest results.
     * </p>
     * <p>
     * For more information about DMS task assessments, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html">Creating a task
     * assessment report</a> in the <i>Database Migration Service User Guide</i>.
     * </p>
     *
     * @param describeReplicationTaskAssessmentResultsRequest
     * @return Result of the DescribeReplicationTaskAssessmentResults operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTaskAssessmentResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentResults"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTaskAssessmentResultsResponse describeReplicationTaskAssessmentResults(
            DescribeReplicationTaskAssessmentResultsRequest describeReplicationTaskAssessmentResultsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the task assessment results from the Amazon S3 bucket that DMS creates in your Amazon Web Services
     * account. This action always returns the latest results.
     * </p>
     * <p>
     * For more information about DMS task assessments, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html">Creating a task
     * assessment report</a> in the <i>Database Migration Service User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReplicationTaskAssessmentResultsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeReplicationTaskAssessmentResultsRequest#builder()}
     * </p>
     *
     * @param describeReplicationTaskAssessmentResultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeReplicationTaskAssessmentResultsMessage.Builder} to create a request.
     * @return Result of the DescribeReplicationTaskAssessmentResults operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTaskAssessmentResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentResults"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTaskAssessmentResultsResponse describeReplicationTaskAssessmentResults(
            Consumer<DescribeReplicationTaskAssessmentResultsRequest.Builder> describeReplicationTaskAssessmentResultsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationTaskAssessmentResults(DescribeReplicationTaskAssessmentResultsRequest.builder()
                .applyMutation(describeReplicationTaskAssessmentResultsRequest).build());
    }

    /**
     * <p>
     * Returns the task assessment results from the Amazon S3 bucket that DMS creates in your Amazon Web Services
     * account. This action always returns the latest results.
     * </p>
     * <p>
     * For more information about DMS task assessments, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html">Creating a task
     * assessment report</a> in the <i>Database Migration Service User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationTaskAssessmentResults(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentResultsIterable responses = client.describeReplicationTaskAssessmentResultsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentResultsIterable responses = client
     *             .describeReplicationTaskAssessmentResultsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentResultsIterable responses = client.describeReplicationTaskAssessmentResultsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationTaskAssessmentResults(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationTaskAssessmentResultsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTaskAssessmentResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentResults"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTaskAssessmentResultsIterable describeReplicationTaskAssessmentResultsPaginator(
            DescribeReplicationTaskAssessmentResultsRequest describeReplicationTaskAssessmentResultsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the task assessment results from the Amazon S3 bucket that DMS creates in your Amazon Web Services
     * account. This action always returns the latest results.
     * </p>
     * <p>
     * For more information about DMS task assessments, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html">Creating a task
     * assessment report</a> in the <i>Database Migration Service User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationTaskAssessmentResults(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentResultsIterable responses = client.describeReplicationTaskAssessmentResultsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentResultsIterable responses = client
     *             .describeReplicationTaskAssessmentResultsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentResultsIterable responses = client.describeReplicationTaskAssessmentResultsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationTaskAssessmentResults(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReplicationTaskAssessmentResultsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeReplicationTaskAssessmentResultsRequest#builder()}
     * </p>
     *
     * @param describeReplicationTaskAssessmentResultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeReplicationTaskAssessmentResultsMessage.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTaskAssessmentResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentResults"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTaskAssessmentResultsIterable describeReplicationTaskAssessmentResultsPaginator(
            Consumer<DescribeReplicationTaskAssessmentResultsRequest.Builder> describeReplicationTaskAssessmentResultsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationTaskAssessmentResultsPaginator(DescribeReplicationTaskAssessmentResultsRequest.builder()
                .applyMutation(describeReplicationTaskAssessmentResultsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of premigration assessment runs based on filter settings.
     * </p>
     * <p>
     * These filter settings can specify a combination of premigration assessment runs, migration tasks, replication
     * instances, and assessment run status values.
     * </p>
     * <note>
     * <p>
     * This operation doesn't return information about individual assessments. For this information, see the
     * <code>DescribeReplicationTaskIndividualAssessments</code> operation.
     * </p>
     * </note>
     *
     * @param describeReplicationTaskAssessmentRunsRequest
     * @return Result of the DescribeReplicationTaskAssessmentRuns operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTaskAssessmentRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTaskAssessmentRunsResponse describeReplicationTaskAssessmentRuns(
            DescribeReplicationTaskAssessmentRunsRequest describeReplicationTaskAssessmentRunsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of premigration assessment runs based on filter settings.
     * </p>
     * <p>
     * These filter settings can specify a combination of premigration assessment runs, migration tasks, replication
     * instances, and assessment run status values.
     * </p>
     * <note>
     * <p>
     * This operation doesn't return information about individual assessments. For this information, see the
     * <code>DescribeReplicationTaskIndividualAssessments</code> operation.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReplicationTaskAssessmentRunsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeReplicationTaskAssessmentRunsRequest#builder()}
     * </p>
     *
     * @param describeReplicationTaskAssessmentRunsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReplicationTaskAssessmentRunsMessage.Builder}
     *        to create a request.
     * @return Result of the DescribeReplicationTaskAssessmentRuns operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTaskAssessmentRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTaskAssessmentRunsResponse describeReplicationTaskAssessmentRuns(
            Consumer<DescribeReplicationTaskAssessmentRunsRequest.Builder> describeReplicationTaskAssessmentRunsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationTaskAssessmentRuns(DescribeReplicationTaskAssessmentRunsRequest.builder()
                .applyMutation(describeReplicationTaskAssessmentRunsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of premigration assessment runs based on filter settings.
     * </p>
     * <p>
     * These filter settings can specify a combination of premigration assessment runs, migration tasks, replication
     * instances, and assessment run status values.
     * </p>
     * <note>
     * <p>
     * This operation doesn't return information about individual assessments. For this information, see the
     * <code>DescribeReplicationTaskIndividualAssessments</code> operation.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationTaskAssessmentRuns(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentRunsIterable responses = client.describeReplicationTaskAssessmentRunsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentRunsIterable responses = client
     *             .describeReplicationTaskAssessmentRunsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentRunsIterable responses = client.describeReplicationTaskAssessmentRunsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationTaskAssessmentRuns(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationTaskAssessmentRunsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTaskAssessmentRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTaskAssessmentRunsIterable describeReplicationTaskAssessmentRunsPaginator(
            DescribeReplicationTaskAssessmentRunsRequest describeReplicationTaskAssessmentRunsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of premigration assessment runs based on filter settings.
     * </p>
     * <p>
     * These filter settings can specify a combination of premigration assessment runs, migration tasks, replication
     * instances, and assessment run status values.
     * </p>
     * <note>
     * <p>
     * This operation doesn't return information about individual assessments. For this information, see the
     * <code>DescribeReplicationTaskIndividualAssessments</code> operation.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationTaskAssessmentRuns(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentRunsIterable responses = client.describeReplicationTaskAssessmentRunsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentRunsIterable responses = client
     *             .describeReplicationTaskAssessmentRunsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentRunsIterable responses = client.describeReplicationTaskAssessmentRunsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationTaskAssessmentRuns(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReplicationTaskAssessmentRunsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeReplicationTaskAssessmentRunsRequest#builder()}
     * </p>
     *
     * @param describeReplicationTaskAssessmentRunsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReplicationTaskAssessmentRunsMessage.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTaskAssessmentRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTaskAssessmentRunsIterable describeReplicationTaskAssessmentRunsPaginator(
            Consumer<DescribeReplicationTaskAssessmentRunsRequest.Builder> describeReplicationTaskAssessmentRunsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationTaskAssessmentRunsPaginator(DescribeReplicationTaskAssessmentRunsRequest.builder()
                .applyMutation(describeReplicationTaskAssessmentRunsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of individual assessments based on filter settings.
     * </p>
     * <p>
     * These filter settings can specify a combination of premigration assessment runs, migration tasks, and assessment
     * status values.
     * </p>
     *
     * @param describeReplicationTaskIndividualAssessmentsRequest
     * @return Result of the DescribeReplicationTaskIndividualAssessments operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTaskIndividualAssessments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskIndividualAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTaskIndividualAssessmentsResponse describeReplicationTaskIndividualAssessments(
            DescribeReplicationTaskIndividualAssessmentsRequest describeReplicationTaskIndividualAssessmentsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of individual assessments based on filter settings.
     * </p>
     * <p>
     * These filter settings can specify a combination of premigration assessment runs, migration tasks, and assessment
     * status values.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReplicationTaskIndividualAssessmentsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeReplicationTaskIndividualAssessmentsRequest#builder()}
     * </p>
     *
     * @param describeReplicationTaskIndividualAssessmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeReplicationTaskIndividualAssessmentsMessage.Builder} to create a request.
     * @return Result of the DescribeReplicationTaskIndividualAssessments operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTaskIndividualAssessments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskIndividualAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTaskIndividualAssessmentsResponse describeReplicationTaskIndividualAssessments(
            Consumer<DescribeReplicationTaskIndividualAssessmentsRequest.Builder> describeReplicationTaskIndividualAssessmentsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationTaskIndividualAssessments(DescribeReplicationTaskIndividualAssessmentsRequest.builder()
                .applyMutation(describeReplicationTaskIndividualAssessmentsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of individual assessments based on filter settings.
     * </p>
     * <p>
     * These filter settings can specify a combination of premigration assessment runs, migration tasks, and assessment
     * status values.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationTaskIndividualAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskIndividualAssessmentsIterable responses = client.describeReplicationTaskIndividualAssessmentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskIndividualAssessmentsIterable responses = client
     *             .describeReplicationTaskIndividualAssessmentsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskIndividualAssessmentsIterable responses = client.describeReplicationTaskIndividualAssessmentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationTaskIndividualAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationTaskIndividualAssessmentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTaskIndividualAssessments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskIndividualAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTaskIndividualAssessmentsIterable describeReplicationTaskIndividualAssessmentsPaginator(
            DescribeReplicationTaskIndividualAssessmentsRequest describeReplicationTaskIndividualAssessmentsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of individual assessments based on filter settings.
     * </p>
     * <p>
     * These filter settings can specify a combination of premigration assessment runs, migration tasks, and assessment
     * status values.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationTaskIndividualAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskIndividualAssessmentsIterable responses = client.describeReplicationTaskIndividualAssessmentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskIndividualAssessmentsIterable responses = client
     *             .describeReplicationTaskIndividualAssessmentsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskIndividualAssessmentsIterable responses = client.describeReplicationTaskIndividualAssessmentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationTaskIndividualAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReplicationTaskIndividualAssessmentsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeReplicationTaskIndividualAssessmentsRequest#builder()}
     * </p>
     *
     * @param describeReplicationTaskIndividualAssessmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeReplicationTaskIndividualAssessmentsMessage.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTaskIndividualAssessments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskIndividualAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTaskIndividualAssessmentsIterable describeReplicationTaskIndividualAssessmentsPaginator(
            Consumer<DescribeReplicationTaskIndividualAssessmentsRequest.Builder> describeReplicationTaskIndividualAssessmentsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationTaskIndividualAssessmentsPaginator(DescribeReplicationTaskIndividualAssessmentsRequest
                .builder().applyMutation(describeReplicationTaskIndividualAssessmentsRequest).build());
    }

    /**
     * <p>
     * Returns information about replication tasks for your account in the current region.
     * </p>
     *
     * @return Result of the DescribeReplicationTasks operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTasks
     * @see #describeReplicationTasks(DescribeReplicationTasksRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReplicationTasksResponse describeReplicationTasks() throws ResourceNotFoundException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return describeReplicationTasks(DescribeReplicationTasksRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about replication tasks for your account in the current region.
     * </p>
     *
     * @param describeReplicationTasksRequest
     * @return Result of the DescribeReplicationTasks operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReplicationTasksResponse describeReplicationTasks(
            DescribeReplicationTasksRequest describeReplicationTasksRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about replication tasks for your account in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationTasksRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeReplicationTasksRequest#builder()}
     * </p>
     *
     * @param describeReplicationTasksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReplicationTasksMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeReplicationTasks operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReplicationTasksResponse describeReplicationTasks(
            Consumer<DescribeReplicationTasksRequest.Builder> describeReplicationTasksRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationTasks(DescribeReplicationTasksRequest.builder().applyMutation(describeReplicationTasksRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about replication tasks for your account in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationTasks(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTasksIterable responses = client.describeReplicationTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTasksIterable responses = client
     *             .describeReplicationTasksPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTasksIterable responses = client.describeReplicationTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationTasks(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTasks
     * @see #describeReplicationTasksPaginator(DescribeReplicationTasksRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReplicationTasksIterable describeReplicationTasksPaginator() throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationTasksPaginator(DescribeReplicationTasksRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about replication tasks for your account in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationTasks(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTasksIterable responses = client.describeReplicationTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTasksIterable responses = client
     *             .describeReplicationTasksPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTasksIterable responses = client.describeReplicationTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationTasks(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationTasksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReplicationTasksIterable describeReplicationTasksPaginator(
            DescribeReplicationTasksRequest describeReplicationTasksRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about replication tasks for your account in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationTasks(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTasksIterable responses = client.describeReplicationTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTasksIterable responses = client
     *             .describeReplicationTasksPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTasksIterable responses = client.describeReplicationTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationTasks(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationTasksRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeReplicationTasksRequest#builder()}
     * </p>
     *
     * @param describeReplicationTasksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReplicationTasksMessage.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeReplicationTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReplicationTasksIterable describeReplicationTasksPaginator(
            Consumer<DescribeReplicationTasksRequest.Builder> describeReplicationTasksRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeReplicationTasksPaginator(DescribeReplicationTasksRequest.builder()
                .applyMutation(describeReplicationTasksRequest).build());
    }

    /**
     * <p>
     * Returns information about the schema for the specified endpoint.
     * </p>
     * <p/>
     *
     * @param describeSchemasRequest
     * @return Result of the DescribeSchemas operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSchemasResponse describeSchemas(DescribeSchemasRequest describeSchemasRequest)
            throws InvalidResourceStateException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the schema for the specified endpoint.
     * </p>
     * <p/>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSchemasRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeSchemasRequest#builder()}
     * </p>
     *
     * @param describeSchemasRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSchemasMessage.Builder} to create a request.
     * @return Result of the DescribeSchemas operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSchemasResponse describeSchemas(Consumer<DescribeSchemasRequest.Builder> describeSchemasRequest)
            throws InvalidResourceStateException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return describeSchemas(DescribeSchemasRequest.builder().applyMutation(describeSchemasRequest).build());
    }

    /**
     * <p>
     * Returns information about the schema for the specified endpoint.
     * </p>
     * <p/>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeSchemas(software.amazon.awssdk.services.databasemigration.model.DescribeSchemasRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeSchemasIterable responses = client.describeSchemasPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeSchemasIterable responses = client
     *             .describeSchemasPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeSchemasResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeSchemasIterable responses = client.describeSchemasPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSchemas(software.amazon.awssdk.services.databasemigration.model.DescribeSchemasRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSchemasRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSchemasIterable describeSchemasPaginator(DescribeSchemasRequest describeSchemasRequest)
            throws InvalidResourceStateException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the schema for the specified endpoint.
     * </p>
     * <p/>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeSchemas(software.amazon.awssdk.services.databasemigration.model.DescribeSchemasRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeSchemasIterable responses = client.describeSchemasPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeSchemasIterable responses = client
     *             .describeSchemasPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeSchemasResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeSchemasIterable responses = client.describeSchemasPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSchemas(software.amazon.awssdk.services.databasemigration.model.DescribeSchemasRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSchemasRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeSchemasRequest#builder()}
     * </p>
     *
     * @param describeSchemasRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSchemasMessage.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSchemasIterable describeSchemasPaginator(Consumer<DescribeSchemasRequest.Builder> describeSchemasRequest)
            throws InvalidResourceStateException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return describeSchemasPaginator(DescribeSchemasRequest.builder().applyMutation(describeSchemasRequest).build());
    }

    /**
     * <p>
     * Returns table statistics on the database migration task, including table name, rows inserted, rows updated, and
     * rows deleted.
     * </p>
     * <p>
     * Note that the "last updated" column the DMS console only indicates the time that DMS last updated the table
     * statistics record for a table. It does not indicate the time of the last update to the table.
     * </p>
     *
     * @param describeTableStatisticsRequest
     * @return Result of the DescribeTableStatistics operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeTableStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeTableStatistics" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeTableStatisticsResponse describeTableStatistics(DescribeTableStatisticsRequest describeTableStatisticsRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns table statistics on the database migration task, including table name, rows inserted, rows updated, and
     * rows deleted.
     * </p>
     * <p>
     * Note that the "last updated" column the DMS console only indicates the time that DMS last updated the table
     * statistics record for a table. It does not indicate the time of the last update to the table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTableStatisticsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeTableStatisticsRequest#builder()}
     * </p>
     *
     * @param describeTableStatisticsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTableStatisticsMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeTableStatistics operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeTableStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeTableStatistics" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeTableStatisticsResponse describeTableStatistics(
            Consumer<DescribeTableStatisticsRequest.Builder> describeTableStatisticsRequest) throws ResourceNotFoundException,
            InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeTableStatistics(DescribeTableStatisticsRequest.builder().applyMutation(describeTableStatisticsRequest)
                .build());
    }

    /**
     * <p>
     * Returns table statistics on the database migration task, including table name, rows inserted, rows updated, and
     * rows deleted.
     * </p>
     * <p>
     * Note that the "last updated" column the DMS console only indicates the time that DMS last updated the table
     * statistics record for a table. It does not indicate the time of the last update to the table.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeTableStatistics(software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeTableStatisticsIterable responses = client.describeTableStatisticsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeTableStatisticsIterable responses = client
     *             .describeTableStatisticsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeTableStatisticsIterable responses = client.describeTableStatisticsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTableStatistics(software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeTableStatisticsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeTableStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeTableStatistics" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeTableStatisticsIterable describeTableStatisticsPaginator(
            DescribeTableStatisticsRequest describeTableStatisticsRequest) throws ResourceNotFoundException,
            InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns table statistics on the database migration task, including table name, rows inserted, rows updated, and
     * rows deleted.
     * </p>
     * <p>
     * Note that the "last updated" column the DMS console only indicates the time that DMS last updated the table
     * statistics record for a table. It does not indicate the time of the last update to the table.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeTableStatistics(software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeTableStatisticsIterable responses = client.describeTableStatisticsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.databasemigration.paginators.DescribeTableStatisticsIterable responses = client
     *             .describeTableStatisticsPaginator(request);
     *     for (software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeTableStatisticsIterable responses = client.describeTableStatisticsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTableStatistics(software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTableStatisticsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeTableStatisticsRequest#builder()}
     * </p>
     *
     * @param describeTableStatisticsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTableStatisticsMessage.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.DescribeTableStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeTableStatistics" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeTableStatisticsIterable describeTableStatisticsPaginator(
            Consumer<DescribeTableStatisticsRequest.Builder> describeTableStatisticsRequest) throws ResourceNotFoundException,
            InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return describeTableStatisticsPaginator(DescribeTableStatisticsRequest.builder()
                .applyMutation(describeTableStatisticsRequest).build());
    }

    /**
     * <p>
     * Uploads the specified certificate.
     * </p>
     *
     * @param importCertificateRequest
     * @return Result of the ImportCertificate operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws InvalidCertificateException
     *         The certificate was not valid.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ImportCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ImportCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    default ImportCertificateResponse importCertificate(ImportCertificateRequest importCertificateRequest)
            throws ResourceAlreadyExistsException, InvalidCertificateException, ResourceQuotaExceededException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Uploads the specified certificate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportCertificateRequest.Builder} avoiding the need
     * to create one manually via {@link ImportCertificateRequest#builder()}
     * </p>
     *
     * @param importCertificateRequest
     *        A {@link Consumer} that will call methods on {@link ImportCertificateMessage.Builder} to create a request.
     * @return Result of the ImportCertificate operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws InvalidCertificateException
     *         The certificate was not valid.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ImportCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ImportCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    default ImportCertificateResponse importCertificate(Consumer<ImportCertificateRequest.Builder> importCertificateRequest)
            throws ResourceAlreadyExistsException, InvalidCertificateException, ResourceQuotaExceededException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return importCertificate(ImportCertificateRequest.builder().applyMutation(importCertificateRequest).build());
    }

    /**
     * <p>
     * Lists all metadata tags attached to an DMS resource, including replication instance, endpoint, security group,
     * and migration task. For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html"> <code>Tag</code> </a> data type
     * description.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all metadata tags attached to an DMS resource, including replication instance, endpoint, security group,
     * and migration task. For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html"> <code>Tag</code> </a> data type
     * description.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceMessage.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Modifies the specified endpoint.
     * </p>
     * <note>
     * <p>
     * For a MySQL source or target endpoint, don't explicitly specify the database using the <code>DatabaseName</code>
     * request parameter on the <code>ModifyEndpoint</code> API call. Specifying <code>DatabaseName</code> when you
     * modify a MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify
     * the database only when you specify the schema in the table-mapping rules of the DMS task.
     * </p>
     * </note>
     *
     * @param modifyEndpointRequest
     * @return Result of the ModifyEndpoint operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyEndpointResponse modifyEndpoint(ModifyEndpointRequest modifyEndpointRequest)
            throws InvalidResourceStateException, ResourceNotFoundException, ResourceAlreadyExistsException,
            KmsKeyNotAccessibleException, AccessDeniedException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the specified endpoint.
     * </p>
     * <note>
     * <p>
     * For a MySQL source or target endpoint, don't explicitly specify the database using the <code>DatabaseName</code>
     * request parameter on the <code>ModifyEndpoint</code> API call. Specifying <code>DatabaseName</code> when you
     * modify a MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify
     * the database only when you specify the schema in the table-mapping rules of the DMS task.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link ModifyEndpointRequest#builder()}
     * </p>
     *
     * @param modifyEndpointRequest
     *        A {@link Consumer} that will call methods on {@link ModifyEndpointMessage.Builder} to create a request.
     * @return Result of the ModifyEndpoint operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyEndpointResponse modifyEndpoint(Consumer<ModifyEndpointRequest.Builder> modifyEndpointRequest)
            throws InvalidResourceStateException, ResourceNotFoundException, ResourceAlreadyExistsException,
            KmsKeyNotAccessibleException, AccessDeniedException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return modifyEndpoint(ModifyEndpointRequest.builder().applyMutation(modifyEndpointRequest).build());
    }

    /**
     * <p>
     * Modifies an existing DMS event notification subscription.
     * </p>
     *
     * @param modifyEventSubscriptionRequest
     * @return Result of the ModifyEventSubscription operation returned by the service.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SnsInvalidTopicException
     *         The SNS topic is invalid.
     * @throws SnsNoAuthorizationException
     *         You are not authorized for the SNS subscription.
     * @throws KmsAccessDeniedException
     *         The ciphertext references a key that doesn't exist or that the DMS account doesn't have access to.
     * @throws KmsDisabledException
     *         The specified KMS key isn't enabled.
     * @throws KmsInvalidStateException
     *         The state of the specified KMS resource isn't valid for this request.
     * @throws KmsNotFoundException
     *         The specified KMS entity or resource can't be found.
     * @throws KmsThrottlingException
     *         This request triggered KMS request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default ModifyEventSubscriptionResponse modifyEventSubscription(ModifyEventSubscriptionRequest modifyEventSubscriptionRequest)
            throws ResourceQuotaExceededException, ResourceNotFoundException, SnsInvalidTopicException,
            SnsNoAuthorizationException, KmsAccessDeniedException, KmsDisabledException, KmsInvalidStateException,
            KmsNotFoundException, KmsThrottlingException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies an existing DMS event notification subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyEventSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link ModifyEventSubscriptionRequest#builder()}
     * </p>
     *
     * @param modifyEventSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link ModifyEventSubscriptionMessage.Builder} to create a
     *        request.
     * @return Result of the ModifyEventSubscription operation returned by the service.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SnsInvalidTopicException
     *         The SNS topic is invalid.
     * @throws SnsNoAuthorizationException
     *         You are not authorized for the SNS subscription.
     * @throws KmsAccessDeniedException
     *         The ciphertext references a key that doesn't exist or that the DMS account doesn't have access to.
     * @throws KmsDisabledException
     *         The specified KMS key isn't enabled.
     * @throws KmsInvalidStateException
     *         The state of the specified KMS resource isn't valid for this request.
     * @throws KmsNotFoundException
     *         The specified KMS entity or resource can't be found.
     * @throws KmsThrottlingException
     *         This request triggered KMS request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default ModifyEventSubscriptionResponse modifyEventSubscription(
            Consumer<ModifyEventSubscriptionRequest.Builder> modifyEventSubscriptionRequest)
            throws ResourceQuotaExceededException, ResourceNotFoundException, SnsInvalidTopicException,
            SnsNoAuthorizationException, KmsAccessDeniedException, KmsDisabledException, KmsInvalidStateException,
            KmsNotFoundException, KmsThrottlingException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return modifyEventSubscription(ModifyEventSubscriptionRequest.builder().applyMutation(modifyEventSubscriptionRequest)
                .build());
    }

    /**
     * <p>
     * Modifies the replication instance to apply new settings. You can change one or more parameters by specifying
     * these parameters and the new values in the request.
     * </p>
     * <p>
     * Some settings are applied during the maintenance window.
     * </p>
     * <p/>
     *
     * @param modifyReplicationInstanceRequest
     * @return Result of the ModifyReplicationInstance operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InsufficientResourceCapacityException
     *         There are not enough resources allocated to the database migration.
     * @throws StorageQuotaExceededException
     *         The storage quota has been exceeded.
     * @throws UpgradeDependencyFailureException
     *         An upgrade dependency is preventing the database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyReplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default ModifyReplicationInstanceResponse modifyReplicationInstance(
            ModifyReplicationInstanceRequest modifyReplicationInstanceRequest) throws AccessDeniedException,
            InvalidResourceStateException, ResourceAlreadyExistsException, ResourceNotFoundException,
            InsufficientResourceCapacityException, StorageQuotaExceededException, UpgradeDependencyFailureException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the replication instance to apply new settings. You can change one or more parameters by specifying
     * these parameters and the new values in the request.
     * </p>
     * <p>
     * Some settings are applied during the maintenance window.
     * </p>
     * <p/>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyReplicationInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link ModifyReplicationInstanceRequest#builder()}
     * </p>
     *
     * @param modifyReplicationInstanceRequest
     *        A {@link Consumer} that will call methods on {@link ModifyReplicationInstanceMessage.Builder} to create a
     *        request.
     * @return Result of the ModifyReplicationInstance operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InsufficientResourceCapacityException
     *         There are not enough resources allocated to the database migration.
     * @throws StorageQuotaExceededException
     *         The storage quota has been exceeded.
     * @throws UpgradeDependencyFailureException
     *         An upgrade dependency is preventing the database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyReplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default ModifyReplicationInstanceResponse modifyReplicationInstance(
            Consumer<ModifyReplicationInstanceRequest.Builder> modifyReplicationInstanceRequest) throws AccessDeniedException,
            InvalidResourceStateException, ResourceAlreadyExistsException, ResourceNotFoundException,
            InsufficientResourceCapacityException, StorageQuotaExceededException, UpgradeDependencyFailureException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return modifyReplicationInstance(ModifyReplicationInstanceRequest.builder()
                .applyMutation(modifyReplicationInstanceRequest).build());
    }

    /**
     * <p>
     * Modifies the settings for the specified replication subnet group.
     * </p>
     *
     * @param modifyReplicationSubnetGroupRequest
     * @return Result of the ModifyReplicationSubnetGroup operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws SubnetAlreadyInUseException
     *         The specified subnet is already in use.
     * @throws ReplicationSubnetGroupDoesNotCoverEnoughAZsException
     *         The replication subnet group does not cover enough Availability Zones (AZs). Edit the replication subnet
     *         group and add more AZs.
     * @throws InvalidSubnetException
     *         The subnet provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyReplicationSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyReplicationSubnetGroupResponse modifyReplicationSubnetGroup(
            ModifyReplicationSubnetGroupRequest modifyReplicationSubnetGroupRequest) throws AccessDeniedException,
            ResourceNotFoundException, ResourceQuotaExceededException, SubnetAlreadyInUseException,
            ReplicationSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the settings for the specified replication subnet group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyReplicationSubnetGroupRequest.Builder}
     * avoiding the need to create one manually via {@link ModifyReplicationSubnetGroupRequest#builder()}
     * </p>
     *
     * @param modifyReplicationSubnetGroupRequest
     *        A {@link Consumer} that will call methods on {@link ModifyReplicationSubnetGroupMessage.Builder} to create
     *        a request.
     * @return Result of the ModifyReplicationSubnetGroup operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws SubnetAlreadyInUseException
     *         The specified subnet is already in use.
     * @throws ReplicationSubnetGroupDoesNotCoverEnoughAZsException
     *         The replication subnet group does not cover enough Availability Zones (AZs). Edit the replication subnet
     *         group and add more AZs.
     * @throws InvalidSubnetException
     *         The subnet provided is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyReplicationSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyReplicationSubnetGroupResponse modifyReplicationSubnetGroup(
            Consumer<ModifyReplicationSubnetGroupRequest.Builder> modifyReplicationSubnetGroupRequest)
            throws AccessDeniedException, ResourceNotFoundException, ResourceQuotaExceededException, SubnetAlreadyInUseException,
            ReplicationSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return modifyReplicationSubnetGroup(ModifyReplicationSubnetGroupRequest.builder()
                .applyMutation(modifyReplicationSubnetGroupRequest).build());
    }

    /**
     * <p>
     * Modifies the specified replication task.
     * </p>
     * <p>
     * You can't modify the task endpoints. The task must be stopped before you can modify it.
     * </p>
     * <p>
     * For more information about DMS tasks, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html">Working with Migration Tasks</a> in the
     * <i>Database Migration Service User Guide</i>.
     * </p>
     *
     * @param modifyReplicationTaskRequest
     * @return Result of the ModifyReplicationTask operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyReplicationTaskResponse modifyReplicationTask(ModifyReplicationTaskRequest modifyReplicationTaskRequest)
            throws InvalidResourceStateException, ResourceNotFoundException, ResourceAlreadyExistsException,
            KmsKeyNotAccessibleException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the specified replication task.
     * </p>
     * <p>
     * You can't modify the task endpoints. The task must be stopped before you can modify it.
     * </p>
     * <p>
     * For more information about DMS tasks, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html">Working with Migration Tasks</a> in the
     * <i>Database Migration Service User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyReplicationTaskRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyReplicationTaskRequest#builder()}
     * </p>
     *
     * @param modifyReplicationTaskRequest
     *        A {@link Consumer} that will call methods on {@link ModifyReplicationTaskMessage.Builder} to create a
     *        request.
     * @return Result of the ModifyReplicationTask operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ModifyReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyReplicationTaskResponse modifyReplicationTask(
            Consumer<ModifyReplicationTaskRequest.Builder> modifyReplicationTaskRequest) throws InvalidResourceStateException,
            ResourceNotFoundException, ResourceAlreadyExistsException, KmsKeyNotAccessibleException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return modifyReplicationTask(ModifyReplicationTaskRequest.builder().applyMutation(modifyReplicationTaskRequest).build());
    }

    /**
     * <p>
     * Moves a replication task from its current replication instance to a different target replication instance using
     * the specified parameters. The target replication instance must be created with the same or later DMS version as
     * the current replication instance.
     * </p>
     *
     * @param moveReplicationTaskRequest
     * @return Result of the MoveReplicationTask operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.MoveReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/MoveReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default MoveReplicationTaskResponse moveReplicationTask(MoveReplicationTaskRequest moveReplicationTaskRequest)
            throws AccessDeniedException, InvalidResourceStateException, ResourceNotFoundException, KmsKeyNotAccessibleException,
            ResourceQuotaExceededException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Moves a replication task from its current replication instance to a different target replication instance using
     * the specified parameters. The target replication instance must be created with the same or later DMS version as
     * the current replication instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link MoveReplicationTaskRequest.Builder} avoiding the
     * need to create one manually via {@link MoveReplicationTaskRequest#builder()}
     * </p>
     *
     * @param moveReplicationTaskRequest
     *        A {@link Consumer} that will call methods on {@link MoveReplicationTaskMessage.Builder} to create a
     *        request.
     * @return Result of the MoveReplicationTask operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.MoveReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/MoveReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default MoveReplicationTaskResponse moveReplicationTask(
            Consumer<MoveReplicationTaskRequest.Builder> moveReplicationTaskRequest) throws AccessDeniedException,
            InvalidResourceStateException, ResourceNotFoundException, KmsKeyNotAccessibleException,
            ResourceQuotaExceededException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return moveReplicationTask(MoveReplicationTaskRequest.builder().applyMutation(moveReplicationTaskRequest).build());
    }

    /**
     * <p>
     * Reboots a replication instance. Rebooting results in a momentary outage, until the replication instance becomes
     * available again.
     * </p>
     *
     * @param rebootReplicationInstanceRequest
     * @return Result of the RebootReplicationInstance operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.RebootReplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RebootReplicationInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default RebootReplicationInstanceResponse rebootReplicationInstance(
            RebootReplicationInstanceRequest rebootReplicationInstanceRequest) throws ResourceNotFoundException,
            InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reboots a replication instance. Rebooting results in a momentary outage, until the replication instance becomes
     * available again.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RebootReplicationInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link RebootReplicationInstanceRequest#builder()}
     * </p>
     *
     * @param rebootReplicationInstanceRequest
     *        A {@link Consumer} that will call methods on {@link RebootReplicationInstanceMessage.Builder} to create a
     *        request.
     * @return Result of the RebootReplicationInstance operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.RebootReplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RebootReplicationInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default RebootReplicationInstanceResponse rebootReplicationInstance(
            Consumer<RebootReplicationInstanceRequest.Builder> rebootReplicationInstanceRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return rebootReplicationInstance(RebootReplicationInstanceRequest.builder()
                .applyMutation(rebootReplicationInstanceRequest).build());
    }

    /**
     * <p>
     * Populates the schema for the specified endpoint. This is an asynchronous operation and can take several minutes.
     * You can check the status of this operation by calling the DescribeRefreshSchemasStatus operation.
     * </p>
     *
     * @param refreshSchemasRequest
     * @return Result of the RefreshSchemas operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.RefreshSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RefreshSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default RefreshSchemasResponse refreshSchemas(RefreshSchemasRequest refreshSchemasRequest)
            throws InvalidResourceStateException, ResourceNotFoundException, KmsKeyNotAccessibleException,
            ResourceQuotaExceededException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Populates the schema for the specified endpoint. This is an asynchronous operation and can take several minutes.
     * You can check the status of this operation by calling the DescribeRefreshSchemasStatus operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RefreshSchemasRequest.Builder} avoiding the need to
     * create one manually via {@link RefreshSchemasRequest#builder()}
     * </p>
     *
     * @param refreshSchemasRequest
     *        A {@link Consumer} that will call methods on {@link RefreshSchemasMessage.Builder} to create a request.
     * @return Result of the RefreshSchemas operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.RefreshSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RefreshSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default RefreshSchemasResponse refreshSchemas(Consumer<RefreshSchemasRequest.Builder> refreshSchemasRequest)
            throws InvalidResourceStateException, ResourceNotFoundException, KmsKeyNotAccessibleException,
            ResourceQuotaExceededException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return refreshSchemas(RefreshSchemasRequest.builder().applyMutation(refreshSchemasRequest).build());
    }

    /**
     * <p>
     * Reloads the target database table with the source data.
     * </p>
     * <p>
     * You can only use this operation with a task in the <code>RUNNING</code> state, otherwise the service will throw
     * an <code>InvalidResourceStateFault</code> exception.
     * </p>
     *
     * @param reloadTablesRequest
     * @return Result of the ReloadTables operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ReloadTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ReloadTables" target="_top">AWS API
     *      Documentation</a>
     */
    default ReloadTablesResponse reloadTables(ReloadTablesRequest reloadTablesRequest) throws ResourceNotFoundException,
            InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reloads the target database table with the source data.
     * </p>
     * <p>
     * You can only use this operation with a task in the <code>RUNNING</code> state, otherwise the service will throw
     * an <code>InvalidResourceStateFault</code> exception.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ReloadTablesRequest.Builder} avoiding the need to
     * create one manually via {@link ReloadTablesRequest#builder()}
     * </p>
     *
     * @param reloadTablesRequest
     *        A {@link Consumer} that will call methods on {@link ReloadTablesMessage.Builder} to create a request.
     * @return Result of the ReloadTables operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.ReloadTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ReloadTables" target="_top">AWS API
     *      Documentation</a>
     */
    default ReloadTablesResponse reloadTables(Consumer<ReloadTablesRequest.Builder> reloadTablesRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return reloadTables(ReloadTablesRequest.builder().applyMutation(reloadTablesRequest).build());
    }

    /**
     * <p>
     * Removes metadata tags from an DMS resource, including replication instance, endpoint, security group, and
     * migration task. For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html"> <code>Tag</code> </a> data type
     * description.
     * </p>
     *
     * @param removeTagsFromResourceRequest
     *        Removes one or more tags from an DMS resource.
     * @return Result of the RemoveTagsFromResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.RemoveTagsFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RemoveTagsFromResource" target="_top">AWS
     *      API Documentation</a>
     */
    default RemoveTagsFromResourceResponse removeTagsFromResource(RemoveTagsFromResourceRequest removeTagsFromResourceRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes metadata tags from an DMS resource, including replication instance, endpoint, security group, and
     * migration task. For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html"> <code>Tag</code> </a> data type
     * description.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveTagsFromResourceRequest.Builder} avoiding the
     * need to create one manually via {@link RemoveTagsFromResourceRequest#builder()}
     * </p>
     *
     * @param removeTagsFromResourceRequest
     *        A {@link Consumer} that will call methods on {@link RemoveTagsFromResourceMessage.Builder} to create a
     *        request. Removes one or more tags from an DMS resource.
     * @return Result of the RemoveTagsFromResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.RemoveTagsFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RemoveTagsFromResource" target="_top">AWS
     *      API Documentation</a>
     */
    default RemoveTagsFromResourceResponse removeTagsFromResource(
            Consumer<RemoveTagsFromResourceRequest.Builder> removeTagsFromResourceRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        return removeTagsFromResource(RemoveTagsFromResourceRequest.builder().applyMutation(removeTagsFromResourceRequest)
                .build());
    }

    /**
     * <p>
     * Starts the replication task.
     * </p>
     * <p>
     * For more information about DMS tasks, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html">Working with Migration Tasks </a> in the
     * <i>Database Migration Service User Guide.</i>
     * </p>
     *
     * @param startReplicationTaskRequest
     * @return Result of the StartReplicationTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StartReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default StartReplicationTaskResponse startReplicationTask(StartReplicationTaskRequest startReplicationTaskRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AccessDeniedException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the replication task.
     * </p>
     * <p>
     * For more information about DMS tasks, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html">Working with Migration Tasks </a> in the
     * <i>Database Migration Service User Guide.</i>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartReplicationTaskRequest.Builder} avoiding the
     * need to create one manually via {@link StartReplicationTaskRequest#builder()}
     * </p>
     *
     * @param startReplicationTaskRequest
     *        A {@link Consumer} that will call methods on {@link StartReplicationTaskMessage.Builder} to create a
     *        request.
     * @return Result of the StartReplicationTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StartReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default StartReplicationTaskResponse startReplicationTask(
            Consumer<StartReplicationTaskRequest.Builder> startReplicationTaskRequest) throws ResourceNotFoundException,
            InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return startReplicationTask(StartReplicationTaskRequest.builder().applyMutation(startReplicationTaskRequest).build());
    }

    /**
     * <p>
     * Starts the replication task assessment for unsupported data types in the source database.
     * </p>
     * <p>
     * You can only use this operation for a task if the following conditions are true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The task must be in the <code>stopped</code> state.
     * </p>
     * </li>
     * <li>
     * <p>
     * The task must have successful connections to the source and target.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If either of these conditions are not met, an <code>InvalidResourceStateFault</code> error will result.
     * </p>
     * <p>
     * For information about DMS task assessments, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html">Creating a task
     * assessment report</a> in the <i>Database Migration Service User Guide</i>.
     * </p>
     *
     * @param startReplicationTaskAssessmentRequest
     * @return Result of the StartReplicationTaskAssessment operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StartReplicationTaskAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTaskAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default StartReplicationTaskAssessmentResponse startReplicationTaskAssessment(
            StartReplicationTaskAssessmentRequest startReplicationTaskAssessmentRequest) throws InvalidResourceStateException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the replication task assessment for unsupported data types in the source database.
     * </p>
     * <p>
     * You can only use this operation for a task if the following conditions are true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The task must be in the <code>stopped</code> state.
     * </p>
     * </li>
     * <li>
     * <p>
     * The task must have successful connections to the source and target.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If either of these conditions are not met, an <code>InvalidResourceStateFault</code> error will result.
     * </p>
     * <p>
     * For information about DMS task assessments, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html">Creating a task
     * assessment report</a> in the <i>Database Migration Service User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartReplicationTaskAssessmentRequest.Builder}
     * avoiding the need to create one manually via {@link StartReplicationTaskAssessmentRequest#builder()}
     * </p>
     *
     * @param startReplicationTaskAssessmentRequest
     *        A {@link Consumer} that will call methods on {@link StartReplicationTaskAssessmentMessage.Builder} to
     *        create a request.
     * @return Result of the StartReplicationTaskAssessment operation returned by the service.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StartReplicationTaskAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTaskAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default StartReplicationTaskAssessmentResponse startReplicationTaskAssessment(
            Consumer<StartReplicationTaskAssessmentRequest.Builder> startReplicationTaskAssessmentRequest)
            throws InvalidResourceStateException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return startReplicationTaskAssessment(StartReplicationTaskAssessmentRequest.builder()
                .applyMutation(startReplicationTaskAssessmentRequest).build());
    }

    /**
     * <p>
     * Starts a new premigration assessment run for one or more individual assessments of a migration task.
     * </p>
     * <p>
     * The assessments that you can specify depend on the source and target database engine and the migration type
     * defined for the given task. To run this operation, your migration task must already be created. After you run
     * this operation, you can review the status of each individual assessment. You can also run the migration task
     * manually after the assessment run and its individual assessments complete.
     * </p>
     *
     * @param startReplicationTaskAssessmentRunRequest
     * @return Result of the StartReplicationTaskAssessmentRun operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws KmsAccessDeniedException
     *         The ciphertext references a key that doesn't exist or that the DMS account doesn't have access to.
     * @throws KmsDisabledException
     *         The specified KMS key isn't enabled.
     * @throws KmsException
     *         An Key Management Service (KMS) error is preventing access to KMS.
     * @throws KmsInvalidStateException
     *         The state of the specified KMS resource isn't valid for this request.
     * @throws KmsNotFoundException
     *         The specified KMS entity or resource can't be found.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws S3AccessDeniedException
     *         Insufficient privileges are preventing access to an Amazon S3 object.
     * @throws S3ResourceNotFoundException
     *         A specified Amazon S3 bucket, bucket folder, or other object can't be found.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StartReplicationTaskAssessmentRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTaskAssessmentRun"
     *      target="_top">AWS API Documentation</a>
     */
    default StartReplicationTaskAssessmentRunResponse startReplicationTaskAssessmentRun(
            StartReplicationTaskAssessmentRunRequest startReplicationTaskAssessmentRunRequest) throws AccessDeniedException,
            ResourceNotFoundException, InvalidResourceStateException, KmsAccessDeniedException, KmsDisabledException,
            KmsException, KmsInvalidStateException, KmsNotFoundException, KmsKeyNotAccessibleException, S3AccessDeniedException,
            S3ResourceNotFoundException, ResourceAlreadyExistsException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a new premigration assessment run for one or more individual assessments of a migration task.
     * </p>
     * <p>
     * The assessments that you can specify depend on the source and target database engine and the migration type
     * defined for the given task. To run this operation, your migration task must already be created. After you run
     * this operation, you can review the status of each individual assessment. You can also run the migration task
     * manually after the assessment run and its individual assessments complete.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartReplicationTaskAssessmentRunRequest.Builder}
     * avoiding the need to create one manually via {@link StartReplicationTaskAssessmentRunRequest#builder()}
     * </p>
     *
     * @param startReplicationTaskAssessmentRunRequest
     *        A {@link Consumer} that will call methods on {@link StartReplicationTaskAssessmentRunMessage.Builder} to
     *        create a request.
     * @return Result of the StartReplicationTaskAssessmentRun operation returned by the service.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws KmsAccessDeniedException
     *         The ciphertext references a key that doesn't exist or that the DMS account doesn't have access to.
     * @throws KmsDisabledException
     *         The specified KMS key isn't enabled.
     * @throws KmsException
     *         An Key Management Service (KMS) error is preventing access to KMS.
     * @throws KmsInvalidStateException
     *         The state of the specified KMS resource isn't valid for this request.
     * @throws KmsNotFoundException
     *         The specified KMS entity or resource can't be found.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws S3AccessDeniedException
     *         Insufficient privileges are preventing access to an Amazon S3 object.
     * @throws S3ResourceNotFoundException
     *         A specified Amazon S3 bucket, bucket folder, or other object can't be found.
     * @throws ResourceAlreadyExistsException
     *         The resource you are attempting to create already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StartReplicationTaskAssessmentRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTaskAssessmentRun"
     *      target="_top">AWS API Documentation</a>
     */
    default StartReplicationTaskAssessmentRunResponse startReplicationTaskAssessmentRun(
            Consumer<StartReplicationTaskAssessmentRunRequest.Builder> startReplicationTaskAssessmentRunRequest)
            throws AccessDeniedException, ResourceNotFoundException, InvalidResourceStateException, KmsAccessDeniedException,
            KmsDisabledException, KmsException, KmsInvalidStateException, KmsNotFoundException, KmsKeyNotAccessibleException,
            S3AccessDeniedException, S3ResourceNotFoundException, ResourceAlreadyExistsException, AwsServiceException,
            SdkClientException, DatabaseMigrationException {
        return startReplicationTaskAssessmentRun(StartReplicationTaskAssessmentRunRequest.builder()
                .applyMutation(startReplicationTaskAssessmentRunRequest).build());
    }

    /**
     * <p>
     * Stops the replication task.
     * </p>
     *
     * @param stopReplicationTaskRequest
     * @return Result of the StopReplicationTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StopReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StopReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default StopReplicationTaskResponse stopReplicationTask(StopReplicationTaskRequest stopReplicationTaskRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the replication task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopReplicationTaskRequest.Builder} avoiding the
     * need to create one manually via {@link StopReplicationTaskRequest#builder()}
     * </p>
     *
     * @param stopReplicationTaskRequest
     *        A {@link Consumer} that will call methods on {@link StopReplicationTaskMessage.Builder} to create a
     *        request.
     * @return Result of the StopReplicationTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.StopReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StopReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default StopReplicationTaskResponse stopReplicationTask(
            Consumer<StopReplicationTaskRequest.Builder> stopReplicationTaskRequest) throws ResourceNotFoundException,
            InvalidResourceStateException, AwsServiceException, SdkClientException, DatabaseMigrationException {
        return stopReplicationTask(StopReplicationTaskRequest.builder().applyMutation(stopReplicationTaskRequest).build());
    }

    /**
     * <p>
     * Tests the connection between the replication instance and the endpoint.
     * </p>
     *
     * @param testConnectionRequest
     * @return Result of the TestConnection operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.TestConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/TestConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default TestConnectionResponse testConnection(TestConnectionRequest testConnectionRequest) throws ResourceNotFoundException,
            InvalidResourceStateException, KmsKeyNotAccessibleException, ResourceQuotaExceededException, AccessDeniedException,
            AwsServiceException, SdkClientException, DatabaseMigrationException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tests the connection between the replication instance and the endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TestConnectionRequest.Builder} avoiding the need to
     * create one manually via {@link TestConnectionRequest#builder()}
     * </p>
     *
     * @param testConnectionRequest
     *        A {@link Consumer} that will call methods on {@link TestConnectionMessage.Builder} to create a request.
     * @return Result of the TestConnection operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The resource is in a state that prevents it from being used for database migration.
     * @throws KmsKeyNotAccessibleException
     *         DMS cannot access the KMS key.
     * @throws ResourceQuotaExceededException
     *         The quota for this resource quota has been exceeded.
     * @throws AccessDeniedException
     *         DMS was denied access to the endpoint. Check that the role is correctly configured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DatabaseMigrationException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DatabaseMigrationClient.TestConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/TestConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default TestConnectionResponse testConnection(Consumer<TestConnectionRequest.Builder> testConnectionRequest)
            throws ResourceNotFoundException, InvalidResourceStateException, KmsKeyNotAccessibleException,
            ResourceQuotaExceededException, AccessDeniedException, AwsServiceException, SdkClientException,
            DatabaseMigrationException {
        return testConnection(TestConnectionRequest.builder().applyMutation(testConnectionRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    /**
     * Create an instance of {@link DatabaseMigrationWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link DatabaseMigrationWaiter}
     */
    default DatabaseMigrationWaiter waiter() {
        throw new UnsupportedOperationException();
    }
}
