/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAccountAttributesResponse extends DatabaseMigrationResponse implements
        ToCopyableBuilder<DescribeAccountAttributesResponse.Builder, DescribeAccountAttributesResponse> {
    private static final SdkField<List<AccountQuota>> ACCOUNT_QUOTAS_FIELD = SdkField
            .<List<AccountQuota>> builder(MarshallingType.LIST)
            .memberName("AccountQuotas")
            .getter(getter(DescribeAccountAttributesResponse::accountQuotas))
            .setter(setter(Builder::accountQuotas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountQuotas").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccountQuota> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccountQuota::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> UNIQUE_ACCOUNT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UniqueAccountIdentifier").getter(getter(DescribeAccountAttributesResponse::uniqueAccountIdentifier))
            .setter(setter(Builder::uniqueAccountIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UniqueAccountIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_QUOTAS_FIELD,
            UNIQUE_ACCOUNT_IDENTIFIER_FIELD));

    private final List<AccountQuota> accountQuotas;

    private final String uniqueAccountIdentifier;

    private DescribeAccountAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.accountQuotas = builder.accountQuotas;
        this.uniqueAccountIdentifier = builder.uniqueAccountIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountQuotas property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccountQuotas() {
        return accountQuotas != null && !(accountQuotas instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Account quota information.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountQuotas} method.
     * </p>
     * 
     * @return Account quota information.
     */
    public final List<AccountQuota> accountQuotas() {
        return accountQuotas;
    }

    /**
     * <p>
     * A unique DMS identifier for an account in a particular Amazon Web Services Region. The value of this identifier
     * has the following format: <code>c99999999999</code>. DMS uses this identifier to name artifacts. For example, DMS
     * uses this identifier to name the default Amazon S3 bucket for storing task assessment reports in a given Amazon
     * Web Services Region. The format of this S3 bucket name is the following:
     * <code>dms-<i>AccountNumber</i>-<i>UniqueAccountIdentifier</i>.</code> Here is an example name for this default S3
     * bucket: <code>dms-111122223333-c44445555666</code>.
     * </p>
     * <note>
     * <p>
     * DMS supports the <code>UniqueAccountIdentifier</code> parameter in versions 3.1.4 and later.
     * </p>
     * </note>
     * 
     * @return A unique DMS identifier for an account in a particular Amazon Web Services Region. The value of this
     *         identifier has the following format: <code>c99999999999</code>. DMS uses this identifier to name
     *         artifacts. For example, DMS uses this identifier to name the default Amazon S3 bucket for storing task
     *         assessment reports in a given Amazon Web Services Region. The format of this S3 bucket name is the
     *         following: <code>dms-<i>AccountNumber</i>-<i>UniqueAccountIdentifier</i>.</code> Here is an example name
     *         for this default S3 bucket: <code>dms-111122223333-c44445555666</code>.</p> <note>
     *         <p>
     *         DMS supports the <code>UniqueAccountIdentifier</code> parameter in versions 3.1.4 and later.
     *         </p>
     */
    public final String uniqueAccountIdentifier() {
        return uniqueAccountIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountQuotas() ? accountQuotas() : null);
        hashCode = 31 * hashCode + Objects.hashCode(uniqueAccountIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountAttributesResponse)) {
            return false;
        }
        DescribeAccountAttributesResponse other = (DescribeAccountAttributesResponse) obj;
        return hasAccountQuotas() == other.hasAccountQuotas() && Objects.equals(accountQuotas(), other.accountQuotas())
                && Objects.equals(uniqueAccountIdentifier(), other.uniqueAccountIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAccountAttributesResponse")
                .add("AccountQuotas", hasAccountQuotas() ? accountQuotas() : null)
                .add("UniqueAccountIdentifier", uniqueAccountIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountQuotas":
            return Optional.ofNullable(clazz.cast(accountQuotas()));
        case "UniqueAccountIdentifier":
            return Optional.ofNullable(clazz.cast(uniqueAccountIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountAttributesResponse, T> g) {
        return obj -> g.apply((DescribeAccountAttributesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAccountAttributesResponse> {
        /**
         * <p>
         * Account quota information.
         * </p>
         * 
         * @param accountQuotas
         *        Account quota information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountQuotas(Collection<AccountQuota> accountQuotas);

        /**
         * <p>
         * Account quota information.
         * </p>
         * 
         * @param accountQuotas
         *        Account quota information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountQuotas(AccountQuota... accountQuotas);

        /**
         * <p>
         * Account quota information.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<AccountQuota>.Builder} avoiding the
         * need to create one manually via {@link List<AccountQuota>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AccountQuota>.Builder#build()} is called immediately and its
         * result is passed to {@link #accountQuotas(List<AccountQuota>)}.
         * 
         * @param accountQuotas
         *        a consumer that will call methods on {@link List<AccountQuota>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountQuotas(List<AccountQuota>)
         */
        Builder accountQuotas(Consumer<AccountQuota.Builder>... accountQuotas);

        /**
         * <p>
         * A unique DMS identifier for an account in a particular Amazon Web Services Region. The value of this
         * identifier has the following format: <code>c99999999999</code>. DMS uses this identifier to name artifacts.
         * For example, DMS uses this identifier to name the default Amazon S3 bucket for storing task assessment
         * reports in a given Amazon Web Services Region. The format of this S3 bucket name is the following:
         * <code>dms-<i>AccountNumber</i>-<i>UniqueAccountIdentifier</i>.</code> Here is an example name for this
         * default S3 bucket: <code>dms-111122223333-c44445555666</code>.
         * </p>
         * <note>
         * <p>
         * DMS supports the <code>UniqueAccountIdentifier</code> parameter in versions 3.1.4 and later.
         * </p>
         * </note>
         * 
         * @param uniqueAccountIdentifier
         *        A unique DMS identifier for an account in a particular Amazon Web Services Region. The value of this
         *        identifier has the following format: <code>c99999999999</code>. DMS uses this identifier to name
         *        artifacts. For example, DMS uses this identifier to name the default Amazon S3 bucket for storing task
         *        assessment reports in a given Amazon Web Services Region. The format of this S3 bucket name is the
         *        following: <code>dms-<i>AccountNumber</i>-<i>UniqueAccountIdentifier</i>.</code> Here is an example
         *        name for this default S3 bucket: <code>dms-111122223333-c44445555666</code>.</p> <note>
         *        <p>
         *        DMS supports the <code>UniqueAccountIdentifier</code> parameter in versions 3.1.4 and later.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uniqueAccountIdentifier(String uniqueAccountIdentifier);
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private List<AccountQuota> accountQuotas = DefaultSdkAutoConstructList.getInstance();

        private String uniqueAccountIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountAttributesResponse model) {
            super(model);
            accountQuotas(model.accountQuotas);
            uniqueAccountIdentifier(model.uniqueAccountIdentifier);
        }

        public final List<AccountQuota.Builder> getAccountQuotas() {
            List<AccountQuota.Builder> result = AccountQuotaListCopier.copyToBuilder(this.accountQuotas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountQuotas(Collection<AccountQuota.BuilderImpl> accountQuotas) {
            this.accountQuotas = AccountQuotaListCopier.copyFromBuilder(accountQuotas);
        }

        @Override
        public final Builder accountQuotas(Collection<AccountQuota> accountQuotas) {
            this.accountQuotas = AccountQuotaListCopier.copy(accountQuotas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountQuotas(AccountQuota... accountQuotas) {
            accountQuotas(Arrays.asList(accountQuotas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountQuotas(Consumer<AccountQuota.Builder>... accountQuotas) {
            accountQuotas(Stream.of(accountQuotas).map(c -> AccountQuota.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getUniqueAccountIdentifier() {
            return uniqueAccountIdentifier;
        }

        public final void setUniqueAccountIdentifier(String uniqueAccountIdentifier) {
            this.uniqueAccountIdentifier = uniqueAccountIdentifier;
        }

        @Override
        public final Builder uniqueAccountIdentifier(String uniqueAccountIdentifier) {
            this.uniqueAccountIdentifier = uniqueAccountIdentifier;
            return this;
        }

        @Override
        public DescribeAccountAttributesResponse build() {
            return new DescribeAccountAttributesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
