/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReplicationTaskAssessmentResultsResponse extends DatabaseMigrationResponse
        implements
        ToCopyableBuilder<DescribeReplicationTaskAssessmentResultsResponse.Builder, DescribeReplicationTaskAssessmentResultsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeReplicationTaskAssessmentResultsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BucketName").getter(getter(DescribeReplicationTaskAssessmentResultsResponse::bucketName))
            .setter(setter(Builder::bucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").build()).build();

    private static final SdkField<List<ReplicationTaskAssessmentResult>> REPLICATION_TASK_ASSESSMENT_RESULTS_FIELD = SdkField
            .<List<ReplicationTaskAssessmentResult>> builder(MarshallingType.LIST)
            .memberName("ReplicationTaskAssessmentResults")
            .getter(getter(DescribeReplicationTaskAssessmentResultsResponse::replicationTaskAssessmentResults))
            .setter(setter(Builder::replicationTaskAssessmentResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskAssessmentResults")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReplicationTaskAssessmentResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReplicationTaskAssessmentResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            BUCKET_NAME_FIELD, REPLICATION_TASK_ASSESSMENT_RESULTS_FIELD));

    private final String marker;

    private final String bucketName;

    private final List<ReplicationTaskAssessmentResult> replicationTaskAssessmentResults;

    private DescribeReplicationTaskAssessmentResultsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.bucketName = builder.bucketName;
        this.replicationTaskAssessmentResults = builder.replicationTaskAssessmentResults;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * - The Amazon S3 bucket where the task assessment report is located.
     * </p>
     * 
     * @return - The Amazon S3 bucket where the task assessment report is located.
     */
    public final String bucketName() {
        return bucketName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicationTaskAssessmentResults
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasReplicationTaskAssessmentResults() {
        return replicationTaskAssessmentResults != null && !(replicationTaskAssessmentResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The task assessment report.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicationTaskAssessmentResults}
     * method.
     * </p>
     * 
     * @return The task assessment report.
     */
    public final List<ReplicationTaskAssessmentResult> replicationTaskAssessmentResults() {
        return replicationTaskAssessmentResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasReplicationTaskAssessmentResults() ? replicationTaskAssessmentResults() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplicationTaskAssessmentResultsResponse)) {
            return false;
        }
        DescribeReplicationTaskAssessmentResultsResponse other = (DescribeReplicationTaskAssessmentResultsResponse) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(bucketName(), other.bucketName())
                && hasReplicationTaskAssessmentResults() == other.hasReplicationTaskAssessmentResults()
                && Objects.equals(replicationTaskAssessmentResults(), other.replicationTaskAssessmentResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeReplicationTaskAssessmentResultsResponse")
                .add("Marker", marker())
                .add("BucketName", bucketName())
                .add("ReplicationTaskAssessmentResults",
                        hasReplicationTaskAssessmentResults() ? replicationTaskAssessmentResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "BucketName":
            return Optional.ofNullable(clazz.cast(bucketName()));
        case "ReplicationTaskAssessmentResults":
            return Optional.ofNullable(clazz.cast(replicationTaskAssessmentResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReplicationTaskAssessmentResultsResponse, T> g) {
        return obj -> g.apply((DescribeReplicationTaskAssessmentResultsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeReplicationTaskAssessmentResultsResponse> {
        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * - The Amazon S3 bucket where the task assessment report is located.
         * </p>
         * 
         * @param bucketName
         *        - The Amazon S3 bucket where the task assessment report is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * The task assessment report.
         * </p>
         * 
         * @param replicationTaskAssessmentResults
         *        The task assessment report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskAssessmentResults(Collection<ReplicationTaskAssessmentResult> replicationTaskAssessmentResults);

        /**
         * <p>
         * The task assessment report.
         * </p>
         * 
         * @param replicationTaskAssessmentResults
         *        The task assessment report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskAssessmentResults(ReplicationTaskAssessmentResult... replicationTaskAssessmentResults);

        /**
         * <p>
         * The task assessment report.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <ReplicationTaskAssessmentResult>.Builder} avoiding the need to create one manually via {@link List
         * <ReplicationTaskAssessmentResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReplicationTaskAssessmentResult>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #replicationTaskAssessmentResults(List<ReplicationTaskAssessmentResult>)}.
         * 
         * @param replicationTaskAssessmentResults
         *        a consumer that will call methods on {@link List<ReplicationTaskAssessmentResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationTaskAssessmentResults(List<ReplicationTaskAssessmentResult>)
         */
        Builder replicationTaskAssessmentResults(
                Consumer<ReplicationTaskAssessmentResult.Builder>... replicationTaskAssessmentResults);
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private String marker;

        private String bucketName;

        private List<ReplicationTaskAssessmentResult> replicationTaskAssessmentResults = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReplicationTaskAssessmentResultsResponse model) {
            super(model);
            marker(model.marker);
            bucketName(model.bucketName);
            replicationTaskAssessmentResults(model.replicationTaskAssessmentResults);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final String getBucketName() {
            return bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final List<ReplicationTaskAssessmentResult.Builder> getReplicationTaskAssessmentResults() {
            List<ReplicationTaskAssessmentResult.Builder> result = ReplicationTaskAssessmentResultListCopier
                    .copyToBuilder(this.replicationTaskAssessmentResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicationTaskAssessmentResults(
                Collection<ReplicationTaskAssessmentResult.BuilderImpl> replicationTaskAssessmentResults) {
            this.replicationTaskAssessmentResults = ReplicationTaskAssessmentResultListCopier
                    .copyFromBuilder(replicationTaskAssessmentResults);
        }

        @Override
        public final Builder replicationTaskAssessmentResults(
                Collection<ReplicationTaskAssessmentResult> replicationTaskAssessmentResults) {
            this.replicationTaskAssessmentResults = ReplicationTaskAssessmentResultListCopier
                    .copy(replicationTaskAssessmentResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationTaskAssessmentResults(ReplicationTaskAssessmentResult... replicationTaskAssessmentResults) {
            replicationTaskAssessmentResults(Arrays.asList(replicationTaskAssessmentResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationTaskAssessmentResults(
                Consumer<ReplicationTaskAssessmentResult.Builder>... replicationTaskAssessmentResults) {
            replicationTaskAssessmentResults(Stream.of(replicationTaskAssessmentResults)
                    .map(c -> ReplicationTaskAssessmentResult.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeReplicationTaskAssessmentResultsResponse build() {
            return new DescribeReplicationTaskAssessmentResultsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
