/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RebootReplicationInstanceResponse extends DatabaseMigrationResponse implements
        ToCopyableBuilder<RebootReplicationInstanceResponse.Builder, RebootReplicationInstanceResponse> {
    private static final SdkField<ReplicationInstance> REPLICATION_INSTANCE_FIELD = SdkField
            .<ReplicationInstance> builder(MarshallingType.SDK_POJO).memberName("ReplicationInstance")
            .getter(getter(RebootReplicationInstanceResponse::replicationInstance)).setter(setter(Builder::replicationInstance))
            .constructor(ReplicationInstance::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstance").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_INSTANCE_FIELD));

    private final ReplicationInstance replicationInstance;

    private RebootReplicationInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.replicationInstance = builder.replicationInstance;
    }

    /**
     * <p>
     * The replication instance that is being rebooted.
     * </p>
     * 
     * @return The replication instance that is being rebooted.
     */
    public final ReplicationInstance replicationInstance() {
        return replicationInstance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replicationInstance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RebootReplicationInstanceResponse)) {
            return false;
        }
        RebootReplicationInstanceResponse other = (RebootReplicationInstanceResponse) obj;
        return Objects.equals(replicationInstance(), other.replicationInstance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RebootReplicationInstanceResponse").add("ReplicationInstance", replicationInstance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationInstance":
            return Optional.ofNullable(clazz.cast(replicationInstance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RebootReplicationInstanceResponse, T> g) {
        return obj -> g.apply((RebootReplicationInstanceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, RebootReplicationInstanceResponse> {
        /**
         * <p>
         * The replication instance that is being rebooted.
         * </p>
         * 
         * @param replicationInstance
         *        The replication instance that is being rebooted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInstance(ReplicationInstance replicationInstance);

        /**
         * <p>
         * The replication instance that is being rebooted.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReplicationInstance.Builder} avoiding the
         * need to create one manually via {@link ReplicationInstance#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReplicationInstance.Builder#build()} is called immediately and
         * its result is passed to {@link #replicationInstance(ReplicationInstance)}.
         * 
         * @param replicationInstance
         *        a consumer that will call methods on {@link ReplicationInstance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationInstance(ReplicationInstance)
         */
        default Builder replicationInstance(Consumer<ReplicationInstance.Builder> replicationInstance) {
            return replicationInstance(ReplicationInstance.builder().applyMutation(replicationInstance).build());
        }
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private ReplicationInstance replicationInstance;

        private BuilderImpl() {
        }

        private BuilderImpl(RebootReplicationInstanceResponse model) {
            super(model);
            replicationInstance(model.replicationInstance);
        }

        public final ReplicationInstance.Builder getReplicationInstance() {
            return replicationInstance != null ? replicationInstance.toBuilder() : null;
        }

        public final void setReplicationInstance(ReplicationInstance.BuilderImpl replicationInstance) {
            this.replicationInstance = replicationInstance != null ? replicationInstance.build() : null;
        }

        @Override
        public final Builder replicationInstance(ReplicationInstance replicationInstance) {
            this.replicationInstance = replicationInstance;
            return this;
        }

        @Override
        public RebootReplicationInstanceResponse build() {
            return new RebootReplicationInstanceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
