/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.CollectorShortInfoResponse;
import software.amazon.awssdk.services.databasemigration.model.CollectorsListCopier;
import software.amazon.awssdk.services.databasemigration.model.DatabaseInstanceSoftwareDetailsResponse;
import software.amazon.awssdk.services.databasemigration.model.ServerShortInfoResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatabaseResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatabaseResponse> {
    private static final SdkField<String> DATABASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseId").getter(DatabaseResponse.getter(DatabaseResponse::databaseId)).setter(DatabaseResponse.setter(Builder::databaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseId").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(DatabaseResponse.getter(DatabaseResponse::databaseName)).setter(DatabaseResponse.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddress").getter(DatabaseResponse.getter(DatabaseResponse::ipAddress)).setter(DatabaseResponse.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()}).build();
    private static final SdkField<Long> NUMBER_OF_SCHEMAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NumberOfSchemas").getter(DatabaseResponse.getter(DatabaseResponse::numberOfSchemas)).setter(DatabaseResponse.setter(Builder::numberOfSchemas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfSchemas").build()}).build();
    private static final SdkField<ServerShortInfoResponse> SERVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Server").getter(DatabaseResponse.getter(DatabaseResponse::server)).setter(DatabaseResponse.setter(Builder::server)).constructor(ServerShortInfoResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Server").build()}).build();
    private static final SdkField<DatabaseInstanceSoftwareDetailsResponse> SOFTWARE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SoftwareDetails").getter(DatabaseResponse.getter(DatabaseResponse::softwareDetails)).setter(DatabaseResponse.setter(Builder::softwareDetails)).constructor(DatabaseInstanceSoftwareDetailsResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SoftwareDetails").build()}).build();
    private static final SdkField<List<CollectorShortInfoResponse>> COLLECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Collectors").getter(DatabaseResponse.getter(DatabaseResponse::collectors)).setter(DatabaseResponse.setter(Builder::collectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Collectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CollectorShortInfoResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_ID_FIELD, DATABASE_NAME_FIELD, IP_ADDRESS_FIELD, NUMBER_OF_SCHEMAS_FIELD, SERVER_FIELD, SOFTWARE_DETAILS_FIELD, COLLECTORS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String databaseId;
    private final String databaseName;
    private final String ipAddress;
    private final Long numberOfSchemas;
    private final ServerShortInfoResponse server;
    private final DatabaseInstanceSoftwareDetailsResponse softwareDetails;
    private final List<CollectorShortInfoResponse> collectors;

    private DatabaseResponse(BuilderImpl builder) {
        this.databaseId = builder.databaseId;
        this.databaseName = builder.databaseName;
        this.ipAddress = builder.ipAddress;
        this.numberOfSchemas = builder.numberOfSchemas;
        this.server = builder.server;
        this.softwareDetails = builder.softwareDetails;
        this.collectors = builder.collectors;
    }

    public final String databaseId() {
        return this.databaseId;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String ipAddress() {
        return this.ipAddress;
    }

    public final Long numberOfSchemas() {
        return this.numberOfSchemas;
    }

    public final ServerShortInfoResponse server() {
        return this.server;
    }

    public final DatabaseInstanceSoftwareDetailsResponse softwareDetails() {
        return this.softwareDetails;
    }

    public final boolean hasCollectors() {
        return this.collectors != null && !(this.collectors instanceof SdkAutoConstructList);
    }

    public final List<CollectorShortInfoResponse> collectors() {
        return this.collectors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfSchemas());
        hashCode = 31 * hashCode + Objects.hashCode(this.server());
        hashCode = 31 * hashCode + Objects.hashCode(this.softwareDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCollectors() ? this.collectors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatabaseResponse)) {
            return false;
        }
        DatabaseResponse other = (DatabaseResponse)obj;
        return Objects.equals(this.databaseId(), other.databaseId()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.numberOfSchemas(), other.numberOfSchemas()) && Objects.equals(this.server(), other.server()) && Objects.equals(this.softwareDetails(), other.softwareDetails()) && this.hasCollectors() == other.hasCollectors() && Objects.equals(this.collectors(), other.collectors());
    }

    public final String toString() {
        return ToString.builder((String)"DatabaseResponse").add("DatabaseId", (Object)this.databaseId()).add("DatabaseName", (Object)this.databaseName()).add("IpAddress", (Object)this.ipAddress()).add("NumberOfSchemas", (Object)this.numberOfSchemas()).add("Server", (Object)this.server()).add("SoftwareDetails", (Object)this.softwareDetails()).add("Collectors", this.hasCollectors() ? this.collectors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatabaseId": {
                return Optional.ofNullable(clazz.cast(this.databaseId()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "IpAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "NumberOfSchemas": {
                return Optional.ofNullable(clazz.cast(this.numberOfSchemas()));
            }
            case "Server": {
                return Optional.ofNullable(clazz.cast(this.server()));
            }
            case "SoftwareDetails": {
                return Optional.ofNullable(clazz.cast(this.softwareDetails()));
            }
            case "Collectors": {
                return Optional.ofNullable(clazz.cast(this.collectors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatabaseResponse, T> g) {
        return obj -> g.apply((DatabaseResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String databaseId;
        private String databaseName;
        private String ipAddress;
        private Long numberOfSchemas;
        private ServerShortInfoResponse server;
        private DatabaseInstanceSoftwareDetailsResponse softwareDetails;
        private List<CollectorShortInfoResponse> collectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DatabaseResponse model) {
            this.databaseId(model.databaseId);
            this.databaseName(model.databaseName);
            this.ipAddress(model.ipAddress);
            this.numberOfSchemas(model.numberOfSchemas);
            this.server(model.server);
            this.softwareDetails(model.softwareDetails);
            this.collectors(model.collectors);
        }

        public final String getDatabaseId() {
            return this.databaseId;
        }

        public final void setDatabaseId(String databaseId) {
            this.databaseId = databaseId;
        }

        @Override
        public final Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final Long getNumberOfSchemas() {
            return this.numberOfSchemas;
        }

        public final void setNumberOfSchemas(Long numberOfSchemas) {
            this.numberOfSchemas = numberOfSchemas;
        }

        @Override
        public final Builder numberOfSchemas(Long numberOfSchemas) {
            this.numberOfSchemas = numberOfSchemas;
            return this;
        }

        public final ServerShortInfoResponse.Builder getServer() {
            return this.server != null ? this.server.toBuilder() : null;
        }

        public final void setServer(ServerShortInfoResponse.BuilderImpl server) {
            this.server = server != null ? server.build() : null;
        }

        @Override
        public final Builder server(ServerShortInfoResponse server) {
            this.server = server;
            return this;
        }

        public final DatabaseInstanceSoftwareDetailsResponse.Builder getSoftwareDetails() {
            return this.softwareDetails != null ? this.softwareDetails.toBuilder() : null;
        }

        public final void setSoftwareDetails(DatabaseInstanceSoftwareDetailsResponse.BuilderImpl softwareDetails) {
            this.softwareDetails = softwareDetails != null ? softwareDetails.build() : null;
        }

        @Override
        public final Builder softwareDetails(DatabaseInstanceSoftwareDetailsResponse softwareDetails) {
            this.softwareDetails = softwareDetails;
            return this;
        }

        public final List<CollectorShortInfoResponse.Builder> getCollectors() {
            List<CollectorShortInfoResponse.Builder> result = CollectorsListCopier.copyToBuilder(this.collectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCollectors(Collection<CollectorShortInfoResponse.BuilderImpl> collectors) {
            this.collectors = CollectorsListCopier.copyFromBuilder(collectors);
        }

        @Override
        public final Builder collectors(Collection<CollectorShortInfoResponse> collectors) {
            this.collectors = CollectorsListCopier.copy(collectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collectors(CollectorShortInfoResponse ... collectors) {
            this.collectors(Arrays.asList(collectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collectors(Consumer<CollectorShortInfoResponse.Builder> ... collectors) {
            this.collectors(Stream.of(collectors).map(c -> (CollectorShortInfoResponse)((CollectorShortInfoResponse.Builder)CollectorShortInfoResponse.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DatabaseResponse build() {
            return new DatabaseResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatabaseResponse> {
        public Builder databaseId(String var1);

        public Builder databaseName(String var1);

        public Builder ipAddress(String var1);

        public Builder numberOfSchemas(Long var1);

        public Builder server(ServerShortInfoResponse var1);

        default public Builder server(Consumer<ServerShortInfoResponse.Builder> server) {
            return this.server((ServerShortInfoResponse)((ServerShortInfoResponse.Builder)ServerShortInfoResponse.builder().applyMutation(server)).build());
        }

        public Builder softwareDetails(DatabaseInstanceSoftwareDetailsResponse var1);

        default public Builder softwareDetails(Consumer<DatabaseInstanceSoftwareDetailsResponse.Builder> softwareDetails) {
            return this.softwareDetails((DatabaseInstanceSoftwareDetailsResponse)((DatabaseInstanceSoftwareDetailsResponse.Builder)DatabaseInstanceSoftwareDetailsResponse.builder().applyMutation(softwareDetails)).build());
        }

        public Builder collectors(Collection<CollectorShortInfoResponse> var1);

        public Builder collectors(CollectorShortInfoResponse ... var1);

        public Builder collectors(Consumer<CollectorShortInfoResponse.Builder> ... var1);
    }
}

