/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DmsSslModeValue {
    NONE("none"),
    REQUIRE("require"),
    VERIFY_CA("verify-ca"),
    VERIFY_FULL("verify-full"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DmsSslModeValue> VALUE_MAP;
    private final String value;

    private DmsSslModeValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DmsSslModeValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DmsSslModeValue> knownValues() {
        EnumSet<DmsSslModeValue> knownValues = EnumSet.allOf(DmsSslModeValue.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DmsSslModeValue.class, DmsSslModeValue::toString);
    }
}

