/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information that describes an individual assessment from a premigration assessment run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationTaskIndividualAssessment implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicationTaskIndividualAssessment.Builder, ReplicationTaskIndividualAssessment> {
    private static final SdkField<String> REPLICATION_TASK_INDIVIDUAL_ASSESSMENT_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReplicationTaskIndividualAssessmentArn")
            .getter(getter(ReplicationTaskIndividualAssessment::replicationTaskIndividualAssessmentArn))
            .setter(setter(Builder::replicationTaskIndividualAssessmentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ReplicationTaskIndividualAssessmentArn").build()).build();

    private static final SdkField<String> REPLICATION_TASK_ASSESSMENT_RUN_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReplicationTaskAssessmentRunArn")
            .getter(getter(ReplicationTaskIndividualAssessment::replicationTaskAssessmentRunArn))
            .setter(setter(Builder::replicationTaskAssessmentRunArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationTaskAssessmentRunArn")
                    .build()).build();

    private static final SdkField<String> INDIVIDUAL_ASSESSMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IndividualAssessmentName").getter(getter(ReplicationTaskIndividualAssessment::individualAssessmentName))
            .setter(setter(Builder::individualAssessmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndividualAssessmentName").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ReplicationTaskIndividualAssessment::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> REPLICATION_TASK_INDIVIDUAL_ASSESSMENT_START_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ReplicationTaskIndividualAssessmentStartDate")
            .getter(getter(ReplicationTaskIndividualAssessment::replicationTaskIndividualAssessmentStartDate))
            .setter(setter(Builder::replicationTaskIndividualAssessmentStartDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ReplicationTaskIndividualAssessmentStartDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            REPLICATION_TASK_INDIVIDUAL_ASSESSMENT_ARN_FIELD, REPLICATION_TASK_ASSESSMENT_RUN_ARN_FIELD,
            INDIVIDUAL_ASSESSMENT_NAME_FIELD, STATUS_FIELD, REPLICATION_TASK_INDIVIDUAL_ASSESSMENT_START_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String replicationTaskIndividualAssessmentArn;

    private final String replicationTaskAssessmentRunArn;

    private final String individualAssessmentName;

    private final String status;

    private final Instant replicationTaskIndividualAssessmentStartDate;

    private ReplicationTaskIndividualAssessment(BuilderImpl builder) {
        this.replicationTaskIndividualAssessmentArn = builder.replicationTaskIndividualAssessmentArn;
        this.replicationTaskAssessmentRunArn = builder.replicationTaskAssessmentRunArn;
        this.individualAssessmentName = builder.individualAssessmentName;
        this.status = builder.status;
        this.replicationTaskIndividualAssessmentStartDate = builder.replicationTaskIndividualAssessmentStartDate;
    }

    /**
     * <p>
     * Amazon Resource Name (ARN) of this individual assessment.
     * </p>
     * 
     * @return Amazon Resource Name (ARN) of this individual assessment.
     */
    public final String replicationTaskIndividualAssessmentArn() {
        return replicationTaskIndividualAssessmentArn;
    }

    /**
     * <p>
     * ARN of the premigration assessment run that is created to run this individual assessment.
     * </p>
     * 
     * @return ARN of the premigration assessment run that is created to run this individual assessment.
     */
    public final String replicationTaskAssessmentRunArn() {
        return replicationTaskAssessmentRunArn;
    }

    /**
     * <p>
     * Name of this individual assessment.
     * </p>
     * 
     * @return Name of this individual assessment.
     */
    public final String individualAssessmentName() {
        return individualAssessmentName;
    }

    /**
     * <p>
     * Individual assessment status.
     * </p>
     * <p>
     * This status can have one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>"cancelled"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"error"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"failed"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"passed"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"pending"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"running"</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return Individual assessment status.</p>
     *         <p>
     *         This status can have one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>"cancelled"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"error"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"failed"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"passed"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"pending"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"running"</code>
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * Date when this individual assessment was started as part of running the
     * <code>StartReplicationTaskAssessmentRun</code> operation.
     * </p>
     * 
     * @return Date when this individual assessment was started as part of running the
     *         <code>StartReplicationTaskAssessmentRun</code> operation.
     */
    public final Instant replicationTaskIndividualAssessmentStartDate() {
        return replicationTaskIndividualAssessmentStartDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(replicationTaskIndividualAssessmentArn());
        hashCode = 31 * hashCode + Objects.hashCode(replicationTaskAssessmentRunArn());
        hashCode = 31 * hashCode + Objects.hashCode(individualAssessmentName());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(replicationTaskIndividualAssessmentStartDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationTaskIndividualAssessment)) {
            return false;
        }
        ReplicationTaskIndividualAssessment other = (ReplicationTaskIndividualAssessment) obj;
        return Objects.equals(replicationTaskIndividualAssessmentArn(), other.replicationTaskIndividualAssessmentArn())
                && Objects.equals(replicationTaskAssessmentRunArn(), other.replicationTaskAssessmentRunArn())
                && Objects.equals(individualAssessmentName(), other.individualAssessmentName())
                && Objects.equals(status(), other.status())
                && Objects.equals(replicationTaskIndividualAssessmentStartDate(),
                        other.replicationTaskIndividualAssessmentStartDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReplicationTaskIndividualAssessment")
                .add("ReplicationTaskIndividualAssessmentArn", replicationTaskIndividualAssessmentArn())
                .add("ReplicationTaskAssessmentRunArn", replicationTaskAssessmentRunArn())
                .add("IndividualAssessmentName", individualAssessmentName()).add("Status", status())
                .add("ReplicationTaskIndividualAssessmentStartDate", replicationTaskIndividualAssessmentStartDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationTaskIndividualAssessmentArn":
            return Optional.ofNullable(clazz.cast(replicationTaskIndividualAssessmentArn()));
        case "ReplicationTaskAssessmentRunArn":
            return Optional.ofNullable(clazz.cast(replicationTaskAssessmentRunArn()));
        case "IndividualAssessmentName":
            return Optional.ofNullable(clazz.cast(individualAssessmentName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "ReplicationTaskIndividualAssessmentStartDate":
            return Optional.ofNullable(clazz.cast(replicationTaskIndividualAssessmentStartDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationTaskIndividualAssessment, T> g) {
        return obj -> g.apply((ReplicationTaskIndividualAssessment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationTaskIndividualAssessment> {
        /**
         * <p>
         * Amazon Resource Name (ARN) of this individual assessment.
         * </p>
         * 
         * @param replicationTaskIndividualAssessmentArn
         *        Amazon Resource Name (ARN) of this individual assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskIndividualAssessmentArn(String replicationTaskIndividualAssessmentArn);

        /**
         * <p>
         * ARN of the premigration assessment run that is created to run this individual assessment.
         * </p>
         * 
         * @param replicationTaskAssessmentRunArn
         *        ARN of the premigration assessment run that is created to run this individual assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskAssessmentRunArn(String replicationTaskAssessmentRunArn);

        /**
         * <p>
         * Name of this individual assessment.
         * </p>
         * 
         * @param individualAssessmentName
         *        Name of this individual assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder individualAssessmentName(String individualAssessmentName);

        /**
         * <p>
         * Individual assessment status.
         * </p>
         * <p>
         * This status can have one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>"cancelled"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"error"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"failed"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"passed"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"pending"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"running"</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        Individual assessment status.</p>
         *        <p>
         *        This status can have one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>"cancelled"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"error"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"failed"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"passed"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"pending"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"running"</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Date when this individual assessment was started as part of running the
         * <code>StartReplicationTaskAssessmentRun</code> operation.
         * </p>
         * 
         * @param replicationTaskIndividualAssessmentStartDate
         *        Date when this individual assessment was started as part of running the
         *        <code>StartReplicationTaskAssessmentRun</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationTaskIndividualAssessmentStartDate(Instant replicationTaskIndividualAssessmentStartDate);
    }

    static final class BuilderImpl implements Builder {
        private String replicationTaskIndividualAssessmentArn;

        private String replicationTaskAssessmentRunArn;

        private String individualAssessmentName;

        private String status;

        private Instant replicationTaskIndividualAssessmentStartDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationTaskIndividualAssessment model) {
            replicationTaskIndividualAssessmentArn(model.replicationTaskIndividualAssessmentArn);
            replicationTaskAssessmentRunArn(model.replicationTaskAssessmentRunArn);
            individualAssessmentName(model.individualAssessmentName);
            status(model.status);
            replicationTaskIndividualAssessmentStartDate(model.replicationTaskIndividualAssessmentStartDate);
        }

        public final String getReplicationTaskIndividualAssessmentArn() {
            return replicationTaskIndividualAssessmentArn;
        }

        public final void setReplicationTaskIndividualAssessmentArn(String replicationTaskIndividualAssessmentArn) {
            this.replicationTaskIndividualAssessmentArn = replicationTaskIndividualAssessmentArn;
        }

        @Override
        @Transient
        public final Builder replicationTaskIndividualAssessmentArn(String replicationTaskIndividualAssessmentArn) {
            this.replicationTaskIndividualAssessmentArn = replicationTaskIndividualAssessmentArn;
            return this;
        }

        public final String getReplicationTaskAssessmentRunArn() {
            return replicationTaskAssessmentRunArn;
        }

        public final void setReplicationTaskAssessmentRunArn(String replicationTaskAssessmentRunArn) {
            this.replicationTaskAssessmentRunArn = replicationTaskAssessmentRunArn;
        }

        @Override
        @Transient
        public final Builder replicationTaskAssessmentRunArn(String replicationTaskAssessmentRunArn) {
            this.replicationTaskAssessmentRunArn = replicationTaskAssessmentRunArn;
            return this;
        }

        public final String getIndividualAssessmentName() {
            return individualAssessmentName;
        }

        public final void setIndividualAssessmentName(String individualAssessmentName) {
            this.individualAssessmentName = individualAssessmentName;
        }

        @Override
        @Transient
        public final Builder individualAssessmentName(String individualAssessmentName) {
            this.individualAssessmentName = individualAssessmentName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getReplicationTaskIndividualAssessmentStartDate() {
            return replicationTaskIndividualAssessmentStartDate;
        }

        public final void setReplicationTaskIndividualAssessmentStartDate(Instant replicationTaskIndividualAssessmentStartDate) {
            this.replicationTaskIndividualAssessmentStartDate = replicationTaskIndividualAssessmentStartDate;
        }

        @Override
        @Transient
        public final Builder replicationTaskIndividualAssessmentStartDate(Instant replicationTaskIndividualAssessmentStartDate) {
            this.replicationTaskIndividualAssessmentStartDate = replicationTaskIndividualAssessmentStartDate;
            return this;
        }

        @Override
        public ReplicationTaskIndividualAssessment build() {
            return new ReplicationTaskIndividualAssessment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
