/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StopReplicationResponse extends DatabaseMigrationResponse implements
        ToCopyableBuilder<StopReplicationResponse.Builder, StopReplicationResponse> {
    private static final SdkField<Replication> REPLICATION_FIELD = SdkField.<Replication> builder(MarshallingType.SDK_POJO)
            .memberName("Replication").getter(getter(StopReplicationResponse::replication)).setter(setter(Builder::replication))
            .constructor(Replication::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Replication").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_FIELD));

    private final Replication replication;

    private StopReplicationResponse(BuilderImpl builder) {
        super(builder);
        this.replication = builder.replication;
    }

    /**
     * <p>
     * The replication that DMS stopped.
     * </p>
     * 
     * @return The replication that DMS stopped.
     */
    public final Replication replication() {
        return replication;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(replication());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopReplicationResponse)) {
            return false;
        }
        StopReplicationResponse other = (StopReplicationResponse) obj;
        return Objects.equals(replication(), other.replication());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StopReplicationResponse").add("Replication", replication()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Replication":
            return Optional.ofNullable(clazz.cast(replication()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StopReplicationResponse, T> g) {
        return obj -> g.apply((StopReplicationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StopReplicationResponse> {
        /**
         * <p>
         * The replication that DMS stopped.
         * </p>
         * 
         * @param replication
         *        The replication that DMS stopped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replication(Replication replication);

        /**
         * <p>
         * The replication that DMS stopped.
         * </p>
         * This is a convenience method that creates an instance of the {@link Replication.Builder} avoiding the need to
         * create one manually via {@link Replication#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Replication.Builder#build()} is called immediately and its result
         * is passed to {@link #replication(Replication)}.
         * 
         * @param replication
         *        a consumer that will call methods on {@link Replication.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replication(Replication)
         */
        default Builder replication(Consumer<Replication.Builder> replication) {
            return replication(Replication.builder().applyMutation(replication).build());
        }
    }

    static final class BuilderImpl extends DatabaseMigrationResponse.BuilderImpl implements Builder {
        private Replication replication;

        private BuilderImpl() {
        }

        private BuilderImpl(StopReplicationResponse model) {
            super(model);
            replication(model.replication);
        }

        public final Replication.Builder getReplication() {
            return replication != null ? replication.toBuilder() : null;
        }

        public final void setReplication(Replication.BuilderImpl replication) {
            this.replication = replication != null ? replication.build() : null;
        }

        @Override
        public final Builder replication(Replication replication) {
            this.replication = replication;
            return this;
        }

        @Override
        public StopReplicationResponse build() {
            return new StopReplicationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
