/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about a metadata model assessment exported to SQL.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportSqlDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ExportSqlDetails.Builder, ExportSqlDetails> {
    private static final SdkField<String> S3_OBJECT_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3ObjectKey").getter(getter(ExportSqlDetails::s3ObjectKey)).setter(setter(Builder::s3ObjectKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ObjectKey").build()).build();

    private static final SdkField<String> OBJECT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectURL").getter(getter(ExportSqlDetails::objectURL)).setter(setter(Builder::objectURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectURL").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_OBJECT_KEY_FIELD,
            OBJECT_URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3ObjectKey;

    private final String objectURL;

    private ExportSqlDetails(BuilderImpl builder) {
        this.s3ObjectKey = builder.s3ObjectKey;
        this.objectURL = builder.objectURL;
    }

    /**
     * <p>
     * The Amazon S3 object key for the object containing the exported metadata model assessment.
     * </p>
     * 
     * @return The Amazon S3 object key for the object containing the exported metadata model assessment.
     */
    public final String s3ObjectKey() {
        return s3ObjectKey;
    }

    /**
     * <p>
     * The URL for the object containing the exported metadata model assessment.
     * </p>
     * 
     * @return The URL for the object containing the exported metadata model assessment.
     */
    public final String objectURL() {
        return objectURL;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3ObjectKey());
        hashCode = 31 * hashCode + Objects.hashCode(objectURL());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportSqlDetails)) {
            return false;
        }
        ExportSqlDetails other = (ExportSqlDetails) obj;
        return Objects.equals(s3ObjectKey(), other.s3ObjectKey()) && Objects.equals(objectURL(), other.objectURL());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportSqlDetails").add("S3ObjectKey", s3ObjectKey()).add("ObjectURL", objectURL()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3ObjectKey":
            return Optional.ofNullable(clazz.cast(s3ObjectKey()));
        case "ObjectURL":
            return Optional.ofNullable(clazz.cast(objectURL()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportSqlDetails, T> g) {
        return obj -> g.apply((ExportSqlDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportSqlDetails> {
        /**
         * <p>
         * The Amazon S3 object key for the object containing the exported metadata model assessment.
         * </p>
         * 
         * @param s3ObjectKey
         *        The Amazon S3 object key for the object containing the exported metadata model assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ObjectKey(String s3ObjectKey);

        /**
         * <p>
         * The URL for the object containing the exported metadata model assessment.
         * </p>
         * 
         * @param objectURL
         *        The URL for the object containing the exported metadata model assessment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectURL(String objectURL);
    }

    static final class BuilderImpl implements Builder {
        private String s3ObjectKey;

        private String objectURL;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportSqlDetails model) {
            s3ObjectKey(model.s3ObjectKey);
            objectURL(model.objectURL);
        }

        public final String getS3ObjectKey() {
            return s3ObjectKey;
        }

        public final void setS3ObjectKey(String s3ObjectKey) {
            this.s3ObjectKey = s3ObjectKey;
        }

        @Override
        public final Builder s3ObjectKey(String s3ObjectKey) {
            this.s3ObjectKey = s3ObjectKey;
            return this;
        }

        public final String getObjectURL() {
            return objectURL;
        }

        public final void setObjectURL(String objectURL) {
            this.objectURL = objectURL;
        }

        @Override
        public final Builder objectURL(String objectURL) {
            this.objectURL = objectURL;
            return this;
        }

        @Override
        public ExportSqlDetails build() {
            return new ExportSqlDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
