/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTagsForResourceRequest extends DatabaseMigrationRequest implements
        ToCopyableBuilder<ListTagsForResourceRequest.Builder, ListTagsForResourceRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(ListTagsForResourceRequest::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<List<String>> RESOURCE_ARN_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceArnList")
            .getter(getter(ListTagsForResourceRequest::resourceArnList))
            .setter(setter(Builder::resourceArnList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArnList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            RESOURCE_ARN_LIST_FIELD));

    private final String resourceArn;

    private final List<String> resourceArnList;

    private ListTagsForResourceRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.resourceArnList = builder.resourceArnList;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) string that uniquely identifies the DMS resource to list tags for. This returns a
     * list of keys (names of tags) created for the resource and their associated tag values.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) string that uniquely identifies the DMS resource to list tags for. This
     *         returns a list of keys (names of tags) created for the resource and their associated tag values.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceArnList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceArnList() {
        return resourceArnList != null && !(resourceArnList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of ARNs that identify multiple DMS resources that you want to list tags for. This returns a list of keys
     * (tag names) and their associated tag values. It also returns each tag's associated <code>ResourceArn</code>
     * value, which is the ARN of the resource for which each listed tag is created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceArnList} method.
     * </p>
     * 
     * @return List of ARNs that identify multiple DMS resources that you want to list tags for. This returns a list of
     *         keys (tag names) and their associated tag values. It also returns each tag's associated
     *         <code>ResourceArn</code> value, which is the ARN of the resource for which each listed tag is created.
     */
    public final List<String> resourceArnList() {
        return resourceArnList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceArnList() ? resourceArnList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForResourceRequest)) {
            return false;
        }
        ListTagsForResourceRequest other = (ListTagsForResourceRequest) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && hasResourceArnList() == other.hasResourceArnList()
                && Objects.equals(resourceArnList(), other.resourceArnList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTagsForResourceRequest").add("ResourceArn", resourceArn())
                .add("ResourceArnList", hasResourceArnList() ? resourceArnList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "ResourceArnList":
            return Optional.ofNullable(clazz.cast(resourceArnList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTagsForResourceRequest, T> g) {
        return obj -> g.apply((ListTagsForResourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListTagsForResourceRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) string that uniquely identifies the DMS resource to list tags for. This
         * returns a list of keys (names of tags) created for the resource and their associated tag values.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) string that uniquely identifies the DMS resource to list tags for. This
         *        returns a list of keys (names of tags) created for the resource and their associated tag values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * List of ARNs that identify multiple DMS resources that you want to list tags for. This returns a list of keys
         * (tag names) and their associated tag values. It also returns each tag's associated <code>ResourceArn</code>
         * value, which is the ARN of the resource for which each listed tag is created.
         * </p>
         * 
         * @param resourceArnList
         *        List of ARNs that identify multiple DMS resources that you want to list tags for. This returns a list
         *        of keys (tag names) and their associated tag values. It also returns each tag's associated
         *        <code>ResourceArn</code> value, which is the ARN of the resource for which each listed tag is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArnList(Collection<String> resourceArnList);

        /**
         * <p>
         * List of ARNs that identify multiple DMS resources that you want to list tags for. This returns a list of keys
         * (tag names) and their associated tag values. It also returns each tag's associated <code>ResourceArn</code>
         * value, which is the ARN of the resource for which each listed tag is created.
         * </p>
         * 
         * @param resourceArnList
         *        List of ARNs that identify multiple DMS resources that you want to list tags for. This returns a list
         *        of keys (tag names) and their associated tag values. It also returns each tag's associated
         *        <code>ResourceArn</code> value, which is the ARN of the resource for which each listed tag is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArnList(String... resourceArnList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DatabaseMigrationRequest.BuilderImpl implements Builder {
        private String resourceArn;

        private List<String> resourceArnList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForResourceRequest model) {
            super(model);
            resourceArn(model.resourceArn);
            resourceArnList(model.resourceArnList);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Collection<String> getResourceArnList() {
            if (resourceArnList instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceArnList;
        }

        public final void setResourceArnList(Collection<String> resourceArnList) {
            this.resourceArnList = ArnListCopier.copy(resourceArnList);
        }

        @Override
        public final Builder resourceArnList(Collection<String> resourceArnList) {
            this.resourceArnList = ArnListCopier.copy(resourceArnList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArnList(String... resourceArnList) {
            resourceArnList(Arrays.asList(resourceArnList));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTagsForResourceRequest build() {
            return new ListTagsForResourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
