/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.databasemigration.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.databasemigration.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.databasemigration.model.ApplyPendingMaintenanceActionRequest;
import software.amazon.awssdk.services.databasemigration.model.ApplyPendingMaintenanceActionResponse;
import software.amazon.awssdk.services.databasemigration.model.BatchStartRecommendationsRequest;
import software.amazon.awssdk.services.databasemigration.model.BatchStartRecommendationsResponse;
import software.amazon.awssdk.services.databasemigration.model.CancelReplicationTaskAssessmentRunRequest;
import software.amazon.awssdk.services.databasemigration.model.CancelReplicationTaskAssessmentRunResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateDataMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateDataMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateDataProviderRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateDataProviderResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateEndpointRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateEndpointResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateEventSubscriptionRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateEventSubscriptionResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateFleetAdvisorCollectorRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateFleetAdvisorCollectorResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateInstanceProfileRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateInstanceProfileResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateMigrationProjectRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateMigrationProjectResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationConfigRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationConfigResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationInstanceRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationInstanceResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationSubnetGroupRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationSubnetGroupResponse;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.CreateReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteCertificateRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteCertificateResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteConnectionRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteConnectionResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteDataMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteDataMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteDataProviderRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteDataProviderResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteEventSubscriptionRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteEventSubscriptionResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteFleetAdvisorCollectorRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteFleetAdvisorCollectorResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteFleetAdvisorDatabasesRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteFleetAdvisorDatabasesResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteInstanceProfileRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteInstanceProfileResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteMigrationProjectRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteMigrationProjectResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationConfigRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationConfigResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationInstanceRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationInstanceResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationSubnetGroupRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationSubnetGroupResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskAssessmentRunRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskAssessmentRunResponse;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeConversionConfigurationRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeConversionConfigurationResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeDataProvidersRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeDataProvidersResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEngineVersionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEngineVersionsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventCategoriesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventCategoriesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeEventsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeExtensionPackAssociationsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeExtensionPackAssociationsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorCollectorsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorCollectorsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorDatabasesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorDatabasesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeInstanceProfilesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeInstanceProfilesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelAssessmentsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelAssessmentsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelConversionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelConversionsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsAsScriptRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsAsScriptResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsToTargetRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsToTargetResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelImportsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelImportsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeMigrationProjectsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeMigrationProjectsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationLimitationsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationLimitationsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeRefreshSchemasStatusRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeRefreshSchemasStatusResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationConfigsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationConfigsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeReplicationsResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeSchemasRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeSchemasResponse;
import software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsRequest;
import software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsResponse;
import software.amazon.awssdk.services.databasemigration.model.ExportMetadataModelAssessmentRequest;
import software.amazon.awssdk.services.databasemigration.model.ExportMetadataModelAssessmentResponse;
import software.amazon.awssdk.services.databasemigration.model.ImportCertificateRequest;
import software.amazon.awssdk.services.databasemigration.model.ImportCertificateResponse;
import software.amazon.awssdk.services.databasemigration.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.databasemigration.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyConversionConfigurationRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyConversionConfigurationResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyDataMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyDataMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyDataProviderRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyDataProviderResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyEndpointRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyEndpointResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyEventSubscriptionRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyEventSubscriptionResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyInstanceProfileRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyInstanceProfileResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyMigrationProjectRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyMigrationProjectResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationConfigRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationConfigResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationInstanceRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationInstanceResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationSubnetGroupRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationSubnetGroupResponse;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.ModifyReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.MoveReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.MoveReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.RebootReplicationInstanceRequest;
import software.amazon.awssdk.services.databasemigration.model.RebootReplicationInstanceResponse;
import software.amazon.awssdk.services.databasemigration.model.RefreshSchemasRequest;
import software.amazon.awssdk.services.databasemigration.model.RefreshSchemasResponse;
import software.amazon.awssdk.services.databasemigration.model.ReloadReplicationTablesRequest;
import software.amazon.awssdk.services.databasemigration.model.ReloadReplicationTablesResponse;
import software.amazon.awssdk.services.databasemigration.model.ReloadTablesRequest;
import software.amazon.awssdk.services.databasemigration.model.ReloadTablesResponse;
import software.amazon.awssdk.services.databasemigration.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.databasemigration.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.databasemigration.model.RunFleetAdvisorLsaAnalysisRequest;
import software.amazon.awssdk.services.databasemigration.model.RunFleetAdvisorLsaAnalysisResponse;
import software.amazon.awssdk.services.databasemigration.model.StartDataMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.StartDataMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.StartExtensionPackAssociationRequest;
import software.amazon.awssdk.services.databasemigration.model.StartExtensionPackAssociationResponse;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelAssessmentRequest;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelAssessmentResponse;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelConversionRequest;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelConversionResponse;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportAsScriptRequest;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportAsScriptResponse;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportToTargetRequest;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportToTargetResponse;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelImportRequest;
import software.amazon.awssdk.services.databasemigration.model.StartMetadataModelImportResponse;
import software.amazon.awssdk.services.databasemigration.model.StartRecommendationsRequest;
import software.amazon.awssdk.services.databasemigration.model.StartRecommendationsResponse;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationRequest;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationResponse;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentRequest;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentResponse;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentRunRequest;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentRunResponse;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.StopDataMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.StopDataMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.StopReplicationRequest;
import software.amazon.awssdk.services.databasemigration.model.StopReplicationResponse;
import software.amazon.awssdk.services.databasemigration.model.StopReplicationTaskRequest;
import software.amazon.awssdk.services.databasemigration.model.StopReplicationTaskResponse;
import software.amazon.awssdk.services.databasemigration.model.TestConnectionRequest;
import software.amazon.awssdk.services.databasemigration.model.TestConnectionResponse;
import software.amazon.awssdk.services.databasemigration.model.UpdateSubscriptionsToEventBridgeRequest;
import software.amazon.awssdk.services.databasemigration.model.UpdateSubscriptionsToEventBridgeResponse;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeApplicableIndividualAssessmentsPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeCertificatesPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeConnectionsPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeDataMigrationsPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeDataProvidersPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointSettingsPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointTypesPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointsPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeEngineVersionsPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeEventSubscriptionsPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeEventsPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeExtensionPackAssociationsPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorCollectorsPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorDatabasesPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorLsaAnalysisPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorSchemaObjectSummaryPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorSchemasPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeInstanceProfilesPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelAssessmentsPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelConversionsPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelExportsAsScriptPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelExportsToTargetPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelImportsPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeMigrationProjectsPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeOrderableReplicationInstancesPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribePendingMaintenanceActionsPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeRecommendationLimitationsPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeRecommendationsPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationConfigsPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstanceTaskLogsPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstancesPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationSubnetGroupsPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTableStatisticsPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentResultsPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentRunsPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskIndividualAssessmentsPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTasksPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationsPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeSchemasPublisher;
import software.amazon.awssdk.services.databasemigration.paginators.DescribeTableStatisticsPublisher;
import software.amazon.awssdk.services.databasemigration.waiters.DatabaseMigrationAsyncWaiter;

/**
 * Service client for accessing AWS Database Migration Service asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <fullname>Database Migration Service</fullname>
 * <p>
 * Database Migration Service (DMS) can migrate your data to and from the most widely used commercial and open-source
 * databases such as Oracle, PostgreSQL, Microsoft SQL Server, Amazon Redshift, MariaDB, Amazon Aurora, MySQL, and SAP
 * Adaptive Server Enterprise (ASE). The service supports homogeneous migrations such as Oracle to Oracle, as well as
 * heterogeneous migrations between different database platforms, such as Oracle to MySQL or SQL Server to PostgreSQL.
 * </p>
 * <p>
 * For more information about DMS, see <a href="https://docs.aws.amazon.com/dms/latest/userguide/Welcome.html">What Is
 * Database Migration Service?</a> in the <i>Database Migration Service User Guide.</i>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface DatabaseMigrationAsyncClient extends AwsClient {
    String SERVICE_NAME = "dms";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "dms";

    /**
     * <p>
     * Adds metadata tags to an DMS resource, including replication instance, endpoint, subnet group, and migration
     * task. These tags can also be used with cost allocation reporting to track cost associated with DMS resources, or
     * used in a Condition statement in an IAM policy for DMS. For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html"> <code>Tag</code> </a> data type
     * description.
     * </p>
     *
     * @param addTagsToResourceRequest
     *        Associates a set of tags with an DMS resource.
     * @return A Java Future containing the result of the AddTagsToResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddTagsToResourceResponse> addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds metadata tags to an DMS resource, including replication instance, endpoint, subnet group, and migration
     * task. These tags can also be used with cost allocation reporting to track cost associated with DMS resources, or
     * used in a Condition statement in an IAM policy for DMS. For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html"> <code>Tag</code> </a> data type
     * description.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddTagsToResourceRequest.Builder} avoiding the need
     * to create one manually via {@link AddTagsToResourceRequest#builder()}
     * </p>
     *
     * @param addTagsToResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.AddTagsToResourceRequest.Builder} to create
     *        a request. Associates a set of tags with an DMS resource.
     * @return A Java Future containing the result of the AddTagsToResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddTagsToResourceResponse> addTagsToResource(
            Consumer<AddTagsToResourceRequest.Builder> addTagsToResourceRequest) {
        return addTagsToResource(AddTagsToResourceRequest.builder().applyMutation(addTagsToResourceRequest).build());
    }

    /**
     * <p>
     * Applies a pending maintenance action to a resource (for example, to a replication instance).
     * </p>
     *
     * @param applyPendingMaintenanceActionRequest
     * @return A Java Future containing the result of the ApplyPendingMaintenanceAction operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.ApplyPendingMaintenanceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ApplyPendingMaintenanceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ApplyPendingMaintenanceActionResponse> applyPendingMaintenanceAction(
            ApplyPendingMaintenanceActionRequest applyPendingMaintenanceActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies a pending maintenance action to a resource (for example, to a replication instance).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ApplyPendingMaintenanceActionRequest.Builder}
     * avoiding the need to create one manually via {@link ApplyPendingMaintenanceActionRequest#builder()}
     * </p>
     *
     * @param applyPendingMaintenanceActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.ApplyPendingMaintenanceActionRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ApplyPendingMaintenanceAction operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.ApplyPendingMaintenanceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ApplyPendingMaintenanceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ApplyPendingMaintenanceActionResponse> applyPendingMaintenanceAction(
            Consumer<ApplyPendingMaintenanceActionRequest.Builder> applyPendingMaintenanceActionRequest) {
        return applyPendingMaintenanceAction(ApplyPendingMaintenanceActionRequest.builder()
                .applyMutation(applyPendingMaintenanceActionRequest).build());
    }

    /**
     * <p>
     * Starts the analysis of up to 20 source databases to recommend target engines for each source database. This is a
     * batch version of <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartRecommendations.html">StartRecommendations
     * </a>.
     * </p>
     * <p>
     * The result of analysis of each source database is reported individually in the response. Because the batch
     * request can result in a combination of successful and unsuccessful actions, you should check for batch errors
     * even when the call returns an HTTP status code of <code>200</code>.
     * </p>
     *
     * @param batchStartRecommendationsRequest
     * @return A Java Future containing the result of the BatchStartRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.BatchStartRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/BatchStartRecommendations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchStartRecommendationsResponse> batchStartRecommendations(
            BatchStartRecommendationsRequest batchStartRecommendationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the analysis of up to 20 source databases to recommend target engines for each source database. This is a
     * batch version of <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_StartRecommendations.html">StartRecommendations
     * </a>.
     * </p>
     * <p>
     * The result of analysis of each source database is reported individually in the response. Because the batch
     * request can result in a combination of successful and unsuccessful actions, you should check for batch errors
     * even when the call returns an HTTP status code of <code>200</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchStartRecommendationsRequest.Builder} avoiding
     * the need to create one manually via {@link BatchStartRecommendationsRequest#builder()}
     * </p>
     *
     * @param batchStartRecommendationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.BatchStartRecommendationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchStartRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.BatchStartRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/BatchStartRecommendations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchStartRecommendationsResponse> batchStartRecommendations(
            Consumer<BatchStartRecommendationsRequest.Builder> batchStartRecommendationsRequest) {
        return batchStartRecommendations(BatchStartRecommendationsRequest.builder()
                .applyMutation(batchStartRecommendationsRequest).build());
    }

    /**
     * <p>
     * Cancels a single premigration assessment run.
     * </p>
     * <p>
     * This operation prevents any individual assessments from running if they haven't started running. It also attempts
     * to cancel any individual assessments that are currently running.
     * </p>
     *
     * @param cancelReplicationTaskAssessmentRunRequest
     * @return A Java Future containing the result of the CancelReplicationTaskAssessmentRun operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CancelReplicationTaskAssessmentRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CancelReplicationTaskAssessmentRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelReplicationTaskAssessmentRunResponse> cancelReplicationTaskAssessmentRun(
            CancelReplicationTaskAssessmentRunRequest cancelReplicationTaskAssessmentRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a single premigration assessment run.
     * </p>
     * <p>
     * This operation prevents any individual assessments from running if they haven't started running. It also attempts
     * to cancel any individual assessments that are currently running.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelReplicationTaskAssessmentRunRequest.Builder}
     * avoiding the need to create one manually via {@link CancelReplicationTaskAssessmentRunRequest#builder()}
     * </p>
     *
     * @param cancelReplicationTaskAssessmentRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.CancelReplicationTaskAssessmentRunRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CancelReplicationTaskAssessmentRun operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CancelReplicationTaskAssessmentRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CancelReplicationTaskAssessmentRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelReplicationTaskAssessmentRunResponse> cancelReplicationTaskAssessmentRun(
            Consumer<CancelReplicationTaskAssessmentRunRequest.Builder> cancelReplicationTaskAssessmentRunRequest) {
        return cancelReplicationTaskAssessmentRun(CancelReplicationTaskAssessmentRunRequest.builder()
                .applyMutation(cancelReplicationTaskAssessmentRunRequest).build());
    }

    /**
     * <p>
     * Creates a data migration using the provided settings.
     * </p>
     *
     * @param createDataMigrationRequest
     * @return A Java Future containing the result of the CreateDataMigration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>InvalidOperationException The action or operation requested isn't valid.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CreateDataMigration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateDataMigration" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDataMigrationResponse> createDataMigration(
            CreateDataMigrationRequest createDataMigrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a data migration using the provided settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataMigrationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDataMigrationRequest#builder()}
     * </p>
     *
     * @param createDataMigrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.CreateDataMigrationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateDataMigration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>InvalidOperationException The action or operation requested isn't valid.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CreateDataMigration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateDataMigration" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDataMigrationResponse> createDataMigration(
            Consumer<CreateDataMigrationRequest.Builder> createDataMigrationRequest) {
        return createDataMigration(CreateDataMigrationRequest.builder().applyMutation(createDataMigrationRequest).build());
    }

    /**
     * <p>
     * Creates a data provider using the provided settings. A data provider stores a data store type and location
     * information about your database.
     * </p>
     *
     * @param createDataProviderRequest
     * @return A Java Future containing the result of the CreateDataProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CreateDataProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateDataProvider" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDataProviderResponse> createDataProvider(CreateDataProviderRequest createDataProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a data provider using the provided settings. A data provider stores a data store type and location
     * information about your database.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataProviderRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDataProviderRequest#builder()}
     * </p>
     *
     * @param createDataProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.CreateDataProviderRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateDataProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CreateDataProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateDataProvider" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDataProviderResponse> createDataProvider(
            Consumer<CreateDataProviderRequest.Builder> createDataProviderRequest) {
        return createDataProvider(CreateDataProviderRequest.builder().applyMutation(createDataProviderRequest).build());
    }

    /**
     * <p>
     * Creates an endpoint using the provided settings.
     * </p>
     * <note>
     * <p>
     * For a MySQL source or target endpoint, don't explicitly specify the database using the <code>DatabaseName</code>
     * request parameter on the <code>CreateEndpoint</code> API call. Specifying <code>DatabaseName</code> when you
     * create a MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify
     * the database only when you specify the schema in the table-mapping rules of the DMS task.
     * </p>
     * </note>
     *
     * @param createEndpointRequest
     * @return A Java Future containing the result of the CreateEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>S3AccessDeniedException Insufficient privileges are preventing access to an Amazon S3 object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CreateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateEndpointResponse> createEndpoint(CreateEndpointRequest createEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an endpoint using the provided settings.
     * </p>
     * <note>
     * <p>
     * For a MySQL source or target endpoint, don't explicitly specify the database using the <code>DatabaseName</code>
     * request parameter on the <code>CreateEndpoint</code> API call. Specifying <code>DatabaseName</code> when you
     * create a MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify
     * the database only when you specify the schema in the table-mapping rules of the DMS task.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link CreateEndpointRequest#builder()}
     * </p>
     *
     * @param createEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.CreateEndpointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>S3AccessDeniedException Insufficient privileges are preventing access to an Amazon S3 object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CreateEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateEndpointResponse> createEndpoint(Consumer<CreateEndpointRequest.Builder> createEndpointRequest) {
        return createEndpoint(CreateEndpointRequest.builder().applyMutation(createEndpointRequest).build());
    }

    /**
     * <p>
     * Creates an DMS event notification subscription.
     * </p>
     * <p>
     * You can specify the type of source (<code>SourceType</code>) you want to be notified of, provide a list of DMS
     * source IDs (<code>SourceIds</code>) that triggers the events, and provide a list of event categories (
     * <code>EventCategories</code>) for events you want to be notified of. If you specify both the
     * <code>SourceType</code> and <code>SourceIds</code>, such as <code>SourceType = replication-instance</code> and
     * <code>SourceIdentifier = my-replinstance</code>, you will be notified of all the replication instance events for
     * the specified source. If you specify a <code>SourceType</code> but don't specify a <code>SourceIdentifier</code>,
     * you receive notice of the events for that source type for all your DMS sources. If you don't specify either
     * <code>SourceType</code> nor <code>SourceIdentifier</code>, you will be notified of events generated from all DMS
     * sources belonging to your customer account.
     * </p>
     * <p>
     * For more information about DMS events, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     *
     * @param createEventSubscriptionRequest
     * @return A Java Future containing the result of the CreateEventSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>SnsInvalidTopicException The SNS topic is invalid.</li>
     *         <li>SnsNoAuthorizationException You are not authorized for the SNS subscription.</li>
     *         <li>KmsAccessDeniedException The ciphertext references a key that doesn't exist or that the DMS account
     *         doesn't have access to.</li>
     *         <li>KmsDisabledException The specified KMS key isn't enabled.</li>
     *         <li>KmsInvalidStateException The state of the specified KMS resource isn't valid for this request.</li>
     *         <li>KmsNotFoundException The specified KMS entity or resource can't be found.</li>
     *         <li>KmsThrottlingException This request triggered KMS request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CreateEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateEventSubscriptionResponse> createEventSubscription(
            CreateEventSubscriptionRequest createEventSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an DMS event notification subscription.
     * </p>
     * <p>
     * You can specify the type of source (<code>SourceType</code>) you want to be notified of, provide a list of DMS
     * source IDs (<code>SourceIds</code>) that triggers the events, and provide a list of event categories (
     * <code>EventCategories</code>) for events you want to be notified of. If you specify both the
     * <code>SourceType</code> and <code>SourceIds</code>, such as <code>SourceType = replication-instance</code> and
     * <code>SourceIdentifier = my-replinstance</code>, you will be notified of all the replication instance events for
     * the specified source. If you specify a <code>SourceType</code> but don't specify a <code>SourceIdentifier</code>,
     * you receive notice of the events for that source type for all your DMS sources. If you don't specify either
     * <code>SourceType</code> nor <code>SourceIdentifier</code>, you will be notified of events generated from all DMS
     * sources belonging to your customer account.
     * </p>
     * <p>
     * For more information about DMS events, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateEventSubscriptionRequest#builder()}
     * </p>
     *
     * @param createEventSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.CreateEventSubscriptionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateEventSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>SnsInvalidTopicException The SNS topic is invalid.</li>
     *         <li>SnsNoAuthorizationException You are not authorized for the SNS subscription.</li>
     *         <li>KmsAccessDeniedException The ciphertext references a key that doesn't exist or that the DMS account
     *         doesn't have access to.</li>
     *         <li>KmsDisabledException The specified KMS key isn't enabled.</li>
     *         <li>KmsInvalidStateException The state of the specified KMS resource isn't valid for this request.</li>
     *         <li>KmsNotFoundException The specified KMS entity or resource can't be found.</li>
     *         <li>KmsThrottlingException This request triggered KMS request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CreateEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateEventSubscriptionResponse> createEventSubscription(
            Consumer<CreateEventSubscriptionRequest.Builder> createEventSubscriptionRequest) {
        return createEventSubscription(CreateEventSubscriptionRequest.builder().applyMutation(createEventSubscriptionRequest)
                .build());
    }

    /**
     * <p>
     * Creates a Fleet Advisor collector using the specified parameters.
     * </p>
     *
     * @param createFleetAdvisorCollectorRequest
     * @return A Java Future containing the result of the CreateFleetAdvisorCollector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>S3AccessDeniedException Insufficient privileges are preventing access to an Amazon S3 object.</li>
     *         <li>S3ResourceNotFoundException A specified Amazon S3 bucket, bucket folder, or other object can't be
     *         found.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CreateFleetAdvisorCollector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateFleetAdvisorCollector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateFleetAdvisorCollectorResponse> createFleetAdvisorCollector(
            CreateFleetAdvisorCollectorRequest createFleetAdvisorCollectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Fleet Advisor collector using the specified parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFleetAdvisorCollectorRequest.Builder}
     * avoiding the need to create one manually via {@link CreateFleetAdvisorCollectorRequest#builder()}
     * </p>
     *
     * @param createFleetAdvisorCollectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.CreateFleetAdvisorCollectorRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateFleetAdvisorCollector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>S3AccessDeniedException Insufficient privileges are preventing access to an Amazon S3 object.</li>
     *         <li>S3ResourceNotFoundException A specified Amazon S3 bucket, bucket folder, or other object can't be
     *         found.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CreateFleetAdvisorCollector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateFleetAdvisorCollector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateFleetAdvisorCollectorResponse> createFleetAdvisorCollector(
            Consumer<CreateFleetAdvisorCollectorRequest.Builder> createFleetAdvisorCollectorRequest) {
        return createFleetAdvisorCollector(CreateFleetAdvisorCollectorRequest.builder()
                .applyMutation(createFleetAdvisorCollectorRequest).build());
    }

    /**
     * <p>
     * Creates the instance profile using the specified parameters.
     * </p>
     *
     * @param createInstanceProfileRequest
     * @return A Java Future containing the result of the CreateInstanceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>S3ResourceNotFoundException A specified Amazon S3 bucket, bucket folder, or other object can't be
     *         found.</li>
     *         <li>S3AccessDeniedException Insufficient privileges are preventing access to an Amazon S3 object.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CreateInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateInstanceProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateInstanceProfileResponse> createInstanceProfile(
            CreateInstanceProfileRequest createInstanceProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the instance profile using the specified parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInstanceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateInstanceProfileRequest#builder()}
     * </p>
     *
     * @param createInstanceProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.CreateInstanceProfileRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateInstanceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>S3ResourceNotFoundException A specified Amazon S3 bucket, bucket folder, or other object can't be
     *         found.</li>
     *         <li>S3AccessDeniedException Insufficient privileges are preventing access to an Amazon S3 object.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CreateInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateInstanceProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateInstanceProfileResponse> createInstanceProfile(
            Consumer<CreateInstanceProfileRequest.Builder> createInstanceProfileRequest) {
        return createInstanceProfile(CreateInstanceProfileRequest.builder().applyMutation(createInstanceProfileRequest).build());
    }

    /**
     * <p>
     * Creates the migration project using the specified parameters.
     * </p>
     * <p>
     * You can run this action only after you create an instance profile and data providers using <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateInstanceProfile.html"
     * >CreateInstanceProfile</a> and <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateDataProvider.html">CreateDataProvider</a>.
     * </p>
     *
     * @param createMigrationProjectRequest
     * @return A Java Future containing the result of the CreateMigrationProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>S3ResourceNotFoundException A specified Amazon S3 bucket, bucket folder, or other object can't be
     *         found.</li>
     *         <li>S3AccessDeniedException Insufficient privileges are preventing access to an Amazon S3 object.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CreateMigrationProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateMigrationProject" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateMigrationProjectResponse> createMigrationProject(
            CreateMigrationProjectRequest createMigrationProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the migration project using the specified parameters.
     * </p>
     * <p>
     * You can run this action only after you create an instance profile and data providers using <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateInstanceProfile.html"
     * >CreateInstanceProfile</a> and <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateDataProvider.html">CreateDataProvider</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMigrationProjectRequest.Builder} avoiding the
     * need to create one manually via {@link CreateMigrationProjectRequest#builder()}
     * </p>
     *
     * @param createMigrationProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.CreateMigrationProjectRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateMigrationProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>S3ResourceNotFoundException A specified Amazon S3 bucket, bucket folder, or other object can't be
     *         found.</li>
     *         <li>S3AccessDeniedException Insufficient privileges are preventing access to an Amazon S3 object.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CreateMigrationProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateMigrationProject" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateMigrationProjectResponse> createMigrationProject(
            Consumer<CreateMigrationProjectRequest.Builder> createMigrationProjectRequest) {
        return createMigrationProject(CreateMigrationProjectRequest.builder().applyMutation(createMigrationProjectRequest)
                .build());
    }

    /**
     * <p>
     * Creates a configuration that you can later provide to configure and start an DMS Serverless replication. You can
     * also provide options to validate the configuration inputs before you start the replication.
     * </p>
     *
     * @param createReplicationConfigRequest
     * @return A Java Future containing the result of the CreateReplicationConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ReplicationSubnetGroupDoesNotCoverEnoughAZsException The replication subnet group does not cover
     *         enough Availability Zones (AZs). Edit the replication subnet group and add more AZs.</li>
     *         <li>InvalidSubnetException The subnet provided isn't valid.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CreateReplicationConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateReplicationConfigResponse> createReplicationConfig(
            CreateReplicationConfigRequest createReplicationConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a configuration that you can later provide to configure and start an DMS Serverless replication. You can
     * also provide options to validate the configuration inputs before you start the replication.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReplicationConfigRequest.Builder} avoiding
     * the need to create one manually via {@link CreateReplicationConfigRequest#builder()}
     * </p>
     *
     * @param createReplicationConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.CreateReplicationConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateReplicationConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ReplicationSubnetGroupDoesNotCoverEnoughAZsException The replication subnet group does not cover
     *         enough Availability Zones (AZs). Edit the replication subnet group and add more AZs.</li>
     *         <li>InvalidSubnetException The subnet provided isn't valid.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CreateReplicationConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateReplicationConfigResponse> createReplicationConfig(
            Consumer<CreateReplicationConfigRequest.Builder> createReplicationConfigRequest) {
        return createReplicationConfig(CreateReplicationConfigRequest.builder().applyMutation(createReplicationConfigRequest)
                .build());
    }

    /**
     * <p>
     * Creates the replication instance using the specified parameters.
     * </p>
     * <p>
     * DMS requires that your account have certain roles with appropriate permissions before you can create a
     * replication instance. For information on the required roles, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.APIRole">Creating the IAM
     * Roles to Use With the CLI and DMS API</a>. For information on the required permissions, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.IAMPermissions">IAM
     * Permissions Needed to Use DMS</a>.
     * </p>
     * <note>
     * <p>
     * If you don't specify a version when creating a replication instance, DMS will create the instance using the
     * default engine version. For information about the default engine version, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReleaseNotes.html">Release Notes</a>.
     * </p>
     * </note>
     *
     * @param createReplicationInstanceRequest
     * @return A Java Future containing the result of the CreateReplicationInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>InsufficientResourceCapacityException There are not enough resources allocated to the database
     *         migration.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>StorageQuotaExceededException The storage quota has been exceeded.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ReplicationSubnetGroupDoesNotCoverEnoughAZsException The replication subnet group does not cover
     *         enough Availability Zones (AZs). Edit the replication subnet group and add more AZs.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>InvalidSubnetException The subnet provided isn't valid.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CreateReplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateReplicationInstanceResponse> createReplicationInstance(
            CreateReplicationInstanceRequest createReplicationInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates the replication instance using the specified parameters.
     * </p>
     * <p>
     * DMS requires that your account have certain roles with appropriate permissions before you can create a
     * replication instance. For information on the required roles, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.APIRole">Creating the IAM
     * Roles to Use With the CLI and DMS API</a>. For information on the required permissions, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.IAMPermissions">IAM
     * Permissions Needed to Use DMS</a>.
     * </p>
     * <note>
     * <p>
     * If you don't specify a version when creating a replication instance, DMS will create the instance using the
     * default engine version. For information about the default engine version, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReleaseNotes.html">Release Notes</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReplicationInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link CreateReplicationInstanceRequest#builder()}
     * </p>
     *
     * @param createReplicationInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.CreateReplicationInstanceRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateReplicationInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>InsufficientResourceCapacityException There are not enough resources allocated to the database
     *         migration.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>StorageQuotaExceededException The storage quota has been exceeded.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ReplicationSubnetGroupDoesNotCoverEnoughAZsException The replication subnet group does not cover
     *         enough Availability Zones (AZs). Edit the replication subnet group and add more AZs.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>InvalidSubnetException The subnet provided isn't valid.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CreateReplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateReplicationInstanceResponse> createReplicationInstance(
            Consumer<CreateReplicationInstanceRequest.Builder> createReplicationInstanceRequest) {
        return createReplicationInstance(CreateReplicationInstanceRequest.builder()
                .applyMutation(createReplicationInstanceRequest).build());
    }

    /**
     * <p>
     * Creates a replication subnet group given a list of the subnet IDs in a VPC.
     * </p>
     * <p>
     * The VPC needs to have at least one subnet in at least two availability zones in the Amazon Web Services Region,
     * otherwise the service will throw a <code>ReplicationSubnetGroupDoesNotCoverEnoughAZs</code> exception.
     * </p>
     * <p>
     * If a replication subnet group exists in your Amazon Web Services account, the CreateReplicationSubnetGroup action
     * returns the following error message: The Replication Subnet Group already exists. In this case, delete the
     * existing replication subnet group. To do so, use the <a
     * href="https://docs.aws.amazon.com/en_us/dms/latest/APIReference/API_DeleteReplicationSubnetGroup.html"
     * >DeleteReplicationSubnetGroup</a> action. Optionally, choose Subnet groups in the DMS console, then choose your
     * subnet group. Next, choose Delete from Actions.
     * </p>
     *
     * @param createReplicationSubnetGroupRequest
     * @return A Java Future containing the result of the CreateReplicationSubnetGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>ReplicationSubnetGroupDoesNotCoverEnoughAZsException The replication subnet group does not cover
     *         enough Availability Zones (AZs). Edit the replication subnet group and add more AZs.</li>
     *         <li>InvalidSubnetException The subnet provided isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CreateReplicationSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateReplicationSubnetGroupResponse> createReplicationSubnetGroup(
            CreateReplicationSubnetGroupRequest createReplicationSubnetGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a replication subnet group given a list of the subnet IDs in a VPC.
     * </p>
     * <p>
     * The VPC needs to have at least one subnet in at least two availability zones in the Amazon Web Services Region,
     * otherwise the service will throw a <code>ReplicationSubnetGroupDoesNotCoverEnoughAZs</code> exception.
     * </p>
     * <p>
     * If a replication subnet group exists in your Amazon Web Services account, the CreateReplicationSubnetGroup action
     * returns the following error message: The Replication Subnet Group already exists. In this case, delete the
     * existing replication subnet group. To do so, use the <a
     * href="https://docs.aws.amazon.com/en_us/dms/latest/APIReference/API_DeleteReplicationSubnetGroup.html"
     * >DeleteReplicationSubnetGroup</a> action. Optionally, choose Subnet groups in the DMS console, then choose your
     * subnet group. Next, choose Delete from Actions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReplicationSubnetGroupRequest.Builder}
     * avoiding the need to create one manually via {@link CreateReplicationSubnetGroupRequest#builder()}
     * </p>
     *
     * @param createReplicationSubnetGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.CreateReplicationSubnetGroupRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateReplicationSubnetGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>ReplicationSubnetGroupDoesNotCoverEnoughAZsException The replication subnet group does not cover
     *         enough Availability Zones (AZs). Edit the replication subnet group and add more AZs.</li>
     *         <li>InvalidSubnetException The subnet provided isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CreateReplicationSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateReplicationSubnetGroupResponse> createReplicationSubnetGroup(
            Consumer<CreateReplicationSubnetGroupRequest.Builder> createReplicationSubnetGroupRequest) {
        return createReplicationSubnetGroup(CreateReplicationSubnetGroupRequest.builder()
                .applyMutation(createReplicationSubnetGroupRequest).build());
    }

    /**
     * <p>
     * Creates a replication task using the specified parameters.
     * </p>
     *
     * @param createReplicationTaskRequest
     * @return A Java Future containing the result of the CreateReplicationTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CreateReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateReplicationTaskResponse> createReplicationTask(
            CreateReplicationTaskRequest createReplicationTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a replication task using the specified parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReplicationTaskRequest.Builder} avoiding the
     * need to create one manually via {@link CreateReplicationTaskRequest#builder()}
     * </p>
     *
     * @param createReplicationTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.CreateReplicationTaskRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateReplicationTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.CreateReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateReplicationTaskResponse> createReplicationTask(
            Consumer<CreateReplicationTaskRequest.Builder> createReplicationTaskRequest) {
        return createReplicationTask(CreateReplicationTaskRequest.builder().applyMutation(createReplicationTaskRequest).build());
    }

    /**
     * <p>
     * Deletes the specified certificate.
     * </p>
     *
     * @param deleteCertificateRequest
     * @return A Java Future containing the result of the DeleteCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteCertificateResponse> deleteCertificate(DeleteCertificateRequest deleteCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified certificate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCertificateRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteCertificateRequest#builder()}
     * </p>
     *
     * @param deleteCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DeleteCertificateRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteCertificateResponse> deleteCertificate(
            Consumer<DeleteCertificateRequest.Builder> deleteCertificateRequest) {
        return deleteCertificate(DeleteCertificateRequest.builder().applyMutation(deleteCertificateRequest).build());
    }

    /**
     * <p>
     * Deletes the connection between a replication instance and an endpoint.
     * </p>
     *
     * @param deleteConnectionRequest
     * @return A Java Future containing the result of the DeleteConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteConnectionResponse> deleteConnection(DeleteConnectionRequest deleteConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the connection between a replication instance and an endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteConnectionRequest#builder()}
     * </p>
     *
     * @param deleteConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DeleteConnectionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteConnection" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteConnectionResponse> deleteConnection(
            Consumer<DeleteConnectionRequest.Builder> deleteConnectionRequest) {
        return deleteConnection(DeleteConnectionRequest.builder().applyMutation(deleteConnectionRequest).build());
    }

    /**
     * <p>
     * Deletes the specified data migration.
     * </p>
     *
     * @param deleteDataMigrationRequest
     * @return A Java Future containing the result of the DeleteDataMigration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteDataMigration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteDataMigration" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDataMigrationResponse> deleteDataMigration(
            DeleteDataMigrationRequest deleteDataMigrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified data migration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataMigrationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDataMigrationRequest#builder()}
     * </p>
     *
     * @param deleteDataMigrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DeleteDataMigrationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteDataMigration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteDataMigration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteDataMigration" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDataMigrationResponse> deleteDataMigration(
            Consumer<DeleteDataMigrationRequest.Builder> deleteDataMigrationRequest) {
        return deleteDataMigration(DeleteDataMigrationRequest.builder().applyMutation(deleteDataMigrationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified data provider.
     * </p>
     * <note>
     * <p>
     * All migration projects associated with the data provider must be deleted or modified before you can delete the
     * data provider.
     * </p>
     * </note>
     *
     * @param deleteDataProviderRequest
     * @return A Java Future containing the result of the DeleteDataProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteDataProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteDataProvider" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDataProviderResponse> deleteDataProvider(DeleteDataProviderRequest deleteDataProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified data provider.
     * </p>
     * <note>
     * <p>
     * All migration projects associated with the data provider must be deleted or modified before you can delete the
     * data provider.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataProviderRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDataProviderRequest#builder()}
     * </p>
     *
     * @param deleteDataProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DeleteDataProviderRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteDataProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteDataProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteDataProvider" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDataProviderResponse> deleteDataProvider(
            Consumer<DeleteDataProviderRequest.Builder> deleteDataProviderRequest) {
        return deleteDataProvider(DeleteDataProviderRequest.builder().applyMutation(deleteDataProviderRequest).build());
    }

    /**
     * <p>
     * Deletes the specified endpoint.
     * </p>
     * <note>
     * <p>
     * All tasks associated with the endpoint must be deleted before you can delete the endpoint.
     * </p>
     * </note>
     * <p/>
     *
     * @param deleteEndpointRequest
     * @return A Java Future containing the result of the DeleteEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li> <li>InvalidResourceStateException The
     *         resource is in a state that prevents it from being used for database migration.</li> <li>SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.</li> <li>SdkClientException If any client side error occurs such as an IO related
     *         failure, failure to get credentials, etc.</li> <li>DatabaseMigrationException Base class for all service
     *         exceptions. Unknown exceptions will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteEndpointResponse> deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified endpoint.
     * </p>
     * <note>
     * <p>
     * All tasks associated with the endpoint must be deleted before you can delete the endpoint.
     * </p>
     * </note>
     * <p/>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteEndpointRequest#builder()}
     * </p>
     *
     * @param deleteEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DeleteEndpointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteEndpointResponse> deleteEndpoint(Consumer<DeleteEndpointRequest.Builder> deleteEndpointRequest) {
        return deleteEndpoint(DeleteEndpointRequest.builder().applyMutation(deleteEndpointRequest).build());
    }

    /**
     * <p>
     * Deletes an DMS event subscription.
     * </p>
     *
     * @param deleteEventSubscriptionRequest
     * @return A Java Future containing the result of the DeleteEventSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteEventSubscriptionResponse> deleteEventSubscription(
            DeleteEventSubscriptionRequest deleteEventSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an DMS event subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteEventSubscriptionRequest#builder()}
     * </p>
     *
     * @param deleteEventSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DeleteEventSubscriptionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteEventSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteEventSubscriptionResponse> deleteEventSubscription(
            Consumer<DeleteEventSubscriptionRequest.Builder> deleteEventSubscriptionRequest) {
        return deleteEventSubscription(DeleteEventSubscriptionRequest.builder().applyMutation(deleteEventSubscriptionRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified Fleet Advisor collector.
     * </p>
     *
     * @param deleteFleetAdvisorCollectorRequest
     * @return A Java Future containing the result of the DeleteFleetAdvisorCollector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>CollectorNotFoundException The specified collector doesn't exist.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteFleetAdvisorCollector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteFleetAdvisorCollector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFleetAdvisorCollectorResponse> deleteFleetAdvisorCollector(
            DeleteFleetAdvisorCollectorRequest deleteFleetAdvisorCollectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Fleet Advisor collector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFleetAdvisorCollectorRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteFleetAdvisorCollectorRequest#builder()}
     * </p>
     *
     * @param deleteFleetAdvisorCollectorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DeleteFleetAdvisorCollectorRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteFleetAdvisorCollector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>CollectorNotFoundException The specified collector doesn't exist.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteFleetAdvisorCollector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteFleetAdvisorCollector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFleetAdvisorCollectorResponse> deleteFleetAdvisorCollector(
            Consumer<DeleteFleetAdvisorCollectorRequest.Builder> deleteFleetAdvisorCollectorRequest) {
        return deleteFleetAdvisorCollector(DeleteFleetAdvisorCollectorRequest.builder()
                .applyMutation(deleteFleetAdvisorCollectorRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Fleet Advisor collector databases.
     * </p>
     *
     * @param deleteFleetAdvisorDatabasesRequest
     * @return A Java Future containing the result of the DeleteFleetAdvisorDatabases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidOperationException The action or operation requested isn't valid.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteFleetAdvisorDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteFleetAdvisorDatabases"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFleetAdvisorDatabasesResponse> deleteFleetAdvisorDatabases(
            DeleteFleetAdvisorDatabasesRequest deleteFleetAdvisorDatabasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Fleet Advisor collector databases.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFleetAdvisorDatabasesRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteFleetAdvisorDatabasesRequest#builder()}
     * </p>
     *
     * @param deleteFleetAdvisorDatabasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DeleteFleetAdvisorDatabasesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteFleetAdvisorDatabases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidOperationException The action or operation requested isn't valid.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteFleetAdvisorDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteFleetAdvisorDatabases"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteFleetAdvisorDatabasesResponse> deleteFleetAdvisorDatabases(
            Consumer<DeleteFleetAdvisorDatabasesRequest.Builder> deleteFleetAdvisorDatabasesRequest) {
        return deleteFleetAdvisorDatabases(DeleteFleetAdvisorDatabasesRequest.builder()
                .applyMutation(deleteFleetAdvisorDatabasesRequest).build());
    }

    /**
     * <p>
     * Deletes the specified instance profile.
     * </p>
     * <note>
     * <p>
     * All migration projects associated with the instance profile must be deleted or modified before you can delete the
     * instance profile.
     * </p>
     * </note>
     *
     * @param deleteInstanceProfileRequest
     * @return A Java Future containing the result of the DeleteInstanceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteInstanceProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteInstanceProfileResponse> deleteInstanceProfile(
            DeleteInstanceProfileRequest deleteInstanceProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified instance profile.
     * </p>
     * <note>
     * <p>
     * All migration projects associated with the instance profile must be deleted or modified before you can delete the
     * instance profile.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInstanceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteInstanceProfileRequest#builder()}
     * </p>
     *
     * @param deleteInstanceProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DeleteInstanceProfileRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteInstanceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteInstanceProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteInstanceProfileResponse> deleteInstanceProfile(
            Consumer<DeleteInstanceProfileRequest.Builder> deleteInstanceProfileRequest) {
        return deleteInstanceProfile(DeleteInstanceProfileRequest.builder().applyMutation(deleteInstanceProfileRequest).build());
    }

    /**
     * <p>
     * Deletes the specified migration project.
     * </p>
     * <note>
     * <p>
     * The migration project must be closed before you can delete it.
     * </p>
     * </note>
     *
     * @param deleteMigrationProjectRequest
     * @return A Java Future containing the result of the DeleteMigrationProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteMigrationProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteMigrationProject" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteMigrationProjectResponse> deleteMigrationProject(
            DeleteMigrationProjectRequest deleteMigrationProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified migration project.
     * </p>
     * <note>
     * <p>
     * The migration project must be closed before you can delete it.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMigrationProjectRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteMigrationProjectRequest#builder()}
     * </p>
     *
     * @param deleteMigrationProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DeleteMigrationProjectRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteMigrationProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteMigrationProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteMigrationProject" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteMigrationProjectResponse> deleteMigrationProject(
            Consumer<DeleteMigrationProjectRequest.Builder> deleteMigrationProjectRequest) {
        return deleteMigrationProject(DeleteMigrationProjectRequest.builder().applyMutation(deleteMigrationProjectRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an DMS Serverless replication configuration. This effectively deprovisions any and all replications that
     * use this configuration. You can't delete the configuration for an DMS Serverless replication that is ongoing. You
     * can delete the configuration when the replication is in a non-RUNNING and non-STARTING state.
     * </p>
     *
     * @param deleteReplicationConfigRequest
     * @return A Java Future containing the result of the DeleteReplicationConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteReplicationConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteReplicationConfigResponse> deleteReplicationConfig(
            DeleteReplicationConfigRequest deleteReplicationConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an DMS Serverless replication configuration. This effectively deprovisions any and all replications that
     * use this configuration. You can't delete the configuration for an DMS Serverless replication that is ongoing. You
     * can delete the configuration when the replication is in a non-RUNNING and non-STARTING state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReplicationConfigRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteReplicationConfigRequest#builder()}
     * </p>
     *
     * @param deleteReplicationConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DeleteReplicationConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteReplicationConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteReplicationConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteReplicationConfigResponse> deleteReplicationConfig(
            Consumer<DeleteReplicationConfigRequest.Builder> deleteReplicationConfigRequest) {
        return deleteReplicationConfig(DeleteReplicationConfigRequest.builder().applyMutation(deleteReplicationConfigRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified replication instance.
     * </p>
     * <note>
     * <p>
     * You must delete any migration tasks that are associated with the replication instance before you can delete it.
     * </p>
     * </note>
     * <p/>
     *
     * @param deleteReplicationInstanceRequest
     * @return A Java Future containing the result of the DeleteReplicationInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li> <li>ResourceNotFoundException The resource could not be found.</li> <li>
     *         SdkException Base class for all exceptions that can be thrown by the SDK (both service and client). Can
     *         be used for catch all scenarios.</li> <li>SdkClientException If any client side error occurs such as an
     *         IO related failure, failure to get credentials, etc.</li> <li>DatabaseMigrationException Base class for
     *         all service exceptions. Unknown exceptions will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteReplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteReplicationInstanceResponse> deleteReplicationInstance(
            DeleteReplicationInstanceRequest deleteReplicationInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified replication instance.
     * </p>
     * <note>
     * <p>
     * You must delete any migration tasks that are associated with the replication instance before you can delete it.
     * </p>
     * </note>
     * <p/>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReplicationInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteReplicationInstanceRequest#builder()}
     * </p>
     *
     * @param deleteReplicationInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DeleteReplicationInstanceRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteReplicationInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteReplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteReplicationInstanceResponse> deleteReplicationInstance(
            Consumer<DeleteReplicationInstanceRequest.Builder> deleteReplicationInstanceRequest) {
        return deleteReplicationInstance(DeleteReplicationInstanceRequest.builder()
                .applyMutation(deleteReplicationInstanceRequest).build());
    }

    /**
     * <p>
     * Deletes a subnet group.
     * </p>
     *
     * @param deleteReplicationSubnetGroupRequest
     * @return A Java Future containing the result of the DeleteReplicationSubnetGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteReplicationSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteReplicationSubnetGroupResponse> deleteReplicationSubnetGroup(
            DeleteReplicationSubnetGroupRequest deleteReplicationSubnetGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a subnet group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReplicationSubnetGroupRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteReplicationSubnetGroupRequest#builder()}
     * </p>
     *
     * @param deleteReplicationSubnetGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DeleteReplicationSubnetGroupRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteReplicationSubnetGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteReplicationSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteReplicationSubnetGroupResponse> deleteReplicationSubnetGroup(
            Consumer<DeleteReplicationSubnetGroupRequest.Builder> deleteReplicationSubnetGroupRequest) {
        return deleteReplicationSubnetGroup(DeleteReplicationSubnetGroupRequest.builder()
                .applyMutation(deleteReplicationSubnetGroupRequest).build());
    }

    /**
     * <p>
     * Deletes the specified replication task.
     * </p>
     *
     * @param deleteReplicationTaskRequest
     * @return A Java Future containing the result of the DeleteReplicationTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteReplicationTaskResponse> deleteReplicationTask(
            DeleteReplicationTaskRequest deleteReplicationTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified replication task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReplicationTaskRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteReplicationTaskRequest#builder()}
     * </p>
     *
     * @param deleteReplicationTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteReplicationTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteReplicationTaskResponse> deleteReplicationTask(
            Consumer<DeleteReplicationTaskRequest.Builder> deleteReplicationTaskRequest) {
        return deleteReplicationTask(DeleteReplicationTaskRequest.builder().applyMutation(deleteReplicationTaskRequest).build());
    }

    /**
     * <p>
     * Deletes the record of a single premigration assessment run.
     * </p>
     * <p>
     * This operation removes all metadata that DMS maintains about this assessment run. However, the operation leaves
     * untouched all information about this assessment run that is stored in your Amazon S3 bucket.
     * </p>
     *
     * @param deleteReplicationTaskAssessmentRunRequest
     * @return A Java Future containing the result of the DeleteReplicationTaskAssessmentRun operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteReplicationTaskAssessmentRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationTaskAssessmentRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteReplicationTaskAssessmentRunResponse> deleteReplicationTaskAssessmentRun(
            DeleteReplicationTaskAssessmentRunRequest deleteReplicationTaskAssessmentRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the record of a single premigration assessment run.
     * </p>
     * <p>
     * This operation removes all metadata that DMS maintains about this assessment run. However, the operation leaves
     * untouched all information about this assessment run that is stored in your Amazon S3 bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReplicationTaskAssessmentRunRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteReplicationTaskAssessmentRunRequest#builder()}
     * </p>
     *
     * @param deleteReplicationTaskAssessmentRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DeleteReplicationTaskAssessmentRunRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteReplicationTaskAssessmentRun operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DeleteReplicationTaskAssessmentRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationTaskAssessmentRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteReplicationTaskAssessmentRunResponse> deleteReplicationTaskAssessmentRun(
            Consumer<DeleteReplicationTaskAssessmentRunRequest.Builder> deleteReplicationTaskAssessmentRunRequest) {
        return deleteReplicationTaskAssessmentRun(DeleteReplicationTaskAssessmentRunRequest.builder()
                .applyMutation(deleteReplicationTaskAssessmentRunRequest).build());
    }

    /**
     * <p>
     * Lists all of the DMS attributes for a customer account. These attributes include DMS quotas for the account and a
     * unique account identifier in a particular DMS region. DMS quotas include a list of resource quotas supported by
     * the account, such as the number of replication instances allowed. The description for each resource quota,
     * includes the quota name, current usage toward that quota, and the quota's maximum value. DMS uses the unique
     * account identifier to name each artifact used by DMS in the given region.
     * </p>
     * <p>
     * This command does not take any parameters.
     * </p>
     *
     * @param describeAccountAttributesRequest
     * @return A Java Future containing the result of the DescribeAccountAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeAccountAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAccountAttributesResponse> describeAccountAttributes(
            DescribeAccountAttributesRequest describeAccountAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the DMS attributes for a customer account. These attributes include DMS quotas for the account and a
     * unique account identifier in a particular DMS region. DMS quotas include a list of resource quotas supported by
     * the account, such as the number of replication instances allowed. The description for each resource quota,
     * includes the quota name, current usage toward that quota, and the quota's maximum value. DMS uses the unique
     * account identifier to name each artifact used by DMS in the given region.
     * </p>
     * <p>
     * This command does not take any parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAccountAttributesRequest#builder()}
     * </p>
     *
     * @param describeAccountAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeAccountAttributesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeAccountAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeAccountAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAccountAttributesResponse> describeAccountAttributes(
            Consumer<DescribeAccountAttributesRequest.Builder> describeAccountAttributesRequest) {
        return describeAccountAttributes(DescribeAccountAttributesRequest.builder()
                .applyMutation(describeAccountAttributesRequest).build());
    }

    /**
     * <p>
     * Lists all of the DMS attributes for a customer account. These attributes include DMS quotas for the account and a
     * unique account identifier in a particular DMS region. DMS quotas include a list of resource quotas supported by
     * the account, such as the number of replication instances allowed. The description for each resource quota,
     * includes the quota name, current usage toward that quota, and the quota's maximum value. DMS uses the unique
     * account identifier to name each artifact used by DMS in the given region.
     * </p>
     * <p>
     * This command does not take any parameters.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeAccountAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeAccountAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAccountAttributesResponse> describeAccountAttributes() {
        return describeAccountAttributes(DescribeAccountAttributesRequest.builder().build());
    }

    /**
     * <p>
     * Provides a list of individual assessments that you can specify for a new premigration assessment run, given one
     * or more parameters.
     * </p>
     * <p>
     * If you specify an existing migration task, this operation provides the default individual assessments you can
     * specify for that task. Otherwise, the specified parameters model elements of a possible migration task on which
     * to base a premigration assessment run.
     * </p>
     * <p>
     * To use these migration task modeling parameters, you must specify an existing replication instance, a source
     * database engine, a target database engine, and a migration type. This combination of parameters potentially
     * limits the default individual assessments available for an assessment run created for a corresponding migration
     * task.
     * </p>
     * <p>
     * If you specify no parameters, this operation provides a list of all possible individual assessments that you can
     * specify for an assessment run. If you specify any one of the task modeling parameters, you must specify all of
     * them or the operation cannot provide a list of individual assessments. The only parameter that you can specify
     * alone is for an existing migration task. The specified task definition then determines the default list of
     * individual assessments that you can specify in an assessment run for the task.
     * </p>
     *
     * @param describeApplicableIndividualAssessmentsRequest
     * @return A Java Future containing the result of the DescribeApplicableIndividualAssessments operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeApplicableIndividualAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeApplicableIndividualAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeApplicableIndividualAssessmentsResponse> describeApplicableIndividualAssessments(
            DescribeApplicableIndividualAssessmentsRequest describeApplicableIndividualAssessmentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of individual assessments that you can specify for a new premigration assessment run, given one
     * or more parameters.
     * </p>
     * <p>
     * If you specify an existing migration task, this operation provides the default individual assessments you can
     * specify for that task. Otherwise, the specified parameters model elements of a possible migration task on which
     * to base a premigration assessment run.
     * </p>
     * <p>
     * To use these migration task modeling parameters, you must specify an existing replication instance, a source
     * database engine, a target database engine, and a migration type. This combination of parameters potentially
     * limits the default individual assessments available for an assessment run created for a corresponding migration
     * task.
     * </p>
     * <p>
     * If you specify no parameters, this operation provides a list of all possible individual assessments that you can
     * specify for an assessment run. If you specify any one of the task modeling parameters, you must specify all of
     * them or the operation cannot provide a list of individual assessments. The only parameter that you can specify
     * alone is for an existing migration task. The specified task definition then determines the default list of
     * individual assessments that you can specify in an assessment run for the task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeApplicableIndividualAssessmentsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeApplicableIndividualAssessmentsRequest#builder()}
     * </p>
     *
     * @param describeApplicableIndividualAssessmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeApplicableIndividualAssessments operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeApplicableIndividualAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeApplicableIndividualAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeApplicableIndividualAssessmentsResponse> describeApplicableIndividualAssessments(
            Consumer<DescribeApplicableIndividualAssessmentsRequest.Builder> describeApplicableIndividualAssessmentsRequest) {
        return describeApplicableIndividualAssessments(DescribeApplicableIndividualAssessmentsRequest.builder()
                .applyMutation(describeApplicableIndividualAssessmentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeApplicableIndividualAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeApplicableIndividualAssessmentsPublisher publisher = client.describeApplicableIndividualAssessmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeApplicableIndividualAssessmentsPublisher publisher = client.describeApplicableIndividualAssessmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeApplicableIndividualAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeApplicableIndividualAssessmentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeApplicableIndividualAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeApplicableIndividualAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicableIndividualAssessmentsPublisher describeApplicableIndividualAssessmentsPaginator(
            DescribeApplicableIndividualAssessmentsRequest describeApplicableIndividualAssessmentsRequest) {
        return new DescribeApplicableIndividualAssessmentsPublisher(this, describeApplicableIndividualAssessmentsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeApplicableIndividualAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeApplicableIndividualAssessmentsPublisher publisher = client.describeApplicableIndividualAssessmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeApplicableIndividualAssessmentsPublisher publisher = client.describeApplicableIndividualAssessmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeApplicableIndividualAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeApplicableIndividualAssessmentsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeApplicableIndividualAssessmentsRequest#builder()}
     * </p>
     *
     * @param describeApplicableIndividualAssessmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeApplicableIndividualAssessmentsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeApplicableIndividualAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeApplicableIndividualAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicableIndividualAssessmentsPublisher describeApplicableIndividualAssessmentsPaginator(
            Consumer<DescribeApplicableIndividualAssessmentsRequest.Builder> describeApplicableIndividualAssessmentsRequest) {
        return describeApplicableIndividualAssessmentsPaginator(DescribeApplicableIndividualAssessmentsRequest.builder()
                .applyMutation(describeApplicableIndividualAssessmentsRequest).build());
    }

    /**
     * <p>
     * Provides a description of the certificate.
     * </p>
     *
     * @param describeCertificatesRequest
     * @return A Java Future containing the result of the DescribeCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeCertificatesResponse> describeCertificates(
            DescribeCertificatesRequest describeCertificatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a description of the certificate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCertificatesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCertificatesRequest#builder()}
     * </p>
     *
     * @param describeCertificatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeCertificatesResponse> describeCertificates(
            Consumer<DescribeCertificatesRequest.Builder> describeCertificatesRequest) {
        return describeCertificates(DescribeCertificatesRequest.builder().applyMutation(describeCertificatesRequest).build());
    }

    /**
     * <p>
     * Provides a description of the certificate.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeCertificatesResponse> describeCertificates() {
        return describeCertificates(DescribeCertificatesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeCertificates(software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeCertificatesPublisher publisher = client.describeCertificatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeCertificatesPublisher publisher = client.describeCertificatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCertificates(software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCertificatesPublisher describeCertificatesPaginator() {
        return describeCertificatesPaginator(DescribeCertificatesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeCertificates(software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeCertificatesPublisher publisher = client.describeCertificatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeCertificatesPublisher publisher = client.describeCertificatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCertificates(software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeCertificatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCertificatesPublisher describeCertificatesPaginator(DescribeCertificatesRequest describeCertificatesRequest) {
        return new DescribeCertificatesPublisher(this, describeCertificatesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeCertificates(software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeCertificatesPublisher publisher = client.describeCertificatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeCertificatesPublisher publisher = client.describeCertificatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCertificates(software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCertificatesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCertificatesRequest#builder()}
     * </p>
     *
     * @param describeCertificatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeCertificatesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCertificatesPublisher describeCertificatesPaginator(
            Consumer<DescribeCertificatesRequest.Builder> describeCertificatesRequest) {
        return describeCertificatesPaginator(DescribeCertificatesRequest.builder().applyMutation(describeCertificatesRequest)
                .build());
    }

    /**
     * <p>
     * Describes the status of the connections that have been made between the replication instance and an endpoint.
     * Connections are created when you test an endpoint.
     * </p>
     *
     * @param describeConnectionsRequest
     * @return A Java Future containing the result of the DescribeConnections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeConnectionsResponse> describeConnections(
            DescribeConnectionsRequest describeConnectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the status of the connections that have been made between the replication instance and an endpoint.
     * Connections are created when you test an endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConnectionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeConnectionsRequest#builder()}
     * </p>
     *
     * @param describeConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeConnections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeConnectionsResponse> describeConnections(
            Consumer<DescribeConnectionsRequest.Builder> describeConnectionsRequest) {
        return describeConnections(DescribeConnectionsRequest.builder().applyMutation(describeConnectionsRequest).build());
    }

    /**
     * <p>
     * Describes the status of the connections that have been made between the replication instance and an endpoint.
     * Connections are created when you test an endpoint.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeConnections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeConnectionsResponse> describeConnections() {
        return describeConnections(DescribeConnectionsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeConnections(software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeConnectionsPublisher publisher = client.describeConnectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeConnectionsPublisher publisher = client.describeConnectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConnections(software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeConnectionsPublisher describeConnectionsPaginator() {
        return describeConnectionsPaginator(DescribeConnectionsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeConnections(software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeConnectionsPublisher publisher = client.describeConnectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeConnectionsPublisher publisher = client.describeConnectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConnections(software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeConnectionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeConnectionsPublisher describeConnectionsPaginator(DescribeConnectionsRequest describeConnectionsRequest) {
        return new DescribeConnectionsPublisher(this, describeConnectionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeConnections(software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeConnectionsPublisher publisher = client.describeConnectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeConnectionsPublisher publisher = client.describeConnectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeConnections(software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConnectionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeConnectionsRequest#builder()}
     * </p>
     *
     * @param describeConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeConnectionsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConnections" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeConnectionsPublisher describeConnectionsPaginator(
            Consumer<DescribeConnectionsRequest.Builder> describeConnectionsRequest) {
        return describeConnectionsPaginator(DescribeConnectionsRequest.builder().applyMutation(describeConnectionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns configuration parameters for a schema conversion project.
     * </p>
     *
     * @param describeConversionConfigurationRequest
     * @return A Java Future containing the result of the DescribeConversionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeConversionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConversionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConversionConfigurationResponse> describeConversionConfiguration(
            DescribeConversionConfigurationRequest describeConversionConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns configuration parameters for a schema conversion project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeConversionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeConversionConfigurationRequest#builder()}
     * </p>
     *
     * @param describeConversionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeConversionConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeConversionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeConversionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConversionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeConversionConfigurationResponse> describeConversionConfiguration(
            Consumer<DescribeConversionConfigurationRequest.Builder> describeConversionConfigurationRequest) {
        return describeConversionConfiguration(DescribeConversionConfigurationRequest.builder()
                .applyMutation(describeConversionConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns information about data migrations.
     * </p>
     *
     * @param describeDataMigrationsRequest
     * @return A Java Future containing the result of the DescribeDataMigrations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeDataMigrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeDataMigrations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDataMigrationsResponse> describeDataMigrations(
            DescribeDataMigrationsRequest describeDataMigrationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about data migrations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDataMigrationsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDataMigrationsRequest#builder()}
     * </p>
     *
     * @param describeDataMigrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeDataMigrations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeDataMigrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeDataMigrations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeDataMigrationsResponse> describeDataMigrations(
            Consumer<DescribeDataMigrationsRequest.Builder> describeDataMigrationsRequest) {
        return describeDataMigrations(DescribeDataMigrationsRequest.builder().applyMutation(describeDataMigrationsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDataMigrations(software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeDataMigrationsPublisher publisher = client.describeDataMigrationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeDataMigrationsPublisher publisher = client.describeDataMigrationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDataMigrations(software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDataMigrationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeDataMigrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeDataMigrations" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDataMigrationsPublisher describeDataMigrationsPaginator(
            DescribeDataMigrationsRequest describeDataMigrationsRequest) {
        return new DescribeDataMigrationsPublisher(this, describeDataMigrationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDataMigrations(software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeDataMigrationsPublisher publisher = client.describeDataMigrationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeDataMigrationsPublisher publisher = client.describeDataMigrationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDataMigrations(software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDataMigrationsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDataMigrationsRequest#builder()}
     * </p>
     *
     * @param describeDataMigrationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeDataMigrationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeDataMigrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeDataMigrations" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDataMigrationsPublisher describeDataMigrationsPaginator(
            Consumer<DescribeDataMigrationsRequest.Builder> describeDataMigrationsRequest) {
        return describeDataMigrationsPaginator(DescribeDataMigrationsRequest.builder()
                .applyMutation(describeDataMigrationsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of data providers for your account in the current region.
     * </p>
     *
     * @param describeDataProvidersRequest
     * @return A Java Future containing the result of the DescribeDataProviders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeDataProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeDataProviders" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDataProvidersResponse> describeDataProviders(
            DescribeDataProvidersRequest describeDataProvidersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of data providers for your account in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDataProvidersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDataProvidersRequest#builder()}
     * </p>
     *
     * @param describeDataProvidersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeDataProvidersRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeDataProviders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeDataProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeDataProviders" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDataProvidersResponse> describeDataProviders(
            Consumer<DescribeDataProvidersRequest.Builder> describeDataProvidersRequest) {
        return describeDataProviders(DescribeDataProvidersRequest.builder().applyMutation(describeDataProvidersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDataProviders(software.amazon.awssdk.services.databasemigration.model.DescribeDataProvidersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeDataProvidersPublisher publisher = client.describeDataProvidersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeDataProvidersPublisher publisher = client.describeDataProvidersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeDataProvidersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeDataProvidersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDataProviders(software.amazon.awssdk.services.databasemigration.model.DescribeDataProvidersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDataProvidersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeDataProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeDataProviders" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDataProvidersPublisher describeDataProvidersPaginator(
            DescribeDataProvidersRequest describeDataProvidersRequest) {
        return new DescribeDataProvidersPublisher(this, describeDataProvidersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeDataProviders(software.amazon.awssdk.services.databasemigration.model.DescribeDataProvidersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeDataProvidersPublisher publisher = client.describeDataProvidersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeDataProvidersPublisher publisher = client.describeDataProvidersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeDataProvidersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeDataProvidersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDataProviders(software.amazon.awssdk.services.databasemigration.model.DescribeDataProvidersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDataProvidersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDataProvidersRequest#builder()}
     * </p>
     *
     * @param describeDataProvidersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeDataProvidersRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeDataProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeDataProviders" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDataProvidersPublisher describeDataProvidersPaginator(
            Consumer<DescribeDataProvidersRequest.Builder> describeDataProvidersRequest) {
        return describeDataProvidersPaginator(DescribeDataProvidersRequest.builder().applyMutation(describeDataProvidersRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about the possible endpoint settings available when you create an endpoint for a specific
     * database engine.
     * </p>
     *
     * @param describeEndpointSettingsRequest
     * @return A Java Future containing the result of the DescribeEndpointSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEndpointSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeEndpointSettingsResponse> describeEndpointSettings(
            DescribeEndpointSettingsRequest describeEndpointSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the possible endpoint settings available when you create an endpoint for a specific
     * database engine.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointSettingsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEndpointSettingsRequest#builder()}
     * </p>
     *
     * @param describeEndpointSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeEndpointSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEndpointSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeEndpointSettingsResponse> describeEndpointSettings(
            Consumer<DescribeEndpointSettingsRequest.Builder> describeEndpointSettingsRequest) {
        return describeEndpointSettings(DescribeEndpointSettingsRequest.builder().applyMutation(describeEndpointSettingsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEndpointSettings(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointSettingsPublisher publisher = client.describeEndpointSettingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointSettingsPublisher publisher = client.describeEndpointSettingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEndpointSettings(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEndpointSettingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEndpointSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEndpointSettingsPublisher describeEndpointSettingsPaginator(
            DescribeEndpointSettingsRequest describeEndpointSettingsRequest) {
        return new DescribeEndpointSettingsPublisher(this, describeEndpointSettingsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEndpointSettings(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointSettingsPublisher publisher = client.describeEndpointSettingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointSettingsPublisher publisher = client.describeEndpointSettingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEndpointSettings(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointSettingsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEndpointSettingsRequest#builder()}
     * </p>
     *
     * @param describeEndpointSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeEndpointSettingsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEndpointSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointSettings" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEndpointSettingsPublisher describeEndpointSettingsPaginator(
            Consumer<DescribeEndpointSettingsRequest.Builder> describeEndpointSettingsRequest) {
        return describeEndpointSettingsPaginator(DescribeEndpointSettingsRequest.builder()
                .applyMutation(describeEndpointSettingsRequest).build());
    }

    /**
     * <p>
     * Returns information about the type of endpoints available.
     * </p>
     *
     * @param describeEndpointTypesRequest
     * @return A Java Future containing the result of the DescribeEndpointTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEndpointTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeEndpointTypesResponse> describeEndpointTypes(
            DescribeEndpointTypesRequest describeEndpointTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the type of endpoints available.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointTypesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEndpointTypesRequest#builder()}
     * </p>
     *
     * @param describeEndpointTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeEndpointTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEndpointTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeEndpointTypesResponse> describeEndpointTypes(
            Consumer<DescribeEndpointTypesRequest.Builder> describeEndpointTypesRequest) {
        return describeEndpointTypes(DescribeEndpointTypesRequest.builder().applyMutation(describeEndpointTypesRequest).build());
    }

    /**
     * <p>
     * Returns information about the type of endpoints available.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeEndpointTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEndpointTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeEndpointTypesResponse> describeEndpointTypes() {
        return describeEndpointTypes(DescribeEndpointTypesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEndpointTypes(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointTypesPublisher publisher = client.describeEndpointTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointTypesPublisher publisher = client.describeEndpointTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEndpointTypes(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEndpointTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEndpointTypesPublisher describeEndpointTypesPaginator() {
        return describeEndpointTypesPaginator(DescribeEndpointTypesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEndpointTypes(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointTypesPublisher publisher = client.describeEndpointTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointTypesPublisher publisher = client.describeEndpointTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEndpointTypes(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEndpointTypesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEndpointTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEndpointTypesPublisher describeEndpointTypesPaginator(
            DescribeEndpointTypesRequest describeEndpointTypesRequest) {
        return new DescribeEndpointTypesPublisher(this, describeEndpointTypesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEndpointTypes(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointTypesPublisher publisher = client.describeEndpointTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointTypesPublisher publisher = client.describeEndpointTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEndpointTypes(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointTypesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEndpointTypesRequest#builder()}
     * </p>
     *
     * @param describeEndpointTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeEndpointTypesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEndpointTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEndpointTypesPublisher describeEndpointTypesPaginator(
            Consumer<DescribeEndpointTypesRequest.Builder> describeEndpointTypesRequest) {
        return describeEndpointTypesPaginator(DescribeEndpointTypesRequest.builder().applyMutation(describeEndpointTypesRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about the endpoints for your account in the current region.
     * </p>
     *
     * @param describeEndpointsRequest
     * @return A Java Future containing the result of the DescribeEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeEndpointsResponse> describeEndpoints(DescribeEndpointsRequest describeEndpointsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the endpoints for your account in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeEndpointsRequest#builder()}
     * </p>
     *
     * @param describeEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeEndpointsResponse> describeEndpoints(
            Consumer<DescribeEndpointsRequest.Builder> describeEndpointsRequest) {
        return describeEndpoints(DescribeEndpointsRequest.builder().applyMutation(describeEndpointsRequest).build());
    }

    /**
     * <p>
     * Returns information about the endpoints for your account in the current region.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeEndpointsResponse> describeEndpoints() {
        return describeEndpoints(DescribeEndpointsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEndpoints(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointsPublisher publisher = client.describeEndpointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointsPublisher publisher = client.describeEndpointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEndpoints(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEndpointsPublisher describeEndpointsPaginator() {
        return describeEndpointsPaginator(DescribeEndpointsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEndpoints(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointsPublisher publisher = client.describeEndpointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointsPublisher publisher = client.describeEndpointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEndpoints(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEndpointsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEndpointsPublisher describeEndpointsPaginator(DescribeEndpointsRequest describeEndpointsRequest) {
        return new DescribeEndpointsPublisher(this, describeEndpointsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEndpoints(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointsPublisher publisher = client.describeEndpointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEndpointsPublisher publisher = client.describeEndpointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEndpoints(software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeEndpointsRequest#builder()}
     * </p>
     *
     * @param describeEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeEndpointsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpoints" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEndpointsPublisher describeEndpointsPaginator(
            Consumer<DescribeEndpointsRequest.Builder> describeEndpointsRequest) {
        return describeEndpointsPaginator(DescribeEndpointsRequest.builder().applyMutation(describeEndpointsRequest).build());
    }

    /**
     * <p>
     * Returns information about the replication instance versions used in the project.
     * </p>
     *
     * @param describeEngineVersionsRequest
     * @return A Java Future containing the result of the DescribeEngineVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEngineVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeEngineVersionsResponse> describeEngineVersions(
            DescribeEngineVersionsRequest describeEngineVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the replication instance versions used in the project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEngineVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEngineVersionsRequest#builder()}
     * </p>
     *
     * @param describeEngineVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeEngineVersionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeEngineVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEngineVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeEngineVersionsResponse> describeEngineVersions(
            Consumer<DescribeEngineVersionsRequest.Builder> describeEngineVersionsRequest) {
        return describeEngineVersions(DescribeEngineVersionsRequest.builder().applyMutation(describeEngineVersionsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEngineVersions(software.amazon.awssdk.services.databasemigration.model.DescribeEngineVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEngineVersionsPublisher publisher = client.describeEngineVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEngineVersionsPublisher publisher = client.describeEngineVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeEngineVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeEngineVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEngineVersions(software.amazon.awssdk.services.databasemigration.model.DescribeEngineVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEngineVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEngineVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEngineVersionsPublisher describeEngineVersionsPaginator(
            DescribeEngineVersionsRequest describeEngineVersionsRequest) {
        return new DescribeEngineVersionsPublisher(this, describeEngineVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEngineVersions(software.amazon.awssdk.services.databasemigration.model.DescribeEngineVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEngineVersionsPublisher publisher = client.describeEngineVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEngineVersionsPublisher publisher = client.describeEngineVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeEngineVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeEngineVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEngineVersions(software.amazon.awssdk.services.databasemigration.model.DescribeEngineVersionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEngineVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEngineVersionsRequest#builder()}
     * </p>
     *
     * @param describeEngineVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeEngineVersionsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEngineVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEngineVersionsPublisher describeEngineVersionsPaginator(
            Consumer<DescribeEngineVersionsRequest.Builder> describeEngineVersionsRequest) {
        return describeEngineVersionsPaginator(DescribeEngineVersionsRequest.builder()
                .applyMutation(describeEngineVersionsRequest).build());
    }

    /**
     * <p>
     * Lists categories for all event source types, or, if specified, for a specified source type. You can see a list of
     * the event categories and source types in <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     *
     * @param describeEventCategoriesRequest
     * @return A Java Future containing the result of the DescribeEventCategories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEventCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventCategories" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeEventCategoriesResponse> describeEventCategories(
            DescribeEventCategoriesRequest describeEventCategoriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists categories for all event source types, or, if specified, for a specified source type. You can see a list of
     * the event categories and source types in <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventCategoriesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEventCategoriesRequest#builder()}
     * </p>
     *
     * @param describeEventCategoriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeEventCategoriesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeEventCategories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEventCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventCategories" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeEventCategoriesResponse> describeEventCategories(
            Consumer<DescribeEventCategoriesRequest.Builder> describeEventCategoriesRequest) {
        return describeEventCategories(DescribeEventCategoriesRequest.builder().applyMutation(describeEventCategoriesRequest)
                .build());
    }

    /**
     * <p>
     * Lists categories for all event source types, or, if specified, for a specified source type. You can see a list of
     * the event categories and source types in <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     *
     * @return A Java Future containing the result of the DescribeEventCategories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEventCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventCategories" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeEventCategoriesResponse> describeEventCategories() {
        return describeEventCategories(DescribeEventCategoriesRequest.builder().build());
    }

    /**
     * <p>
     * Lists all the event subscriptions for a customer account. The description of a subscription includes
     * <code>SubscriptionName</code>, <code>SNSTopicARN</code>, <code>CustomerID</code>, <code>SourceType</code>,
     * <code>SourceID</code>, <code>CreationTime</code>, and <code>Status</code>.
     * </p>
     * <p>
     * If you specify <code>SubscriptionName</code>, this action lists the description for that subscription.
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     * @return A Java Future containing the result of the DescribeEventSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEventSubscriptionsResponse> describeEventSubscriptions(
            DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the event subscriptions for a customer account. The description of a subscription includes
     * <code>SubscriptionName</code>, <code>SNSTopicARN</code>, <code>CustomerID</code>, <code>SourceType</code>,
     * <code>SourceID</code>, <code>CreationTime</code>, and <code>Status</code>.
     * </p>
     * <p>
     * If you specify <code>SubscriptionName</code>, this action lists the description for that subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventSubscriptionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEventSubscriptionsRequest#builder()}
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeEventSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEventSubscriptionsResponse> describeEventSubscriptions(
            Consumer<DescribeEventSubscriptionsRequest.Builder> describeEventSubscriptionsRequest) {
        return describeEventSubscriptions(DescribeEventSubscriptionsRequest.builder()
                .applyMutation(describeEventSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Lists all the event subscriptions for a customer account. The description of a subscription includes
     * <code>SubscriptionName</code>, <code>SNSTopicARN</code>, <code>CustomerID</code>, <code>SourceType</code>,
     * <code>SourceID</code>, <code>CreationTime</code>, and <code>Status</code>.
     * </p>
     * <p>
     * If you specify <code>SubscriptionName</code>, this action lists the description for that subscription.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeEventSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEventSubscriptionsResponse> describeEventSubscriptions() {
        return describeEventSubscriptions(DescribeEventSubscriptionsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventSubscriptionsPublisher publisher = client.describeEventSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventSubscriptionsPublisher publisher = client.describeEventSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsPublisher describeEventSubscriptionsPaginator() {
        return describeEventSubscriptionsPaginator(DescribeEventSubscriptionsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventSubscriptionsPublisher publisher = client.describeEventSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventSubscriptionsPublisher publisher = client.describeEventSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsPublisher describeEventSubscriptionsPaginator(
            DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) {
        return new DescribeEventSubscriptionsPublisher(this, describeEventSubscriptionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventSubscriptionsPublisher publisher = client.describeEventSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventSubscriptionsPublisher publisher = client.describeEventSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventSubscriptionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEventSubscriptionsRequest#builder()}
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeEventSubscriptionsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsPublisher describeEventSubscriptionsPaginator(
            Consumer<DescribeEventSubscriptionsRequest.Builder> describeEventSubscriptionsRequest) {
        return describeEventSubscriptionsPaginator(DescribeEventSubscriptionsRequest.builder()
                .applyMutation(describeEventSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Lists events for a given source identifier and source type. You can also specify a start and end time. For more
     * information on DMS events, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     *
     * @param describeEventsRequest
     * @return A Java Future containing the result of the DescribeEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeEventsResponse> describeEvents(DescribeEventsRequest describeEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists events for a given source identifier and source type. You can also specify a start and end time. For more
     * information on DMS events, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEventsRequest#builder()}
     * </p>
     *
     * @param describeEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeEventsResponse> describeEvents(Consumer<DescribeEventsRequest.Builder> describeEventsRequest) {
        return describeEvents(DescribeEventsRequest.builder().applyMutation(describeEventsRequest).build());
    }

    /**
     * <p>
     * Lists events for a given source identifier and source type. You can also specify a start and end time. For more
     * information on DMS events, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html">Working with Events and
     * Notifications</a> in the <i>Database Migration Service User Guide.</i>
     * </p>
     *
     * @return A Java Future containing the result of the DescribeEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeEventsResponse> describeEvents() {
        return describeEvents(DescribeEventsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEvents(software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsPublisher describeEventsPaginator() {
        return describeEventsPaginator(DescribeEventsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEvents(software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEventsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsPublisher describeEventsPaginator(DescribeEventsRequest describeEventsRequest) {
        return new DescribeEventsPublisher(this, describeEventsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeEvents(software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeEventsPublisher publisher = client.describeEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEventsRequest#builder()}
     * </p>
     *
     * @param describeEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeEventsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsPublisher describeEventsPaginator(Consumer<DescribeEventsRequest.Builder> describeEventsRequest) {
        return describeEventsPaginator(DescribeEventsRequest.builder().applyMutation(describeEventsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of extension pack associations for the specified migration project. An extension pack is
     * an add-on module that emulates functions present in a source database that are required when converting objects
     * to the target database.
     * </p>
     *
     * @param describeExtensionPackAssociationsRequest
     * @return A Java Future containing the result of the DescribeExtensionPackAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeExtensionPackAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeExtensionPackAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeExtensionPackAssociationsResponse> describeExtensionPackAssociations(
            DescribeExtensionPackAssociationsRequest describeExtensionPackAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of extension pack associations for the specified migration project. An extension pack is
     * an add-on module that emulates functions present in a source database that are required when converting objects
     * to the target database.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeExtensionPackAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeExtensionPackAssociationsRequest#builder()}
     * </p>
     *
     * @param describeExtensionPackAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeExtensionPackAssociationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeExtensionPackAssociations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeExtensionPackAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeExtensionPackAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeExtensionPackAssociationsResponse> describeExtensionPackAssociations(
            Consumer<DescribeExtensionPackAssociationsRequest.Builder> describeExtensionPackAssociationsRequest) {
        return describeExtensionPackAssociations(DescribeExtensionPackAssociationsRequest.builder()
                .applyMutation(describeExtensionPackAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeExtensionPackAssociations(software.amazon.awssdk.services.databasemigration.model.DescribeExtensionPackAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeExtensionPackAssociationsPublisher publisher = client.describeExtensionPackAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeExtensionPackAssociationsPublisher publisher = client.describeExtensionPackAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeExtensionPackAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeExtensionPackAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeExtensionPackAssociations(software.amazon.awssdk.services.databasemigration.model.DescribeExtensionPackAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeExtensionPackAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeExtensionPackAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeExtensionPackAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeExtensionPackAssociationsPublisher describeExtensionPackAssociationsPaginator(
            DescribeExtensionPackAssociationsRequest describeExtensionPackAssociationsRequest) {
        return new DescribeExtensionPackAssociationsPublisher(this, describeExtensionPackAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeExtensionPackAssociations(software.amazon.awssdk.services.databasemigration.model.DescribeExtensionPackAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeExtensionPackAssociationsPublisher publisher = client.describeExtensionPackAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeExtensionPackAssociationsPublisher publisher = client.describeExtensionPackAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeExtensionPackAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeExtensionPackAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeExtensionPackAssociations(software.amazon.awssdk.services.databasemigration.model.DescribeExtensionPackAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeExtensionPackAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeExtensionPackAssociationsRequest#builder()}
     * </p>
     *
     * @param describeExtensionPackAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeExtensionPackAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeExtensionPackAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeExtensionPackAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeExtensionPackAssociationsPublisher describeExtensionPackAssociationsPaginator(
            Consumer<DescribeExtensionPackAssociationsRequest.Builder> describeExtensionPackAssociationsRequest) {
        return describeExtensionPackAssociationsPaginator(DescribeExtensionPackAssociationsRequest.builder()
                .applyMutation(describeExtensionPackAssociationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the Fleet Advisor collectors in your account.
     * </p>
     *
     * @param describeFleetAdvisorCollectorsRequest
     * @return A Java Future containing the result of the DescribeFleetAdvisorCollectors operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeFleetAdvisorCollectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorCollectors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFleetAdvisorCollectorsResponse> describeFleetAdvisorCollectors(
            DescribeFleetAdvisorCollectorsRequest describeFleetAdvisorCollectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the Fleet Advisor collectors in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetAdvisorCollectorsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeFleetAdvisorCollectorsRequest#builder()}
     * </p>
     *
     * @param describeFleetAdvisorCollectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorCollectorsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeFleetAdvisorCollectors operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeFleetAdvisorCollectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorCollectors"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFleetAdvisorCollectorsResponse> describeFleetAdvisorCollectors(
            Consumer<DescribeFleetAdvisorCollectorsRequest.Builder> describeFleetAdvisorCollectorsRequest) {
        return describeFleetAdvisorCollectors(DescribeFleetAdvisorCollectorsRequest.builder()
                .applyMutation(describeFleetAdvisorCollectorsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeFleetAdvisorCollectors(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorCollectorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorCollectorsPublisher publisher = client.describeFleetAdvisorCollectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorCollectorsPublisher publisher = client.describeFleetAdvisorCollectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorCollectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorCollectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetAdvisorCollectors(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorCollectorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeFleetAdvisorCollectorsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeFleetAdvisorCollectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorCollectors"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAdvisorCollectorsPublisher describeFleetAdvisorCollectorsPaginator(
            DescribeFleetAdvisorCollectorsRequest describeFleetAdvisorCollectorsRequest) {
        return new DescribeFleetAdvisorCollectorsPublisher(this, describeFleetAdvisorCollectorsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeFleetAdvisorCollectors(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorCollectorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorCollectorsPublisher publisher = client.describeFleetAdvisorCollectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorCollectorsPublisher publisher = client.describeFleetAdvisorCollectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorCollectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorCollectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetAdvisorCollectors(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorCollectorsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetAdvisorCollectorsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeFleetAdvisorCollectorsRequest#builder()}
     * </p>
     *
     * @param describeFleetAdvisorCollectorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorCollectorsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeFleetAdvisorCollectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorCollectors"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAdvisorCollectorsPublisher describeFleetAdvisorCollectorsPaginator(
            Consumer<DescribeFleetAdvisorCollectorsRequest.Builder> describeFleetAdvisorCollectorsRequest) {
        return describeFleetAdvisorCollectorsPaginator(DescribeFleetAdvisorCollectorsRequest.builder()
                .applyMutation(describeFleetAdvisorCollectorsRequest).build());
    }

    /**
     * <p>
     * Returns a list of Fleet Advisor databases in your account.
     * </p>
     *
     * @param describeFleetAdvisorDatabasesRequest
     * @return A Java Future containing the result of the DescribeFleetAdvisorDatabases operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeFleetAdvisorDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorDatabases"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFleetAdvisorDatabasesResponse> describeFleetAdvisorDatabases(
            DescribeFleetAdvisorDatabasesRequest describeFleetAdvisorDatabasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Fleet Advisor databases in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetAdvisorDatabasesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeFleetAdvisorDatabasesRequest#builder()}
     * </p>
     *
     * @param describeFleetAdvisorDatabasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorDatabasesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeFleetAdvisorDatabases operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeFleetAdvisorDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorDatabases"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFleetAdvisorDatabasesResponse> describeFleetAdvisorDatabases(
            Consumer<DescribeFleetAdvisorDatabasesRequest.Builder> describeFleetAdvisorDatabasesRequest) {
        return describeFleetAdvisorDatabases(DescribeFleetAdvisorDatabasesRequest.builder()
                .applyMutation(describeFleetAdvisorDatabasesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeFleetAdvisorDatabases(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorDatabasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorDatabasesPublisher publisher = client.describeFleetAdvisorDatabasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorDatabasesPublisher publisher = client.describeFleetAdvisorDatabasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorDatabasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorDatabasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetAdvisorDatabases(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorDatabasesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeFleetAdvisorDatabasesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeFleetAdvisorDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorDatabases"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAdvisorDatabasesPublisher describeFleetAdvisorDatabasesPaginator(
            DescribeFleetAdvisorDatabasesRequest describeFleetAdvisorDatabasesRequest) {
        return new DescribeFleetAdvisorDatabasesPublisher(this, describeFleetAdvisorDatabasesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeFleetAdvisorDatabases(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorDatabasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorDatabasesPublisher publisher = client.describeFleetAdvisorDatabasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorDatabasesPublisher publisher = client.describeFleetAdvisorDatabasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorDatabasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorDatabasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetAdvisorDatabases(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorDatabasesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetAdvisorDatabasesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeFleetAdvisorDatabasesRequest#builder()}
     * </p>
     *
     * @param describeFleetAdvisorDatabasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorDatabasesRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeFleetAdvisorDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorDatabases"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAdvisorDatabasesPublisher describeFleetAdvisorDatabasesPaginator(
            Consumer<DescribeFleetAdvisorDatabasesRequest.Builder> describeFleetAdvisorDatabasesRequest) {
        return describeFleetAdvisorDatabasesPaginator(DescribeFleetAdvisorDatabasesRequest.builder()
                .applyMutation(describeFleetAdvisorDatabasesRequest).build());
    }

    /**
     * <p>
     * Provides descriptions of large-scale assessment (LSA) analyses produced by your Fleet Advisor collectors.
     * </p>
     *
     * @param describeFleetAdvisorLsaAnalysisRequest
     * @return A Java Future containing the result of the DescribeFleetAdvisorLsaAnalysis operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeFleetAdvisorLsaAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorLsaAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFleetAdvisorLsaAnalysisResponse> describeFleetAdvisorLsaAnalysis(
            DescribeFleetAdvisorLsaAnalysisRequest describeFleetAdvisorLsaAnalysisRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides descriptions of large-scale assessment (LSA) analyses produced by your Fleet Advisor collectors.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetAdvisorLsaAnalysisRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeFleetAdvisorLsaAnalysisRequest#builder()}
     * </p>
     *
     * @param describeFleetAdvisorLsaAnalysisRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeFleetAdvisorLsaAnalysis operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeFleetAdvisorLsaAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorLsaAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFleetAdvisorLsaAnalysisResponse> describeFleetAdvisorLsaAnalysis(
            Consumer<DescribeFleetAdvisorLsaAnalysisRequest.Builder> describeFleetAdvisorLsaAnalysisRequest) {
        return describeFleetAdvisorLsaAnalysis(DescribeFleetAdvisorLsaAnalysisRequest.builder()
                .applyMutation(describeFleetAdvisorLsaAnalysisRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeFleetAdvisorLsaAnalysis(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorLsaAnalysisPublisher publisher = client.describeFleetAdvisorLsaAnalysisPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorLsaAnalysisPublisher publisher = client.describeFleetAdvisorLsaAnalysisPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetAdvisorLsaAnalysis(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeFleetAdvisorLsaAnalysisRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeFleetAdvisorLsaAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorLsaAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAdvisorLsaAnalysisPublisher describeFleetAdvisorLsaAnalysisPaginator(
            DescribeFleetAdvisorLsaAnalysisRequest describeFleetAdvisorLsaAnalysisRequest) {
        return new DescribeFleetAdvisorLsaAnalysisPublisher(this, describeFleetAdvisorLsaAnalysisRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeFleetAdvisorLsaAnalysis(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorLsaAnalysisPublisher publisher = client.describeFleetAdvisorLsaAnalysisPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorLsaAnalysisPublisher publisher = client.describeFleetAdvisorLsaAnalysisPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetAdvisorLsaAnalysis(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetAdvisorLsaAnalysisRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeFleetAdvisorLsaAnalysisRequest#builder()}
     * </p>
     *
     * @param describeFleetAdvisorLsaAnalysisRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorLsaAnalysisRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeFleetAdvisorLsaAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorLsaAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAdvisorLsaAnalysisPublisher describeFleetAdvisorLsaAnalysisPaginator(
            Consumer<DescribeFleetAdvisorLsaAnalysisRequest.Builder> describeFleetAdvisorLsaAnalysisRequest) {
        return describeFleetAdvisorLsaAnalysisPaginator(DescribeFleetAdvisorLsaAnalysisRequest.builder()
                .applyMutation(describeFleetAdvisorLsaAnalysisRequest).build());
    }

    /**
     * <p>
     * Provides descriptions of the schemas discovered by your Fleet Advisor collectors.
     * </p>
     *
     * @param describeFleetAdvisorSchemaObjectSummaryRequest
     * @return A Java Future containing the result of the DescribeFleetAdvisorSchemaObjectSummary operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeFleetAdvisorSchemaObjectSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorSchemaObjectSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFleetAdvisorSchemaObjectSummaryResponse> describeFleetAdvisorSchemaObjectSummary(
            DescribeFleetAdvisorSchemaObjectSummaryRequest describeFleetAdvisorSchemaObjectSummaryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides descriptions of the schemas discovered by your Fleet Advisor collectors.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeFleetAdvisorSchemaObjectSummaryRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeFleetAdvisorSchemaObjectSummaryRequest#builder()}
     * </p>
     *
     * @param describeFleetAdvisorSchemaObjectSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeFleetAdvisorSchemaObjectSummary operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeFleetAdvisorSchemaObjectSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorSchemaObjectSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFleetAdvisorSchemaObjectSummaryResponse> describeFleetAdvisorSchemaObjectSummary(
            Consumer<DescribeFleetAdvisorSchemaObjectSummaryRequest.Builder> describeFleetAdvisorSchemaObjectSummaryRequest) {
        return describeFleetAdvisorSchemaObjectSummary(DescribeFleetAdvisorSchemaObjectSummaryRequest.builder()
                .applyMutation(describeFleetAdvisorSchemaObjectSummaryRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeFleetAdvisorSchemaObjectSummary(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorSchemaObjectSummaryPublisher publisher = client.describeFleetAdvisorSchemaObjectSummaryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorSchemaObjectSummaryPublisher publisher = client.describeFleetAdvisorSchemaObjectSummaryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetAdvisorSchemaObjectSummary(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeFleetAdvisorSchemaObjectSummaryRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeFleetAdvisorSchemaObjectSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorSchemaObjectSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAdvisorSchemaObjectSummaryPublisher describeFleetAdvisorSchemaObjectSummaryPaginator(
            DescribeFleetAdvisorSchemaObjectSummaryRequest describeFleetAdvisorSchemaObjectSummaryRequest) {
        return new DescribeFleetAdvisorSchemaObjectSummaryPublisher(this, describeFleetAdvisorSchemaObjectSummaryRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeFleetAdvisorSchemaObjectSummary(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorSchemaObjectSummaryPublisher publisher = client.describeFleetAdvisorSchemaObjectSummaryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorSchemaObjectSummaryPublisher publisher = client.describeFleetAdvisorSchemaObjectSummaryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetAdvisorSchemaObjectSummary(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeFleetAdvisorSchemaObjectSummaryRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeFleetAdvisorSchemaObjectSummaryRequest#builder()}
     * </p>
     *
     * @param describeFleetAdvisorSchemaObjectSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemaObjectSummaryRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeFleetAdvisorSchemaObjectSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorSchemaObjectSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAdvisorSchemaObjectSummaryPublisher describeFleetAdvisorSchemaObjectSummaryPaginator(
            Consumer<DescribeFleetAdvisorSchemaObjectSummaryRequest.Builder> describeFleetAdvisorSchemaObjectSummaryRequest) {
        return describeFleetAdvisorSchemaObjectSummaryPaginator(DescribeFleetAdvisorSchemaObjectSummaryRequest.builder()
                .applyMutation(describeFleetAdvisorSchemaObjectSummaryRequest).build());
    }

    /**
     * <p>
     * Returns a list of schemas detected by Fleet Advisor Collectors in your account.
     * </p>
     *
     * @param describeFleetAdvisorSchemasRequest
     * @return A Java Future containing the result of the DescribeFleetAdvisorSchemas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeFleetAdvisorSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorSchemas"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFleetAdvisorSchemasResponse> describeFleetAdvisorSchemas(
            DescribeFleetAdvisorSchemasRequest describeFleetAdvisorSchemasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of schemas detected by Fleet Advisor Collectors in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetAdvisorSchemasRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeFleetAdvisorSchemasRequest#builder()}
     * </p>
     *
     * @param describeFleetAdvisorSchemasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeFleetAdvisorSchemas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeFleetAdvisorSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorSchemas"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFleetAdvisorSchemasResponse> describeFleetAdvisorSchemas(
            Consumer<DescribeFleetAdvisorSchemasRequest.Builder> describeFleetAdvisorSchemasRequest) {
        return describeFleetAdvisorSchemas(DescribeFleetAdvisorSchemasRequest.builder()
                .applyMutation(describeFleetAdvisorSchemasRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeFleetAdvisorSchemas(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorSchemasPublisher publisher = client.describeFleetAdvisorSchemasPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorSchemasPublisher publisher = client.describeFleetAdvisorSchemasPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetAdvisorSchemas(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeFleetAdvisorSchemasRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeFleetAdvisorSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorSchemas"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAdvisorSchemasPublisher describeFleetAdvisorSchemasPaginator(
            DescribeFleetAdvisorSchemasRequest describeFleetAdvisorSchemasRequest) {
        return new DescribeFleetAdvisorSchemasPublisher(this, describeFleetAdvisorSchemasRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeFleetAdvisorSchemas(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorSchemasPublisher publisher = client.describeFleetAdvisorSchemasPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeFleetAdvisorSchemasPublisher publisher = client.describeFleetAdvisorSchemasPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetAdvisorSchemas(software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetAdvisorSchemasRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeFleetAdvisorSchemasRequest#builder()}
     * </p>
     *
     * @param describeFleetAdvisorSchemasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeFleetAdvisorSchemasRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeFleetAdvisorSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeFleetAdvisorSchemas"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAdvisorSchemasPublisher describeFleetAdvisorSchemasPaginator(
            Consumer<DescribeFleetAdvisorSchemasRequest.Builder> describeFleetAdvisorSchemasRequest) {
        return describeFleetAdvisorSchemasPaginator(DescribeFleetAdvisorSchemasRequest.builder()
                .applyMutation(describeFleetAdvisorSchemasRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of instance profiles for your account in the current region.
     * </p>
     *
     * @param describeInstanceProfilesRequest
     * @return A Java Future containing the result of the DescribeInstanceProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeInstanceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeInstanceProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeInstanceProfilesResponse> describeInstanceProfiles(
            DescribeInstanceProfilesRequest describeInstanceProfilesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of instance profiles for your account in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstanceProfilesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInstanceProfilesRequest#builder()}
     * </p>
     *
     * @param describeInstanceProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeInstanceProfilesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeInstanceProfiles operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeInstanceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeInstanceProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeInstanceProfilesResponse> describeInstanceProfiles(
            Consumer<DescribeInstanceProfilesRequest.Builder> describeInstanceProfilesRequest) {
        return describeInstanceProfiles(DescribeInstanceProfilesRequest.builder().applyMutation(describeInstanceProfilesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeInstanceProfiles(software.amazon.awssdk.services.databasemigration.model.DescribeInstanceProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeInstanceProfilesPublisher publisher = client.describeInstanceProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeInstanceProfilesPublisher publisher = client.describeInstanceProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeInstanceProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeInstanceProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstanceProfiles(software.amazon.awssdk.services.databasemigration.model.DescribeInstanceProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInstanceProfilesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeInstanceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeInstanceProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeInstanceProfilesPublisher describeInstanceProfilesPaginator(
            DescribeInstanceProfilesRequest describeInstanceProfilesRequest) {
        return new DescribeInstanceProfilesPublisher(this, describeInstanceProfilesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeInstanceProfiles(software.amazon.awssdk.services.databasemigration.model.DescribeInstanceProfilesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeInstanceProfilesPublisher publisher = client.describeInstanceProfilesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeInstanceProfilesPublisher publisher = client.describeInstanceProfilesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeInstanceProfilesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeInstanceProfilesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstanceProfiles(software.amazon.awssdk.services.databasemigration.model.DescribeInstanceProfilesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstanceProfilesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInstanceProfilesRequest#builder()}
     * </p>
     *
     * @param describeInstanceProfilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeInstanceProfilesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeInstanceProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeInstanceProfiles" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeInstanceProfilesPublisher describeInstanceProfilesPaginator(
            Consumer<DescribeInstanceProfilesRequest.Builder> describeInstanceProfilesRequest) {
        return describeInstanceProfilesPaginator(DescribeInstanceProfilesRequest.builder()
                .applyMutation(describeInstanceProfilesRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of metadata model assessments for your account in the current region.
     * </p>
     *
     * @param describeMetadataModelAssessmentsRequest
     * @return A Java Future containing the result of the DescribeMetadataModelAssessments operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeMetadataModelAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMetadataModelAssessmentsResponse> describeMetadataModelAssessments(
            DescribeMetadataModelAssessmentsRequest describeMetadataModelAssessmentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of metadata model assessments for your account in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMetadataModelAssessmentsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMetadataModelAssessmentsRequest#builder()}
     * </p>
     *
     * @param describeMetadataModelAssessmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelAssessmentsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeMetadataModelAssessments operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeMetadataModelAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMetadataModelAssessmentsResponse> describeMetadataModelAssessments(
            Consumer<DescribeMetadataModelAssessmentsRequest.Builder> describeMetadataModelAssessmentsRequest) {
        return describeMetadataModelAssessments(DescribeMetadataModelAssessmentsRequest.builder()
                .applyMutation(describeMetadataModelAssessmentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeMetadataModelAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelAssessmentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelAssessmentsPublisher publisher = client.describeMetadataModelAssessmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelAssessmentsPublisher publisher = client.describeMetadataModelAssessmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelAssessmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelAssessmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMetadataModelAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelAssessmentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMetadataModelAssessmentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeMetadataModelAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetadataModelAssessmentsPublisher describeMetadataModelAssessmentsPaginator(
            DescribeMetadataModelAssessmentsRequest describeMetadataModelAssessmentsRequest) {
        return new DescribeMetadataModelAssessmentsPublisher(this, describeMetadataModelAssessmentsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeMetadataModelAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelAssessmentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelAssessmentsPublisher publisher = client.describeMetadataModelAssessmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelAssessmentsPublisher publisher = client.describeMetadataModelAssessmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelAssessmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelAssessmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMetadataModelAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelAssessmentsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMetadataModelAssessmentsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMetadataModelAssessmentsRequest#builder()}
     * </p>
     *
     * @param describeMetadataModelAssessmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelAssessmentsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeMetadataModelAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetadataModelAssessmentsPublisher describeMetadataModelAssessmentsPaginator(
            Consumer<DescribeMetadataModelAssessmentsRequest.Builder> describeMetadataModelAssessmentsRequest) {
        return describeMetadataModelAssessmentsPaginator(DescribeMetadataModelAssessmentsRequest.builder()
                .applyMutation(describeMetadataModelAssessmentsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of metadata model conversions for a migration project.
     * </p>
     *
     * @param describeMetadataModelConversionsRequest
     * @return A Java Future containing the result of the DescribeMetadataModelConversions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeMetadataModelConversions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelConversions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMetadataModelConversionsResponse> describeMetadataModelConversions(
            DescribeMetadataModelConversionsRequest describeMetadataModelConversionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of metadata model conversions for a migration project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMetadataModelConversionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMetadataModelConversionsRequest#builder()}
     * </p>
     *
     * @param describeMetadataModelConversionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelConversionsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeMetadataModelConversions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeMetadataModelConversions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelConversions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMetadataModelConversionsResponse> describeMetadataModelConversions(
            Consumer<DescribeMetadataModelConversionsRequest.Builder> describeMetadataModelConversionsRequest) {
        return describeMetadataModelConversions(DescribeMetadataModelConversionsRequest.builder()
                .applyMutation(describeMetadataModelConversionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeMetadataModelConversions(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelConversionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelConversionsPublisher publisher = client.describeMetadataModelConversionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelConversionsPublisher publisher = client.describeMetadataModelConversionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelConversionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelConversionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMetadataModelConversions(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelConversionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMetadataModelConversionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeMetadataModelConversions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelConversions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetadataModelConversionsPublisher describeMetadataModelConversionsPaginator(
            DescribeMetadataModelConversionsRequest describeMetadataModelConversionsRequest) {
        return new DescribeMetadataModelConversionsPublisher(this, describeMetadataModelConversionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeMetadataModelConversions(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelConversionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelConversionsPublisher publisher = client.describeMetadataModelConversionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelConversionsPublisher publisher = client.describeMetadataModelConversionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelConversionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelConversionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMetadataModelConversions(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelConversionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMetadataModelConversionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMetadataModelConversionsRequest#builder()}
     * </p>
     *
     * @param describeMetadataModelConversionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelConversionsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeMetadataModelConversions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelConversions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetadataModelConversionsPublisher describeMetadataModelConversionsPaginator(
            Consumer<DescribeMetadataModelConversionsRequest.Builder> describeMetadataModelConversionsRequest) {
        return describeMetadataModelConversionsPaginator(DescribeMetadataModelConversionsRequest.builder()
                .applyMutation(describeMetadataModelConversionsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of metadata model exports.
     * </p>
     *
     * @param describeMetadataModelExportsAsScriptRequest
     * @return A Java Future containing the result of the DescribeMetadataModelExportsAsScript operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeMetadataModelExportsAsScript
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelExportsAsScript"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMetadataModelExportsAsScriptResponse> describeMetadataModelExportsAsScript(
            DescribeMetadataModelExportsAsScriptRequest describeMetadataModelExportsAsScriptRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of metadata model exports.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeMetadataModelExportsAsScriptRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeMetadataModelExportsAsScriptRequest#builder()}
     * </p>
     *
     * @param describeMetadataModelExportsAsScriptRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsAsScriptRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeMetadataModelExportsAsScript operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeMetadataModelExportsAsScript
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelExportsAsScript"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMetadataModelExportsAsScriptResponse> describeMetadataModelExportsAsScript(
            Consumer<DescribeMetadataModelExportsAsScriptRequest.Builder> describeMetadataModelExportsAsScriptRequest) {
        return describeMetadataModelExportsAsScript(DescribeMetadataModelExportsAsScriptRequest.builder()
                .applyMutation(describeMetadataModelExportsAsScriptRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeMetadataModelExportsAsScript(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsAsScriptRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelExportsAsScriptPublisher publisher = client.describeMetadataModelExportsAsScriptPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelExportsAsScriptPublisher publisher = client.describeMetadataModelExportsAsScriptPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsAsScriptResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsAsScriptResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMetadataModelExportsAsScript(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsAsScriptRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMetadataModelExportsAsScriptRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeMetadataModelExportsAsScript
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelExportsAsScript"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetadataModelExportsAsScriptPublisher describeMetadataModelExportsAsScriptPaginator(
            DescribeMetadataModelExportsAsScriptRequest describeMetadataModelExportsAsScriptRequest) {
        return new DescribeMetadataModelExportsAsScriptPublisher(this, describeMetadataModelExportsAsScriptRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeMetadataModelExportsAsScript(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsAsScriptRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelExportsAsScriptPublisher publisher = client.describeMetadataModelExportsAsScriptPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelExportsAsScriptPublisher publisher = client.describeMetadataModelExportsAsScriptPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsAsScriptResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsAsScriptResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMetadataModelExportsAsScript(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsAsScriptRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeMetadataModelExportsAsScriptRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeMetadataModelExportsAsScriptRequest#builder()}
     * </p>
     *
     * @param describeMetadataModelExportsAsScriptRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsAsScriptRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeMetadataModelExportsAsScript
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelExportsAsScript"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetadataModelExportsAsScriptPublisher describeMetadataModelExportsAsScriptPaginator(
            Consumer<DescribeMetadataModelExportsAsScriptRequest.Builder> describeMetadataModelExportsAsScriptRequest) {
        return describeMetadataModelExportsAsScriptPaginator(DescribeMetadataModelExportsAsScriptRequest.builder()
                .applyMutation(describeMetadataModelExportsAsScriptRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of metadata model exports.
     * </p>
     *
     * @param describeMetadataModelExportsToTargetRequest
     * @return A Java Future containing the result of the DescribeMetadataModelExportsToTarget operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeMetadataModelExportsToTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelExportsToTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMetadataModelExportsToTargetResponse> describeMetadataModelExportsToTarget(
            DescribeMetadataModelExportsToTargetRequest describeMetadataModelExportsToTargetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of metadata model exports.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeMetadataModelExportsToTargetRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeMetadataModelExportsToTargetRequest#builder()}
     * </p>
     *
     * @param describeMetadataModelExportsToTargetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsToTargetRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeMetadataModelExportsToTarget operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeMetadataModelExportsToTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelExportsToTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMetadataModelExportsToTargetResponse> describeMetadataModelExportsToTarget(
            Consumer<DescribeMetadataModelExportsToTargetRequest.Builder> describeMetadataModelExportsToTargetRequest) {
        return describeMetadataModelExportsToTarget(DescribeMetadataModelExportsToTargetRequest.builder()
                .applyMutation(describeMetadataModelExportsToTargetRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeMetadataModelExportsToTarget(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsToTargetRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelExportsToTargetPublisher publisher = client.describeMetadataModelExportsToTargetPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelExportsToTargetPublisher publisher = client.describeMetadataModelExportsToTargetPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsToTargetResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsToTargetResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMetadataModelExportsToTarget(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsToTargetRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMetadataModelExportsToTargetRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeMetadataModelExportsToTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelExportsToTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetadataModelExportsToTargetPublisher describeMetadataModelExportsToTargetPaginator(
            DescribeMetadataModelExportsToTargetRequest describeMetadataModelExportsToTargetRequest) {
        return new DescribeMetadataModelExportsToTargetPublisher(this, describeMetadataModelExportsToTargetRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeMetadataModelExportsToTarget(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsToTargetRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelExportsToTargetPublisher publisher = client.describeMetadataModelExportsToTargetPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelExportsToTargetPublisher publisher = client.describeMetadataModelExportsToTargetPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsToTargetResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsToTargetResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMetadataModelExportsToTarget(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsToTargetRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeMetadataModelExportsToTargetRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeMetadataModelExportsToTargetRequest#builder()}
     * </p>
     *
     * @param describeMetadataModelExportsToTargetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelExportsToTargetRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeMetadataModelExportsToTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelExportsToTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetadataModelExportsToTargetPublisher describeMetadataModelExportsToTargetPaginator(
            Consumer<DescribeMetadataModelExportsToTargetRequest.Builder> describeMetadataModelExportsToTargetRequest) {
        return describeMetadataModelExportsToTargetPaginator(DescribeMetadataModelExportsToTargetRequest.builder()
                .applyMutation(describeMetadataModelExportsToTargetRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of metadata model imports.
     * </p>
     *
     * @param describeMetadataModelImportsRequest
     * @return A Java Future containing the result of the DescribeMetadataModelImports operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeMetadataModelImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelImports"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMetadataModelImportsResponse> describeMetadataModelImports(
            DescribeMetadataModelImportsRequest describeMetadataModelImportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of metadata model imports.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMetadataModelImportsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMetadataModelImportsRequest#builder()}
     * </p>
     *
     * @param describeMetadataModelImportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelImportsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeMetadataModelImports operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeMetadataModelImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelImports"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMetadataModelImportsResponse> describeMetadataModelImports(
            Consumer<DescribeMetadataModelImportsRequest.Builder> describeMetadataModelImportsRequest) {
        return describeMetadataModelImports(DescribeMetadataModelImportsRequest.builder()
                .applyMutation(describeMetadataModelImportsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeMetadataModelImports(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelImportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelImportsPublisher publisher = client.describeMetadataModelImportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelImportsPublisher publisher = client.describeMetadataModelImportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelImportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelImportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMetadataModelImports(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelImportsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMetadataModelImportsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeMetadataModelImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelImports"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetadataModelImportsPublisher describeMetadataModelImportsPaginator(
            DescribeMetadataModelImportsRequest describeMetadataModelImportsRequest) {
        return new DescribeMetadataModelImportsPublisher(this, describeMetadataModelImportsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeMetadataModelImports(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelImportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelImportsPublisher publisher = client.describeMetadataModelImportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMetadataModelImportsPublisher publisher = client.describeMetadataModelImportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelImportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelImportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMetadataModelImports(software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelImportsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMetadataModelImportsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMetadataModelImportsRequest#builder()}
     * </p>
     *
     * @param describeMetadataModelImportsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeMetadataModelImportsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeMetadataModelImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMetadataModelImports"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetadataModelImportsPublisher describeMetadataModelImportsPaginator(
            Consumer<DescribeMetadataModelImportsRequest.Builder> describeMetadataModelImportsRequest) {
        return describeMetadataModelImportsPaginator(DescribeMetadataModelImportsRequest.builder()
                .applyMutation(describeMetadataModelImportsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of migration projects for your account in the current region.
     * </p>
     *
     * @param describeMigrationProjectsRequest
     * @return A Java Future containing the result of the DescribeMigrationProjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeMigrationProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMigrationProjects" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeMigrationProjectsResponse> describeMigrationProjects(
            DescribeMigrationProjectsRequest describeMigrationProjectsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of migration projects for your account in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMigrationProjectsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeMigrationProjectsRequest#builder()}
     * </p>
     *
     * @param describeMigrationProjectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeMigrationProjectsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeMigrationProjects operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeMigrationProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMigrationProjects" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeMigrationProjectsResponse> describeMigrationProjects(
            Consumer<DescribeMigrationProjectsRequest.Builder> describeMigrationProjectsRequest) {
        return describeMigrationProjects(DescribeMigrationProjectsRequest.builder()
                .applyMutation(describeMigrationProjectsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeMigrationProjects(software.amazon.awssdk.services.databasemigration.model.DescribeMigrationProjectsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMigrationProjectsPublisher publisher = client.describeMigrationProjectsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMigrationProjectsPublisher publisher = client.describeMigrationProjectsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeMigrationProjectsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeMigrationProjectsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMigrationProjects(software.amazon.awssdk.services.databasemigration.model.DescribeMigrationProjectsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMigrationProjectsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeMigrationProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMigrationProjects" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeMigrationProjectsPublisher describeMigrationProjectsPaginator(
            DescribeMigrationProjectsRequest describeMigrationProjectsRequest) {
        return new DescribeMigrationProjectsPublisher(this, describeMigrationProjectsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeMigrationProjects(software.amazon.awssdk.services.databasemigration.model.DescribeMigrationProjectsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMigrationProjectsPublisher publisher = client.describeMigrationProjectsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeMigrationProjectsPublisher publisher = client.describeMigrationProjectsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeMigrationProjectsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeMigrationProjectsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMigrationProjects(software.amazon.awssdk.services.databasemigration.model.DescribeMigrationProjectsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMigrationProjectsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeMigrationProjectsRequest#builder()}
     * </p>
     *
     * @param describeMigrationProjectsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeMigrationProjectsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeMigrationProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeMigrationProjects" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeMigrationProjectsPublisher describeMigrationProjectsPaginator(
            Consumer<DescribeMigrationProjectsRequest.Builder> describeMigrationProjectsRequest) {
        return describeMigrationProjectsPaginator(DescribeMigrationProjectsRequest.builder()
                .applyMutation(describeMigrationProjectsRequest).build());
    }

    /**
     * <p>
     * Returns information about the replication instance types that can be created in the specified region.
     * </p>
     *
     * @param describeOrderableReplicationInstancesRequest
     * @return A Java Future containing the result of the DescribeOrderableReplicationInstances operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeOrderableReplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeOrderableReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrderableReplicationInstancesResponse> describeOrderableReplicationInstances(
            DescribeOrderableReplicationInstancesRequest describeOrderableReplicationInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the replication instance types that can be created in the specified region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeOrderableReplicationInstancesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeOrderableReplicationInstancesRequest#builder()}
     * </p>
     *
     * @param describeOrderableReplicationInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeOrderableReplicationInstances operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeOrderableReplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeOrderableReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrderableReplicationInstancesResponse> describeOrderableReplicationInstances(
            Consumer<DescribeOrderableReplicationInstancesRequest.Builder> describeOrderableReplicationInstancesRequest) {
        return describeOrderableReplicationInstances(DescribeOrderableReplicationInstancesRequest.builder()
                .applyMutation(describeOrderableReplicationInstancesRequest).build());
    }

    /**
     * <p>
     * Returns information about the replication instance types that can be created in the specified region.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeOrderableReplicationInstances operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeOrderableReplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeOrderableReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeOrderableReplicationInstancesResponse> describeOrderableReplicationInstances() {
        return describeOrderableReplicationInstances(DescribeOrderableReplicationInstancesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeOrderableReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeOrderableReplicationInstancesPublisher publisher = client.describeOrderableReplicationInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeOrderableReplicationInstancesPublisher publisher = client.describeOrderableReplicationInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrderableReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeOrderableReplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeOrderableReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableReplicationInstancesPublisher describeOrderableReplicationInstancesPaginator() {
        return describeOrderableReplicationInstancesPaginator(DescribeOrderableReplicationInstancesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeOrderableReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeOrderableReplicationInstancesPublisher publisher = client.describeOrderableReplicationInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeOrderableReplicationInstancesPublisher publisher = client.describeOrderableReplicationInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrderableReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOrderableReplicationInstancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeOrderableReplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeOrderableReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableReplicationInstancesPublisher describeOrderableReplicationInstancesPaginator(
            DescribeOrderableReplicationInstancesRequest describeOrderableReplicationInstancesRequest) {
        return new DescribeOrderableReplicationInstancesPublisher(this, describeOrderableReplicationInstancesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeOrderableReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeOrderableReplicationInstancesPublisher publisher = client.describeOrderableReplicationInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeOrderableReplicationInstancesPublisher publisher = client.describeOrderableReplicationInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrderableReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeOrderableReplicationInstancesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeOrderableReplicationInstancesRequest#builder()}
     * </p>
     *
     * @param describeOrderableReplicationInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeOrderableReplicationInstancesRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeOrderableReplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeOrderableReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableReplicationInstancesPublisher describeOrderableReplicationInstancesPaginator(
            Consumer<DescribeOrderableReplicationInstancesRequest.Builder> describeOrderableReplicationInstancesRequest) {
        return describeOrderableReplicationInstancesPaginator(DescribeOrderableReplicationInstancesRequest.builder()
                .applyMutation(describeOrderableReplicationInstancesRequest).build());
    }

    /**
     * <p>
     * For internal use only
     * </p>
     *
     * @param describePendingMaintenanceActionsRequest
     * @return A Java Future containing the result of the DescribePendingMaintenanceActions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribePendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePendingMaintenanceActionsResponse> describePendingMaintenanceActions(
            DescribePendingMaintenanceActionsRequest describePendingMaintenanceActionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For internal use only
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePendingMaintenanceActionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribePendingMaintenanceActionsRequest#builder()}
     * </p>
     *
     * @param describePendingMaintenanceActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribePendingMaintenanceActions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribePendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePendingMaintenanceActionsResponse> describePendingMaintenanceActions(
            Consumer<DescribePendingMaintenanceActionsRequest.Builder> describePendingMaintenanceActionsRequest) {
        return describePendingMaintenanceActions(DescribePendingMaintenanceActionsRequest.builder()
                .applyMutation(describePendingMaintenanceActionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describePendingMaintenanceActions(software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribePendingMaintenanceActionsPublisher publisher = client.describePendingMaintenanceActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribePendingMaintenanceActionsPublisher publisher = client.describePendingMaintenanceActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePendingMaintenanceActions(software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePendingMaintenanceActionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribePendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePendingMaintenanceActionsPublisher describePendingMaintenanceActionsPaginator(
            DescribePendingMaintenanceActionsRequest describePendingMaintenanceActionsRequest) {
        return new DescribePendingMaintenanceActionsPublisher(this, describePendingMaintenanceActionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describePendingMaintenanceActions(software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribePendingMaintenanceActionsPublisher publisher = client.describePendingMaintenanceActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribePendingMaintenanceActionsPublisher publisher = client.describePendingMaintenanceActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePendingMaintenanceActions(software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePendingMaintenanceActionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribePendingMaintenanceActionsRequest#builder()}
     * </p>
     *
     * @param describePendingMaintenanceActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribePendingMaintenanceActionsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribePendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePendingMaintenanceActionsPublisher describePendingMaintenanceActionsPaginator(
            Consumer<DescribePendingMaintenanceActionsRequest.Builder> describePendingMaintenanceActionsRequest) {
        return describePendingMaintenanceActionsPaginator(DescribePendingMaintenanceActionsRequest.builder()
                .applyMutation(describePendingMaintenanceActionsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of limitations for recommendations of target Amazon Web Services engines.
     * </p>
     *
     * @param describeRecommendationLimitationsRequest
     * @return A Java Future containing the result of the DescribeRecommendationLimitations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeRecommendationLimitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRecommendationLimitations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRecommendationLimitationsResponse> describeRecommendationLimitations(
            DescribeRecommendationLimitationsRequest describeRecommendationLimitationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of limitations for recommendations of target Amazon Web Services engines.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRecommendationLimitationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRecommendationLimitationsRequest#builder()}
     * </p>
     *
     * @param describeRecommendationLimitationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationLimitationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeRecommendationLimitations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeRecommendationLimitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRecommendationLimitations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRecommendationLimitationsResponse> describeRecommendationLimitations(
            Consumer<DescribeRecommendationLimitationsRequest.Builder> describeRecommendationLimitationsRequest) {
        return describeRecommendationLimitations(DescribeRecommendationLimitationsRequest.builder()
                .applyMutation(describeRecommendationLimitationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRecommendationLimitations(software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationLimitationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeRecommendationLimitationsPublisher publisher = client.describeRecommendationLimitationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeRecommendationLimitationsPublisher publisher = client.describeRecommendationLimitationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationLimitationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationLimitationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRecommendationLimitations(software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationLimitationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRecommendationLimitationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeRecommendationLimitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRecommendationLimitations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRecommendationLimitationsPublisher describeRecommendationLimitationsPaginator(
            DescribeRecommendationLimitationsRequest describeRecommendationLimitationsRequest) {
        return new DescribeRecommendationLimitationsPublisher(this, describeRecommendationLimitationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRecommendationLimitations(software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationLimitationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeRecommendationLimitationsPublisher publisher = client.describeRecommendationLimitationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeRecommendationLimitationsPublisher publisher = client.describeRecommendationLimitationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationLimitationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationLimitationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRecommendationLimitations(software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationLimitationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRecommendationLimitationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRecommendationLimitationsRequest#builder()}
     * </p>
     *
     * @param describeRecommendationLimitationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationLimitationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeRecommendationLimitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRecommendationLimitations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRecommendationLimitationsPublisher describeRecommendationLimitationsPaginator(
            Consumer<DescribeRecommendationLimitationsRequest.Builder> describeRecommendationLimitationsRequest) {
        return describeRecommendationLimitationsPaginator(DescribeRecommendationLimitationsRequest.builder()
                .applyMutation(describeRecommendationLimitationsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of target engine recommendations for your source databases.
     * </p>
     *
     * @param describeRecommendationsRequest
     * @return A Java Future containing the result of the DescribeRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRecommendations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeRecommendationsResponse> describeRecommendations(
            DescribeRecommendationsRequest describeRecommendationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of target engine recommendations for your source databases.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRecommendationsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeRecommendationsRequest#builder()}
     * </p>
     *
     * @param describeRecommendationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRecommendations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeRecommendationsResponse> describeRecommendations(
            Consumer<DescribeRecommendationsRequest.Builder> describeRecommendationsRequest) {
        return describeRecommendations(DescribeRecommendationsRequest.builder().applyMutation(describeRecommendationsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRecommendations(software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeRecommendationsPublisher publisher = client.describeRecommendationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeRecommendationsPublisher publisher = client.describeRecommendationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRecommendations(software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeRecommendationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRecommendations" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRecommendationsPublisher describeRecommendationsPaginator(
            DescribeRecommendationsRequest describeRecommendationsRequest) {
        return new DescribeRecommendationsPublisher(this, describeRecommendationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeRecommendations(software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeRecommendationsPublisher publisher = client.describeRecommendationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeRecommendationsPublisher publisher = client.describeRecommendationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeRecommendations(software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRecommendationsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeRecommendationsRequest#builder()}
     * </p>
     *
     * @param describeRecommendationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeRecommendationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRecommendations" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeRecommendationsPublisher describeRecommendationsPaginator(
            Consumer<DescribeRecommendationsRequest.Builder> describeRecommendationsRequest) {
        return describeRecommendationsPaginator(DescribeRecommendationsRequest.builder()
                .applyMutation(describeRecommendationsRequest).build());
    }

    /**
     * <p>
     * Returns the status of the RefreshSchemas operation.
     * </p>
     *
     * @param describeRefreshSchemasStatusRequest
     * @return A Java Future containing the result of the DescribeRefreshSchemasStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeRefreshSchemasStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRefreshSchemasStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRefreshSchemasStatusResponse> describeRefreshSchemasStatus(
            DescribeRefreshSchemasStatusRequest describeRefreshSchemasStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the status of the RefreshSchemas operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRefreshSchemasStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRefreshSchemasStatusRequest#builder()}
     * </p>
     *
     * @param describeRefreshSchemasStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeRefreshSchemasStatusRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeRefreshSchemasStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeRefreshSchemasStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRefreshSchemasStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRefreshSchemasStatusResponse> describeRefreshSchemasStatus(
            Consumer<DescribeRefreshSchemasStatusRequest.Builder> describeRefreshSchemasStatusRequest) {
        return describeRefreshSchemasStatus(DescribeRefreshSchemasStatusRequest.builder()
                .applyMutation(describeRefreshSchemasStatusRequest).build());
    }

    /**
     * <p>
     * Returns one or more existing DMS Serverless replication configurations as a list of structures.
     * </p>
     *
     * @param describeReplicationConfigsRequest
     * @return A Java Future containing the result of the DescribeReplicationConfigs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReplicationConfigsResponse> describeReplicationConfigs(
            DescribeReplicationConfigsRequest describeReplicationConfigsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns one or more existing DMS Serverless replication configurations as a list of structures.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationConfigsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeReplicationConfigsRequest#builder()}
     * </p>
     *
     * @param describeReplicationConfigsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationConfigsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeReplicationConfigs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReplicationConfigsResponse> describeReplicationConfigs(
            Consumer<DescribeReplicationConfigsRequest.Builder> describeReplicationConfigsRequest) {
        return describeReplicationConfigs(DescribeReplicationConfigsRequest.builder()
                .applyMutation(describeReplicationConfigsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationConfigs(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationConfigsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationConfigsPublisher publisher = client.describeReplicationConfigsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationConfigsPublisher publisher = client.describeReplicationConfigsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeReplicationConfigsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationConfigsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationConfigs(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationConfigsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationConfigsPublisher describeReplicationConfigsPaginator(
            DescribeReplicationConfigsRequest describeReplicationConfigsRequest) {
        return new DescribeReplicationConfigsPublisher(this, describeReplicationConfigsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationConfigs(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationConfigsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationConfigsPublisher publisher = client.describeReplicationConfigsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationConfigsPublisher publisher = client.describeReplicationConfigsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeReplicationConfigsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationConfigsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationConfigs(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationConfigsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationConfigsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeReplicationConfigsRequest#builder()}
     * </p>
     *
     * @param describeReplicationConfigsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationConfigsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationConfigsPublisher describeReplicationConfigsPaginator(
            Consumer<DescribeReplicationConfigsRequest.Builder> describeReplicationConfigsRequest) {
        return describeReplicationConfigsPaginator(DescribeReplicationConfigsRequest.builder()
                .applyMutation(describeReplicationConfigsRequest).build());
    }

    /**
     * <p>
     * Returns information about the task logs for the specified task.
     * </p>
     *
     * @param describeReplicationInstanceTaskLogsRequest
     * @return A Java Future containing the result of the DescribeReplicationInstanceTaskLogs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationInstanceTaskLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstanceTaskLogs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReplicationInstanceTaskLogsResponse> describeReplicationInstanceTaskLogs(
            DescribeReplicationInstanceTaskLogsRequest describeReplicationInstanceTaskLogsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the task logs for the specified task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationInstanceTaskLogsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReplicationInstanceTaskLogsRequest#builder()}
     * </p>
     *
     * @param describeReplicationInstanceTaskLogsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeReplicationInstanceTaskLogs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationInstanceTaskLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstanceTaskLogs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReplicationInstanceTaskLogsResponse> describeReplicationInstanceTaskLogs(
            Consumer<DescribeReplicationInstanceTaskLogsRequest.Builder> describeReplicationInstanceTaskLogsRequest) {
        return describeReplicationInstanceTaskLogs(DescribeReplicationInstanceTaskLogsRequest.builder()
                .applyMutation(describeReplicationInstanceTaskLogsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationInstanceTaskLogs(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstanceTaskLogsPublisher publisher = client.describeReplicationInstanceTaskLogsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstanceTaskLogsPublisher publisher = client.describeReplicationInstanceTaskLogsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationInstanceTaskLogs(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationInstanceTaskLogsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationInstanceTaskLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstanceTaskLogs"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationInstanceTaskLogsPublisher describeReplicationInstanceTaskLogsPaginator(
            DescribeReplicationInstanceTaskLogsRequest describeReplicationInstanceTaskLogsRequest) {
        return new DescribeReplicationInstanceTaskLogsPublisher(this, describeReplicationInstanceTaskLogsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationInstanceTaskLogs(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstanceTaskLogsPublisher publisher = client.describeReplicationInstanceTaskLogsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstanceTaskLogsPublisher publisher = client.describeReplicationInstanceTaskLogsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationInstanceTaskLogs(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationInstanceTaskLogsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReplicationInstanceTaskLogsRequest#builder()}
     * </p>
     *
     * @param describeReplicationInstanceTaskLogsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstanceTaskLogsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationInstanceTaskLogs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstanceTaskLogs"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationInstanceTaskLogsPublisher describeReplicationInstanceTaskLogsPaginator(
            Consumer<DescribeReplicationInstanceTaskLogsRequest.Builder> describeReplicationInstanceTaskLogsRequest) {
        return describeReplicationInstanceTaskLogsPaginator(DescribeReplicationInstanceTaskLogsRequest.builder()
                .applyMutation(describeReplicationInstanceTaskLogsRequest).build());
    }

    /**
     * <p>
     * Returns information about replication instances for your account in the current region.
     * </p>
     *
     * @param describeReplicationInstancesRequest
     * @return A Java Future containing the result of the DescribeReplicationInstances operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReplicationInstancesResponse> describeReplicationInstances(
            DescribeReplicationInstancesRequest describeReplicationInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about replication instances for your account in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationInstancesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReplicationInstancesRequest#builder()}
     * </p>
     *
     * @param describeReplicationInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeReplicationInstances operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReplicationInstancesResponse> describeReplicationInstances(
            Consumer<DescribeReplicationInstancesRequest.Builder> describeReplicationInstancesRequest) {
        return describeReplicationInstances(DescribeReplicationInstancesRequest.builder()
                .applyMutation(describeReplicationInstancesRequest).build());
    }

    /**
     * <p>
     * Returns information about replication instances for your account in the current region.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeReplicationInstances operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReplicationInstancesResponse> describeReplicationInstances() {
        return describeReplicationInstances(DescribeReplicationInstancesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstancesPublisher publisher = client.describeReplicationInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstancesPublisher publisher = client.describeReplicationInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationInstancesPublisher describeReplicationInstancesPaginator() {
        return describeReplicationInstancesPaginator(DescribeReplicationInstancesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstancesPublisher publisher = client.describeReplicationInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstancesPublisher publisher = client.describeReplicationInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationInstancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationInstancesPublisher describeReplicationInstancesPaginator(
            DescribeReplicationInstancesRequest describeReplicationInstancesRequest) {
        return new DescribeReplicationInstancesPublisher(this, describeReplicationInstancesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstancesPublisher publisher = client.describeReplicationInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationInstancesPublisher publisher = client.describeReplicationInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationInstances(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationInstancesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReplicationInstancesRequest#builder()}
     * </p>
     *
     * @param describeReplicationInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationInstancesRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationInstancesPublisher describeReplicationInstancesPaginator(
            Consumer<DescribeReplicationInstancesRequest.Builder> describeReplicationInstancesRequest) {
        return describeReplicationInstancesPaginator(DescribeReplicationInstancesRequest.builder()
                .applyMutation(describeReplicationInstancesRequest).build());
    }

    /**
     * <p>
     * Returns information about the replication subnet groups.
     * </p>
     *
     * @param describeReplicationSubnetGroupsRequest
     * @return A Java Future containing the result of the DescribeReplicationSubnetGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReplicationSubnetGroupsResponse> describeReplicationSubnetGroups(
            DescribeReplicationSubnetGroupsRequest describeReplicationSubnetGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the replication subnet groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationSubnetGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReplicationSubnetGroupsRequest#builder()}
     * </p>
     *
     * @param describeReplicationSubnetGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeReplicationSubnetGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReplicationSubnetGroupsResponse> describeReplicationSubnetGroups(
            Consumer<DescribeReplicationSubnetGroupsRequest.Builder> describeReplicationSubnetGroupsRequest) {
        return describeReplicationSubnetGroups(DescribeReplicationSubnetGroupsRequest.builder()
                .applyMutation(describeReplicationSubnetGroupsRequest).build());
    }

    /**
     * <p>
     * Returns information about the replication subnet groups.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeReplicationSubnetGroups operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReplicationSubnetGroupsResponse> describeReplicationSubnetGroups() {
        return describeReplicationSubnetGroups(DescribeReplicationSubnetGroupsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationSubnetGroups(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationSubnetGroupsPublisher publisher = client.describeReplicationSubnetGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationSubnetGroupsPublisher publisher = client.describeReplicationSubnetGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationSubnetGroups(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationSubnetGroupsPublisher describeReplicationSubnetGroupsPaginator() {
        return describeReplicationSubnetGroupsPaginator(DescribeReplicationSubnetGroupsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationSubnetGroups(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationSubnetGroupsPublisher publisher = client.describeReplicationSubnetGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationSubnetGroupsPublisher publisher = client.describeReplicationSubnetGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationSubnetGroups(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationSubnetGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationSubnetGroupsPublisher describeReplicationSubnetGroupsPaginator(
            DescribeReplicationSubnetGroupsRequest describeReplicationSubnetGroupsRequest) {
        return new DescribeReplicationSubnetGroupsPublisher(this, describeReplicationSubnetGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationSubnetGroups(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationSubnetGroupsPublisher publisher = client.describeReplicationSubnetGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationSubnetGroupsPublisher publisher = client.describeReplicationSubnetGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationSubnetGroups(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationSubnetGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReplicationSubnetGroupsRequest#builder()}
     * </p>
     *
     * @param describeReplicationSubnetGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationSubnetGroupsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationSubnetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationSubnetGroupsPublisher describeReplicationSubnetGroupsPaginator(
            Consumer<DescribeReplicationSubnetGroupsRequest.Builder> describeReplicationSubnetGroupsRequest) {
        return describeReplicationSubnetGroupsPaginator(DescribeReplicationSubnetGroupsRequest.builder()
                .applyMutation(describeReplicationSubnetGroupsRequest).build());
    }

    /**
     * <p>
     * Returns table and schema statistics for one or more provisioned replications that use a given DMS Serverless
     * replication configuration.
     * </p>
     *
     * @param describeReplicationTableStatisticsRequest
     * @return A Java Future containing the result of the DescribeReplicationTableStatistics operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationTableStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTableStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReplicationTableStatisticsResponse> describeReplicationTableStatistics(
            DescribeReplicationTableStatisticsRequest describeReplicationTableStatisticsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns table and schema statistics for one or more provisioned replications that use a given DMS Serverless
     * replication configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationTableStatisticsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReplicationTableStatisticsRequest#builder()}
     * </p>
     *
     * @param describeReplicationTableStatisticsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeReplicationTableStatistics operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationTableStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTableStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReplicationTableStatisticsResponse> describeReplicationTableStatistics(
            Consumer<DescribeReplicationTableStatisticsRequest.Builder> describeReplicationTableStatisticsRequest) {
        return describeReplicationTableStatistics(DescribeReplicationTableStatisticsRequest.builder()
                .applyMutation(describeReplicationTableStatisticsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationTableStatistics(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTableStatisticsPublisher publisher = client.describeReplicationTableStatisticsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTableStatisticsPublisher publisher = client.describeReplicationTableStatisticsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationTableStatistics(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationTableStatisticsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationTableStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTableStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTableStatisticsPublisher describeReplicationTableStatisticsPaginator(
            DescribeReplicationTableStatisticsRequest describeReplicationTableStatisticsRequest) {
        return new DescribeReplicationTableStatisticsPublisher(this, describeReplicationTableStatisticsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationTableStatistics(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTableStatisticsPublisher publisher = client.describeReplicationTableStatisticsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTableStatisticsPublisher publisher = client.describeReplicationTableStatisticsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationTableStatistics(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationTableStatisticsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReplicationTableStatisticsRequest#builder()}
     * </p>
     *
     * @param describeReplicationTableStatisticsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTableStatisticsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationTableStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTableStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTableStatisticsPublisher describeReplicationTableStatisticsPaginator(
            Consumer<DescribeReplicationTableStatisticsRequest.Builder> describeReplicationTableStatisticsRequest) {
        return describeReplicationTableStatisticsPaginator(DescribeReplicationTableStatisticsRequest.builder()
                .applyMutation(describeReplicationTableStatisticsRequest).build());
    }

    /**
     * <p>
     * Returns the task assessment results from the Amazon S3 bucket that DMS creates in your Amazon Web Services
     * account. This action always returns the latest results.
     * </p>
     * <p>
     * For more information about DMS task assessments, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html">Creating a task
     * assessment report</a> in the <i>Database Migration Service User Guide</i>.
     * </p>
     *
     * @param describeReplicationTaskAssessmentResultsRequest
     * @return A Java Future containing the result of the DescribeReplicationTaskAssessmentResults operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationTaskAssessmentResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentResults"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReplicationTaskAssessmentResultsResponse> describeReplicationTaskAssessmentResults(
            DescribeReplicationTaskAssessmentResultsRequest describeReplicationTaskAssessmentResultsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the task assessment results from the Amazon S3 bucket that DMS creates in your Amazon Web Services
     * account. This action always returns the latest results.
     * </p>
     * <p>
     * For more information about DMS task assessments, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html">Creating a task
     * assessment report</a> in the <i>Database Migration Service User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReplicationTaskAssessmentResultsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeReplicationTaskAssessmentResultsRequest#builder()}
     * </p>
     *
     * @param describeReplicationTaskAssessmentResultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeReplicationTaskAssessmentResults operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationTaskAssessmentResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentResults"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReplicationTaskAssessmentResultsResponse> describeReplicationTaskAssessmentResults(
            Consumer<DescribeReplicationTaskAssessmentResultsRequest.Builder> describeReplicationTaskAssessmentResultsRequest) {
        return describeReplicationTaskAssessmentResults(DescribeReplicationTaskAssessmentResultsRequest.builder()
                .applyMutation(describeReplicationTaskAssessmentResultsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationTaskAssessmentResults(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentResultsPublisher publisher = client.describeReplicationTaskAssessmentResultsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentResultsPublisher publisher = client.describeReplicationTaskAssessmentResultsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationTaskAssessmentResults(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationTaskAssessmentResultsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationTaskAssessmentResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentResults"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTaskAssessmentResultsPublisher describeReplicationTaskAssessmentResultsPaginator(
            DescribeReplicationTaskAssessmentResultsRequest describeReplicationTaskAssessmentResultsRequest) {
        return new DescribeReplicationTaskAssessmentResultsPublisher(this, describeReplicationTaskAssessmentResultsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationTaskAssessmentResults(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentResultsPublisher publisher = client.describeReplicationTaskAssessmentResultsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentResultsPublisher publisher = client.describeReplicationTaskAssessmentResultsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationTaskAssessmentResults(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReplicationTaskAssessmentResultsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeReplicationTaskAssessmentResultsRequest#builder()}
     * </p>
     *
     * @param describeReplicationTaskAssessmentResultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentResultsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationTaskAssessmentResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentResults"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTaskAssessmentResultsPublisher describeReplicationTaskAssessmentResultsPaginator(
            Consumer<DescribeReplicationTaskAssessmentResultsRequest.Builder> describeReplicationTaskAssessmentResultsRequest) {
        return describeReplicationTaskAssessmentResultsPaginator(DescribeReplicationTaskAssessmentResultsRequest.builder()
                .applyMutation(describeReplicationTaskAssessmentResultsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of premigration assessment runs based on filter settings.
     * </p>
     * <p>
     * These filter settings can specify a combination of premigration assessment runs, migration tasks, replication
     * instances, and assessment run status values.
     * </p>
     * <note>
     * <p>
     * This operation doesn't return information about individual assessments. For this information, see the
     * <code>DescribeReplicationTaskIndividualAssessments</code> operation.
     * </p>
     * </note>
     *
     * @param describeReplicationTaskAssessmentRunsRequest
     * @return A Java Future containing the result of the DescribeReplicationTaskAssessmentRuns operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationTaskAssessmentRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReplicationTaskAssessmentRunsResponse> describeReplicationTaskAssessmentRuns(
            DescribeReplicationTaskAssessmentRunsRequest describeReplicationTaskAssessmentRunsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of premigration assessment runs based on filter settings.
     * </p>
     * <p>
     * These filter settings can specify a combination of premigration assessment runs, migration tasks, replication
     * instances, and assessment run status values.
     * </p>
     * <note>
     * <p>
     * This operation doesn't return information about individual assessments. For this information, see the
     * <code>DescribeReplicationTaskIndividualAssessments</code> operation.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReplicationTaskAssessmentRunsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeReplicationTaskAssessmentRunsRequest#builder()}
     * </p>
     *
     * @param describeReplicationTaskAssessmentRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeReplicationTaskAssessmentRuns operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationTaskAssessmentRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReplicationTaskAssessmentRunsResponse> describeReplicationTaskAssessmentRuns(
            Consumer<DescribeReplicationTaskAssessmentRunsRequest.Builder> describeReplicationTaskAssessmentRunsRequest) {
        return describeReplicationTaskAssessmentRuns(DescribeReplicationTaskAssessmentRunsRequest.builder()
                .applyMutation(describeReplicationTaskAssessmentRunsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationTaskAssessmentRuns(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentRunsPublisher publisher = client.describeReplicationTaskAssessmentRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentRunsPublisher publisher = client.describeReplicationTaskAssessmentRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationTaskAssessmentRuns(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationTaskAssessmentRunsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationTaskAssessmentRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTaskAssessmentRunsPublisher describeReplicationTaskAssessmentRunsPaginator(
            DescribeReplicationTaskAssessmentRunsRequest describeReplicationTaskAssessmentRunsRequest) {
        return new DescribeReplicationTaskAssessmentRunsPublisher(this, describeReplicationTaskAssessmentRunsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationTaskAssessmentRuns(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentRunsPublisher publisher = client.describeReplicationTaskAssessmentRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskAssessmentRunsPublisher publisher = client.describeReplicationTaskAssessmentRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationTaskAssessmentRuns(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReplicationTaskAssessmentRunsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeReplicationTaskAssessmentRunsRequest#builder()}
     * </p>
     *
     * @param describeReplicationTaskAssessmentRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskAssessmentRunsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationTaskAssessmentRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentRuns"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTaskAssessmentRunsPublisher describeReplicationTaskAssessmentRunsPaginator(
            Consumer<DescribeReplicationTaskAssessmentRunsRequest.Builder> describeReplicationTaskAssessmentRunsRequest) {
        return describeReplicationTaskAssessmentRunsPaginator(DescribeReplicationTaskAssessmentRunsRequest.builder()
                .applyMutation(describeReplicationTaskAssessmentRunsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of individual assessments based on filter settings.
     * </p>
     * <p>
     * These filter settings can specify a combination of premigration assessment runs, migration tasks, and assessment
     * status values.
     * </p>
     *
     * @param describeReplicationTaskIndividualAssessmentsRequest
     * @return A Java Future containing the result of the DescribeReplicationTaskIndividualAssessments operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationTaskIndividualAssessments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskIndividualAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReplicationTaskIndividualAssessmentsResponse> describeReplicationTaskIndividualAssessments(
            DescribeReplicationTaskIndividualAssessmentsRequest describeReplicationTaskIndividualAssessmentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of individual assessments based on filter settings.
     * </p>
     * <p>
     * These filter settings can specify a combination of premigration assessment runs, migration tasks, and assessment
     * status values.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReplicationTaskIndividualAssessmentsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeReplicationTaskIndividualAssessmentsRequest#builder()}
     * </p>
     *
     * @param describeReplicationTaskIndividualAssessmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeReplicationTaskIndividualAssessments operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationTaskIndividualAssessments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskIndividualAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReplicationTaskIndividualAssessmentsResponse> describeReplicationTaskIndividualAssessments(
            Consumer<DescribeReplicationTaskIndividualAssessmentsRequest.Builder> describeReplicationTaskIndividualAssessmentsRequest) {
        return describeReplicationTaskIndividualAssessments(DescribeReplicationTaskIndividualAssessmentsRequest.builder()
                .applyMutation(describeReplicationTaskIndividualAssessmentsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationTaskIndividualAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskIndividualAssessmentsPublisher publisher = client.describeReplicationTaskIndividualAssessmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskIndividualAssessmentsPublisher publisher = client.describeReplicationTaskIndividualAssessmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationTaskIndividualAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationTaskIndividualAssessmentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationTaskIndividualAssessments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskIndividualAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTaskIndividualAssessmentsPublisher describeReplicationTaskIndividualAssessmentsPaginator(
            DescribeReplicationTaskIndividualAssessmentsRequest describeReplicationTaskIndividualAssessmentsRequest) {
        return new DescribeReplicationTaskIndividualAssessmentsPublisher(this,
                describeReplicationTaskIndividualAssessmentsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationTaskIndividualAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskIndividualAssessmentsPublisher publisher = client.describeReplicationTaskIndividualAssessmentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTaskIndividualAssessmentsPublisher publisher = client.describeReplicationTaskIndividualAssessmentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationTaskIndividualAssessments(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReplicationTaskIndividualAssessmentsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeReplicationTaskIndividualAssessmentsRequest#builder()}
     * </p>
     *
     * @param describeReplicationTaskIndividualAssessmentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTaskIndividualAssessmentsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationTaskIndividualAssessments
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskIndividualAssessments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationTaskIndividualAssessmentsPublisher describeReplicationTaskIndividualAssessmentsPaginator(
            Consumer<DescribeReplicationTaskIndividualAssessmentsRequest.Builder> describeReplicationTaskIndividualAssessmentsRequest) {
        return describeReplicationTaskIndividualAssessmentsPaginator(DescribeReplicationTaskIndividualAssessmentsRequest
                .builder().applyMutation(describeReplicationTaskIndividualAssessmentsRequest).build());
    }

    /**
     * <p>
     * Returns information about replication tasks for your account in the current region.
     * </p>
     *
     * @param describeReplicationTasksRequest
     * @return A Java Future containing the result of the DescribeReplicationTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeReplicationTasksResponse> describeReplicationTasks(
            DescribeReplicationTasksRequest describeReplicationTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about replication tasks for your account in the current region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationTasksRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeReplicationTasksRequest#builder()}
     * </p>
     *
     * @param describeReplicationTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeReplicationTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeReplicationTasksResponse> describeReplicationTasks(
            Consumer<DescribeReplicationTasksRequest.Builder> describeReplicationTasksRequest) {
        return describeReplicationTasks(DescribeReplicationTasksRequest.builder().applyMutation(describeReplicationTasksRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about replication tasks for your account in the current region.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeReplicationTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeReplicationTasksResponse> describeReplicationTasks() {
        return describeReplicationTasks(DescribeReplicationTasksRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationTasks(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTasksPublisher publisher = client.describeReplicationTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTasksPublisher publisher = client.describeReplicationTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationTasks(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReplicationTasksPublisher describeReplicationTasksPaginator() {
        return describeReplicationTasksPaginator(DescribeReplicationTasksRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationTasks(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTasksPublisher publisher = client.describeReplicationTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTasksPublisher publisher = client.describeReplicationTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationTasks(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationTasksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReplicationTasksPublisher describeReplicationTasksPaginator(
            DescribeReplicationTasksRequest describeReplicationTasksRequest) {
        return new DescribeReplicationTasksPublisher(this, describeReplicationTasksRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplicationTasks(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTasksPublisher publisher = client.describeReplicationTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationTasksPublisher publisher = client.describeReplicationTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationTasks(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationTasksRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeReplicationTasksRequest#builder()}
     * </p>
     *
     * @param describeReplicationTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationTasksRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplicationTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeReplicationTasksPublisher describeReplicationTasksPaginator(
            Consumer<DescribeReplicationTasksRequest.Builder> describeReplicationTasksRequest) {
        return describeReplicationTasksPaginator(DescribeReplicationTasksRequest.builder()
                .applyMutation(describeReplicationTasksRequest).build());
    }

    /**
     * <p>
     * Provides details on replication progress by returning status information for one or more provisioned DMS
     * Serverless replications.
     * </p>
     *
     * @param describeReplicationsRequest
     * @return A Java Future containing the result of the DescribeReplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplications" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeReplicationsResponse> describeReplications(
            DescribeReplicationsRequest describeReplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details on replication progress by returning status information for one or more provisioned DMS
     * Serverless replications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeReplicationsRequest#builder()}
     * </p>
     *
     * @param describeReplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeReplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplications" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeReplicationsResponse> describeReplications(
            Consumer<DescribeReplicationsRequest.Builder> describeReplicationsRequest) {
        return describeReplications(DescribeReplicationsRequest.builder().applyMutation(describeReplicationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplications(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationsPublisher publisher = client.describeReplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationsPublisher publisher = client.describeReplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeReplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplications(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplications" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeReplicationsPublisher describeReplicationsPaginator(DescribeReplicationsRequest describeReplicationsRequest) {
        return new DescribeReplicationsPublisher(this, describeReplicationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeReplications(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationsPublisher publisher = client.describeReplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeReplicationsPublisher publisher = client.describeReplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeReplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplications(software.amazon.awssdk.services.databasemigration.model.DescribeReplicationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReplicationsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeReplicationsRequest#builder()}
     * </p>
     *
     * @param describeReplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeReplicationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeReplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplications" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeReplicationsPublisher describeReplicationsPaginator(
            Consumer<DescribeReplicationsRequest.Builder> describeReplicationsRequest) {
        return describeReplicationsPaginator(DescribeReplicationsRequest.builder().applyMutation(describeReplicationsRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about the schema for the specified endpoint.
     * </p>
     * <p/>
     *
     * @param describeSchemasRequest
     * @return A Java Future containing the result of the DescribeSchemas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li> <li>ResourceNotFoundException The resource could not be found.</li> <li>
     *         SdkException Base class for all exceptions that can be thrown by the SDK (both service and client). Can
     *         be used for catch all scenarios.</li> <li>SdkClientException If any client side error occurs such as an
     *         IO related failure, failure to get credentials, etc.</li> <li>DatabaseMigrationException Base class for
     *         all service exceptions. Unknown exceptions will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeSchemasResponse> describeSchemas(DescribeSchemasRequest describeSchemasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the schema for the specified endpoint.
     * </p>
     * <p/>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSchemasRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeSchemasRequest#builder()}
     * </p>
     *
     * @param describeSchemasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeSchemasRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeSchemas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeSchemasResponse> describeSchemas(
            Consumer<DescribeSchemasRequest.Builder> describeSchemasRequest) {
        return describeSchemas(DescribeSchemasRequest.builder().applyMutation(describeSchemasRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSchemas(software.amazon.awssdk.services.databasemigration.model.DescribeSchemasRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeSchemasPublisher publisher = client.describeSchemasPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeSchemasPublisher publisher = client.describeSchemasPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeSchemasResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeSchemasResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSchemas(software.amazon.awssdk.services.databasemigration.model.DescribeSchemasRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSchemasRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSchemasPublisher describeSchemasPaginator(DescribeSchemasRequest describeSchemasRequest) {
        return new DescribeSchemasPublisher(this, describeSchemasRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeSchemas(software.amazon.awssdk.services.databasemigration.model.DescribeSchemasRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeSchemasPublisher publisher = client.describeSchemasPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeSchemasPublisher publisher = client.describeSchemasPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeSchemasResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeSchemasResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSchemas(software.amazon.awssdk.services.databasemigration.model.DescribeSchemasRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSchemasRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeSchemasRequest#builder()}
     * </p>
     *
     * @param describeSchemasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeSchemasRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSchemasPublisher describeSchemasPaginator(Consumer<DescribeSchemasRequest.Builder> describeSchemasRequest) {
        return describeSchemasPaginator(DescribeSchemasRequest.builder().applyMutation(describeSchemasRequest).build());
    }

    /**
     * <p>
     * Returns table statistics on the database migration task, including table name, rows inserted, rows updated, and
     * rows deleted.
     * </p>
     * <p>
     * Note that the "last updated" column the DMS console only indicates the time that DMS last updated the table
     * statistics record for a table. It does not indicate the time of the last update to the table.
     * </p>
     *
     * @param describeTableStatisticsRequest
     * @return A Java Future containing the result of the DescribeTableStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeTableStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeTableStatistics" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeTableStatisticsResponse> describeTableStatistics(
            DescribeTableStatisticsRequest describeTableStatisticsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns table statistics on the database migration task, including table name, rows inserted, rows updated, and
     * rows deleted.
     * </p>
     * <p>
     * Note that the "last updated" column the DMS console only indicates the time that DMS last updated the table
     * statistics record for a table. It does not indicate the time of the last update to the table.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTableStatisticsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeTableStatisticsRequest#builder()}
     * </p>
     *
     * @param describeTableStatisticsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeTableStatistics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeTableStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeTableStatistics" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeTableStatisticsResponse> describeTableStatistics(
            Consumer<DescribeTableStatisticsRequest.Builder> describeTableStatisticsRequest) {
        return describeTableStatistics(DescribeTableStatisticsRequest.builder().applyMutation(describeTableStatisticsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeTableStatistics(software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeTableStatisticsPublisher publisher = client.describeTableStatisticsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeTableStatisticsPublisher publisher = client.describeTableStatisticsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTableStatistics(software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeTableStatisticsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeTableStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeTableStatistics" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeTableStatisticsPublisher describeTableStatisticsPaginator(
            DescribeTableStatisticsRequest describeTableStatisticsRequest) {
        return new DescribeTableStatisticsPublisher(this, describeTableStatisticsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeTableStatistics(software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeTableStatisticsPublisher publisher = client.describeTableStatisticsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.databasemigration.paginators.DescribeTableStatisticsPublisher publisher = client.describeTableStatisticsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTableStatistics(software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTableStatisticsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeTableStatisticsRequest#builder()}
     * </p>
     *
     * @param describeTableStatisticsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.DescribeTableStatisticsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.DescribeTableStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeTableStatistics" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeTableStatisticsPublisher describeTableStatisticsPaginator(
            Consumer<DescribeTableStatisticsRequest.Builder> describeTableStatisticsRequest) {
        return describeTableStatisticsPaginator(DescribeTableStatisticsRequest.builder()
                .applyMutation(describeTableStatisticsRequest).build());
    }

    /**
     * <p>
     * Saves a copy of a database migration assessment report to your Amazon S3 bucket. DMS can save your assessment
     * report as a comma-separated value (CSV) or a PDF file.
     * </p>
     *
     * @param exportMetadataModelAssessmentRequest
     * @return A Java Future containing the result of the ExportMetadataModelAssessment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.ExportMetadataModelAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ExportMetadataModelAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExportMetadataModelAssessmentResponse> exportMetadataModelAssessment(
            ExportMetadataModelAssessmentRequest exportMetadataModelAssessmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Saves a copy of a database migration assessment report to your Amazon S3 bucket. DMS can save your assessment
     * report as a comma-separated value (CSV) or a PDF file.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportMetadataModelAssessmentRequest.Builder}
     * avoiding the need to create one manually via {@link ExportMetadataModelAssessmentRequest#builder()}
     * </p>
     *
     * @param exportMetadataModelAssessmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.ExportMetadataModelAssessmentRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ExportMetadataModelAssessment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.ExportMetadataModelAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ExportMetadataModelAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExportMetadataModelAssessmentResponse> exportMetadataModelAssessment(
            Consumer<ExportMetadataModelAssessmentRequest.Builder> exportMetadataModelAssessmentRequest) {
        return exportMetadataModelAssessment(ExportMetadataModelAssessmentRequest.builder()
                .applyMutation(exportMetadataModelAssessmentRequest).build());
    }

    /**
     * <p>
     * Uploads the specified certificate.
     * </p>
     *
     * @param importCertificateRequest
     * @return A Java Future containing the result of the ImportCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>InvalidCertificateException The certificate was not valid.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.ImportCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ImportCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ImportCertificateResponse> importCertificate(ImportCertificateRequest importCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Uploads the specified certificate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportCertificateRequest.Builder} avoiding the need
     * to create one manually via {@link ImportCertificateRequest#builder()}
     * </p>
     *
     * @param importCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.ImportCertificateRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ImportCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>InvalidCertificateException The certificate was not valid.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.ImportCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ImportCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ImportCertificateResponse> importCertificate(
            Consumer<ImportCertificateRequest.Builder> importCertificateRequest) {
        return importCertificate(ImportCertificateRequest.builder().applyMutation(importCertificateRequest).build());
    }

    /**
     * <p>
     * Lists all metadata tags attached to an DMS resource, including replication instance, endpoint, subnet group, and
     * migration task. For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html"> <code>Tag</code> </a> data type
     * description.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all metadata tags attached to an DMS resource, including replication instance, endpoint, subnet group, and
     * migration task. For more information, see <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html"> <code>Tag</code> </a> data type
     * description.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Modifies the specified schema conversion configuration using the provided parameters.
     * </p>
     *
     * @param modifyConversionConfigurationRequest
     * @return A Java Future containing the result of the ModifyConversionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.ModifyConversionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyConversionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyConversionConfigurationResponse> modifyConversionConfiguration(
            ModifyConversionConfigurationRequest modifyConversionConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the specified schema conversion configuration using the provided parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyConversionConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link ModifyConversionConfigurationRequest#builder()}
     * </p>
     *
     * @param modifyConversionConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.ModifyConversionConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ModifyConversionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.ModifyConversionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyConversionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyConversionConfigurationResponse> modifyConversionConfiguration(
            Consumer<ModifyConversionConfigurationRequest.Builder> modifyConversionConfigurationRequest) {
        return modifyConversionConfiguration(ModifyConversionConfigurationRequest.builder()
                .applyMutation(modifyConversionConfigurationRequest).build());
    }

    /**
     * <p>
     * Modifies an existing DMS data migration.
     * </p>
     *
     * @param modifyDataMigrationRequest
     * @return A Java Future containing the result of the ModifyDataMigration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.ModifyDataMigration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyDataMigration" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ModifyDataMigrationResponse> modifyDataMigration(
            ModifyDataMigrationRequest modifyDataMigrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies an existing DMS data migration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyDataMigrationRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyDataMigrationRequest#builder()}
     * </p>
     *
     * @param modifyDataMigrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.ModifyDataMigrationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ModifyDataMigration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.ModifyDataMigration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyDataMigration" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ModifyDataMigrationResponse> modifyDataMigration(
            Consumer<ModifyDataMigrationRequest.Builder> modifyDataMigrationRequest) {
        return modifyDataMigration(ModifyDataMigrationRequest.builder().applyMutation(modifyDataMigrationRequest).build());
    }

    /**
     * <p>
     * Modifies the specified data provider using the provided settings.
     * </p>
     * <note>
     * <p>
     * You must remove the data provider from all migration projects before you can modify it.
     * </p>
     * </note>
     *
     * @param modifyDataProviderRequest
     * @return A Java Future containing the result of the ModifyDataProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.ModifyDataProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyDataProvider" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ModifyDataProviderResponse> modifyDataProvider(ModifyDataProviderRequest modifyDataProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the specified data provider using the provided settings.
     * </p>
     * <note>
     * <p>
     * You must remove the data provider from all migration projects before you can modify it.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyDataProviderRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyDataProviderRequest#builder()}
     * </p>
     *
     * @param modifyDataProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.ModifyDataProviderRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ModifyDataProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.ModifyDataProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyDataProvider" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ModifyDataProviderResponse> modifyDataProvider(
            Consumer<ModifyDataProviderRequest.Builder> modifyDataProviderRequest) {
        return modifyDataProvider(ModifyDataProviderRequest.builder().applyMutation(modifyDataProviderRequest).build());
    }

    /**
     * <p>
     * Modifies the specified endpoint.
     * </p>
     * <note>
     * <p>
     * For a MySQL source or target endpoint, don't explicitly specify the database using the <code>DatabaseName</code>
     * request parameter on the <code>ModifyEndpoint</code> API call. Specifying <code>DatabaseName</code> when you
     * modify a MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify
     * the database only when you specify the schema in the table-mapping rules of the DMS task.
     * </p>
     * </note>
     *
     * @param modifyEndpointRequest
     * @return A Java Future containing the result of the ModifyEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.ModifyEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ModifyEndpointResponse> modifyEndpoint(ModifyEndpointRequest modifyEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the specified endpoint.
     * </p>
     * <note>
     * <p>
     * For a MySQL source or target endpoint, don't explicitly specify the database using the <code>DatabaseName</code>
     * request parameter on the <code>ModifyEndpoint</code> API call. Specifying <code>DatabaseName</code> when you
     * modify a MySQL endpoint replicates all the task tables to this single database. For MySQL endpoints, you specify
     * the database only when you specify the schema in the table-mapping rules of the DMS task.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link ModifyEndpointRequest#builder()}
     * </p>
     *
     * @param modifyEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.ModifyEndpointRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ModifyEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.ModifyEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ModifyEndpointResponse> modifyEndpoint(Consumer<ModifyEndpointRequest.Builder> modifyEndpointRequest) {
        return modifyEndpoint(ModifyEndpointRequest.builder().applyMutation(modifyEndpointRequest).build());
    }

    /**
     * <p>
     * Modifies an existing DMS event notification subscription.
     * </p>
     *
     * @param modifyEventSubscriptionRequest
     * @return A Java Future containing the result of the ModifyEventSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SnsInvalidTopicException The SNS topic is invalid.</li>
     *         <li>SnsNoAuthorizationException You are not authorized for the SNS subscription.</li>
     *         <li>KmsAccessDeniedException The ciphertext references a key that doesn't exist or that the DMS account
     *         doesn't have access to.</li>
     *         <li>KmsDisabledException The specified KMS key isn't enabled.</li>
     *         <li>KmsInvalidStateException The state of the specified KMS resource isn't valid for this request.</li>
     *         <li>KmsNotFoundException The specified KMS entity or resource can't be found.</li>
     *         <li>KmsThrottlingException This request triggered KMS request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.ModifyEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ModifyEventSubscriptionResponse> modifyEventSubscription(
            ModifyEventSubscriptionRequest modifyEventSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies an existing DMS event notification subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyEventSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link ModifyEventSubscriptionRequest#builder()}
     * </p>
     *
     * @param modifyEventSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.ModifyEventSubscriptionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ModifyEventSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SnsInvalidTopicException The SNS topic is invalid.</li>
     *         <li>SnsNoAuthorizationException You are not authorized for the SNS subscription.</li>
     *         <li>KmsAccessDeniedException The ciphertext references a key that doesn't exist or that the DMS account
     *         doesn't have access to.</li>
     *         <li>KmsDisabledException The specified KMS key isn't enabled.</li>
     *         <li>KmsInvalidStateException The state of the specified KMS resource isn't valid for this request.</li>
     *         <li>KmsNotFoundException The specified KMS entity or resource can't be found.</li>
     *         <li>KmsThrottlingException This request triggered KMS request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.ModifyEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ModifyEventSubscriptionResponse> modifyEventSubscription(
            Consumer<ModifyEventSubscriptionRequest.Builder> modifyEventSubscriptionRequest) {
        return modifyEventSubscription(ModifyEventSubscriptionRequest.builder().applyMutation(modifyEventSubscriptionRequest)
                .build());
    }

    /**
     * <p>
     * Modifies the specified instance profile using the provided parameters.
     * </p>
     * <note>
     * <p>
     * All migration projects associated with the instance profile must be deleted or modified before you can modify the
     * instance profile.
     * </p>
     * </note>
     *
     * @param modifyInstanceProfileRequest
     * @return A Java Future containing the result of the ModifyInstanceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>S3ResourceNotFoundException A specified Amazon S3 bucket, bucket folder, or other object can't be
     *         found.</li>
     *         <li>S3AccessDeniedException Insufficient privileges are preventing access to an Amazon S3 object.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.ModifyInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyInstanceProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ModifyInstanceProfileResponse> modifyInstanceProfile(
            ModifyInstanceProfileRequest modifyInstanceProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the specified instance profile using the provided parameters.
     * </p>
     * <note>
     * <p>
     * All migration projects associated with the instance profile must be deleted or modified before you can modify the
     * instance profile.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyInstanceProfileRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyInstanceProfileRequest#builder()}
     * </p>
     *
     * @param modifyInstanceProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.ModifyInstanceProfileRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ModifyInstanceProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>S3ResourceNotFoundException A specified Amazon S3 bucket, bucket folder, or other object can't be
     *         found.</li>
     *         <li>S3AccessDeniedException Insufficient privileges are preventing access to an Amazon S3 object.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.ModifyInstanceProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyInstanceProfile" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ModifyInstanceProfileResponse> modifyInstanceProfile(
            Consumer<ModifyInstanceProfileRequest.Builder> modifyInstanceProfileRequest) {
        return modifyInstanceProfile(ModifyInstanceProfileRequest.builder().applyMutation(modifyInstanceProfileRequest).build());
    }

    /**
     * <p>
     * Modifies the specified migration project using the provided parameters.
     * </p>
     * <note>
     * <p>
     * The migration project must be closed before you can modify it.
     * </p>
     * </note>
     *
     * @param modifyMigrationProjectRequest
     * @return A Java Future containing the result of the ModifyMigrationProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>S3ResourceNotFoundException A specified Amazon S3 bucket, bucket folder, or other object can't be
     *         found.</li>
     *         <li>S3AccessDeniedException Insufficient privileges are preventing access to an Amazon S3 object.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.ModifyMigrationProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyMigrationProject" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ModifyMigrationProjectResponse> modifyMigrationProject(
            ModifyMigrationProjectRequest modifyMigrationProjectRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the specified migration project using the provided parameters.
     * </p>
     * <note>
     * <p>
     * The migration project must be closed before you can modify it.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyMigrationProjectRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyMigrationProjectRequest#builder()}
     * </p>
     *
     * @param modifyMigrationProjectRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.ModifyMigrationProjectRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ModifyMigrationProject operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>S3ResourceNotFoundException A specified Amazon S3 bucket, bucket folder, or other object can't be
     *         found.</li>
     *         <li>S3AccessDeniedException Insufficient privileges are preventing access to an Amazon S3 object.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.ModifyMigrationProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyMigrationProject" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ModifyMigrationProjectResponse> modifyMigrationProject(
            Consumer<ModifyMigrationProjectRequest.Builder> modifyMigrationProjectRequest) {
        return modifyMigrationProject(ModifyMigrationProjectRequest.builder().applyMutation(modifyMigrationProjectRequest)
                .build());
    }

    /**
     * <p>
     * Modifies an existing DMS Serverless replication configuration that you can use to start a replication. This
     * command includes input validation and logic to check the state of any replication that uses this configuration.
     * You can only modify a replication configuration before any replication that uses it has started. As soon as you
     * have initially started a replication with a given configuiration, you can't modify that configuration, even if
     * you stop it.
     * </p>
     * <p>
     * Other run statuses that allow you to run this command include FAILED and CREATED. A provisioning state that
     * allows you to run this command is FAILED_PROVISION.
     * </p>
     *
     * @param modifyReplicationConfigRequest
     * @return A Java Future containing the result of the ModifyReplicationConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ReplicationSubnetGroupDoesNotCoverEnoughAZsException The replication subnet group does not cover
     *         enough Availability Zones (AZs). Edit the replication subnet group and add more AZs.</li>
     *         <li>InvalidSubnetException The subnet provided isn't valid.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.ModifyReplicationConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ModifyReplicationConfigResponse> modifyReplicationConfig(
            ModifyReplicationConfigRequest modifyReplicationConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies an existing DMS Serverless replication configuration that you can use to start a replication. This
     * command includes input validation and logic to check the state of any replication that uses this configuration.
     * You can only modify a replication configuration before any replication that uses it has started. As soon as you
     * have initially started a replication with a given configuiration, you can't modify that configuration, even if
     * you stop it.
     * </p>
     * <p>
     * Other run statuses that allow you to run this command include FAILED and CREATED. A provisioning state that
     * allows you to run this command is FAILED_PROVISION.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyReplicationConfigRequest.Builder} avoiding
     * the need to create one manually via {@link ModifyReplicationConfigRequest#builder()}
     * </p>
     *
     * @param modifyReplicationConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.ModifyReplicationConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ModifyReplicationConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ReplicationSubnetGroupDoesNotCoverEnoughAZsException The replication subnet group does not cover
     *         enough Availability Zones (AZs). Edit the replication subnet group and add more AZs.</li>
     *         <li>InvalidSubnetException The subnet provided isn't valid.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.ModifyReplicationConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationConfig" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ModifyReplicationConfigResponse> modifyReplicationConfig(
            Consumer<ModifyReplicationConfigRequest.Builder> modifyReplicationConfigRequest) {
        return modifyReplicationConfig(ModifyReplicationConfigRequest.builder().applyMutation(modifyReplicationConfigRequest)
                .build());
    }

    /**
     * <p>
     * Modifies the replication instance to apply new settings. You can change one or more parameters by specifying
     * these parameters and the new values in the request.
     * </p>
     * <p>
     * Some settings are applied during the maintenance window.
     * </p>
     * <p/>
     *
     * @param modifyReplicationInstanceRequest
     * @return A Java Future containing the result of the ModifyReplicationInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li> <li>InvalidResourceStateException The resource is in a state that prevents it from being
     *         used for database migration.</li> <li>ResourceAlreadyExistsException The resource you are attempting to
     *         create already exists.</li> <li>ResourceNotFoundException The resource could not be found.</li> <li>
     *         InsufficientResourceCapacityException There are not enough resources allocated to the database migration.
     *         </li> <li>StorageQuotaExceededException The storage quota has been exceeded.</li> <li>
     *         UpgradeDependencyFailureException An upgrade dependency is preventing the database migration.</li> <li>
     *         SdkException Base class for all exceptions that can be thrown by the SDK (both service and client). Can
     *         be used for catch all scenarios.</li> <li>SdkClientException If any client side error occurs such as an
     *         IO related failure, failure to get credentials, etc.</li> <li>DatabaseMigrationException Base class for
     *         all service exceptions. Unknown exceptions will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.ModifyReplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ModifyReplicationInstanceResponse> modifyReplicationInstance(
            ModifyReplicationInstanceRequest modifyReplicationInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the replication instance to apply new settings. You can change one or more parameters by specifying
     * these parameters and the new values in the request.
     * </p>
     * <p>
     * Some settings are applied during the maintenance window.
     * </p>
     * <p/>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyReplicationInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link ModifyReplicationInstanceRequest#builder()}
     * </p>
     *
     * @param modifyReplicationInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.ModifyReplicationInstanceRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ModifyReplicationInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InsufficientResourceCapacityException There are not enough resources allocated to the database
     *         migration.</li>
     *         <li>StorageQuotaExceededException The storage quota has been exceeded.</li>
     *         <li>UpgradeDependencyFailureException An upgrade dependency is preventing the database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.ModifyReplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ModifyReplicationInstanceResponse> modifyReplicationInstance(
            Consumer<ModifyReplicationInstanceRequest.Builder> modifyReplicationInstanceRequest) {
        return modifyReplicationInstance(ModifyReplicationInstanceRequest.builder()
                .applyMutation(modifyReplicationInstanceRequest).build());
    }

    /**
     * <p>
     * Modifies the settings for the specified replication subnet group.
     * </p>
     *
     * @param modifyReplicationSubnetGroupRequest
     * @return A Java Future containing the result of the ModifyReplicationSubnetGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>SubnetAlreadyInUseException The specified subnet is already in use.</li>
     *         <li>ReplicationSubnetGroupDoesNotCoverEnoughAZsException The replication subnet group does not cover
     *         enough Availability Zones (AZs). Edit the replication subnet group and add more AZs.</li>
     *         <li>InvalidSubnetException The subnet provided isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.ModifyReplicationSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyReplicationSubnetGroupResponse> modifyReplicationSubnetGroup(
            ModifyReplicationSubnetGroupRequest modifyReplicationSubnetGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the settings for the specified replication subnet group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyReplicationSubnetGroupRequest.Builder}
     * avoiding the need to create one manually via {@link ModifyReplicationSubnetGroupRequest#builder()}
     * </p>
     *
     * @param modifyReplicationSubnetGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.ModifyReplicationSubnetGroupRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ModifyReplicationSubnetGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>SubnetAlreadyInUseException The specified subnet is already in use.</li>
     *         <li>ReplicationSubnetGroupDoesNotCoverEnoughAZsException The replication subnet group does not cover
     *         enough Availability Zones (AZs). Edit the replication subnet group and add more AZs.</li>
     *         <li>InvalidSubnetException The subnet provided isn't valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.ModifyReplicationSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationSubnetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ModifyReplicationSubnetGroupResponse> modifyReplicationSubnetGroup(
            Consumer<ModifyReplicationSubnetGroupRequest.Builder> modifyReplicationSubnetGroupRequest) {
        return modifyReplicationSubnetGroup(ModifyReplicationSubnetGroupRequest.builder()
                .applyMutation(modifyReplicationSubnetGroupRequest).build());
    }

    /**
     * <p>
     * Modifies the specified replication task.
     * </p>
     * <p>
     * You can't modify the task endpoints. The task must be stopped before you can modify it.
     * </p>
     * <p>
     * For more information about DMS tasks, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html">Working with Migration Tasks</a> in the
     * <i>Database Migration Service User Guide</i>.
     * </p>
     *
     * @param modifyReplicationTaskRequest
     * @return A Java Future containing the result of the ModifyReplicationTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.ModifyReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ModifyReplicationTaskResponse> modifyReplicationTask(
            ModifyReplicationTaskRequest modifyReplicationTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the specified replication task.
     * </p>
     * <p>
     * You can't modify the task endpoints. The task must be stopped before you can modify it.
     * </p>
     * <p>
     * For more information about DMS tasks, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html">Working with Migration Tasks</a> in the
     * <i>Database Migration Service User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyReplicationTaskRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyReplicationTaskRequest#builder()}
     * </p>
     *
     * @param modifyReplicationTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.ModifyReplicationTaskRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ModifyReplicationTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.ModifyReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ModifyReplicationTaskResponse> modifyReplicationTask(
            Consumer<ModifyReplicationTaskRequest.Builder> modifyReplicationTaskRequest) {
        return modifyReplicationTask(ModifyReplicationTaskRequest.builder().applyMutation(modifyReplicationTaskRequest).build());
    }

    /**
     * <p>
     * Moves a replication task from its current replication instance to a different target replication instance using
     * the specified parameters. The target replication instance must be created with the same or later DMS version as
     * the current replication instance.
     * </p>
     *
     * @param moveReplicationTaskRequest
     * @return A Java Future containing the result of the MoveReplicationTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.MoveReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/MoveReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<MoveReplicationTaskResponse> moveReplicationTask(
            MoveReplicationTaskRequest moveReplicationTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Moves a replication task from its current replication instance to a different target replication instance using
     * the specified parameters. The target replication instance must be created with the same or later DMS version as
     * the current replication instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link MoveReplicationTaskRequest.Builder} avoiding the
     * need to create one manually via {@link MoveReplicationTaskRequest#builder()}
     * </p>
     *
     * @param moveReplicationTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.MoveReplicationTaskRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the MoveReplicationTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.MoveReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/MoveReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<MoveReplicationTaskResponse> moveReplicationTask(
            Consumer<MoveReplicationTaskRequest.Builder> moveReplicationTaskRequest) {
        return moveReplicationTask(MoveReplicationTaskRequest.builder().applyMutation(moveReplicationTaskRequest).build());
    }

    /**
     * <p>
     * Reboots a replication instance. Rebooting results in a momentary outage, until the replication instance becomes
     * available again.
     * </p>
     *
     * @param rebootReplicationInstanceRequest
     * @return A Java Future containing the result of the RebootReplicationInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.RebootReplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RebootReplicationInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RebootReplicationInstanceResponse> rebootReplicationInstance(
            RebootReplicationInstanceRequest rebootReplicationInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reboots a replication instance. Rebooting results in a momentary outage, until the replication instance becomes
     * available again.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RebootReplicationInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link RebootReplicationInstanceRequest#builder()}
     * </p>
     *
     * @param rebootReplicationInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.RebootReplicationInstanceRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the RebootReplicationInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.RebootReplicationInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RebootReplicationInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RebootReplicationInstanceResponse> rebootReplicationInstance(
            Consumer<RebootReplicationInstanceRequest.Builder> rebootReplicationInstanceRequest) {
        return rebootReplicationInstance(RebootReplicationInstanceRequest.builder()
                .applyMutation(rebootReplicationInstanceRequest).build());
    }

    /**
     * <p>
     * Populates the schema for the specified endpoint. This is an asynchronous operation and can take several minutes.
     * You can check the status of this operation by calling the DescribeRefreshSchemasStatus operation.
     * </p>
     *
     * @param refreshSchemasRequest
     * @return A Java Future containing the result of the RefreshSchemas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.RefreshSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RefreshSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RefreshSchemasResponse> refreshSchemas(RefreshSchemasRequest refreshSchemasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Populates the schema for the specified endpoint. This is an asynchronous operation and can take several minutes.
     * You can check the status of this operation by calling the DescribeRefreshSchemasStatus operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RefreshSchemasRequest.Builder} avoiding the need to
     * create one manually via {@link RefreshSchemasRequest#builder()}
     * </p>
     *
     * @param refreshSchemasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.RefreshSchemasRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RefreshSchemas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.RefreshSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RefreshSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RefreshSchemasResponse> refreshSchemas(Consumer<RefreshSchemasRequest.Builder> refreshSchemasRequest) {
        return refreshSchemas(RefreshSchemasRequest.builder().applyMutation(refreshSchemasRequest).build());
    }

    /**
     * <p>
     * Reloads the target database table with the source data for a given DMS Serverless replication configuration.
     * </p>
     * <p>
     * You can only use this operation with a task in the RUNNING state, otherwise the service will throw an
     * <code>InvalidResourceStateFault</code> exception.
     * </p>
     *
     * @param reloadReplicationTablesRequest
     * @return A Java Future containing the result of the ReloadReplicationTables operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.ReloadReplicationTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ReloadReplicationTables" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ReloadReplicationTablesResponse> reloadReplicationTables(
            ReloadReplicationTablesRequest reloadReplicationTablesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reloads the target database table with the source data for a given DMS Serverless replication configuration.
     * </p>
     * <p>
     * You can only use this operation with a task in the RUNNING state, otherwise the service will throw an
     * <code>InvalidResourceStateFault</code> exception.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ReloadReplicationTablesRequest.Builder} avoiding
     * the need to create one manually via {@link ReloadReplicationTablesRequest#builder()}
     * </p>
     *
     * @param reloadReplicationTablesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.ReloadReplicationTablesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ReloadReplicationTables operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.ReloadReplicationTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ReloadReplicationTables" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ReloadReplicationTablesResponse> reloadReplicationTables(
            Consumer<ReloadReplicationTablesRequest.Builder> reloadReplicationTablesRequest) {
        return reloadReplicationTables(ReloadReplicationTablesRequest.builder().applyMutation(reloadReplicationTablesRequest)
                .build());
    }

    /**
     * <p>
     * Reloads the target database table with the source data.
     * </p>
     * <p>
     * You can only use this operation with a task in the <code>RUNNING</code> state, otherwise the service will throw
     * an <code>InvalidResourceStateFault</code> exception.
     * </p>
     *
     * @param reloadTablesRequest
     * @return A Java Future containing the result of the ReloadTables operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.ReloadTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ReloadTables" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ReloadTablesResponse> reloadTables(ReloadTablesRequest reloadTablesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reloads the target database table with the source data.
     * </p>
     * <p>
     * You can only use this operation with a task in the <code>RUNNING</code> state, otherwise the service will throw
     * an <code>InvalidResourceStateFault</code> exception.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ReloadTablesRequest.Builder} avoiding the need to
     * create one manually via {@link ReloadTablesRequest#builder()}
     * </p>
     *
     * @param reloadTablesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.ReloadTablesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ReloadTables operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.ReloadTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ReloadTables" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ReloadTablesResponse> reloadTables(Consumer<ReloadTablesRequest.Builder> reloadTablesRequest) {
        return reloadTables(ReloadTablesRequest.builder().applyMutation(reloadTablesRequest).build());
    }

    /**
     * <p>
     * Removes metadata tags from an DMS resource, including replication instance, endpoint, subnet group, and migration
     * task. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html">
     * <code>Tag</code> </a> data type description.
     * </p>
     *
     * @param removeTagsFromResourceRequest
     *        Removes one or more tags from an DMS resource.
     * @return A Java Future containing the result of the RemoveTagsFromResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.RemoveTagsFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RemoveTagsFromResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RemoveTagsFromResourceResponse> removeTagsFromResource(
            RemoveTagsFromResourceRequest removeTagsFromResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes metadata tags from an DMS resource, including replication instance, endpoint, subnet group, and migration
     * task. For more information, see <a href="https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html">
     * <code>Tag</code> </a> data type description.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveTagsFromResourceRequest.Builder} avoiding the
     * need to create one manually via {@link RemoveTagsFromResourceRequest#builder()}
     * </p>
     *
     * @param removeTagsFromResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.RemoveTagsFromResourceRequest.Builder} to
     *        create a request. Removes one or more tags from an DMS resource.
     * @return A Java Future containing the result of the RemoveTagsFromResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.RemoveTagsFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RemoveTagsFromResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RemoveTagsFromResourceResponse> removeTagsFromResource(
            Consumer<RemoveTagsFromResourceRequest.Builder> removeTagsFromResourceRequest) {
        return removeTagsFromResource(RemoveTagsFromResourceRequest.builder().applyMutation(removeTagsFromResourceRequest)
                .build());
    }

    /**
     * <p>
     * Runs large-scale assessment (LSA) analysis on every Fleet Advisor collector in your account.
     * </p>
     *
     * @param runFleetAdvisorLsaAnalysisRequest
     * @return A Java Future containing the result of the RunFleetAdvisorLsaAnalysis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.RunFleetAdvisorLsaAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RunFleetAdvisorLsaAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RunFleetAdvisorLsaAnalysisResponse> runFleetAdvisorLsaAnalysis(
            RunFleetAdvisorLsaAnalysisRequest runFleetAdvisorLsaAnalysisRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Runs large-scale assessment (LSA) analysis on every Fleet Advisor collector in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RunFleetAdvisorLsaAnalysisRequest.Builder} avoiding
     * the need to create one manually via {@link RunFleetAdvisorLsaAnalysisRequest#builder()}
     * </p>
     *
     * @param runFleetAdvisorLsaAnalysisRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.RunFleetAdvisorLsaAnalysisRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the RunFleetAdvisorLsaAnalysis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.RunFleetAdvisorLsaAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RunFleetAdvisorLsaAnalysis"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RunFleetAdvisorLsaAnalysisResponse> runFleetAdvisorLsaAnalysis(
            Consumer<RunFleetAdvisorLsaAnalysisRequest.Builder> runFleetAdvisorLsaAnalysisRequest) {
        return runFleetAdvisorLsaAnalysis(RunFleetAdvisorLsaAnalysisRequest.builder()
                .applyMutation(runFleetAdvisorLsaAnalysisRequest).build());
    }

    /**
     * <p>
     * Starts the specified data migration.
     * </p>
     *
     * @param startDataMigrationRequest
     * @return A Java Future containing the result of the StartDataMigration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>InvalidOperationException The action or operation requested isn't valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.StartDataMigration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartDataMigration" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartDataMigrationResponse> startDataMigration(StartDataMigrationRequest startDataMigrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the specified data migration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDataMigrationRequest.Builder} avoiding the
     * need to create one manually via {@link StartDataMigrationRequest#builder()}
     * </p>
     *
     * @param startDataMigrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.StartDataMigrationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StartDataMigration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>InvalidOperationException The action or operation requested isn't valid.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.StartDataMigration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartDataMigration" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartDataMigrationResponse> startDataMigration(
            Consumer<StartDataMigrationRequest.Builder> startDataMigrationRequest) {
        return startDataMigration(StartDataMigrationRequest.builder().applyMutation(startDataMigrationRequest).build());
    }

    /**
     * <p>
     * Applies the extension pack to your target database. An extension pack is an add-on module that emulates functions
     * present in a source database that are required when converting objects to the target database.
     * </p>
     *
     * @param startExtensionPackAssociationRequest
     * @return A Java Future containing the result of the StartExtensionPackAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>S3ResourceNotFoundException A specified Amazon S3 bucket, bucket folder, or other object can't be
     *         found.</li>
     *         <li>S3AccessDeniedException Insufficient privileges are preventing access to an Amazon S3 object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.StartExtensionPackAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartExtensionPackAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartExtensionPackAssociationResponse> startExtensionPackAssociation(
            StartExtensionPackAssociationRequest startExtensionPackAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies the extension pack to your target database. An extension pack is an add-on module that emulates functions
     * present in a source database that are required when converting objects to the target database.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartExtensionPackAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link StartExtensionPackAssociationRequest#builder()}
     * </p>
     *
     * @param startExtensionPackAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.StartExtensionPackAssociationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the StartExtensionPackAssociation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>S3ResourceNotFoundException A specified Amazon S3 bucket, bucket folder, or other object can't be
     *         found.</li>
     *         <li>S3AccessDeniedException Insufficient privileges are preventing access to an Amazon S3 object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.StartExtensionPackAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartExtensionPackAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartExtensionPackAssociationResponse> startExtensionPackAssociation(
            Consumer<StartExtensionPackAssociationRequest.Builder> startExtensionPackAssociationRequest) {
        return startExtensionPackAssociation(StartExtensionPackAssociationRequest.builder()
                .applyMutation(startExtensionPackAssociationRequest).build());
    }

    /**
     * <p>
     * Creates a database migration assessment report by assessing the migration complexity for your source database. A
     * database migration assessment report summarizes all of the schema conversion tasks. It also details the action
     * items for database objects that can't be converted to the database engine of your target database instance.
     * </p>
     *
     * @param startMetadataModelAssessmentRequest
     * @return A Java Future containing the result of the StartMetadataModelAssessment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>S3ResourceNotFoundException A specified Amazon S3 bucket, bucket folder, or other object can't be
     *         found.</li>
     *         <li>S3AccessDeniedException Insufficient privileges are preventing access to an Amazon S3 object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.StartMetadataModelAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartMetadataModelAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartMetadataModelAssessmentResponse> startMetadataModelAssessment(
            StartMetadataModelAssessmentRequest startMetadataModelAssessmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a database migration assessment report by assessing the migration complexity for your source database. A
     * database migration assessment report summarizes all of the schema conversion tasks. It also details the action
     * items for database objects that can't be converted to the database engine of your target database instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMetadataModelAssessmentRequest.Builder}
     * avoiding the need to create one manually via {@link StartMetadataModelAssessmentRequest#builder()}
     * </p>
     *
     * @param startMetadataModelAssessmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.StartMetadataModelAssessmentRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the StartMetadataModelAssessment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>S3ResourceNotFoundException A specified Amazon S3 bucket, bucket folder, or other object can't be
     *         found.</li>
     *         <li>S3AccessDeniedException Insufficient privileges are preventing access to an Amazon S3 object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.StartMetadataModelAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartMetadataModelAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartMetadataModelAssessmentResponse> startMetadataModelAssessment(
            Consumer<StartMetadataModelAssessmentRequest.Builder> startMetadataModelAssessmentRequest) {
        return startMetadataModelAssessment(StartMetadataModelAssessmentRequest.builder()
                .applyMutation(startMetadataModelAssessmentRequest).build());
    }

    /**
     * <p>
     * Converts your source database objects to a format compatible with the target database.
     * </p>
     *
     * @param startMetadataModelConversionRequest
     * @return A Java Future containing the result of the StartMetadataModelConversion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>S3ResourceNotFoundException A specified Amazon S3 bucket, bucket folder, or other object can't be
     *         found.</li>
     *         <li>S3AccessDeniedException Insufficient privileges are preventing access to an Amazon S3 object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.StartMetadataModelConversion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartMetadataModelConversion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartMetadataModelConversionResponse> startMetadataModelConversion(
            StartMetadataModelConversionRequest startMetadataModelConversionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Converts your source database objects to a format compatible with the target database.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMetadataModelConversionRequest.Builder}
     * avoiding the need to create one manually via {@link StartMetadataModelConversionRequest#builder()}
     * </p>
     *
     * @param startMetadataModelConversionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.StartMetadataModelConversionRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the StartMetadataModelConversion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>S3ResourceNotFoundException A specified Amazon S3 bucket, bucket folder, or other object can't be
     *         found.</li>
     *         <li>S3AccessDeniedException Insufficient privileges are preventing access to an Amazon S3 object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.StartMetadataModelConversion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartMetadataModelConversion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartMetadataModelConversionResponse> startMetadataModelConversion(
            Consumer<StartMetadataModelConversionRequest.Builder> startMetadataModelConversionRequest) {
        return startMetadataModelConversion(StartMetadataModelConversionRequest.builder()
                .applyMutation(startMetadataModelConversionRequest).build());
    }

    /**
     * <p>
     * Saves your converted code to a file as a SQL script, and stores this file on your Amazon S3 bucket.
     * </p>
     *
     * @param startMetadataModelExportAsScriptRequest
     * @return A Java Future containing the result of the StartMetadataModelExportAsScript operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>S3ResourceNotFoundException A specified Amazon S3 bucket, bucket folder, or other object can't be
     *         found.</li>
     *         <li>S3AccessDeniedException Insufficient privileges are preventing access to an Amazon S3 object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.StartMetadataModelExportAsScript
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartMetadataModelExportAsScript"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartMetadataModelExportAsScriptResponse> startMetadataModelExportAsScript(
            StartMetadataModelExportAsScriptRequest startMetadataModelExportAsScriptRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Saves your converted code to a file as a SQL script, and stores this file on your Amazon S3 bucket.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMetadataModelExportAsScriptRequest.Builder}
     * avoiding the need to create one manually via {@link StartMetadataModelExportAsScriptRequest#builder()}
     * </p>
     *
     * @param startMetadataModelExportAsScriptRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportAsScriptRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the StartMetadataModelExportAsScript operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>S3ResourceNotFoundException A specified Amazon S3 bucket, bucket folder, or other object can't be
     *         found.</li>
     *         <li>S3AccessDeniedException Insufficient privileges are preventing access to an Amazon S3 object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.StartMetadataModelExportAsScript
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartMetadataModelExportAsScript"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartMetadataModelExportAsScriptResponse> startMetadataModelExportAsScript(
            Consumer<StartMetadataModelExportAsScriptRequest.Builder> startMetadataModelExportAsScriptRequest) {
        return startMetadataModelExportAsScript(StartMetadataModelExportAsScriptRequest.builder()
                .applyMutation(startMetadataModelExportAsScriptRequest).build());
    }

    /**
     * <p>
     * Applies converted database objects to your target database.
     * </p>
     *
     * @param startMetadataModelExportToTargetRequest
     * @return A Java Future containing the result of the StartMetadataModelExportToTarget operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>S3ResourceNotFoundException A specified Amazon S3 bucket, bucket folder, or other object can't be
     *         found.</li>
     *         <li>S3AccessDeniedException Insufficient privileges are preventing access to an Amazon S3 object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.StartMetadataModelExportToTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartMetadataModelExportToTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartMetadataModelExportToTargetResponse> startMetadataModelExportToTarget(
            StartMetadataModelExportToTargetRequest startMetadataModelExportToTargetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies converted database objects to your target database.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMetadataModelExportToTargetRequest.Builder}
     * avoiding the need to create one manually via {@link StartMetadataModelExportToTargetRequest#builder()}
     * </p>
     *
     * @param startMetadataModelExportToTargetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.StartMetadataModelExportToTargetRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the StartMetadataModelExportToTarget operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>S3ResourceNotFoundException A specified Amazon S3 bucket, bucket folder, or other object can't be
     *         found.</li>
     *         <li>S3AccessDeniedException Insufficient privileges are preventing access to an Amazon S3 object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.StartMetadataModelExportToTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartMetadataModelExportToTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartMetadataModelExportToTargetResponse> startMetadataModelExportToTarget(
            Consumer<StartMetadataModelExportToTargetRequest.Builder> startMetadataModelExportToTargetRequest) {
        return startMetadataModelExportToTarget(StartMetadataModelExportToTargetRequest.builder()
                .applyMutation(startMetadataModelExportToTargetRequest).build());
    }

    /**
     * <p>
     * Loads the metadata for all the dependent database objects of the parent object.
     * </p>
     * <p>
     * This operation uses your project's Amazon S3 bucket as a metadata cache to improve performance.
     * </p>
     *
     * @param startMetadataModelImportRequest
     * @return A Java Future containing the result of the StartMetadataModelImport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>S3ResourceNotFoundException A specified Amazon S3 bucket, bucket folder, or other object can't be
     *         found.</li>
     *         <li>S3AccessDeniedException Insufficient privileges are preventing access to an Amazon S3 object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.StartMetadataModelImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartMetadataModelImport" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartMetadataModelImportResponse> startMetadataModelImport(
            StartMetadataModelImportRequest startMetadataModelImportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Loads the metadata for all the dependent database objects of the parent object.
     * </p>
     * <p>
     * This operation uses your project's Amazon S3 bucket as a metadata cache to improve performance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMetadataModelImportRequest.Builder} avoiding
     * the need to create one manually via {@link StartMetadataModelImportRequest#builder()}
     * </p>
     *
     * @param startMetadataModelImportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.StartMetadataModelImportRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StartMetadataModelImport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>ResourceQuotaExceededException The quota for this resource quota has been exceeded.</li>
     *         <li>S3ResourceNotFoundException A specified Amazon S3 bucket, bucket folder, or other object can't be
     *         found.</li>
     *         <li>S3AccessDeniedException Insufficient privileges are preventing access to an Amazon S3 object.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.StartMetadataModelImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartMetadataModelImport" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartMetadataModelImportResponse> startMetadataModelImport(
            Consumer<StartMetadataModelImportRequest.Builder> startMetadataModelImportRequest) {
        return startMetadataModelImport(StartMetadataModelImportRequest.builder().applyMutation(startMetadataModelImportRequest)
                .build());
    }

    /**
     * <p>
     * Starts the analysis of your source database to provide recommendations of target engines.
     * </p>
     * <p>
     * You can create recommendations for multiple source databases using <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_BatchStartRecommendations.html"
     * >BatchStartRecommendations</a>.
     * </p>
     *
     * @param startRecommendationsRequest
     * @return A Java Future containing the result of the StartRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.StartRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartRecommendations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartRecommendationsResponse> startRecommendations(
            StartRecommendationsRequest startRecommendationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the analysis of your source database to provide recommendations of target engines.
     * </p>
     * <p>
     * You can create recommendations for multiple source databases using <a
     * href="https://docs.aws.amazon.com/dms/latest/APIReference/API_BatchStartRecommendations.html"
     * >BatchStartRecommendations</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartRecommendationsRequest.Builder} avoiding the
     * need to create one manually via {@link StartRecommendationsRequest#builder()}
     * </p>
     *
     * @param startRecommendationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.StartRecommendationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StartRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.StartRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartRecommendations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartRecommendationsResponse> startRecommendations(
            Consumer<StartRecommendationsRequest.Builder> startRecommendationsRequest) {
        return startRecommendations(StartRecommendationsRequest.builder().applyMutation(startRecommendationsRequest).build());
    }

    /**
     * <p>
     * For a given DMS Serverless replication configuration, DMS connects to the source endpoint and collects the
     * metadata to analyze the replication workload. Using this metadata, DMS then computes and provisions the required
     * capacity and starts replicating to the target endpoint using the server resources that DMS has provisioned for
     * the DMS Serverless replication.
     * </p>
     *
     * @param startReplicationRequest
     * @return A Java Future containing the result of the StartReplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.StartReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartReplicationResponse> startReplication(StartReplicationRequest startReplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For a given DMS Serverless replication configuration, DMS connects to the source endpoint and collects the
     * metadata to analyze the replication workload. Using this metadata, DMS then computes and provisions the required
     * capacity and starts replicating to the target endpoint using the server resources that DMS has provisioned for
     * the DMS Serverless replication.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartReplicationRequest.Builder} avoiding the need
     * to create one manually via {@link StartReplicationRequest#builder()}
     * </p>
     *
     * @param startReplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.StartReplicationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the StartReplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.StartReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartReplicationResponse> startReplication(
            Consumer<StartReplicationRequest.Builder> startReplicationRequest) {
        return startReplication(StartReplicationRequest.builder().applyMutation(startReplicationRequest).build());
    }

    /**
     * <p>
     * Starts the replication task.
     * </p>
     * <p>
     * For more information about DMS tasks, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html">Working with Migration Tasks </a> in the
     * <i>Database Migration Service User Guide.</i>
     * </p>
     *
     * @param startReplicationTaskRequest
     * @return A Java Future containing the result of the StartReplicationTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.StartReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartReplicationTaskResponse> startReplicationTask(
            StartReplicationTaskRequest startReplicationTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the replication task.
     * </p>
     * <p>
     * For more information about DMS tasks, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html">Working with Migration Tasks </a> in the
     * <i>Database Migration Service User Guide.</i>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartReplicationTaskRequest.Builder} avoiding the
     * need to create one manually via {@link StartReplicationTaskRequest#builder()}
     * </p>
     *
     * @param startReplicationTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StartReplicationTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.StartReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartReplicationTaskResponse> startReplicationTask(
            Consumer<StartReplicationTaskRequest.Builder> startReplicationTaskRequest) {
        return startReplicationTask(StartReplicationTaskRequest.builder().applyMutation(startReplicationTaskRequest).build());
    }

    /**
     * <p>
     * Starts the replication task assessment for unsupported data types in the source database.
     * </p>
     * <p>
     * You can only use this operation for a task if the following conditions are true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The task must be in the <code>stopped</code> state.
     * </p>
     * </li>
     * <li>
     * <p>
     * The task must have successful connections to the source and target.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If either of these conditions are not met, an <code>InvalidResourceStateFault</code> error will result.
     * </p>
     * <p>
     * For information about DMS task assessments, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html">Creating a task
     * assessment report</a> in the <i>Database Migration Service User Guide</i>.
     * </p>
     *
     * @param startReplicationTaskAssessmentRequest
     * @return A Java Future containing the result of the StartReplicationTaskAssessment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.StartReplicationTaskAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTaskAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartReplicationTaskAssessmentResponse> startReplicationTaskAssessment(
            StartReplicationTaskAssessmentRequest startReplicationTaskAssessmentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the replication task assessment for unsupported data types in the source database.
     * </p>
     * <p>
     * You can only use this operation for a task if the following conditions are true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The task must be in the <code>stopped</code> state.
     * </p>
     * </li>
     * <li>
     * <p>
     * The task must have successful connections to the source and target.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If either of these conditions are not met, an <code>InvalidResourceStateFault</code> error will result.
     * </p>
     * <p>
     * For information about DMS task assessments, see <a
     * href="https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html">Creating a task
     * assessment report</a> in the <i>Database Migration Service User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartReplicationTaskAssessmentRequest.Builder}
     * avoiding the need to create one manually via {@link StartReplicationTaskAssessmentRequest#builder()}
     * </p>
     *
     * @param startReplicationTaskAssessmentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the StartReplicationTaskAssessment operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.StartReplicationTaskAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTaskAssessment"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartReplicationTaskAssessmentResponse> startReplicationTaskAssessment(
            Consumer<StartReplicationTaskAssessmentRequest.Builder> startReplicationTaskAssessmentRequest) {
        return startReplicationTaskAssessment(StartReplicationTaskAssessmentRequest.builder()
                .applyMutation(startReplicationTaskAssessmentRequest).build());
    }

    /**
     * <p>
     * Starts a new premigration assessment run for one or more individual assessments of a migration task.
     * </p>
     * <p>
     * The assessments that you can specify depend on the source and target database engine and the migration type
     * defined for the given task. To run this operation, your migration task must already be created. After you run
     * this operation, you can review the status of each individual assessment. You can also run the migration task
     * manually after the assessment run and its individual assessments complete.
     * </p>
     *
     * @param startReplicationTaskAssessmentRunRequest
     * @return A Java Future containing the result of the StartReplicationTaskAssessmentRun operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>KmsAccessDeniedException The ciphertext references a key that doesn't exist or that the DMS account
     *         doesn't have access to.</li>
     *         <li>KmsDisabledException The specified KMS key isn't enabled.</li>
     *         <li>KmsException An Key Management Service (KMS) error is preventing access to KMS.</li>
     *         <li>KmsInvalidStateException The state of the specified KMS resource isn't valid for this request.</li>
     *         <li>KmsNotFoundException The specified KMS entity or resource can't be found.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>S3AccessDeniedException Insufficient privileges are preventing access to an Amazon S3 object.</li>
     *         <li>S3ResourceNotFoundException A specified Amazon S3 bucket, bucket folder, or other object can't be
     *         found.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.StartReplicationTaskAssessmentRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTaskAssessmentRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartReplicationTaskAssessmentRunResponse> startReplicationTaskAssessmentRun(
            StartReplicationTaskAssessmentRunRequest startReplicationTaskAssessmentRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a new premigration assessment run for one or more individual assessments of a migration task.
     * </p>
     * <p>
     * The assessments that you can specify depend on the source and target database engine and the migration type
     * defined for the given task. To run this operation, your migration task must already be created. After you run
     * this operation, you can review the status of each individual assessment. You can also run the migration task
     * manually after the assessment run and its individual assessments complete.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartReplicationTaskAssessmentRunRequest.Builder}
     * avoiding the need to create one manually via {@link StartReplicationTaskAssessmentRunRequest#builder()}
     * </p>
     *
     * @param startReplicationTaskAssessmentRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.StartReplicationTaskAssessmentRunRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the StartReplicationTaskAssessmentRun operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>KmsAccessDeniedException The ciphertext references a key that doesn't exist or that the DMS account
     *         doesn't have access to.</li>
     *         <li>KmsDisabledException The specified KMS key isn't enabled.</li>
     *         <li>KmsException An Key Management Service (KMS) error is preventing access to KMS.</li>
     *         <li>KmsInvalidStateException The state of the specified KMS resource isn't valid for this request.</li>
     *         <li>KmsNotFoundException The specified KMS entity or resource can't be found.</li>
     *         <li>KmsKeyNotAccessibleException DMS cannot access the KMS key.</li>
     *         <li>S3AccessDeniedException Insufficient privileges are preventing access to an Amazon S3 object.</li>
     *         <li>S3ResourceNotFoundException A specified Amazon S3 bucket, bucket folder, or other object can't be
     *         found.</li>
     *         <li>ResourceAlreadyExistsException The resource you are attempting to create already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.StartReplicationTaskAssessmentRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTaskAssessmentRun"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartReplicationTaskAssessmentRunResponse> startReplicationTaskAssessmentRun(
            Consumer<StartReplicationTaskAssessmentRunRequest.Builder> startReplicationTaskAssessmentRunRequest) {
        return startReplicationTaskAssessmentRun(StartReplicationTaskAssessmentRunRequest.builder()
                .applyMutation(startReplicationTaskAssessmentRunRequest).build());
    }

    /**
     * <p>
     * Stops the specified data migration.
     * </p>
     *
     * @param stopDataMigrationRequest
     * @return A Java Future containing the result of the StopDataMigration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.StopDataMigration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StopDataMigration" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopDataMigrationResponse> stopDataMigration(StopDataMigrationRequest stopDataMigrationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the specified data migration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopDataMigrationRequest.Builder} avoiding the need
     * to create one manually via {@link StopDataMigrationRequest#builder()}
     * </p>
     *
     * @param stopDataMigrationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.StopDataMigrationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the StopDataMigration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>FailedDependencyException A dependency threw an exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.StopDataMigration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StopDataMigration" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopDataMigrationResponse> stopDataMigration(
            Consumer<StopDataMigrationRequest.Builder> stopDataMigrationRequest) {
        return stopDataMigration(StopDataMigrationRequest.builder().applyMutation(stopDataMigrationRequest).build());
    }

    /**
     * <p>
     * For a given DMS Serverless replication configuration, DMS stops any and all ongoing DMS Serverless replications.
     * This command doesn't deprovision the stopped replications.
     * </p>
     *
     * @param stopReplicationRequest
     * @return A Java Future containing the result of the StopReplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.StopReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StopReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopReplicationResponse> stopReplication(StopReplicationRequest stopReplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For a given DMS Serverless replication configuration, DMS stops any and all ongoing DMS Serverless replications.
     * This command doesn't deprovision the stopped replications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopReplicationRequest.Builder} avoiding the need
     * to create one manually via {@link StopReplicationRequest#builder()}
     * </p>
     *
     * @param stopReplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.StopReplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopReplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>AccessDeniedException DMS was denied access to the endpoint. Check that the role is correctly
     *         configured.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.StopReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StopReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopReplicationResponse> stopReplication(
            Consumer<StopReplicationRequest.Builder> stopReplicationRequest) {
        return stopReplication(StopReplicationRequest.builder().applyMutation(stopReplicationRequest).build());
    }

    /**
     * <p>
     * Stops the replication task.
     * </p>
     *
     * @param stopReplicationTaskRequest
     * @return A Java Future containing the result of the StopReplicationTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.StopReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StopReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopReplicationTaskResponse> stopReplicationTask(
            StopReplicationTaskRequest stopReplicationTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the replication task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopReplicationTaskRequest.Builder} avoiding the
     * need to create one manually via {@link StopReplicationTaskRequest#builder()}
     * </p>
     *
     * @param stopReplicationTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.databasemigration.model.StopReplicationTaskRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the StopReplicationTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The resource could not be found.</li>
     *         <li>InvalidResourceStateException The resource is in a state that prevents it from being used for
     *         database migration.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>DatabaseMigrationException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample DatabaseMigrationAsyncClient.StopReplicationTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StopReplicationTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopReplicationTaskResponse> stopReplicationTask(
            Consumer<StopReplicationTaskRequest.Builder> stopReplicationTaskRequest) {
        return stopReplicati